#! /usr/dist/local/exe/bash
#
# Copyright 2003 Sun Microsystems, Inc. All Rights Reserved.
#
# @(#)component_lib.ksh	1.10 03/10/07
#

#---------------------------------------
# Define Component Level Variables
#---------------------------------------

# The order of these packages reflect the dependencies between the packages
# If you change the order, verify the changes by reviewing the contents of 
# the package dependency files.

CL_PACKAGES="SUNWstoba SUNWstmsu SUNWstmsr SUNWstmdb SUNWstmm SUNWstui SUNWestra"
CL_L10N_PACKAGES="SUNWcstui SUNWfstui SUNWjstui"
CL_NAME="SAN Manager Management"
CL_VERSION=2.0
CL_PKG_PATH=$COMPONENT_DIR/../Packages 

export CL_PACKAGES CL_L10N_PACKAGES CL_PKG_PATH CL_NAME CL_VERSION

#---------------------------------------
# Configuration file Updating Functions

# The configvar_lib.ksh code handles updating the TR_POSTGRES_PORT
# in the ESM_BASE/sssm/etc/sstr.properties file.  Additionally,
# the ESM_BASE/sssm/etc/properties/PersistenceService.properties
# file must be updated also.  For ESM 2.0 this updating is handled
# in the tr_mgmt/postinstall and tr_mgmt/postconfig scripts. This
# function is called from those scripts.

cl_update_postgres_port () {

    _postgres_port=`el_configvar_get NSM_POSTGRESQL_PORT`

    _cf_path="$ESM_BASE/sssm/etc/properties"
    src="$_cf_path/PersistenceService.properties"
    dst="$_cf_path/PersistenceService.properties"
    tgt="$_cf_path/PersistenceService.properties.tmp"
    /usr/sbin/removef SUNWstmsu $dst > /dev/null 2>&1
    /usr/sbin/removef -f SUNWstmsu
    sed "s/ConnectionPool\.port=[0-9]*/ConnectionPool.port=$_postgres_port/g" $src > $tgt
    if [ $? -ne 0 ]; then
        el_log 1 "ERROR: $src Postgresql port modification failed."
	retval=1
    else
	/bin/cp -f $tgt $dst
	/bin/chown root:other "$dst"
	/bin/chmod 644 "$dst"
	/usr/sbin/installf SUNWstmsu $dst f 0644 root other
	/usr/sbin/installf -f SUNWstmsu
	/bin/rm -f $tgt
	retval=0
    fi

    return $retval
}

# The configvar_lib.ksh code handles updating the TR_RMI_REGISTRY_PORT
# in the ESM_BASE/sssm/etc/sstr.properties file.  Additionally,
# the ESM_BASE/sssm/util/cre/population/transient.xml file must be 
# updated also.  For ESM 2.0 this updating is handled in the 
# tr_mgmt/postinstall and tr_mgmt/postconfig scripts. This function
# is called from those scripts.

cl_update_rmi_registry_port () {
    _rmi_reg_port=`el_configvar_get TR_RMI_REGISTRY_PORT`

    _cf_path="$ESM_BASE/sssm/util/cre/population"
    src="$_cf_path/transient.xml.default"
    dst="$_cf_path/transient.xml"
    tgt="$_cf_path/transient.xml.tmp"
    /usr/sbin/removef SUNWstmsu $dst > /dev/null 2>&1
    /usr/sbin/removef -f SUNWstmsu
    sed "s/TR_RMI_REGISTRY_PORT/$_rmi_reg_port/g" $src > $tgt
    if [ $? -ne 0 ]; then
        el_log 1 "ERROR: $src RMI registry port modification failed."
	retval=1
    else
	/bin/cp -f $tgt $dst
	/bin/chown root:other "$dst"
	/bin/chmod 644 "$dst"
	/usr/sbin/installf SUNWstmsu $dst f 0644 root other
	/usr/sbin/installf -f SUNWstmsu
	/bin/rm -f $tgt
	retval=0
    fi

    return $retval
}

#
# Update the secondary configuration files.
#
# The configvar_lib.ksh code handles updating the primary configuration
# files  Additionally, for some configuration attributes there are 
# secondary files that need updating.  This function handles the
# updating of the secondary files.
#
cl_update_secondary_config_file ()
{
    _retvar=0

    cl_update_postgres_port
    [ $? -eq 1 ] && _retvar=$?

    cl_update_rmi_registry_port
    [ $? -eq 1 ] && _retvar=$?

    return $_retvar
}

#---------------------------------------
# Debugging Functions

cl_debug () {
    el_secho 1 $ESM_LOG n "Component Environment Variables:"
    el_secho 1 $ESM_LOG n "    CL_PACKAGES   |$CL_PACKAGES|"
    el_secho 1 $ESM_LOG n "    CL_L10N_PACKAGES |$CL_L10N_PACKAGES|"
    el_secho 1 $ESM_LOG n "    CL_NAME       |$CL_NAME|"
    el_secho 1 $ESM_LOG n "    CL_VERSION    |$CL_VERSION|"
    el_secho 1 $ESM_LOG n "    CL_PKG_PATH   |$CL_PKG_PATH|"
    el_secho 1 $ESM_LOG n " "
}
