/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.generic;

import com.sun.jade.device.util.DeviceConfig;
import com.sun.netstorage.mgmt.esm.logic.device.registry.DeviceProperties;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class GenericProbe
implements Probe {
    public static final String TYPE = "generic";
    private Properties probeProps;
    public static final String sccs_id = "@(#)GenericProbe.java\t1.9 08/07/03 SMI";

    public GenericProbe(Properties properties) {
        this.probeProps = properties;
    }

    public ProbeResult probe(Properties properties) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        String string = properties.getProperty("RHBA.FCPTARGET.PortWWN");
        if (this.checkPrevious(string)) {
            new ProbeResult(properties, arrayList);
        }
        Properties properties2 = new Properties();
        String string2 = properties.getProperty("RHBA.FCPTARGET.SystemId");
        String string3 = properties.getProperty("RHBA.Host");
        String string4 = properties.getProperty("RHBA.FCPTARGET.IpAddress");
        String string5 = properties.getProperty("RHBA.FCPTARGET.VendorId");
        String string6 = properties.getProperty("RHBA.FCPTARGET.ProductId");
        String string7 = properties.getProperty("RHBA.FCPTARGET.ProductRevision");
        if (!this.validValue(string2)) {
            string2 = string;
        }
        properties2.setProperty("type", TYPE);
        properties2.setProperty("name", string2);
        properties2.setProperty("name.ib", string2);
        if (this.validValue(string4)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string4);
                properties2.setProperty("ipno", inetAddress.getHostAddress());
                properties2.setProperty("ip", inetAddress.getHostName());
                properties2.setProperty("logicalName", inetAddress.getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                properties2.setProperty("ip", string4);
                properties2.setProperty("logicalName", string4);
            }
        } else {
            properties2.setProperty("logicalName", string2);
        }
        properties2.setProperty("wwn", string);
        if (string5 != null) {
            properties2.setProperty("VENDOR", string5);
        }
        if (string6 != null) {
            properties2.setProperty("MODEL", string6);
        }
        if (string5 == null) {
            string5 = "UNKNOWN";
        }
        properties2.setProperty("GUID", "1~ARRAY~" + string5.trim() + "~WWN~" + string);
        arrayList.add(properties2);
        return new ProbeResult(properties, arrayList);
    }

    private boolean checkPrevious(String string) {
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            DeviceProperties deviceProperties = new DeviceProperties(properties);
            if (GenericProbe.valuesMatch(properties.getProperty("wwn"), string)) {
                return true;
            }
            if (GenericProbe.valuesMatch(properties.getProperty("name.ib"), string)) {
                return true;
            }
            String[] stringArray = deviceProperties.getWWNList();
            int n = 0;
            while (n < stringArray.length) {
                if (GenericProbe.valuesMatch(stringArray[n], string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static boolean valuesMatch(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    private boolean validValue(String string) {
        if (string == null) {
            return false;
        }
        return !"".equals(string);
    }

    public String getName() {
        return TYPE;
    }
}

