/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.jade.device.protocol.agent.HTTPException;
import com.sun.jade.device.rack.serack.io.SERackException;
import com.sun.jade.device.rack.serack.io.SERackTokenList;
import com.sun.jade.device.util.GUIDGenerator;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public class SERackOOBProbe
implements Probe {
    public static final int SECURE_PORT_1 = 6789;
    public static final int SECURE_PORT = 7443;
    public static final int STANDARD_PORT = 7654;
    public static final int DEFAULT_TIMEOUT = 10;
    public static final String SYS_DESCRIPTION = "Sun StorEdge Solution";
    public static final String GENERIC_DESCRIPTION = "Sun SNMP Agent";
    public static final String SERACK_TYPE = "serack";
    private static final int SA_TYPE = 0;
    private static final int DEVICE_MODEL = 1;
    private static final int HOSTID = 2;
    private static final String T3 = "t3";
    private static final String VE = "ve";
    private static final String MODEL_3910 = "3910";
    private static final String MODEL_3960 = "3960";
    private static final String MODEL_6910 = "6910";
    private static final String MODEL_6960 = "6960";
    private static final String MODEL_6320 = "6320";
    private static final String MODEL_6920 = "6920";
    private Properties probeProps;
    private String description;
    private boolean genericDescr;
    public static final String sccs_id = "@(#)SERackOOBProbe.java\t1.2 04/17/03 SMI";

    public SERackOOBProbe(Properties properties) {
        String string;
        this.probeProps = properties;
        this.description = properties.getProperty("sysDescr");
        if (this.description == null || this.description.length() == 0) {
            this.description = SYS_DESCRIPTION;
        }
        this.genericDescr = "generic".equals(string = properties.getProperty("match"));
    }

    public String getName() {
        return SERACK_TYPE;
    }

    public ProbeResult probe(Properties properties) {
        Object object;
        int n;
        LinkedList<Properties> linkedList = new LinkedList<Properties>();
        String string = properties.getProperty("ip");
        String string2 = properties.getProperty("ipno");
        String string3 = properties.getProperty("timeout");
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            n = 10;
        }
        if (string2 == null) {
            try {
                object = InetAddress.getByName(string);
                string2 = ((InetAddress)object).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if ((object = properties.getProperty("snmp.sysDescr")) != null) {
            Properties properties2;
            if (((String)object).startsWith(this.description)) {
                Properties properties3 = this.getDevProps(string, string2, n);
                if (properties3 != null) {
                    linkedList.add(properties3);
                }
            } else if (this.genericDescr && ((String)object).startsWith(GENERIC_DESCRIPTION) && this.isStorAdeInstalled(string, string2, n) && (properties2 = this.getDevProps(string, string2, n)) != null) {
                linkedList.add(properties2);
            }
        }
        return new ProbeResult(this.probeProps, linkedList);
    }

    private Properties getDevProps(String string, String string2, int n) {
        String string3;
        int n2 = 7443;
        String string4 = null;
        Properties properties = null;
        HTTPConnection hTTPConnection = null;
        String string5 = string2 != null ? string2 : string;
        try {
            n2 = 6789;
            hTTPConnection = new HTTPConnection(string5, n2);
            string4 = hTTPConnection.get(HTTPConnection.LIST_REQUEST, n, "https");
        }
        catch (Exception exception) {
            try {
                n2 = 7443;
                hTTPConnection = new HTTPConnection(string5, n2);
                string4 = hTTPConnection.get(HTTPConnection.LIST_REQUEST, n, "https");
            }
            catch (HTTPException hTTPException) {
                try {
                    n2 = 7654;
                    hTTPConnection = new HTTPConnection(string5, n2);
                    string4 = hTTPConnection.get(HTTPConnection.LIST_REQUEST, n, "http");
                }
                catch (Exception exception2) {
                    Report.debug.log("RACK_DISCOVERY", (Object)("Exception from the non secure attempt (discovery) " + exception2.toString()));
                }
            }
            catch (Exception exception3) {
                Report.debug.log("RACK_DISCOVERY", (Object)("Exception from the secure attempt (discovery) " + exception3.toString()));
            }
        }
        if (string4 != null && (string3 = this.scanList(string4)) != null) {
            properties = new Properties();
            if (string != null) {
                properties.setProperty("ip", string);
            }
            if (string2 != null) {
                properties.setProperty("ipno", string2);
            }
            properties.setProperty("port", Integer.toString(n2));
            properties.setProperty("deviceKey", string3);
            properties.setProperty("name", string3);
            properties.setProperty("name.oob", string3);
            String string6 = this.parseDeviceKey(string3, 1);
            String string7 = this.parseDeviceKey(string3, 2);
            properties.setProperty("MODEL", "StorEdge " + string6);
            properties.setProperty("model.number", string6);
            properties.setProperty("VENDOR", "Sun");
            properties.setProperty("type", SERACK_TYPE);
            SERackTokenList sERackTokenList = this.getReport(hTTPConnection, string3);
            properties.setProperty("wwnList", this.createWWNList(sERackTokenList, string6));
            String string8 = this.createGUID(sERackTokenList, string6, string7);
            properties.setProperty("GUID", string8);
            long l = System.currentTimeMillis();
            properties.setProperty("search.oob", "" + l);
        }
        return properties;
    }

    private String parseDeviceKey(String string, int n) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(":");
            int n3 = string.indexOf(".");
            switch (n) {
                case 0: {
                    string2 = string.substring(0, n2);
                    break;
                }
                case 1: {
                    string2 = string.substring(n2 + 1, n3);
                    break;
                }
                case 2: {
                    string2 = string.substring(n3 + 1);
                }
            }
        }
        return string2;
    }

    private boolean isStorAdeInstalled(String string, String string2, int n) {
        boolean bl;
        block9: {
            String string3;
            bl = false;
            HTTPConnection hTTPConnection = null;
            SERackTokenList sERackTokenList = null;
            String string4 = null;
            String string5 = string2 != null ? string2 : string;
            try {
                hTTPConnection = new HTTPConnection(string5, 6789);
                string4 = hTTPConnection.secureGet(HTTPConnection.DISCO_LIST, n);
            }
            catch (Exception exception) {
                try {
                    hTTPConnection = new HTTPConnection(string5, 7443);
                    string4 = hTTPConnection.secureGet(HTTPConnection.DISCO_LIST, n);
                }
                catch (Exception exception2) {
                    try {
                        hTTPConnection = new HTTPConnection(string5, 7654);
                        string4 = hTTPConnection.nonSecureGet(HTTPConnection.DISCO_LIST, n);
                    }
                    catch (Exception exception3) {
                        Report.debug.log((Object)("Exception accessing the discovery list at " + string5 + " " + exception3.toString()));
                    }
                }
            }
            if (string4 == null || (string3 = (sERackTokenList = new SERackTokenList(string4)).getStringValue("agent.0", "agent_version")) == null) break block9;
            String string6 = string3.substring(0, 3);
            try {
                String string7;
                float f = Float.parseFloat(string6);
                if (f >= 2.2f && (string7 = sERackTokenList.getStringValue("agent.0", "solution_model")) != null) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Report.error.log((Object)("StorAde agent version " + string6 + " is not a number"));
            }
        }
        return bl;
    }

    private String createWWNList(SERackTokenList sERackTokenList, String string) {
        StringBuffer stringBuffer;
        block7: {
            stringBuffer = new StringBuffer();
            if (sERackTokenList == null) break block7;
            try {
                String string2;
                int n = sERackTokenList.getIntValue("portTotal");
                int n2 = 0;
                while (n2 < n) {
                    string2 = sERackTokenList.getStringValue("fcPort." + n2, "LocalPortWWN");
                    if (string2 != null) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(string2);
                    }
                    ++n2;
                }
                string2 = this.getVicomWWNs(sERackTokenList);
                if (string2.length() > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string2);
                }
            }
            catch (SERackException sERackException) {
                Report.warning.log((Object)("Error getting count " + sERackException.toString()));
            }
        }
        return stringBuffer.toString();
    }

    private SERackTokenList getReport(HTTPConnection hTTPConnection, String string) {
        SERackTokenList sERackTokenList = null;
        try {
            String string2 = hTTPConnection.get(HTTPConnection.DATA_REQUEST + string);
            sERackTokenList = new SERackTokenList(string2);
        }
        catch (HTTPException hTTPException) {
            Report.debug.log("RACK_DISCOVERY", (Object)("Exception accessing the report " + hTTPException.toString()));
        }
        catch (IOException iOException) {
            Report.debug.log("RACK_DISCOVERY", (Object)("Exception accessing the report " + iOException.toString()));
        }
        return sERackTokenList;
    }

    private String createGUID(SERackTokenList sERackTokenList, String string, String string2) {
        String string3 = GUIDGenerator.generateGUID((String)"array", (String)"sun", (String)"hostid", (String)string2);
        String string4 = null;
        if (string.startsWith(MODEL_3910)) {
            string4 = this.getWWN(sERackTokenList, T3);
            string3 = GUIDGenerator.generateGUID((String)"array", (String)"sun", (String)"wwn", (String)string4);
        } else if (string.startsWith(MODEL_6910) || string.startsWith(MODEL_6960)) {
            String string5 = this.getWWN(sERackTokenList, VE);
            string3 = GUIDGenerator.generateGUID((String)"array", (String)"sun", (String)"wwn", (String)string5);
        }
        return string3;
    }

    private String getWWN(SERackTokenList sERackTokenList, String string) {
        int n = 0;
        String string2 = "0000000000000000";
        try {
            n = sERackTokenList.getIntValue("slotTotal");
        }
        catch (SERackException sERackException) {
            Report.warning.log((Object)("Error getting count " + sERackException.toString()));
        }
        int n2 = 0;
        while (n2 < n) {
            String string3 = sERackTokenList.getStringValue("slot." + n2, "dev-type");
            if (string.equalsIgnoreCase(string3)) {
                string2 = sERackTokenList.getStringValue("slot." + n2, "dev-wwn");
                break;
            }
            ++n2;
        }
        return string2;
    }

    private String getVicomWWNs(SERackTokenList sERackTokenList) {
        int n = 0;
        try {
            n = sERackTokenList.getIntValue("slotTotal");
        }
        catch (SERackException sERackException) {
            Report.warning.log((Object)("Error getting count " + sERackException.toString()));
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = sERackTokenList.getStringValue("slot." + n2, "dev-type");
            if (VE.equalsIgnoreCase(string2) && (string = sERackTokenList.getStringValue("slot." + n2, "dev-wwn")) != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.mangleVicomWWN(string));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String mangleVicomWWN(String string) {
        String string2 = string;
        if (string != null && string.length() > 2) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(1, 2, "B");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private String createVicomNodeWWN(String string) {
        String string2 = string;
        if (string != null && string.length() > 2) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(1, 2, "A");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private String scanList(String string) {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        try {
            while ((string2 = this.parseEntry(string.substring(n, n2 = string.indexOf("\n", n)))) == null) {
                n = n2 + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
        }
        return string2;
    }

    private String parseEntry(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() > 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (string5.startsWith("se")) {
                string2 = string4;
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        SERackOOBProbe sERackOOBProbe = new SERackOOBProbe(new Properties());
        Properties properties = new Properties();
        properties.setProperty("ip", stringArray[0]);
        if (stringArray.length > 1) {
            int n;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0) {
                properties.setProperty("snmp.sysDescr", "Sun SNMP Agent, UltraAX-i2");
            } else {
                properties.setProperty("snmp.sysDescr", "Sun StorEdge Solution XXXX");
            }
        } else {
            properties.setProperty("snmp.sysDescr", "Sun SNMP Agent, UltraAX-i2");
        }
        ProbeResult probeResult = sERackOOBProbe.probe(properties);
        if (probeResult != null) {
            System.out.println(probeResult.toString());
        }
        System.exit(0);
    }
}

