/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.device.protocol.agent.AgentController;
import com.sun.jade.device.protocol.agent.AgentEvent;
import com.sun.jade.device.protocol.agent.AgentEventDispatcher;
import com.sun.jade.device.protocol.agent.AgentEventDispatcherService;
import com.sun.jade.device.protocol.agent.AgentEventListener;
import com.sun.jade.device.protocol.agent.AgentTest;
import com.sun.jade.device.protocol.agent.GetProviderSettingsCommand;
import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.jade.device.protocol.agent.HTTPException;
import com.sun.jade.device.rack.serack.io.SERackTokenList;
import com.sun.jade.device.rack.serack.service.RackEventConverter;
import com.sun.jade.device.rack.serack.service.SERackMF;
import com.sun.jade.device.rack.serack.service.SERackReportGenerator;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.ServiceException;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.device.api.DeviceConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;

public class SERackMFImpl
extends AbstractMF
implements SERackMF,
AgentEventListener {
    private ServiceHelper[] helpers;
    private String deviceName;
    private String ip;
    private String deviceKey;
    private int port;
    private int alternatePort;
    private Properties p;
    public static String CIM_CLASS_NAME = "StorEdgeRack_AdminDomain";
    private static final int DEFAULT_PORT = 7654;
    private static final int SECURE_PORT = 7443;
    private static final int SECURE_PORT_1 = 6789;
    private static final int ASYNC_PORT_6920 = 6789;
    private static final int ASYNC_PORT_DEFAULT = 8443;
    public static final String sccs_id = "@(#)SERackMFImpl.java\t1.0 05/09/02 SMI";

    public SERackMFImpl(Properties properties) throws RemoteException, ServiceException {
        super(properties);
        this.p = properties;
        this.ip = this.resolveIP(properties);
        this.deviceName = properties.getProperty("deviceKey");
        this.deviceKey = properties.getProperty("deviceKey");
        String string = properties.getProperty("port");
        try {
            this.port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.port = 7654;
        }
        this.alternatePort = this.port == 7443 ? 7654 : 7443;
        this.setDeviceReport(new SERackReportGenerator(properties));
        this.addDiagnostics();
        this.disableProviders();
        this.subscribeForEvents();
    }

    public String getClassName() {
        return CIM_CLASS_NAME;
    }

    public String getName() {
        return this.deviceName;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        String string = "Sun ";
        String string2 = this.p.getProperty("MODEL");
        if (string2 == null) {
            string2 = "StorEdge Solution Rack";
        }
        return new LocalizedString(string + string2);
    }

    private void addDiagnostics() {
        String string = "se";
        String string2 = this.p.getProperty("MODEL");
        if (string2 != null && (string2.endsWith("6320") || string2.endsWith("6920"))) {
            string = "se2";
        }
        AgentTest[] agentTestArray = null;
        try {
            agentTestArray = AgentTest.getTests((String)string, (String)this.ip, (int)this.port, (String)CIM_CLASS_NAME);
        }
        catch (Exception exception) {
            try {
                agentTestArray = AgentTest.getTests((String)string, (String)this.ip, (int)this.alternatePort, (String)CIM_CLASS_NAME);
            }
            catch (Exception exception2) {
                Report.error.log((Object)("Unable to retrieve diags for " + this.deviceKey));
            }
        }
        if (agentTestArray != null) {
            int n = 0;
            while (n < agentTestArray.length) {
                this.addDiagnosticTest((TestTemplate)agentTestArray[n]);
                ++n;
            }
        }
    }

    private void subscribeForEvents() {
        AgentEventDispatcher agentEventDispatcher;
        Properties properties;
        int n = 8443;
        String string = this.p.getProperty("model.number");
        if (string != null) {
            properties = new DeviceConfig("serack");
            agentEventDispatcher = properties.getDevice();
            Properties properties2 = agentEventDispatcher.getProps();
            String string2 = "EventPort." + string;
            String string3 = properties2.getProperty(string2);
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        properties = new Properties();
        agentEventDispatcher = AgentEventDispatcherService.getService((Properties)properties);
        agentEventDispatcher.subscribeListener(this.ip, this.port, n, this.deviceKey, (AgentEventListener)this);
    }

    public void unsubscribeFromEvents() {
        Properties properties = new Properties();
        AgentEventDispatcher agentEventDispatcher = AgentEventDispatcherService.getService((Properties)properties);
        agentEventDispatcher.unsubscribeListener((AgentEventListener)this);
    }

    public void notify(AgentEvent agentEvent) {
        RackEventConverter.translateEvent(agentEvent, this.deviceName, this.p.getProperty("ipno"));
    }

    protected void shutdown() {
    }

    private boolean subscribed() {
        boolean bl;
        block4: {
            String string;
            bl = false;
            SERackTokenList sERackTokenList = this.getProviderSettings();
            if (sERackTokenList == null) {
                return false;
            }
            String string2 = sERackTokenList.getStringValue("pro.sae", "active");
            if (!"Y".equals(string2) || (string = sERackTokenList.getStringValue("pro.sae", "ip")) == null) break block4;
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
                String string3 = inetAddress.getHostAddress();
                if (string.startsWith(string3)) {
                    bl = true;
                }
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return bl;
    }

    private boolean isSubscriptionAvailable() {
        boolean bl = false;
        SERackTokenList sERackTokenList = this.getProviderSettings();
        if (sERackTokenList == null) {
            return false;
        }
        String string = sERackTokenList.getStringValue("pro.sae", "active");
        if ("N".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private SERackTokenList getProviderSettings() {
        SERackTokenList sERackTokenList = null;
        GetProviderSettingsCommand getProviderSettingsCommand = new GetProviderSettingsCommand("tab");
        String string = getProviderSettingsCommand.getRequest();
        try {
            HTTPConnection hTTPConnection = new HTTPConnection(this.ip, this.port);
            sERackTokenList = new SERackTokenList(hTTPConnection.get(string));
        }
        catch (Exception exception) {
            try {
                HTTPConnection hTTPConnection = new HTTPConnection(this.ip, this.alternatePort);
                sERackTokenList = new SERackTokenList(hTTPConnection.get(string));
            }
            catch (HTTPException hTTPException) {
                Report.warning.log((Object)("Comm error getting provider settings: " + hTTPException.toString()));
            }
            catch (IOException iOException) {
                Report.warning.log((Object)("IO error getting provider settings: " + iOException.toString()));
            }
        }
        return sERackTokenList;
    }

    private void disableProviders() {
        boolean bl = AgentController.disableProvider((String)this.ip, (int)this.port, (String)"srs");
        if (!bl) {
            bl = AgentController.disableProvider((String)this.ip, (int)this.alternatePort, (String)"srs");
        }
        if (!bl) {
            Report.error.log((Object)("Unable to turn off providers on " + this.deviceKey));
        }
    }
}

