/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.jade.device.protocol.agent.HTTPException;
import com.sun.jade.device.rack.serack.io.SERackTokenList;
import com.sun.jade.device.rack.serack.service.RackTranslator;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.log.Report;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RackReportTranslator
extends RackTranslator {
    private String hostIP;
    private int port;
    private int alternatePort;
    private int secondAltPort;
    private String deviceKey;
    private String model;
    private static int DEFAULT_PORT = 7654;
    private static int SECURE_PORT = 7443;
    private static int SECURE_PORT_1 = 6789;
    public static final String sccs_id = "@(#)RackReportTranslator.java\t1.0 05/09/02 SMI";

    public RackReportTranslator(String string, String string2, String string3) {
        super(string);
        this.hostIP = string2;
        this.port = DEFAULT_PORT;
        this.alternatePort = SECURE_PORT;
        this.secondAltPort = SECURE_PORT_1;
        this.deviceKey = string3;
    }

    public RackReportTranslator(String string, String string2, int n, String string3) {
        super(string);
        this.hostIP = string2;
        this.port = n;
        this.deviceKey = string3;
        if (n == SECURE_PORT) {
            this.alternatePort = SECURE_PORT_1;
            this.secondAltPort = DEFAULT_PORT;
        } else if (n == SECURE_PORT_1) {
            this.alternatePort = SECURE_PORT;
            this.secondAltPort = DEFAULT_PORT;
        } else {
            this.alternatePort = SECURE_PORT;
            this.secondAltPort = SECURE_PORT_1;
        }
    }

    private String collectData() {
        String string = this.requestReport(this.port);
        if (string == "FAILURE") {
            string = this.requestReport(this.alternatePort);
        }
        if (string == "FAILURE") {
            string = this.requestReport(this.secondAltPort);
        }
        return string;
    }

    private String requestReport(int n) {
        String string = "FAILURE";
        try {
            HTTPConnection hTTPConnection = new HTTPConnection(this.hostIP, n);
            String string2 = hTTPConnection.get(HTTPConnection.DATA_REQUEST + this.deviceKey);
            this.rack = new SERackTokenList(string2);
            string = "OK";
        }
        catch (HTTPException hTTPException) {
            Report.warning.log((Object)("HTTP error getting inst report for " + this.deviceKey + " on port " + n + " : " + hTTPException.toString()));
        }
        catch (IOException iOException) {
            Report.warning.log((Object)("IO error getting inst report: " + iOException.toString()));
        }
        return string;
    }

    public String createReport() {
        DeviceClass deviceClass;
        Map.Entry entry;
        Object object;
        DeviceClass deviceClass2;
        int n;
        DeviceClass deviceClass3;
        String string = this.collectData();
        if (string.equals("FAILURE")) {
            String string2 = "<report ReturnCode=\"FAILURE\">\n<exception Reason=\"Lost Comm\"/></report>\n";
            return string2;
        }
        DeviceClass deviceClass4 = new DeviceClass();
        deviceClass4.setClassName("report");
        deviceClass4.setProperty("ReturnCode", "OK");
        DeviceClass deviceClass5 = deviceClass4.newSubInstance();
        deviceClass5.setClassName("model");
        deviceClass5.setProperty("schema", "CIM2.5");
        deviceClass5.setProperty("view", "system");
        deviceClass5.setProperty("type", "rack");
        deviceClass5.setProperty("prefix", "StorEdgeRack");
        deviceClass5.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass6 = deviceClass5.newSubInstance();
        deviceClass6.setClassName("SystemView");
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        this.updateAdminDomain(deviceClass7);
        this.model = this.rack.getStringValue("info", "model");
        int n2 = this.getCount("portTotal");
        int n3 = this.getCount("lunTotal");
        int n4 = this.getCount("sliceTotal");
        int n5 = this.getCount("fruTotal");
        int n6 = this.getCount("slotTotal");
        int n7 = 0;
        while (n7 < n2) {
            DeviceClass deviceClass8 = deviceClass7.newSubInstance();
            this.updateFibrePort(deviceClass8, n7);
            deviceClass3 = deviceClass8.newSubInstance();
            this.updateProtocolEndpoint(deviceClass3, n7);
            ++n7;
        }
        int n8 = 1;
        while (n8 <= n3) {
            deviceClass3 = deviceClass7.newSubInstance();
            this.updateVolume(deviceClass3, n8);
            ++n8;
        }
        if ("6920".equals(this.model)) {
            n = this.getCount("volTotal");
            int n9 = 1;
            while (n9 <= n) {
                deviceClass2 = deviceClass7.newSubInstance();
                this.updateLogicalDisk(deviceClass2, n9, "volume");
                ++n9;
            }
        } else {
            n = 1;
            while (n <= n4) {
                DeviceClass deviceClass9 = deviceClass7.newSubInstance();
                this.updateLogicalDisk(deviceClass9, n, "slice");
                ++n;
            }
        }
        HashMap hashMap = new HashMap();
        int n10 = 0;
        while (n10 < n5) {
            block13: {
                String string3;
                block15: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block16: {
                                                                block14: {
                                                                    deviceClass2 = null;
                                                                    string3 = this.rack.getStringValue("fru." + n10, "fruType");
                                                                    if (string3 == null) break block13;
                                                                    if (!"sp".equals(string3)) break block14;
                                                                    deviceClass2 = deviceClass7.newSubInstance();
                                                                    this.updateServiceProcessor(deviceClass2, string3, n10);
                                                                    break block15;
                                                                }
                                                                if (!"ve".equals(string3)) break block16;
                                                                deviceClass2 = deviceClass7.newSubInstance();
                                                                this.updateVirtualizationEngine(deviceClass2, string3, n10);
                                                                break block15;
                                                            }
                                                            if (!"powerUnit".equals(string3)) break block17;
                                                            deviceClass2 = deviceClass7.newSubInstance();
                                                            this.updatePowerSupply(deviceClass2, string3, n10);
                                                            break block15;
                                                        }
                                                        if (!"diskDrive".equals(string3)) break block18;
                                                        deviceClass2 = deviceClass7.newSubInstance();
                                                        this.updateDiskDrive(deviceClass2, string3, n10);
                                                        break block15;
                                                    }
                                                    if (!"loopCard".equals(string3)) break block19;
                                                    deviceClass2 = deviceClass7.newSubInstance();
                                                    this.updateLoopController(deviceClass2, string3, n10);
                                                    break block15;
                                                }
                                                if (!"controllerCard".equals(string3)) break block20;
                                                deviceClass2 = deviceClass7.newSubInstance();
                                                this.updateSCSIController(deviceClass2, string3, n10);
                                                break block15;
                                            }
                                            if (!"midplane".equals(string3)) break block21;
                                            deviceClass2 = deviceClass7.newSubInstance();
                                            this.updateMidplaneDevice(deviceClass2, string3, n10);
                                            break block15;
                                        }
                                        if (!"switch".equals(string3)) break block22;
                                        deviceClass2 = deviceClass7.newSubInstance();
                                        this.updateSwitch(deviceClass2, string3, n10);
                                        break block15;
                                    }
                                    if (!string3.startsWith("SRC")) break block23;
                                    deviceClass2 = deviceClass7.newSubInstance();
                                    this.updateStorageResourceController(deviceClass2, string3, n10);
                                    break block15;
                                }
                                if (!string3.startsWith("SFC")) break block24;
                                deviceClass2 = deviceClass7.newSubInstance();
                                this.updateSwitchFabricController(deviceClass2, string3, n10);
                                break block15;
                            }
                            if (!string3.startsWith("SIO")) break block25;
                            deviceClass2 = deviceClass7.newSubInstance();
                            this.updateStorageIOController(deviceClass2, string3, n10);
                            break block15;
                        }
                        if (!string3.startsWith("MIC")) break block26;
                        deviceClass2 = deviceClass7.newSubInstance();
                        this.updateManagementInterfaceController(deviceClass2, string3, n10);
                        break block15;
                    }
                    if (!string3.startsWith("psu")) break block13;
                    deviceClass2 = deviceClass7.newSubInstance();
                    this.updatePowerSupply(deviceClass2, string3, n10);
                }
                object = deviceClass2.newSubInstance();
                this.updatePhysicalPackage((DeviceClass)object, string3, n10, hashMap);
                entry = object.newSubInstance();
                this.updateFRU((DeviceClass)entry, string3, n10);
                deviceClass = object.newSubInstance();
                this.updateLocation(deviceClass, string3, n10);
            }
            ++n10;
        }
        deviceClass2 = deviceClass7.newSubInstance();
        this.updateRack(deviceClass2);
        int n11 = 0;
        while (n11 < n6) {
            object = deviceClass2.newSubInstance();
            this.updateSlot((DeviceClass)object, n11);
            ++n11;
        }
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            entry = (Map.Entry)object.next();
            deviceClass = deviceClass6.newSubInstance();
            this.addPackageInSlotAssociation(deviceClass, (String)entry.getValue(), (String)entry.getKey());
        }
        deviceClass2 = null;
        return deviceClass4.toXML();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            RackReportTranslator rackReportTranslator = new RackReportTranslator(stringArray[0], stringArray[0], 7654, "se:6910.8311c56f");
            String string = rackReportTranslator.createReport();
            System.out.println(string);
        } else {
            System.out.println("Usage: RackReportTranslator <ip>");
        }
    }
}

