/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.cim.bean.CIM_LogicalDevice;
import com.sun.jade.cim.bean.StorEdgeRack_AdminDomain;
import com.sun.jade.cim.bean.StorEdgeRack_SCSIController;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.device.protocol.agent.AgentEvent;
import com.sun.jade.device.protocol.agent.AgentEventConverter;
import com.sun.jade.device.protocol.agent.ConversionHelper;
import com.sun.jade.device.rack.serack.service.PersistenceHelper;
import com.sun.jade.device.rack.serack.service.RackEventTranslator;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class RackEventConverter
extends AgentEventConverter {
    private static final int PACKAGE = 1;
    private static final int FRU = 2;
    private static final int LOCATION = 3;
    private static final int ENDPOINT = 4;

    public static void translateEvent(AgentEvent agentEvent, String string, String string2) {
        Report.trace.log((Object)"Entered translateEvent");
        String string3 = agentEvent.getManagementLevel();
        if ("DS".equals(string3)) {
            String string4;
            String string5 = agentEvent.getEventType();
            if (agentEvent.isDerived() && !"unknown".equals(string4 = agentEvent.getOriginalEvent().getEventType()) && !"LogEvent".equals(string4)) {
                string5 = string4;
            }
            Report.debug.log((Object)("Translating event type " + string5));
            if ("StateChange".equals(string5)) {
                RackEventConverter.convertStateChangeEvent(agentEvent, string, string2);
            } else if ("ComponentAddition".equals(string5)) {
                RackEventConverter.convertComponentAdditionEvent(agentEvent, string);
            } else if ("ComponentRemoval".equals(string5)) {
                RackEventConverter.convertComponentRemovalEvent(agentEvent, string);
            } else if ("CommunicationStateChange".equals(string5)) {
                RackEventConverter.convertCommunicationStateChangeEvent(agentEvent, string, string2);
            } else if ("DiagnosisStatus".equals(string5)) {
                Report.info.log((Object)("Unhandled event type: " + string5 + " from " + string));
            } else {
                Report.info.log((Object)("Event " + agentEvent.getEventID() + " from " + string + " is of an unknown type: " + string5));
            }
        } else {
            Report.debug.log((Object)("Skipping conversion, not a rack level event: " + string3));
        }
        Report.trace.log((Object)"Exiting translateEvent");
    }

    private static String convertStateChangeEvent(AgentEvent agentEvent, String string, String string2) {
        String string3 = null;
        RackEventTranslator rackEventTranslator = new RackEventTranslator(string, agentEvent.getPayload());
        String string4 = RackEventConverter.determineElementID(agentEvent, rackEventTranslator);
        if (string4 != null) {
            CIMBean cIMBean = null;
            CIMBean cIMBean2 = null;
            String string5 = ConversionHelper.getElementCategory((String)string4);
            int n = ConversionHelper.getElementIndex((String)string4);
            if ("fru".equals(string5)) {
                string5 = rackEventTranslator.getFruType(n);
            }
            if ((cIMBean2 = RackEventConverter.createBean(rackEventTranslator, string5, n)) != null) {
                string3 = cIMBean2.getCIMObjectPath().toString();
                cIMBean = PersistenceHelper.retrieveBean(cIMBean2);
                PersistenceHelper.storeBean(cIMBean2);
                String string6 = agentEvent.getTopic() + ".array.serack." + string5;
                Report.debug.log((Object)("Posting state change event with topic " + string6));
                AgentEventConverter.postStateChangeEvent((AgentEvent)agentEvent, (String)string6, (CIMBean)cIMBean, (CIMBean)cIMBean2);
                boolean bl = RackEventConverter.isHealed(agentEvent);
                if (agentEvent.isActionable() || agentEvent.isActionable(true) || bl) {
                    RackEventConverter.convertStateChangeAlert(agentEvent, string, string3, string5, bl, string2);
                } else {
                    Report.debug.log((Object)"No alert - event wasn't actionable or healed");
                }
            } else {
                Report.error.log((Object)("Unable to create a bean for " + string4));
            }
            RackEventConverter.updateBeans(agentEvent, rackEventTranslator, string4);
        } else {
            String string7 = null;
            if (agentEvent.isDerived()) {
                string7 = agentEvent.getOriginalEvent().getCaption();
            }
            Report.error.log((Object)("Could not determine an element ID for event " + agentEvent.getEventID() + " from " + string + " Caption = " + agentEvent.getCaption() + " Original Caption = " + string7 + " The reverse lookup for a component key into the" + " report fragment is failing, or the report" + " fragment is missing from this event."));
        }
        return string3;
    }

    private static void convertStateChangeAlert(AgentEvent agentEvent, String string, String string2, String string3, boolean bl, String string4) {
        String string5 = "create";
        String string6 = null;
        if (bl) {
            string5 = "clear";
            string6 = AgentEventConverter.clearAlert((String)string2);
            if (string6 == null) {
                return;
            }
        }
        String[] stringArray = string6 != null ? new String[]{agentEvent.getEventID(), string6} : new String[]{agentEvent.getEventID()};
        String string7 = ".alert." + string5 + ".device.array.serack." + string3;
        Report.debug.log((Object)("Posting state change alert, topic = " + string7));
        MessageCode messageCode = new MessageCode("event.storage.serack.event", 7);
        AgentEventConverter.postStateChangeAlert((AgentEvent)agentEvent, (String)string7, (String)string2, (MessageCode)messageCode, (String[])stringArray, (String)string4);
    }

    private static void convertComponentAdditionEvent(AgentEvent agentEvent, String string) {
        Collection collection = RackEventConverter.generateBeans(agentEvent, string);
        ArrayList arrayList = (ArrayList)collection;
        if (arrayList != null) {
            CIMBean[] cIMBeanArray = arrayList.toArray(new CIMBean[1]);
            PersistenceHelper.storeBeans(cIMBeanArray);
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n) instanceof StorEdgeRack_AdminDomain) {
                    arrayList.remove(n);
                }
                ++n;
            }
            cIMBeanArray = arrayList.toArray(new CIMBean[1]);
            StringBuffer stringBuffer = new StringBuffer();
            if (agentEvent.isDerived()) {
                stringBuffer.append(agentEvent.getOriginalEvent().getTopic());
            } else {
                stringBuffer.append(agentEvent.getTopic());
            }
            stringBuffer.append(".array.serack." + RackEventConverter.determineCategory(agentEvent, string));
            MessageCode messageCode = new MessageCode("event.storage.serack.insert", 1);
            Report.debug.log((Object)("Posting component addition event with topic " + stringBuffer));
            AgentEventConverter.postComponentAdditionEvent((AgentEvent)agentEvent, (String)stringBuffer.toString(), (MessageCode)messageCode, (CIMBean[])cIMBeanArray);
        } else {
            Report.info.log((Object)"Unable to generate CIMBeans for a component add event.");
        }
    }

    private static void convertComponentRemovalEvent(AgentEvent agentEvent, String string) {
        Collection collection = RackEventConverter.generateBeans(agentEvent, string);
        ArrayList arrayList = (ArrayList)collection;
        if (arrayList != null) {
            CIMBean[] cIMBeanArray = arrayList.toArray(new CIMBean[1]);
            int n = 0;
            while (n < cIMBeanArray.length) {
                if (cIMBeanArray[n] instanceof CIM_LogicalDevice) {
                    PersistenceHelper.storeBean(cIMBeanArray[n]);
                }
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (agentEvent.isDerived()) {
                stringBuffer.append(agentEvent.getOriginalEvent().getTopic());
            } else {
                stringBuffer.append(agentEvent.getTopic());
            }
            stringBuffer.append(".array.serack." + RackEventConverter.determineCategory(agentEvent, string));
            MessageCode messageCode = new MessageCode("event.storage.serack.removal", 1);
            Report.debug.log((Object)("Posting component removal event with topic " + stringBuffer));
            AgentEventConverter.postComponentRemovalEvent((AgentEvent)agentEvent, (String)stringBuffer.toString(), (MessageCode)messageCode, (CIMBean[])cIMBeanArray);
        }
    }

    private static void convertCommunicationStateChangeEvent(AgentEvent agentEvent, String string, String string2) {
        int n;
        CIMBean cIMBean;
        String string3;
        RackEventTranslator rackEventTranslator = new RackEventTranslator(string, agentEvent.getPayload());
        String string4 = RackEventConverter.determineElementID(agentEvent, rackEventTranslator);
        AgentEvent agentEvent2 = agentEvent.getOriginalEvent();
        if (agentEvent2 != null) {
            string3 = agentEvent2.getEventDevice();
        }
        if (string4 != null && (cIMBean = RackEventConverter.createBean(rackEventTranslator, string3 = ConversionHelper.getElementCategory((String)string4), n = ConversionHelper.getElementIndex((String)string4))) != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.jade.cim.bean.StorEdgeRack_PhysicalPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Report.error.log((Object)"Could not find com.sun.jade.cim.bean.StorEdgeRack_PhysicalPackage");
                return;
            }
            Collection collection = PersistenceHelper.getAssociatedBeans(clazz, cIMBean);
            if (collection != null && collection.size() > 0) {
                Collection collection2;
                Iterator iterator = collection.iterator();
                CIMBean cIMBean2 = null;
                while (iterator.hasNext()) {
                    cIMBean2 = (CIMBean)iterator.next();
                    if (cIMBean2 instanceof StorEdgeRack_SCSIController) break;
                }
                if ((collection2 = PersistenceHelper.getAllAssociatedBeans(cIMBean2)) != null && collection2.size() > 0) {
                    Iterator iterator2 = collection2.iterator();
                    while (iterator2.hasNext()) {
                        CIMBean cIMBean3 = (CIMBean)iterator2.next();
                        if (!(cIMBean3 instanceof CIM_LogicalDevice)) continue;
                        String string5 = cIMBean3.getCIMObjectPath().toString();
                        String string6 = rackEventTranslator.getComponentType(string4);
                        String string7 = ".state.update.device.array.serack." + string6;
                        Report.debug.log((Object)("Posting state change event with topic " + string7));
                        AgentEventConverter.postStateChangeEvent((AgentEvent)agentEvent, (String)string7, (CIMBean)cIMBean3, (CIMBean)cIMBean3);
                        if (agentEvent.isActionable()) {
                            RackEventConverter.convertStateChangeAlert(agentEvent, string, string5, string3, false, string2);
                        } else {
                            AgentEventConverter.clearAlert((String)string5);
                        }
                        break;
                    }
                } else {
                    Report.error.log((Object)("No associated beans were found for \n" + cIMBean2.toBeanXML()));
                }
            } else {
                Report.error.log((Object)("No PhysicalPackages were found for \n" + cIMBean.toBeanXML()));
            }
        }
        RackEventConverter.updateBeans(agentEvent, rackEventTranslator, "none");
    }

    private static void updateBeans(AgentEvent agentEvent, RackEventTranslator rackEventTranslator, String string) {
        Vector vector = rackEventTranslator.getElements();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.get(n);
                if (!string.equals(string2)) {
                    String string3 = ConversionHelper.getElementCategory((String)string2);
                    int n2 = ConversionHelper.getElementIndex((String)string2);
                    CIMBean cIMBean = RackEventConverter.createBean(rackEventTranslator, string3, n2);
                    Report.debug.log((Object)("Creating other beans in payload, Bean = " + cIMBean));
                    if (cIMBean != null) {
                        PersistenceHelper.storeBean(cIMBean);
                    }
                }
                ++n;
            }
        }
    }

    private static String determineElementID(AgentEvent agentEvent, RackEventTranslator rackEventTranslator) {
        String string = null;
        String string2 = agentEvent.getComponent();
        String string3 = ConversionHelper.getCaptionComponent((String)string2, (int)1);
        if (string3.equalsIgnoreCase("lun")) {
            string = string2;
        } else if (string3.equalsIgnoreCase("fcPort")) {
            string = string2;
        } else {
            String string4;
            Object object;
            AgentEvent agentEvent2 = agentEvent.getOriginalEvent();
            if (agentEvent2 == null) {
                Report.error.log((Object)"Received a slot event, but no original event is specified.");
                return null;
            }
            String string5 = agentEvent2.getEventDevice();
            String string6 = agentEvent2.getEventType();
            String string7 = null;
            String string8 = null;
            if ("CommunicationStateChange".equals(string6)) {
                Report.debug.log((Object)("Communication event elementID is " + string2));
                return string2;
            }
            if ("t3".equalsIgnoreCase(string5) || "DSP".equalsIgnoreCase(string5) || "6020".equalsIgnoreCase(string5) || "6120".equalsIgnoreCase(string5)) {
                object = agentEvent2.getCaption();
                string7 = ConversionHelper.getCaptionIndex((String)object);
                if (string7 == null) {
                    Report.debug.log((Object)("Received a " + string5 + " event that identified " + (String)object + " as the caption"));
                    return null;
                }
                string8 = "fruId";
            } else {
                object = agentEvent2.getCaption();
                String string9 = ConversionHelper.getCaptionSubject((String)object);
                if ("port".equals(string9)) {
                    string4 = agentEvent2.getTarget();
                    String string10 = ConversionHelper.getCaptionIndex((String)object);
                    string7 = string4 + ":" + string10;
                    string8 = "nodeId";
                } else {
                    int n = ConversionHelper.getSlotIndex((String)agentEvent.getCaption());
                    string7 = Integer.toString(n);
                    string8 = "fruSlot";
                }
            }
            object = rackEventTranslator.getElements();
            Report.debug.log((Object)("Searching instrumentation data for a key named: " + string8 + " that equals: " + string7));
            int n = 0;
            while (n < ((Vector)object).size()) {
                string4 = rackEventTranslator.getPropertyValue((String)((Vector)object).get(n), string8);
                if (string4 != null && string4.equals(string7)) {
                    string = (String)((Vector)object).get(n);
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    private static Collection generateBeans(AgentEvent agentEvent, String string) {
        DeviceReport deviceReport;
        Object object;
        RackEventTranslator rackEventTranslator = new RackEventTranslator(string, agentEvent.getPayload());
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("model");
        deviceClass2.setProperty("schema", "CIM2.5");
        deviceClass2.setProperty("view", "system");
        deviceClass2.setProperty("type", "rack");
        deviceClass2.setProperty("prefix", "StorEdgeRack");
        deviceClass2.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass3 = deviceClass2.newSubInstance();
        deviceClass3.setClassName("SystemView");
        String string2 = RackEventConverter.determineElementID(agentEvent, rackEventTranslator);
        String string3 = ConversionHelper.getElementCategory((String)string2);
        int n = ConversionHelper.getElementIndex((String)string2);
        DeviceClass deviceClass4 = deviceClass3.newSubInstance();
        RackEventConverter.populateDeviceClass(rackEventTranslator, deviceClass4, string3, n);
        if (deviceClass4 != null) {
            if (string3.equalsIgnoreCase("fcPort")) {
                object = deviceClass4.newSubInstance();
                RackEventConverter.populateDeviceClass(rackEventTranslator, object, string3, n, 4);
            } else if (!string3.equalsIgnoreCase("lun")) {
                object = deviceClass4.newSubInstance();
                RackEventConverter.populateDeviceClass(rackEventTranslator, object, string3, n, 1);
                if (object != null) {
                    deviceReport = object.newSubInstance();
                    RackEventConverter.populateDeviceClass(rackEventTranslator, (DeviceClass)deviceReport, string3, n, 2);
                    DeviceClass deviceClass5 = object.newSubInstance();
                    RackEventConverter.populateDeviceClass(rackEventTranslator, deviceClass5, string3, n, 3);
                }
            }
        } else {
            return null;
        }
        object = deviceClass.toXML();
        deviceReport = new DeviceReport((String)object);
        return deviceReport.toBeans();
    }

    private static void populateDeviceClass(RackEventTranslator rackEventTranslator, DeviceClass deviceClass, String string, int n) {
        if (string != null) {
            if ("fru".equals(string)) {
                string = rackEventTranslator.getFruType(n);
            }
            if ("sp".equals(string)) {
                rackEventTranslator.updateServiceProcessor(deviceClass, string, n);
            } else if ("ve".equals(string)) {
                rackEventTranslator.updateVirtualizationEngine(deviceClass, string, n);
            } else if ("powerUnit".equals(string)) {
                rackEventTranslator.updatePowerSupply(deviceClass, string, n);
            } else if ("diskDrive".equals(string)) {
                rackEventTranslator.updateDiskDrive(deviceClass, string, n);
            } else if ("loopCard".equals(string)) {
                rackEventTranslator.updateLoopController(deviceClass, string, n);
            } else if ("controllerCard".equals(string)) {
                rackEventTranslator.updateSCSIController(deviceClass, string, n);
            } else if ("midplane".equals(string)) {
                rackEventTranslator.updateMidplaneDevice(deviceClass, string, n);
            } else if ("switch".equals(string)) {
                rackEventTranslator.updateSwitch(deviceClass, string, n);
            } else if ("fcPort".equals(string)) {
                rackEventTranslator.updateFibrePort(deviceClass, n);
            } else if ("lun".equals(string)) {
                rackEventTranslator.updateVolume(deviceClass, n);
            } else if ("slice".equals(string)) {
                rackEventTranslator.updateLogicalDisk(deviceClass, n, string);
            } else if ("slot".equals(string)) {
                rackEventTranslator.updateSlot(deviceClass, n);
            } else if ("info".equals(string)) {
                rackEventTranslator.updateAdminDomain(deviceClass);
            } else if (string.startsWith("SRC")) {
                rackEventTranslator.updateStorageResourceController(deviceClass, string, n);
            } else if (string.startsWith("SFC")) {
                rackEventTranslator.updateSwitchFabricController(deviceClass, string, n);
            } else if (string.startsWith("SIO")) {
                rackEventTranslator.updateStorageIOController(deviceClass, string, n);
            } else if (string.startsWith("MIC")) {
                rackEventTranslator.updateManagementInterfaceController(deviceClass, string, n);
            } else if (string.startsWith("psu")) {
                rackEventTranslator.updatePowerSupply(deviceClass, string, n);
            } else if (string.startsWith("volume")) {
                rackEventTranslator.updateLogicalDisk(deviceClass, n, string);
            } else {
                Report.debug.log((Object)("Unknown component type: " + string));
                deviceClass = null;
            }
        }
    }

    private static void populateDeviceClass(RackEventTranslator rackEventTranslator, DeviceClass deviceClass, String string, int n, int n2) {
        if ("fru".equals(string)) {
            string = rackEventTranslator.getFruType(n);
        }
        switch (n2) {
            case 1: {
                rackEventTranslator.updatePhysicalPackage(deviceClass, string, n, null);
                break;
            }
            case 2: {
                rackEventTranslator.updateFRU(deviceClass, string, n);
                break;
            }
            case 3: {
                rackEventTranslator.updateLocation(deviceClass, string, n);
                break;
            }
            case 4: {
                rackEventTranslator.updateProtocolEndpoint(deviceClass, n);
                break;
            }
            default: {
                Report.debug.log((Object)("Unknown component category: " + n2));
                deviceClass = null;
            }
        }
    }

    private static CIMBean createBean(RackEventTranslator rackEventTranslator, String string, int n) {
        DeviceClass deviceClass = new DeviceClass();
        RackEventConverter.populateDeviceClass(rackEventTranslator, deviceClass, string, n);
        CIMBean cIMBean = null;
        if (deviceClass != null) {
            cIMBean = deviceClass.toBean();
        }
        return cIMBean;
    }

    private static String determineCategory(AgentEvent agentEvent, String string) {
        RackEventTranslator rackEventTranslator = new RackEventTranslator(string, agentEvent.getPayload());
        return RackEventConverter.determineCategory(agentEvent, rackEventTranslator);
    }

    private static String determineCategory(AgentEvent agentEvent, RackEventTranslator rackEventTranslator) {
        String string = null;
        String string2 = RackEventConverter.determineElementID(agentEvent, rackEventTranslator);
        if (string2 != null) {
            int n = ConversionHelper.getElementIndex((String)string2);
            string = ConversionHelper.getElementCategory((String)string2);
            if ("fru".equals(string)) {
                string = rackEventTranslator.getFruType(n);
            } else if ("slot".equals(string)) {
                string = rackEventTranslator.getComponentType(string2);
            }
        }
        return string;
    }

    private static boolean isHealed(AgentEvent agentEvent) {
        boolean bl = false;
        if (agentEvent.isDerived()) {
            if (agentEvent.getOriginalEvent().getCurrentState() > agentEvent.getOriginalEvent().getPriorState()) {
                bl = true;
            }
        } else if (agentEvent.getCurrentState() > agentEvent.getPriorState()) {
            bl = true;
        }
        return bl;
    }

    public static class Test
    extends UnitTest {
        public void test() {
            System.out.println("Testing RackEventConverter");
        }
    }
}

