/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.service.api;

import com.sun.netstorage.mgmt.esm.logic.service.api.Contract;
import com.sun.netstorage.mgmt.esm.logic.service.api.ServiceException;
import com.sun.netstorage.mgmt.esm.util.system.Configuration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;

public final class ServiceLocator {
    private static final String SCCS_ID = "@(#)ServiceLocator.java 1.11   03/08/28 SMI";
    public static final String REGISTRY_HOSTNAME_PROPERTY = "ServiceLocator.hostname";
    public static final String REGISTRY_HOSTNAME_DEFAULT = "localhost";
    public static final String REGISTRY_PORT_PROPERTY = "ServiceLocator.port";
    public static final int REGISTRY_PORT_DEFAULT = 1099;
    public static final int REGISTRY_PORT_MINIMUM = 1024;
    public static final int REGISTRY_PORT_MAXIMUM = 49151;
    private static final String REGISTRY_FACILITY_NAME = "com.sun.netstorage.mgmt.esm.logic.registry.api.RMIRegistryFacility.Singleton";
    private static Registry ourRegistry = null;
    private static final HashMap ourServiceCache = new HashMap();
    private static final HashMap ourNameKludgeMap = new HashMap();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$service$api$ServiceLocator;

    public static String getRegistryHostname() {
        String string = System.getProperty(REGISTRY_HOSTNAME_PROPERTY);
        if (string == null && (string = Configuration.getRMIRegistryHost()) == null) {
            string = REGISTRY_HOSTNAME_DEFAULT;
        }
        return string;
    }

    public static void setRegistryHostname(String string) {
        if (string == null) {
            string = REGISTRY_HOSTNAME_DEFAULT;
        }
        System.setProperty(REGISTRY_HOSTNAME_PROPERTY, string);
    }

    public static int getRegistryPort() {
        int n = 1099;
        String string = System.getProperty(REGISTRY_PORT_PROPERTY, null);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            n = Configuration.getRMIRegistryPort();
        }
        return n;
    }

    public static void setRegistryPort(int n) {
        Contract.requires((n >= 1024 ? 1 : 0) != 0, (String)"thePort >= REGISTRY_PORT_MINIMUM");
        Contract.requires((n <= 49151 ? 1 : 0) != 0, (String)"thePort <= REGISTRY_PORT_MAXIMUM");
        String string = String.valueOf(n);
        System.setProperty(REGISTRY_PORT_PROPERTY, string);
    }

    public static boolean isRegistryPortValid(int n) {
        return n >= 1024 && n <= 49151;
    }

    private static final synchronized Registry getRegistry() throws ServiceException {
        if (ourRegistry == null && (ourRegistry = ServiceLocator.getRegistryFromContainer()) == null) {
            ourRegistry = ServiceLocator.getRegistryFromClient();
        }
        return ourRegistry;
    }

    private static final Registry getRegistryFromContainer() {
        Registry registry = null;
        try {
            Class<?> clazz = Class.forName(REGISTRY_FACILITY_NAME);
            Class[] classArray = new Class[]{};
            Object[] objectArray = null;
            Method method = clazz.getDeclaredMethod("get", classArray);
            Object object = method.invoke(null, objectArray);
            if (object instanceof Registry) {
                registry = (Registry)object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {}
        return registry;
    }

    private static final Registry getRegistryFromClient() throws ServiceException {
        String string = ServiceLocator.getRegistryHostname();
        int n = ServiceLocator.getRegistryPort();
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(string, n);
        }
        catch (RemoteException remoteException) {
            throw new ServiceException.RegistryNotFound(remoteException, string, n);
        }
        return registry;
    }

    private static final void resetRegistry() {
        ourRegistry = null;
    }

    private static final void resetRegistry(RemoteException remoteException) throws ServiceException {
        ServiceLocator.resetRegistry();
        throw new ServiceException.RegistryUnavailable(remoteException, ServiceLocator.getRegistryHostname(), ServiceLocator.getRegistryPort());
    }

    private static Remote getCachedImpl(Class clazz) {
        Contract.requires((clazz != null ? 1 : 0) != 0, (String)"theServiceInterface != null");
        return (Remote)ourServiceCache.get(clazz);
    }

    private static void setCachedImpl(Class clazz, Remote remote) {
        Contract.requires((clazz != null ? 1 : 0) != 0, (String)"theServiceInterface != null");
        Contract.requires((remote != null ? 1 : 0) != 0, (String)"theServiceImpl != null");
        ourServiceCache.put(clazz, remote);
    }

    public static void flushService(Class clazz) {
        Contract.requires((clazz != null ? 1 : 0) != 0, (String)"theServiceInterface != null");
        ourServiceCache.remove(clazz);
    }

    public static void flushAllServices() {
        ourServiceCache.clear();
    }

    private static String getNameKludge(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theServiceName != null");
        return (String)ourNameKludgeMap.get(string);
    }

    private static void setNameKludge(String string, String string2) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theServiceName != null");
        Contract.requires((string2 != null ? 1 : 0) != 0, (String)"theServiceNameKludge != null");
        ourNameKludgeMap.put(string, string2);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("missing required arguments\n\n");
            stringBuffer.append("Usage: java ");
            stringBuffer.append((class$com$sun$netstorage$mgmt$esm$logic$service$api$ServiceLocator == null ? (class$com$sun$netstorage$mgmt$esm$logic$service$api$ServiceLocator = ServiceLocator.class$("com.sun.netstorage.mgmt.esm.logic.service.api.ServiceLocator")) : class$com$sun$netstorage$mgmt$esm$logic$service$api$ServiceLocator).getName());
            stringBuffer.append(" <service-name> ...");
            ServiceLocator.error(stringBuffer.toString());
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                System.out.print("loading service: ");
                System.out.println(stringArray[n]);
                Remote remote = ServiceLocator.getService(stringArray[n]);
                System.out.print("loaded service: ");
                System.out.println(remote);
            }
            catch (ServiceException serviceException) {
                ServiceLocator.error("cannot load service", (Throwable)((Object)serviceException));
            }
            ++n;
        }
    }

    private static void error(String string, Throwable throwable) {
        System.err.print("ServiceLocator: ERROR: ");
        System.err.println(string);
        if (throwable != null) {
            System.err.print("\t");
            System.err.println(throwable.getMessage());
        }
    }

    private static void error(String string) {
        ServiceLocator.error(string, null);
    }

    private static Remote getService(String string) throws ServiceException {
        Remote remote = null;
        try {
            Class<?> clazz = Class.forName(string);
            remote = ServiceLocator.getService(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLocator.error("dynamic class loading failed", classNotFoundException);
        }
        return remote;
    }

    public static final Remote getService(Class clazz) throws ServiceException {
        Contract.requires((clazz != null ? 1 : 0) != 0, (String)"theServiceInterface != null");
        Remote remote = ServiceLocator.getCachedImpl(clazz);
        if (remote == null) {
            remote = ServiceLocator.getRemoteImpl(clazz);
        }
        if (remote == null) {
            String string = clazz.getName();
            throw new ServiceException.ServiceNotFound(string);
        }
        ServiceLocator.setCachedImpl(clazz, remote);
        return remote;
    }

    private static final Remote getRemoteImpl(Class clazz) throws ServiceException {
        Remote remote = ServiceLocator.getSvcProxyFromRegistry(clazz);
        return (Remote)Proxy.newProxyInstance(remote.getClass().getClassLoader(), remote.getClass().getInterfaces(), (InvocationHandler)new ReconnectHandler(remote, clazz));
    }

    private static final Remote getSvcProxyFromRegistry(Class clazz) throws ServiceException {
        Contract.requires((clazz != null ? 1 : 0) != 0, (String)"theServiceInterface != null");
        Registry registry = ServiceLocator.getRegistry();
        Remote remote = null;
        String string = clazz.getName();
        NotBoundException notBoundException = null;
        int n = 1;
        while (n <= 2) {
            try {
                try {
                    remote = registry.lookup(string);
                }
                catch (NotBoundException notBoundException2) {
                    notBoundException = notBoundException2;
                    try {
                        String string2 = clazz.getPackage().getName();
                        remote = registry.lookup(string2);
                    }
                    catch (NotBoundException notBoundException3) {
                        try {
                            String string3 = ServiceLocator.getNameKludge(string);
                            if (string3 == null) break;
                            remote = registry.lookup(string3);
                        }
                        catch (NotBoundException notBoundException4) {}
                    }
                }
                break;
            }
            catch (RemoteException remoteException) {
                if (n == 1) {
                    ServiceLocator.resetRegistry();
                } else {
                    ServiceLocator.resetRegistry(remoteException);
                }
                ++n;
            }
        }
        if (remote == null) {
            throw new ServiceException.ServiceNotFound(notBoundException, string);
        }
        Contract.ensures((remote != null ? 1 : 0) != 0, (String)"service != null");
        return remote;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ServiceLocator.setNameKludge("com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService", "com.sun.jade.services.asset");
        ServiceLocator.setNameKludge("com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmService", "ESM_ALARM_SERVICE");
        ServiceLocator.setNameKludge("com.sun.netstorage.mgmt.esm.logic.notification.api.NotificationService", "notification");
    }

    private static final class ReconnectHandler
    implements InvocationHandler {
        private Object target;
        private final Class lookupKey;
        private static final int MAX_ATTEMPTS = 2;

        public ReconnectHandler(Object object, Class clazz) {
            this.target = object;
            this.lookupKey = clazz;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2 = this.target;
            int n = 1;
            while (n <= 3) {
                if (n == 3) {
                    ServiceLocator.flushService(this.lookupKey);
                    try {
                        object2 = ServiceLocator.getSvcProxyFromRegistry(this.lookupKey);
                    }
                    catch (ServiceException serviceException) {
                        throw new RemoteException(serviceException.getMessage(), (Throwable)((Object)serviceException));
                    }
                }
                try {
                    Object object3 = method.invoke(object2, objectArray);
                    this.target = object2;
                    return object3;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof RemoteException) {
                        if (n == 3) {
                            throw throwable;
                        }
                    } else {
                        throw throwable;
                    }
                    ++n;
                }
            }
            return null;
        }
    }
}

