/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.Zone;
import com.sun.netstorage.mgmt.services.topology.ZoneImpl;
import java.util.HashMap;
import java.util.Map;

class ZoneTopology {
    private Map zones_ = new HashMap();
    static final String sccs_id = "@(#)ZoneTopology.java %I  02/11/07 SMI";

    protected Zone[] getZones() {
        return this.zones_.values().toArray(new Zone[0]);
    }

    protected void addZone(String string) throws TopologyDuplicateElementException {
        if (this.containsZone(string)) {
            throw new TopologyDuplicateElementException("Given zone already exists.");
        }
        this.zones_.put(string, new ZoneImpl(string));
    }

    protected void removeZone(String string) throws TopologyElementNotFoundException {
        ZoneImpl zoneImpl = this.getZone(string);
        if (zoneImpl != null) {
            this.zones_.remove(string);
            return;
        }
        throw new TopologyElementNotFoundException("Zone with given name not found within fabric");
    }

    protected void addZoneMember(String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException, TopologyDuplicateElementException {
        ZoneImpl zoneImpl = this.getZone(string);
        if (zoneImpl != null) {
            zoneImpl.addMember(tSTopologyNode);
            return;
        }
        throw new TopologyElementNotFoundException("Zone with given name not found within fabric");
    }

    protected void removeZoneMember(String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        ZoneImpl zoneImpl = this.getZone(string);
        if (zoneImpl != null) {
            zoneImpl.removeMember(tSTopologyNode);
            return;
        }
        throw new TopologyElementNotFoundException("Zone with given name not found within fabric");
    }

    private boolean containsZone(String string) {
        return this.zones_.get(string) != null;
    }

    protected ZoneImpl getZone(String string) {
        return (ZoneImpl)this.zones_.get(string);
    }

    public String toString() {
        return "There are " + this.zones_.size() + " zones present.";
    }

    protected String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<zonesList>");
        Zone[] zoneArray = this.getZones();
        int n = 0;
        while (n < zoneArray.length) {
            stringBuffer.append(zoneArray[n].toXML());
            ++n;
        }
        stringBuffer.append("</zonesList>");
        return stringBuffer.toString();
    }
}

