/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.Configuration;
import com.sun.netstorage.mgmt.services.topology.FabricId;
import com.sun.netstorage.mgmt.services.topology.ManagementDomain;
import com.sun.netstorage.mgmt.services.topology.PhysicalTopologyBuilder;
import com.sun.netstorage.mgmt.services.topology.RootRealm;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.StoradeAdapter;
import com.sun.netstorage.mgmt.services.topology.StoradeAdapterSim;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyMalformedNodeException;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyService;
import com.sun.netstorage.mgmt.services.topology.ZoneTopologyBuilder;
import java.io.PrintWriter;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class TopologyServiceImpl
implements TopologyService,
PhysicalTopologyBuilder,
ZoneTopologyBuilder {
    static final String sccs_id = "@(#)TopologyServiceImpl.java 1.66  03/10/02 SMI";
    private static TopologyServiceImpl instance_ = null;
    private ManagementDomain domain_ = new ManagementDomain();
    private RootRealm rootRealm_ = new RootRealm();
    private static boolean refresh_ = true;
    private static long jadeLastUpdateTime_ = 0L;
    private static com.sun.jade.apps.topology.TopologyService jadeTopoService_ = null;
    private static final String JADE_TOPO = "com.sun.jade.apps.topology";
    private Locale myLocale_ = null;

    public synchronized void addChildren(TSTopologyNode tSTopologyNode, TSTopologyNode[] tSTopologyNodeArray) throws TopologyElementNotFoundException {
        if (tSTopologyNode != null && tSTopologyNodeArray != null && tSTopologyNodeArray.length > 0) {
            if (!this.rootRealm_.contains(tSTopologyNode)) {
                throw new TopologyElementNotFoundException("Node not found within topology.");
            }
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (this.rootRealm_.contains(tSTopologyNodeArray[n])) {
                    ((TopologyNodeAdapter)tSTopologyNode).add(tSTopologyNodeArray[n]);
                    ((TopologyNodeAdapter)tSTopologyNodeArray[n]).setImmediateParent((TopologyNodeAdapter)tSTopologyNode);
                }
                ++n;
            }
        }
    }

    public synchronized void addProperty(TSTopologyNode tSTopologyNode, Object object, Object object2) throws TopologyElementNotFoundException {
        if (tSTopologyNode != null && object != null && object2 != null) {
            this.rootRealm_.addProperty(tSTopologyNode, object, object2);
        }
    }

    public synchronized int getOrphanNodeCount() {
        return this.domain_.getOrphanNodeCount();
    }

    public synchronized TSTopologyNode[] getOrphanNodes() {
        return this.domain_.getOrphanNodes();
    }

    public synchronized SanTopology getSanTopology(String string) throws TopologyElementNotFoundException {
        return this.getSanTopology(string, null);
    }

    public synchronized void removeEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, Object object) throws TopologyElementNotFoundException {
        if (tSTopologyNode != null && tSTopologyNode2 != null && object != null) {
            this.domain_.removeEdge(tSTopologyNode, tSTopologyNode2, object);
        }
    }

    public synchronized void removeNode(TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        if (tSTopologyNode != null && this.rootRealm_.contains(tSTopologyNode)) {
            this.rootRealm_.removeNode(tSTopologyNode);
            this.domain_.removeNode(tSTopologyNode);
            return;
        }
        throw new TopologyElementNotFoundException("Node not found within topology.");
    }

    public synchronized void addZone(FabricId fabricId, String string) throws TopologyDuplicateElementException, TopologyElementNotFoundException {
        if (fabricId != null && string != null) {
            this.domain_.addZone(fabricId, string);
        }
    }

    public synchronized void removeZone(FabricId fabricId, String string) throws TopologyElementNotFoundException {
        if (fabricId != null && string != null) {
            this.domain_.removeZone(fabricId, string);
        }
    }

    public synchronized void addZoneMember(FabricId fabricId, String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException, TopologyDuplicateElementException {
        if (fabricId != null && string != null && tSTopologyNode != null) {
            this.domain_.addZoneMember(fabricId, string, tSTopologyNode);
        }
    }

    public synchronized void removeZoneMember(FabricId fabricId, String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        if (fabricId != null && string != null && tSTopologyNode != null) {
            this.domain_.removeZoneMember(fabricId, string, tSTopologyNode);
        }
    }

    private TopologyServiceImpl(Locale locale) {
        this.myLocale_ = locale;
    }

    public synchronized void addEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, boolean bl, Map map) throws TopologyElementNotFoundException {
        if (tSTopologyNode != null && tSTopologyNode2 != null && string != null) {
            this.domain_.addEdge(tSTopologyNode, tSTopologyNode2, string, bl, map);
        }
    }

    public synchronized TSTopologyNode addNode(String string, String string2, String string3, Map map, TSTopologyNode[] tSTopologyNodeArray, FabricId fabricId, TSTopologyNode tSTopologyNode) throws TopologyDuplicateElementException, TopologyMalformedNodeException {
        TSTopologyNode tSTopologyNode2 = null;
        if (string == null || string2 == null || string3 == null) {
            throw new TopologyMalformedNodeException(string, string2, string3);
        }
        tSTopologyNode2 = this.domain_.addNode(string, string2, string3, map, tSTopologyNodeArray, fabricId, (TopologyNodeAdapter)tSTopologyNode);
        this.rootRealm_.addNode(tSTopologyNode2);
        return tSTopologyNode2;
    }

    public synchronized TSTopologyNode findNode(Object object) {
        if (object != null) {
            return this.rootRealm_.findNode(object);
        }
        return null;
    }

    public static synchronized TopologyServiceImpl getInstance() {
        return TopologyServiceImpl.getInstance(null);
    }

    public static synchronized TopologyServiceImpl getInstance(Locale locale) {
        if (instance_ == null) {
            instance_ = new TopologyServiceImpl(locale);
        }
        return instance_;
    }

    protected Locale getLocale() {
        return this.myLocale_;
    }

    protected RootRealm getRootRealm() {
        return this.rootRealm_;
    }

    public synchronized SanTopology getSanTopology(String string, PrintWriter printWriter) throws TopologyElementNotFoundException {
        block12: {
            try {
                TSTopologyNode[] tSTopologyNodeArray;
                int n = -1;
                StoradeAdapter storadeAdapter = null;
                long l = 0L;
                if (jadeTopoService_ != null) {
                    try {
                        l = jadeTopoService_.getLastUpdateTime();
                    }
                    catch (RemoteException remoteException) {
                        refresh_ = true;
                    }
                }
                if (!refresh_ && printWriter == null && l <= jadeLastUpdateTime_) break block12;
                this.reset();
                String string2 = Configuration.getProperty("TR_REGISTRY_HOST");
                String string3 = Configuration.getProperty("TR_RMI_REGISTRY_PORT");
                if (string3 != null) {
                    n = Integer.parseInt(string3);
                }
                try {
                    tSTopologyNodeArray = LocateRegistry.getRegistry(string2, n);
                    jadeTopoService_ = (com.sun.jade.apps.topology.TopologyService)tSTopologyNodeArray.lookup(JADE_TOPO);
                }
                catch (Exception exception) {
                    Registry registry = LocateRegistry.getRegistry(string2, n);
                    jadeTopoService_ = (com.sun.jade.apps.topology.TopologyService)registry.lookup(JADE_TOPO);
                }
                jadeLastUpdateTime_ = l;
                storadeAdapter = new StoradeAdapter(jadeTopoService_);
                if (printWriter != null) {
                    printWriter.println();
                    printWriter.println("*** GJG_DEBUG ***: TopologyServiceImpl.getSanTopology(): ");
                    printWriter.println("Attempting to refresh the data (from JADE),and return new SAN. ");
                    printWriter.println("TIMESTAMP: " + new Date());
                    printWriter.println();
                }
                tSTopologyNodeArray = storadeAdapter.beginStoradePull(printWriter);
                refresh_ = false;
            }
            catch (RemoteException remoteException) {
                if (printWriter != null) {
                    printWriter.println();
                    printWriter.println("*** GJG_DEBUG ***: JADE topology service threw RemoteException in getSanTopology()! ");
                    printWriter.println("The exception was: ");
                    printWriter.println(remoteException.getMessage());
                    printWriter.println();
                }
                throw new TopologyElementNotFoundException(remoteException);
            }
            catch (NotBoundException notBoundException) {
                if (printWriter != null) {
                    printWriter.println();
                    printWriter.println("*** GJG_DEBUG ***: JADE topology service threw NotBoundException in getSanTopology()! ");
                    printWriter.println("The exception was: ");
                    printWriter.println(notBoundException.getMessage());
                    printWriter.println();
                }
                throw new TopologyElementNotFoundException(notBoundException);
            }
        }
        return this.getSanTopologyCached("Default Root SAN");
    }

    protected synchronized SanTopology getSanTopologyCached() {
        return this.domain_.getSan("Default Root SAN");
    }

    public synchronized SanTopology getSanTopologyCached(String string) throws TopologyElementNotFoundException {
        if (refresh_) {
            throw new TopologyElementNotFoundException("SAN with given name does NOT exist.");
        }
        return this.getSanTopologyCached();
    }

    public synchronized SanTopology getSanTopologySim(String string) throws TopologyElementNotFoundException {
        this.reset();
        StoradeAdapterSim storadeAdapterSim = new StoradeAdapterSim();
        TSTopologyNode[] tSTopologyNodeArray = storadeAdapterSim.beginStoradePull(string);
        refresh_ = true;
        return this.domain_.getSan("Default Root SAN");
    }

    public synchronized boolean isOrphanNode(TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode != null) {
            return this.domain_.orphanNodeExists(tSTopologyNode);
        }
        return false;
    }

    protected void moveAllOrphans() {
        this.domain_.moveAllOrphans();
    }

    protected void reset() {
        refresh_ = true;
        this.domain_ = new ManagementDomain();
        this.rootRealm_ = new RootRealm();
    }

    public String toString() {
        return this.domain_.toString();
    }
}

