/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.TSTopologyEdge;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyMutableGraphAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import diva.graph.modular.Edge;
import diva.graph.modular.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TopologyGraphAdapter
extends TopologyMutableGraphAdapter
implements TopologyGraph {
    private static final String FAKE_EDGE_SEMANTIC = "Fake/Unused Edge Semantic! ";
    private List fabricNames_ = null;
    static final String sccs_id = "@(#)TopologyGraphAdapter.java 1.29   03/07/10 SMI";

    public synchronized boolean contains(TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode != null) {
            Iterator iterator = this.nodes(this.getRoot());
            while (iterator.hasNext()) {
                TSTopologyNode tSTopologyNode2 = (TSTopologyNode)iterator.next();
                if (!tSTopologyNode2.equals(tSTopologyNode)) continue;
                return true;
            }
        }
        return false;
    }

    private TSTopologyNode[][] convertToArrays(List list) {
        TSTopologyNode[][] tSTopologyNodeArray = new TSTopologyNode[list.size()][];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = 0;
            List list2 = (List)iterator.next();
            tSTopologyNodeArray[n] = new TSTopologyNode[list2.size()];
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                tSTopologyNodeArray[n][n2++] = (TSTopologyNode)iterator2.next();
            }
            ++n;
        }
        return tSTopologyNodeArray;
    }

    public synchronized String getId() {
        return ((TopologyNodeAdapter)this.getRoot()).getId();
    }

    public synchronized int getNodeCount() {
        return this.getNodeCount(this.getRoot());
    }

    public synchronized TSTopologyNode[] getNodes() {
        int n = this.getNodeCount();
        int n2 = 0;
        TSTopologyNode[] tSTopologyNodeArray = new TSTopologyNode[n];
        Iterator iterator = this.nodes(this.getRoot());
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            tSTopologyNodeArray[n2++] = tSTopologyNode;
        }
        return tSTopologyNodeArray;
    }

    public synchronized TSTopologyNode[] getNodesByType(String string) {
        int n = this.getNodeCount();
        TSTopologyNode[] tSTopologyNodeArray = new TSTopologyNode[n];
        if (string != null && n > 0) {
            int n2 = 0;
            TSTopologyNode[] tSTopologyNodeArray2 = this.getNodes();
            int n3 = 0;
            while (n3 < tSTopologyNodeArray2.length) {
                if (tSTopologyNodeArray2[n3].getType().equals(string)) {
                    tSTopologyNodeArray[n2++] = tSTopologyNodeArray2[n3];
                }
                ++n3;
            }
            tSTopologyNodeArray = this.trimArray(tSTopologyNodeArray, n2);
        }
        return tSTopologyNodeArray;
    }

    public synchronized TSTopologyNode[] getPeers(TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode != null && this.contains(tSTopologyNode)) {
            TSTopologyNode tSTopologyNode2 = null;
            HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
            TSTopologyEdge[] tSTopologyEdgeArray = tSTopologyNode.getInEdges();
            int n = 0;
            while (n < tSTopologyEdgeArray.length) {
                tSTopologyNode2 = tSTopologyEdgeArray[n].getHeadNode();
                hashSet.add(tSTopologyNode2);
                ++n;
            }
            TSTopologyEdge[] tSTopologyEdgeArray2 = tSTopologyNode.getOutEdges();
            int n2 = 0;
            while (n2 < tSTopologyEdgeArray2.length) {
                tSTopologyNode2 = tSTopologyEdgeArray2[n2].getTailNode();
                hashSet.add(tSTopologyNode2);
                ++n2;
            }
            return hashSet.toArray(new TSTopologyNode[hashSet.size()]);
        }
        return new TSTopologyNode[0];
    }

    public String toString() {
        return "Graph id: " + this.getId() + ", node count: " + this.getNodeCount();
    }

    private TSTopologyNode[] trimArray(TSTopologyNode[] tSTopologyNodeArray, int n) {
        TSTopologyNode[] tSTopologyNodeArray2 = new TSTopologyNode[n];
        int n2 = 0;
        while (n2 < n) {
            tSTopologyNodeArray2[n2] = tSTopologyNodeArray[n2];
            ++n2;
        }
        return tSTopologyNodeArray2;
    }

    public TopologyGraphAdapter(Graph graph, List list) {
        super(graph);
        this.fabricNames_ = list;
    }

    protected boolean contains(String string, String string2, String string3) {
        if (string != null) {
            Iterator iterator = this.nodes(this.getRoot());
            while (iterator.hasNext()) {
                TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
                if (!tSTopologyNode.getOid().equals(string) || !tSTopologyNode.getId().equals(string2) || !tSTopologyNode.getType().equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    private int determineRecursion(TSTopologyNode tSTopologyNode) {
        String string = tSTopologyNode.getType();
        if (string.equals("com.sun.netstorage.mgmt.component.model.domain.NxPort")) {
            TSTopologyNode tSTopologyNode2 = tSTopologyNode.getImmediateParent();
            string = tSTopologyNode2.getType();
        } else if (string.equals("com.sun.netstorage.mgmt.component.model.domain.HostCluster")) {
            string = "com.sun.netstorage.mgmt.component.model.domain.StorageHost";
        } else if (string.equals("com.sun.netstorage.mgmt.component.model.domain.SubSystemCluster")) {
            string = "com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem";
        }
        if (string.equals("com.sun.netstorage.mgmt.component.model.domain.HBA") || string.equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost")) {
            return 1;
        }
        if (string.equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
            return 2;
        }
        return 0;
    }

    private Set findCascadedSwitches(Set set) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        HashSet<TSTopologyNode> hashSet2 = new HashSet<TSTopologyNode>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            if (!tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Switch")) continue;
            hashSet.add(tSTopologyNode);
            hashSet2.addAll(this.findCascadedSwitchesOutbound(tSTopologyNode, hashSet));
            hashSet2.addAll(this.findCascadedSwitchesInbound(tSTopologyNode, hashSet));
            hashSet2.add(tSTopologyNode);
        }
        hashSet2.addAll(this.findSwitchPorts(hashSet2));
        return hashSet2;
    }

    private Set findCascadedSwitchesInbound(TSTopologyNode tSTopologyNode, Set set) {
        Set<TSTopologyNode> set2 = new HashSet<TSTopologyNode>();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            TSTopologyEdge[] tSTopologyEdgeArray = tSTopologyNodeArray[n].getInEdges();
            int n2 = 0;
            while (n2 < tSTopologyEdgeArray.length) {
                TSTopologyNode tSTopologyNode2 = tSTopologyEdgeArray[n2].getHeadNode();
                if (tSTopologyNode2.getType().equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort")) {
                    TSTopologyNode tSTopologyNode3 = tSTopologyNode2.getImmediateParent();
                    if (!set.contains(tSTopologyNode3)) {
                        set.add(tSTopologyNode3);
                        set2 = this.findCascadedSwitchesInbound(tSTopologyNode3, set);
                    }
                    set2.add(tSTopologyNode3);
                }
                ++n2;
            }
            ++n;
        }
        return set2;
    }

    private Set findCascadedSwitchesOutbound(TSTopologyNode tSTopologyNode, Set set) {
        Set<TSTopologyNode> set2 = new HashSet<TSTopologyNode>();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            TSTopologyEdge[] tSTopologyEdgeArray = tSTopologyNodeArray[n].getOutEdges();
            int n2 = 0;
            while (n2 < tSTopologyEdgeArray.length) {
                TSTopologyNode tSTopologyNode2 = tSTopologyEdgeArray[n2].getTailNode();
                if (tSTopologyNode2.getType().equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort")) {
                    TSTopologyNode tSTopologyNode3 = tSTopologyNode2.getImmediateParent();
                    if (!set.contains(tSTopologyNode3)) {
                        set.add(tSTopologyNode3);
                        set2 = this.findCascadedSwitchesOutbound(tSTopologyNode3, set);
                    }
                    set2.add(tSTopologyNode3);
                }
                ++n2;
            }
            ++n;
        }
        return set2;
    }

    private Set findComposites(TSTopologyNode tSTopologyNode) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.getAllParents(tSTopologyNode));
        if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost")) {
            hashSet.addAll(this.findHostChildren(tSTopologyNode));
        } else if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
            hashSet.addAll(this.findStorageChildren(tSTopologyNode));
        }
        return hashSet;
    }

    private Set findHostChildren(TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            if (this.contains(tSTopologyNodeArray[n])) {
                hashSet.add(tSTopologyNodeArray[n]);
                TSTopologyNode[] tSTopologyNodeArray2 = tSTopologyNodeArray[n].getChildren();
                int n2 = 0;
                while (n2 < tSTopologyNodeArray2.length) {
                    hashSet.add(tSTopologyNodeArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet;
    }

    private Set findPeerableNodes(Set set, TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        if (this.isHbaOrSwitchType(tSTopologyNode) || this.isSSSType(tSTopologyNode)) {
            hashSet.add(tSTopologyNode);
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TSTopologyNode tSTopologyNode2 = (TSTopologyNode)iterator.next();
                String string = tSTopologyNode2.getType();
                if (!this.isHbaOrSwitchType(tSTopologyNode2) && !this.isSSSType(tSTopologyNode2)) continue;
                hashSet.add(tSTopologyNode2);
            }
        }
        return hashSet;
    }

    private Set findStorageChildren(TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            hashSet.add(tSTopologyNodeArray[n]);
            ++n;
        }
        return hashSet;
    }

    private Set findSwitches(TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost")) {
            TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                TSTopologyNode[] tSTopologyNodeArray2 = this.getPeers(tSTopologyNodeArray[n]);
                int n2 = 0;
                while (n2 < tSTopologyNodeArray2.length) {
                    hashSet.add(tSTopologyNodeArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        } else if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
            TSTopologyNode[] tSTopologyNodeArray = this.getPeers(tSTopologyNode);
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                hashSet.add(tSTopologyNodeArray[n]);
                ++n;
            }
        }
        hashSet.addAll(this.findSwitchPorts(hashSet));
        return hashSet;
    }

    private Set findSwitchPorts(Set set) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            if (!tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Switch")) continue;
            TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                hashSet.add(tSTopologyNodeArray[n]);
                ++n;
            }
        }
        return hashSet;
    }

    public TSTopologyEdge[] getAllEdges() {
        HashSet<TSTopologyEdge> hashSet = new HashSet<TSTopologyEdge>();
        TSTopologyNode[] tSTopologyNodeArray = this.getNodes();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            String string = tSTopologyNodeArray[n].getType();
            if (string.equals("com.sun.netstorage.mgmt.component.model.domain.NxPort") || string.equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort")) {
                TSTopologyEdge[] tSTopologyEdgeArray = tSTopologyNodeArray[n].getInEdges();
                int n2 = 0;
                while (n2 < tSTopologyEdgeArray.length) {
                    hashSet.add(tSTopologyEdgeArray[n2]);
                    ++n2;
                }
                TSTopologyEdge[] tSTopologyEdgeArray2 = tSTopologyNodeArray[n].getOutEdges();
                int n3 = 0;
                while (n3 < tSTopologyEdgeArray2.length) {
                    hashSet.add(tSTopologyEdgeArray2[n3]);
                    ++n3;
                }
            }
            ++n;
        }
        return hashSet.toArray(new TSTopologyEdge[hashSet.size()]);
    }

    private Set getAllParents(TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        TSTopologyNode tSTopologyNode2 = tSTopologyNode.getImmediateParent();
        while (tSTopologyNode2 != null && !tSTopologyNode2.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Fabric")) {
            hashSet.add(tSTopologyNode2);
            tSTopologyNode2 = tSTopologyNode2.getImmediateParent();
        }
        return hashSet;
    }

    protected Set getConnectivityGraph(TSTopologyNode tSTopologyNode, boolean bl) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        hashSet.add(tSTopologyNode);
        hashSet.addAll(this.getAllParents(tSTopologyNode));
        if (!bl) {
            hashSet.addAll(this.getConnectivityGraphShallow(tSTopologyNode));
        } else {
            HashSet<TSTopologyNode> hashSet2 = new HashSet<TSTopologyNode>();
            hashSet2.add(tSTopologyNode);
            hashSet.addAll(this.recurseChildren(tSTopologyNode, hashSet2));
            Set set = this.findPeerableNodes(hashSet, tSTopologyNode);
            int n = this.determineRecursion(tSTopologyNode);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TSTopologyNode tSTopologyNode2 = (TSTopologyNode)iterator.next();
                hashSet2 = new HashSet();
                hashSet2.add(tSTopologyNode);
                Set set2 = this.getPeersRecurse(tSTopologyNode2, hashSet2, n);
                hashSet.addAll(set2);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    TSTopologyNode tSTopologyNode3 = (TSTopologyNode)iterator2.next();
                    hashSet2 = new HashSet();
                    hashSet2.add(tSTopologyNode3);
                    hashSet.addAll(this.getAllParents(tSTopologyNode3));
                    hashSet.addAll(this.recurseChildren(tSTopologyNode3, hashSet2));
                }
            }
        }
        return hashSet;
    }

    private Set getConnectivityGraphShallow(TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        if (this.isPortType(tSTopologyNode)) {
            hashSet.addAll(this.getPeersAndParents(tSTopologyNode));
            return hashSet;
        }
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            HashSet<TSTopologyNode> hashSet2 = new HashSet<TSTopologyNode>();
            hashSet.add(tSTopologyNodeArray[n]);
            if (this.isPortType(tSTopologyNodeArray[n])) {
                hashSet.addAll(this.getPeersAndParents(tSTopologyNodeArray[n]));
            } else {
                hashSet2.add(tSTopologyNodeArray[n]);
                hashSet.addAll(this.recurseChildrenGetPeers(tSTopologyNodeArray[n], hashSet2));
            }
            ++n;
        }
        return hashSet;
    }

    public synchronized String[] getFabricNames() {
        return this.fabricNames_.toArray(new String[this.fabricNames_.size()]);
    }

    private Set getFullPathsOnly(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        if (!this.contains(tSTopologyNode) || !this.contains(tSTopologyNode2)) {
            return hashSet;
        }
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            ArrayList<TSTopologyNode> arrayList = new ArrayList<TSTopologyNode>();
            ArrayList arrayList2 = new ArrayList();
            arrayList.add(tSTopologyNodeArray[n]);
            List list = this.getFullPathsOnly(tSTopologyNodeArray[n], tSTopologyNode2, arrayList, arrayList2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    TSTopologyNode tSTopologyNode3 = (TSTopologyNode)iterator2.next();
                    hashSet.add(tSTopologyNode3);
                    TSTopologyNode[] tSTopologyNodeArray2 = tSTopologyNode3.getChildren();
                    int n2 = 0;
                    while (n2 < tSTopologyNodeArray2.length) {
                        hashSet.add(tSTopologyNodeArray2[n2]);
                        TSTopologyNode[] tSTopologyNodeArray3 = tSTopologyNodeArray2[n2].getChildren();
                        int n3 = 0;
                        while (n3 < tSTopologyNodeArray3.length) {
                            hashSet.add(tSTopologyNodeArray3[n3]);
                            ++n3;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return hashSet;
    }

    private List getFullPathsOnly(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, List list, List list2) {
        if (tSTopologyNode.equals(tSTopologyNode2)) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(list);
            list2.add(arrayList);
            return list2;
        }
        Iterator iterator = ((TopologyNodeAdapter)tSTopologyNode).outEdges();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            TSTopologyNode tSTopologyNode3 = (TSTopologyNode)edge.getTail();
            if (list.contains(tSTopologyNode3)) continue;
            list.add(tSTopologyNode3);
            this.getFullPathsOnly(tSTopologyNode3, tSTopologyNode2, list, list2);
            list.remove(tSTopologyNode3);
        }
        return list2;
    }

    protected Set getPathsGraph(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, boolean bl) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        if (!bl && tSTopologyNode != null && tSTopologyNode2 != null) {
            hashSet.addAll(this.getFullPathsOnly(tSTopologyNode, tSTopologyNode2));
            if (hashSet.size() > 0) {
                hashSet.add(tSTopologyNode);
                hashSet.add(tSTopologyNode2);
            }
        } else if (bl) {
            if (tSTopologyNode != null) {
                hashSet.add(tSTopologyNode);
                hashSet.addAll(this.findSwitches(tSTopologyNode));
                hashSet.addAll(this.findComposites(tSTopologyNode));
            }
            if (tSTopologyNode2 != null) {
                hashSet.add(tSTopologyNode2);
                hashSet.addAll(this.findSwitches(tSTopologyNode2));
                hashSet.addAll(this.findComposites(tSTopologyNode2));
            }
            hashSet.addAll(this.findCascadedSwitches(hashSet));
        }
        return hashSet;
    }

    private Set getPeersAndParents(TSTopologyNode tSTopologyNode) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        TSTopologyNode[] tSTopologyNodeArray = this.getPeers(tSTopologyNode);
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            hashSet.add(tSTopologyNodeArray[n]);
            hashSet.addAll(this.getAllParents(tSTopologyNodeArray[n]));
            ++n;
        }
        return hashSet;
    }

    private Set getPeersRecurse(TSTopologyNode tSTopologyNode, Set set, int n) {
        Set set2 = new HashSet();
        TSTopologyNode[] tSTopologyNodeArray = this.getPeers(tSTopologyNode);
        int n2 = 0;
        while (n2 < tSTopologyNodeArray.length) {
            block4: {
                block3: {
                    if (set.contains(tSTopologyNodeArray[n2])) break block3;
                    if (n == 0 && !tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Switch") || n == 1 && tSTopologyNodeArray[n2].getType().equals("com.sun.netstorage.mgmt.component.model.domain.HBA") || n == 2 && tSTopologyNodeArray[n2].getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) break block4;
                    set.add(tSTopologyNodeArray[n2]);
                    set2 = this.getPeersRecurse(tSTopologyNodeArray[n2], set, n);
                }
                set2.addAll(set);
            }
            ++n2;
        }
        return set2;
    }

    private boolean isHbaOrSwitchType(TSTopologyNode tSTopologyNode) {
        String string = tSTopologyNode.getType();
        return string.equals("com.sun.netstorage.mgmt.component.model.domain.HBA") || string.equals("com.sun.netstorage.mgmt.component.model.domain.Switch");
    }

    private boolean isPortType(TSTopologyNode tSTopologyNode) {
        String string = tSTopologyNode.getType();
        return string.equals("com.sun.netstorage.mgmt.component.model.domain.NxPort") || string.equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort");
    }

    private boolean isSSSType(TSTopologyNode tSTopologyNode) {
        return tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem");
    }

    private Set recurseChildren(TSTopologyNode tSTopologyNode, Set set) {
        Set set2 = new HashSet();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            if (!set.contains(tSTopologyNodeArray[n])) {
                set.add(tSTopologyNodeArray[n]);
                set2 = this.recurseChildren(tSTopologyNodeArray[n], set);
            }
            set2.addAll(set);
            ++n;
        }
        return set2;
    }

    private Set recurseChildrenGetPeers(TSTopologyNode tSTopologyNode, Set set) {
        Set set2 = new HashSet();
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            if (!set.contains(tSTopologyNodeArray[n])) {
                set.add(tSTopologyNodeArray[n]);
                set2 = this.recurseChildrenGetPeers(tSTopologyNodeArray[n], set);
                if (this.isPortType(tSTopologyNodeArray[n])) {
                    set.addAll(this.getPeersAndParents(tSTopologyNodeArray[n]));
                }
            }
            set2.addAll(set);
            ++n;
        }
        return set2;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<graph>");
        stringBuffer.append("<nodesList>");
        TSTopologyNode[] tSTopologyNodeArray = this.getNodes();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            stringBuffer.append(tSTopologyNodeArray[n].toXML());
            ++n;
        }
        stringBuffer.append("</nodesList>");
        stringBuffer.append("</graph>");
        return stringBuffer.toString();
    }

    private class GenericSwitchRouter {
        private GenericSwitchRouter() {
        }
    }
}

