/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.FabricId;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopologyImpl;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyMalformedNodeException;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl_OLD;
import com.sun.netstorage.mgmt.services.topology.stubs.ModelNode;
import com.sun.netstorage.mgmt.services.topology.stubs.TopoPersistenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelNodeAdapterSim {
    private TopoPersistenceManager pm_ = TopoPersistenceManager.getInstance();
    private TopologyServiceImpl_OLD topoService_ = TopologyServiceImpl_OLD.getInstance();
    private static final String CHILD_IDS_KEY = "TEMP Child OIDS";
    private static final String ATTACHED_IDS_KEY = "TEMP Tail Node Attached Keys";
    private static final String PARENT_ID_KEY = "TEMP Parent OID";
    private static final String FABRIC_ID_KEY = "TEMP Fabric ID";
    private static final String ZONE_MEMBERS_KEY = "TEMP Zone Port Member OIDs";
    private Map composites_ = null;
    private Map graphNodes_ = null;
    private Map modelNodes_ = null;
    private Map fabricsAndChildren_ = new HashMap();
    private Map zones_ = null;
    private static final String EDGE_SEMANTIC = "Edge semantics unused! ";
    private static final FabricId dasId_ = new FabricId("DAS Topology", "Default Root SAN");
    static final String sccs_id = "@(#)ModelNodeAdapterSim.java 1.24   03/06/17 SMI";

    public ModelNodeAdapterSim() {
        this.modelNodes_ = new HashMap();
        this.composites_ = new HashMap();
        this.graphNodes_ = new HashMap();
        this.zones_ = new HashMap();
    }

    private void addEdgeToTopology(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, boolean bl) throws TopologyElementNotFoundException {
        this.topoService_.addEdge(tSTopologyNode, tSTopologyNode2, EDGE_SEMANTIC, bl, null);
        String string = (String)tSTopologyNode.getProperty(PARENT_ID_KEY);
        String string2 = (String)tSTopologyNode2.getProperty(PARENT_ID_KEY);
        if (string != null && string2 != null) {
            Object object;
            TSTopologyNode tSTopologyNode3 = (TSTopologyNode)this.graphNodes_.get(string);
            TSTopologyNode tSTopologyNode4 = (TSTopologyNode)this.graphNodes_.get(string2);
            try {
                this.topoService_.addEdge(tSTopologyNode3, tSTopologyNode4, EDGE_SEMANTIC, bl, null);
            }
            catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                object = this.determineFabric(tSTopologyNode3, tSTopologyNode);
                try {
                    this.topoService_.addNode(tSTopologyNode3.getOid(), tSTopologyNode3.getId(), tSTopologyNode3.getType(), tSTopologyNode3.getProperties(), tSTopologyNode3.getChildren(), (FabricId)object, tSTopologyNode3.getImmediateParent());
                }
                catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                }
                catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                    // empty catch block
                }
                try {
                    this.topoService_.addNode(tSTopologyNode4.getOid(), tSTopologyNode4.getId(), tSTopologyNode4.getType(), tSTopologyNode4.getProperties(), tSTopologyNode4.getChildren(), (FabricId)object, tSTopologyNode4.getImmediateParent());
                }
                catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                }
                catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                    // empty catch block
                }
                this.topoService_.addEdge(tSTopologyNode3, tSTopologyNode4, EDGE_SEMANTIC, bl, null);
            }
            String string3 = (String)tSTopologyNode4.getProperty(PARENT_ID_KEY);
            if (string3 != null) {
                this.moveComposites(string3, tSTopologyNode4, bl);
            }
            if ((object = (String)tSTopologyNode3.getProperty(PARENT_ID_KEY)) != null) {
                this.moveComposites((String)object, tSTopologyNode3, bl);
            }
        }
    }

    private void assembleComposites() {
        Iterator iterator = this.composites_.values().iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            String[] stringArray = (String[])tSTopologyNode.getProperty(CHILD_IDS_KEY);
            TSTopologyNode[] tSTopologyNodeArray = new TSTopologyNode[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                TSTopologyNode tSTopologyNode2 = (TSTopologyNode)this.graphNodes_.get(stringArray[n]);
                if (tSTopologyNode2 != null) {
                    tSTopologyNodeArray[n] = tSTopologyNode2;
                }
                ++n;
            }
            try {
                this.topoService_.addChildren(tSTopologyNode, tSTopologyNodeArray);
            }
            catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                // empty catch block
            }
        }
    }

    private void assembleDasEdges(TSTopologyNode tSTopologyNode) {
        List list;
        TSTopologyNode tSTopologyNode2;
        String string = (String)tSTopologyNode.getProperty(PARENT_ID_KEY);
        if (string != null && (tSTopologyNode2 = (TSTopologyNode)this.graphNodes_.get(string)) != null && tSTopologyNode2.getType().equals("com.sun.netstorage.mgmt.component.model.domain.HBA") && (list = (List)tSTopologyNode.getProperty(ATTACHED_IDS_KEY)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                TSTopologyNode tSTopologyNode3;
                String string3 = (String)iterator.next();
                TSTopologyNode tSTopologyNode4 = (TSTopologyNode)this.graphNodes_.get(string3);
                if (tSTopologyNode4 == null || !(tSTopologyNode3 = (TSTopologyNode)this.graphNodes_.get(string2 = (String)tSTopologyNode4.getProperty(PARENT_ID_KEY))).getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) continue;
                try {
                    this.addEdgeToTopology(tSTopologyNode, tSTopologyNode4, true);
                }
                catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private void assembleEdges() {
        Iterator iterator = this.graphNodes_.values().iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            String string = tSTopologyNode.getType();
            if (string.equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort")) {
                this.assembleFabricEdges(tSTopologyNode);
                continue;
            }
            if (!string.equals("com.sun.netstorage.mgmt.component.model.domain.NxPort")) continue;
            this.assembleDasEdges(tSTopologyNode);
        }
    }

    private void assembleFabricEdges(TSTopologyNode tSTopologyNode) {
        TSTopologyNode tSTopologyNode2 = null;
        TSTopologyNode tSTopologyNode3 = null;
        List list = (List)tSTopologyNode.getProperty(ATTACHED_IDS_KEY);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TSTopologyNode tSTopologyNode4;
                String string;
                String string2 = (String)iterator.next();
                TSTopologyNode tSTopologyNode5 = (TSTopologyNode)this.graphNodes_.get(string2);
                if (tSTopologyNode5 != null && (string = (String)tSTopologyNode5.getProperty(PARENT_ID_KEY)) != null && (tSTopologyNode4 = (TSTopologyNode)this.graphNodes_.get(string)) != null) {
                    if (tSTopologyNode4.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
                        tSTopologyNode2 = tSTopologyNode;
                        tSTopologyNode3 = tSTopologyNode5;
                    } else {
                        tSTopologyNode2 = tSTopologyNode5;
                        tSTopologyNode3 = tSTopologyNode;
                    }
                }
                if (tSTopologyNode2 == null || tSTopologyNode3 == null) continue;
                try {
                    this.addEdgeToTopology(tSTopologyNode2, tSTopologyNode3, false);
                }
                catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private void assembleFabrics() {
        String string;
        ModelNode modelNode;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.modelNodes_.values().iterator();
        while (iterator.hasNext()) {
            modelNode = (ModelNode)iterator.next();
            string = modelNode.getOid();
            String string2 = modelNode.getType();
            if (string2.equals("com.sun.netstorage.mgmt.component.model.domain.Fabric") || string2.equals("com.sun.netstorage.mgmt.component.model.domain.Switch") || string2.equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort") || string2.equals("com.sun.netstorage.mgmt.component.model.domain.Zone")) {
                this.fabricsAndChildren_.put(string, modelNode);
            }
            if (!string2.equals("com.sun.netstorage.mgmt.component.model.domain.Fabric")) continue;
            arrayList.add(string);
        }
        if (this.fabricsAndChildren_.size() > 0) {
            iterator = this.fabricsAndChildren_.values().iterator();
            while (iterator.hasNext()) {
                modelNode = (ModelNode)iterator.next();
                string = modelNode.getOid();
                this.modelNodes_.remove(string);
            }
        }
        if (arrayList.size() > 0) {
            this.transformFabrics(arrayList);
        }
    }

    private void assembleOrphanNodes() {
        Iterator iterator = this.modelNodes_.values().iterator();
        while (iterator.hasNext()) {
            try {
                ModelNode modelNode = (ModelNode)iterator.next();
                String string = modelNode.getOid();
                TSTopologyNode tSTopologyNode = this.transform(modelNode, null);
                this.graphNodes_.put(string, tSTopologyNode);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                // empty catch block
            }
        }
    }

    private Map assembleProperties(ModelNode modelNode, String string, FabricId fabricId) {
        String string2;
        String[] stringArray;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (fabricId != null) {
            hashMap.put(FABRIC_ID_KEY, fabricId);
        }
        if ((string9 = modelNode.getName()) != null) {
            hashMap.put("Name", string9);
        }
        if ((string8 = modelNode.getVendor()) != null) {
            hashMap.put("Vendor", string8);
        }
        if ((string7 = modelNode.getModel()) != null) {
            hashMap.put("Model Number", string7);
        }
        if ((string6 = modelNode.getStatus()) != null) {
            hashMap.put("Status", string6);
        }
        if ((string5 = modelNode.getNumber()) != null) {
            hashMap.put("Port Number", string5);
        }
        if ((string4 = modelNode.getState()) != null) {
            hashMap.put("Port State", string4);
        }
        if ((string3 = modelNode.getWWN()) != null) {
            hashMap.put("WWN", string3);
            if (fabricId != null && string3.equals(fabricId.getFabricName())) {
                fabricId.setLogicalName(string9);
            }
        }
        if ((stringArray = modelNode.getChildOids()) != null && stringArray.length > 0 && !string.equals("com.sun.netstorage.mgmt.component.model.domain.Zone")) {
            hashMap.put(CHILD_IDS_KEY, stringArray);
        }
        if ((string2 = modelNode.getParentOid()) != null) {
            hashMap.put(PARENT_ID_KEY, string2);
        }
        this.findRawEdgeInfo(modelNode, hashMap, string);
        return hashMap;
    }

    private void assembleZones() {
        Iterator iterator = this.zones_.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                ModelNode modelNode = (ModelNode)iterator.next();
                String string = modelNode.getName();
                TSTopologyNode tSTopologyNode = (TSTopologyNode)this.graphNodes_.get(modelNode.getParentOid());
                FabricId fabricId = (FabricId)tSTopologyNode.getProperty(FABRIC_ID_KEY);
                this.topoService_.addZone(fabricId, string);
                String[] stringArray = (String[])this.zones_.get(modelNode);
                if (stringArray == null) continue;
                int n = 0;
                while (n < stringArray.length) {
                    TSTopologyNode tSTopologyNode2 = (TSTopologyNode)this.graphNodes_.get(stringArray[n]);
                    if (tSTopologyNode2 != null) {
                        this.topoService_.addZoneMember(fabricId, string, tSTopologyNode2);
                    }
                    ++n;
                }
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                // empty catch block
            }
        }
    }

    protected TSTopologyNode[] beginModelPull(String string) {
        this.modelNodes_ = "EN_GJ".equals(string) ? this.pm_.getNWSNodes() : ("dasBug".equals(string) ? this.pm_.getModelNodes2() : ("zones".equals(string) ? this.pm_.getZoneTestModelNodes() : ("porsche".equals(string) ? this.pm_.getModelNodes3() : this.pm_.getModelNodes())));
        if (this.modelNodes_ != null) {
            this.assembleFabrics();
            this.assembleOrphanNodes();
            this.assembleComposites();
            this.assembleEdges();
            this.assembleZones();
            this.removeTempProperties();
        }
        return this.convertToArray();
    }

    private TSTopologyNode[] convertToArray() {
        TSTopologyNode[] tSTopologyNodeArray = new TSTopologyNode[this.graphNodes_.size()];
        Iterator iterator = this.graphNodes_.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            tSTopologyNodeArray[n++] = tSTopologyNode;
        }
        return tSTopologyNodeArray;
    }

    private void createInternalSwitchPortLinks() {
        try {
            SanTopologyImpl sanTopologyImpl = (SanTopologyImpl)this.topoService_.getSanTopologyCached("Default Root SAN");
            FabricTopology[] fabricTopologyArray = sanTopologyImpl.getFabrics();
            int n = 0;
            while (n < fabricTopologyArray.length) {
                TopologyGraph topologyGraph = fabricTopologyArray[n].getPhysicalTopology();
                TSTopologyNode[] tSTopologyNodeArray = topologyGraph.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.Switch");
                int n2 = 0;
                while (n2 < tSTopologyNodeArray.length) {
                    TSTopologyNode[] tSTopologyNodeArray2 = tSTopologyNodeArray[n2].getChildren();
                    int n3 = 0;
                    while (n3 < tSTopologyNodeArray2.length) {
                        TSTopologyNode tSTopologyNode = null;
                        tSTopologyNode = n3 == tSTopologyNodeArray2.length - 1 ? tSTopologyNodeArray2[0] : tSTopologyNodeArray2[n3 + 1];
                        this.topoService_.addEdge(tSTopologyNodeArray2[n3], tSTopologyNode, EDGE_SEMANTIC, false, null);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (TopologyElementNotFoundException topologyElementNotFoundException) {}
    }

    private void findRawEdgeInfo(ModelNode modelNode, Map map, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = modelNode.getAttachedNodeOids();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
        }
        if (arrayList.size() > 0) {
            map.put(ATTACHED_IDS_KEY, arrayList);
        }
    }

    private void moveComposites(String string, TSTopologyNode tSTopologyNode, boolean bl) {
        block4: {
            try {
                TSTopologyNode tSTopologyNode2 = (TSTopologyNode)this.graphNodes_.get(string);
                if (tSTopologyNode2 == null) break block4;
                FabricId fabricId = null;
                fabricId = !bl ? this.determineFabric(tSTopologyNode2, tSTopologyNode) : dasId_;
                if (fabricId == null) break block4;
                this.topoService_.addNode(tSTopologyNode2.getOid(), tSTopologyNode2.getId(), tSTopologyNode2.getType(), tSTopologyNode2.getProperties(), tSTopologyNode2.getChildren(), fabricId, tSTopologyNode2.getImmediateParent());
                String string2 = (String)tSTopologyNode2.getProperty(PARENT_ID_KEY);
                if (string2 != null) {
                    this.moveComposites(string2, tSTopologyNode2, bl);
                    break block4;
                }
                return;
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {}
        }
    }

    private void removeTempProperties() {
        Iterator iterator = this.graphNodes_.values().iterator();
        while (iterator.hasNext()) {
            TopologyNodeAdapter topologyNodeAdapter = (TopologyNodeAdapter)iterator.next();
            topologyNodeAdapter.removeProperty(FABRIC_ID_KEY);
            topologyNodeAdapter.removeProperty(CHILD_IDS_KEY);
            topologyNodeAdapter.removeProperty(PARENT_ID_KEY);
            topologyNodeAdapter.removeProperty(ATTACHED_IDS_KEY);
            topologyNodeAdapter.removeProperty(ZONE_MEMBERS_KEY);
        }
    }

    private TSTopologyNode transform(ModelNode modelNode, FabricId fabricId) throws TopologyDuplicateElementException, TopologyMalformedNodeException {
        Map map = null;
        String string = null;
        String string2 = null;
        TSTopologyNode tSTopologyNode = null;
        String[] stringArray = null;
        String string3 = modelNode.getType();
        string = modelNode.getOid();
        string2 = string3;
        stringArray = modelNode.getChildOids();
        map = this.assembleProperties(modelNode, string3, fabricId);
        tSTopologyNode = this.topoService_.addNode(string, string2, string3, map, null, fabricId, null);
        if (stringArray != null && stringArray.length > 0) {
            this.composites_.put(string, tSTopologyNode);
        }
        return tSTopologyNode;
    }

    private void transformChildren(FabricId fabricId, TSTopologyNode tSTopologyNode) {
        Iterator iterator = this.fabricsAndChildren_.values().iterator();
        while (iterator.hasNext()) {
            try {
                Object object;
                ModelNode modelNode = (ModelNode)iterator.next();
                String string = modelNode.getType();
                String string2 = modelNode.getParentOid();
                if (string.equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort") && string2 != null && (object = (ModelNode)this.fabricsAndChildren_.get(string2)) != null) {
                    string2 = ((ModelNode)object).getParentOid();
                }
                object = (String)tSTopologyNode.getSemanticObject();
                if (string2 == null || !string2.equals(object)) continue;
                String string3 = modelNode.getOid();
                if (modelNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Zone")) {
                    this.zones_.put(modelNode, modelNode.getChildOids());
                } else {
                    TSTopologyNode tSTopologyNode2 = this.transform(modelNode, fabricId);
                    this.graphNodes_.put(string3, tSTopologyNode2);
                }
                this.modelNodes_.remove(string3);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                // empty catch block
            }
        }
    }

    private void transformFabrics(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                ModelNode modelNode = (ModelNode)this.fabricsAndChildren_.get(string);
                String string2 = modelNode.getName();
                FabricId fabricId = new FabricId(string2, "Default Root SAN");
                TSTopologyNode tSTopologyNode = this.transform(modelNode, fabricId);
                this.graphNodes_.put(string, tSTopologyNode);
                this.fabricsAndChildren_.remove(string);
                this.transformChildren(fabricId, tSTopologyNode);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                // empty catch block
            }
        }
    }

    private FabricId determineFabric(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        FabricId fabricId = null;
        SanTopology sanTopology = null;
        sanTopology = this.topoService_.getSanTopologyCached();
        FabricTopology[] fabricTopologyArray = sanTopology.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Switch") && fabricTopologyArray[n].contains(tSTopologyNode) || !fabricTopologyArray[n].contains(tSTopologyNode) && fabricTopologyArray[n].contains(tSTopologyNode2)) {
                fabricId = fabricTopologyArray[n].getFabricId();
                return fabricId;
            }
            ++n;
        }
        return fabricId;
    }

    protected void reverseEngineer(Map map, String string) {
        this.modelNodes_.putAll(map);
        if (map != null) {
            long l = System.currentTimeMillis();
            this.assembleFabrics();
            this.assembleOrphanNodes();
            this.assembleComposites();
            this.assembleEdges();
            this.assembleZones();
            this.removeTempProperties();
            long l2 = System.currentTimeMillis();
            Long l3 = new Long(l2 - l);
        }
    }
}

