/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.zones;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.device.fcswitch.util.snmp.EF_6000_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.EF_6000_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.FIBRE_CHANNEL_MGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class ZoneInfo {
    private static final String BROCADE_ZONE_COMMAND = "brocadezone ";
    private static final String QLOGIC_ZONE_COMMAND = "qlogicWWNzones ";
    private static final String SWITCH_1GB_ZONE_COMMAND = "sanbox get_zone ";
    private static final String DEFAULT_BROCADE_PASSWORD = "password";
    private static final String DEFAULT_BROCADE_USER = "admin";
    private static final String HARD_ZONE = " hd all";
    private static final String SOFT_ZONE = " ns all";
    private static final String LOOP_ZONE = " sl all";
    private static final String SADE_HOME = "storade.home";
    private static final String SBIN = "sbin";
    private static final String LOG_TAG = "Zone";
    private static final String HARD_ZONE_DESCRPTION = "Hard Zone";
    private static final String SOFT_ZONE_DESCRPTION = "Soft Zone";
    private static final String SL_ZONE_DESCRPTION = "Segmented Loop Zone";
    private static final String ZONE_TIMEOUT_PROPERTY = "Zone.Timeout";
    private static final String SWITCH = "switch";
    private static final long DEFAULTZONE_COMMAND_TIMEOUT = 5000L;
    private static final String WWN_ZONEMEMBER = "1";
    private static final String PORTID_ZONEMEMBER = "2";
    private static final String ZONE_INDEX_OID = "1.3.6.1.4.1.289.2.1.1.2.5.6.1.1";
    private static final String ZONE_NAME_OID = "1.3.6.1.4.1.289.2.1.1.2.5.6.1.2";
    private static final String ZONE_MEMINDEX_OID = "1.3.6.1.4.1.289.2.1.1.2.5.6.1.3";
    private static final String MEMBER_TYPE_OID = "1.3.6.1.4.1.289.2.1.1.2.5.7.1.3";
    private static final String MEMBER_WWN_OID = "1.3.6.1.4.1.289.2.1.1.2.5.7.1.4";
    private static final String MEMBER_DOMAINID_OID = "1.3.6.1.4.1.289.2.1.1.2.5.7.1.5";
    private static final String MEMBER_PORTID_OID = "1.3.6.1.4.1.289.2.1.1.2.5.7.1.6";
    public static final String sccs_id = "@(#)ZoneInfo.java\t1.17 08/26/03 SMI";

    private static String toIP(String string) {
        String string2 = string;
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Throwable)unknownHostException, (Object)("Cannot obtain ip address from: " + string));
        }
        return string2;
    }

    private static long getZoneTimeOut() {
        long l = 5000L;
        try {
            Properties properties = DevInfo.getDeviceProperties((String)SWITCH);
            l = Long.parseLong(properties.getProperty(ZONE_TIMEOUT_PROPERTY));
        }
        catch (Exception exception) {
            Report.warning.log(exception.getLocalizedMessage(), (Object)"Error reading Zone timeout property. Using default of 5 sec timeout.");
        }
        return l;
    }

    public static Object[] getBrocadeZones(String string, String string2, String string3) {
        Object[] objectArray = null;
        if (string2 == null) {
            string2 = DEFAULT_BROCADE_PASSWORD;
        }
        if (string3 == null) {
            string3 = DEFAULT_BROCADE_USER;
        }
        try {
            objectArray = ZoneInfo.parseBrocadeZoneInfo(ZoneInfo.execute(BROCADE_ZONE_COMMAND + ZoneInfo.toIP(string), string2 + " " + string3));
        }
        catch (Exception exception) {
            return new Object[0];
        }
        return objectArray;
    }

    public static Object[] getBrocadeZones(String string, String string2) {
        Object[] objectArray = null;
        if (string2 == null) {
            string2 = DEFAULT_BROCADE_PASSWORD;
        }
        try {
            objectArray = ZoneInfo.parseBrocadeZoneInfo(ZoneInfo.execute(BROCADE_ZONE_COMMAND + ZoneInfo.toIP(string), string2));
        }
        catch (Exception exception) {
            return new Object[0];
        }
        return objectArray;
    }

    public static Object[] getBrocadeZones(String string) {
        return ZoneInfo.getBrocadeZones(string, DEFAULT_BROCADE_PASSWORD);
    }

    public static Object[] getQlogicZones(String string, String string2) {
        Object[] objectArray = null;
        if (string2 == null) {
            return new Object[0];
        }
        try {
            objectArray = ZoneInfo.parseQlogicZoneInfo(ZoneInfo.execute(QLOGIC_ZONE_COMMAND + ZoneInfo.toIP(string), string2));
        }
        catch (Exception exception) {
            return new Object[0];
        }
        return objectArray;
    }

    public static Object[] getQlogicZones(String string) {
        Object[] objectArray = null;
        try {
            objectArray = ZoneInfo.parseQlogicZoneInfo(ZoneInfo.execute(QLOGIC_ZONE_COMMAND + ZoneInfo.toIP(string)));
        }
        catch (Exception exception) {
            return new Object[0];
        }
        return objectArray;
    }

    public static Object[] get1GBSwitchZones(String string) {
        ArrayList arrayList = new ArrayList();
        ZoneInfo.parse1GBZoneInfo(arrayList, ZoneInfo.execute(SWITCH_1GB_ZONE_COMMAND + ZoneInfo.toIP(string) + HARD_ZONE), HARD_ZONE_DESCRPTION);
        ZoneInfo.parse1GBZoneInfo(arrayList, ZoneInfo.execute(SWITCH_1GB_ZONE_COMMAND + ZoneInfo.toIP(string) + SOFT_ZONE), SOFT_ZONE_DESCRPTION);
        ZoneInfo.parse1GBZoneInfo(arrayList, ZoneInfo.execute(SWITCH_1GB_ZONE_COMMAND + ZoneInfo.toIP(string) + LOOP_ZONE), SL_ZONE_DESCRPTION);
        return arrayList.toArray();
    }

    public static Object[] getMcDataZones(String string) {
        ArrayList arrayList = new ArrayList();
        ZoneInfo.parseMcDataZones(arrayList, string);
        return arrayList.toArray();
    }

    private static String execute(String string) {
        return ZoneInfo.execute(string, null);
    }

    private static String execute(String string, String string2) {
        String string3 = System.getProperty(SADE_HOME) + File.separator + SBIN + File.separator;
        Report.debug.log(LOG_TAG, (Object)string3);
        String string4 = null;
        String string5 = string2 != null ? string3 + string + " " + string2 : string3 + string;
        CommandExec commandExec = new CommandExec(string5);
        long l = ZoneInfo.getZoneTimeOut();
        try {
            commandExec.exec();
            Report.debug.log((Object)("Executing " + string5 + "\tTimeout : " + l + " milliSeconds"));
            commandExec.getReturnValue(l);
        }
        catch (InterruptedException interruptedException) {
            Report.debug.log((Object)("Retrying command: " + string));
            try {
                commandExec.getReturnValue(l + l);
            }
            catch (InterruptedException interruptedException2) {
                Report.error.log((Object)("Timed out for zone command: " + string + ".\n\t Current timeout value: " + l + ".\n\t Increase the Zone timeout value in switch.xml file"));
            }
            catch (Exception exception) {
                Report.error.log((Throwable)exception, (Object)("Error while executing: " + string));
                LocalizedString localizedString = new LocalizedString(exception);
                return localizedString.getString();
            }
        }
        catch (Exception exception) {
            Report.error.log((Throwable)exception, (Object)("Error while executing: " + string));
            LocalizedString localizedString = new LocalizedString(exception);
            return localizedString.getString();
        }
        string4 = commandExec.getStandardOutput();
        string4 = string4.trim();
        return string4;
    }

    private static Object[] parseBrocadeZoneInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<Zones> arrayList = new ArrayList<Zones>();
        Zones zones = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("ERROR:")) {
                Report.error.log((Object)string3);
                continue;
            }
            if (string3.startsWith("Zone Name")) {
                int n = string3.indexOf("=");
                string2 = string3.substring(n + 1, string3.length());
                zones = new Zones(string2);
                zones.setZoneDescription(SOFT_ZONE_DESCRPTION);
                arrayList.add(zones);
                Report.debug.log(LOG_TAG, (Object)("Added Zone " + string2));
                continue;
            }
            if (!string3.startsWith("Port") && !string3.startsWith("WWN")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                if ("Port".equalsIgnoreCase(string2.trim()) || "WWN".equalsIgnoreCase(string2.trim())) continue;
                Report.debug.log(LOG_TAG, (Object)("\t --> Added Port " + string2));
                zones.addMember(string2);
            }
        }
        return arrayList.toArray();
    }

    private static Object[] parseQlogicZoneInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<Zones> arrayList = new ArrayList<Zones>();
        Zones zones = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            StringTokenizer stringTokenizer2;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("Name")) {
                stringTokenizer2 = new StringTokenizer(string3, "=");
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if ("Name".equalsIgnoreCase(string2.trim())) continue;
                    zones = new Zones(string2);
                    arrayList.add(zones);
                    Report.debug.log(LOG_TAG, (Object)("Added Zone " + string2));
                }
                continue;
            }
            if (string3.startsWith("Type")) {
                stringTokenizer2 = new StringTokenizer(string3, "=");
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if ("Type".equalsIgnoreCase(string2.trim())) continue;
                    if (zones != null) {
                        zones.setZoneDescription(string2.trim());
                    }
                    Report.debug.log(LOG_TAG, (Object)("Zone Type " + string2.trim()));
                }
                continue;
            }
            if (string3.startsWith("Port") || string3.startsWith("WWN")) {
                stringTokenizer2 = new StringTokenizer(string3, "=");
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if ("Port".equalsIgnoreCase(string2.trim()) || "WWN".equalsIgnoreCase(string2.trim())) continue;
                    Report.debug.log(LOG_TAG, (Object)("\t-> Added Port/WWN " + string2));
                    zones.addMember(string2);
                }
                continue;
            }
            if (!string3.startsWith("ERROR:")) continue;
            Report.error.log((Object)string3);
        }
        return arrayList.toArray();
    }

    private static Object[] parse1GBZoneInfo(ArrayList arrayList, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Zones zones = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.trim().startsWith("Zone:")) {
                int n;
                String string4;
                int n2 = string3.indexOf("Zone:");
                int n3 = string3.indexOf(",");
                String string5 = string3.substring(n2 + 5, n3);
                String string6 = string3.substring(n3 + 1, string3.length());
                if (!string6.trim().startsWith("Enabled:") || !(string4 = string6.substring((n = string6.indexOf("Enabled:")) + 8, string6.length())).trim().equalsIgnoreCase("yes")) continue;
                zones = new Zones(string5);
                zones.setZoneDescription(string2);
                arrayList.add(zones);
                Report.debug.log(LOG_TAG, (Object)("Added Zone " + string5));
                continue;
            }
            if (!string3.trim().startsWith("Port")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":");
            while (stringTokenizer2.hasMoreTokens()) {
                String string7 = stringTokenizer2.nextToken();
                if ("Port".equalsIgnoreCase(string7.trim())) continue;
                Report.debug.log(LOG_TAG, (Object)("\t --> Added Port " + string7));
                zones.addMember(string7);
            }
        }
        return arrayList.toArray();
    }

    private static Object[] parseMcDataZones(ArrayList arrayList, String string) {
        Zones zones = null;
        EF_6000_Mibsnmp eF_6000_Mibsnmp = new EF_6000_Mibsnmp(string);
        String string2 = ZoneInfo.getMcDataDomainID(string);
        SNMPWalk sNMPWalk = new SNMPWalk(string, new EF_6000_MIBOidTable());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties("ef6000ZoneIndex", "ef6000TATable");
        HashMap hashMap2 = sNMPWalk.filterProperties(hashMap, ZONE_INDEX_OID);
        Collection collection = hashMap2.values();
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = eF_6000_Mibsnmp.getZoneName(string3);
            zones = new Zones(string4);
            zones.setZoneDescription(SOFT_ZONE_DESCRPTION);
            arrayList.add(zones);
            Report.debug.log(LOG_TAG, (Object)("Added Zone " + string4));
            String string5 = (String)hashMap.get("1.3.6.1.4.1.289.2.1.1.2.5.6.1.3." + string3);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n3 = 1;
            while (n3 <= n2) {
                String string6;
                String string7 = (String)hashMap.get("1.3.6.1.4.1.289.2.1.1.2.5.7.1.3." + string3 + "." + n3);
                if (WWN_ZONEMEMBER.equalsIgnoreCase(string7)) {
                    string6 = (String)hashMap.get("1.3.6.1.4.1.289.2.1.1.2.5.7.1.4." + string3 + "." + n3);
                    if (!"NULL".equalsIgnoreCase(string6)) {
                        Report.debug.log(LOG_TAG, (Object)("\t --> Added WWN " + string6));
                        zones.addMember(string6);
                    }
                } else if (PORTID_ZONEMEMBER.equalsIgnoreCase(string7)) {
                    String string8;
                    string6 = (String)hashMap.get("1.3.6.1.4.1.289.2.1.1.2.5.7.1.5." + string3 + "." + n3);
                    if (string2 != null && string2.equalsIgnoreCase(string6) && !"NULL".equalsIgnoreCase(string8 = (String)hashMap.get("1.3.6.1.4.1.289.2.1.1.2.5.7.1.6." + string3 + "." + n3))) {
                        Report.debug.log(LOG_TAG, (Object)("\t --> Added WWN " + string8));
                        zones.addMember(string8);
                    }
                }
                ++n3;
            }
        }
        return arrayList.toArray();
    }

    private static String getMcDataDomainID(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(string, new FIBRE_CHANNEL_MGMT_MIBOidTable());
        int n = 0;
        HashMap hashMap = sNMPWalk.getProperties("fcConnUnitDomainId", "fcConnUnitProxyMaster");
        hashMap = sNMPWalk.filterProperties(hashMap, "1.3.6.1.2.1.8888.1.1.3.1.11");
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n2 = string2.length();
            String string3 = string2.substring(n2 - 1, n2);
            Report.debug.log(LOG_TAG, (Object)("DomainID " + string3));
            try {
                n = Integer.parseInt(string3, 10);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n + "";
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            string = System.getProperty(SADE_HOME);
            if (string == null) {
                System.out.println("Make sure you have your LD_LIBRARY_PATH set to$WORKSPACE/device/switch/lib:${LD_LIBRARY_PATH}.");
            }
            System.out.println("java -Dstorade.home=$WORKSPACE/build/demo com.sun.jade.device.fcswitch.util.zones.ZoneInfo <Brocade/Switch2GB/Switch1GB/McData> <ip>");
            if (stringArray.length != 2) {
                System.out.println("Make sure you have your LD_LIBRARY_PATH set to$WORKSPACE/device/switch/lib:${LD_LIBRARY_PATH}.");
            }
            System.out.println("java -Dstorade.home=$WORKSPACE/build/demo com.sun.jade.device.fcswitch.util.zones.ZoneInfo <Brocade/Switch2GB/Switch1GB/McData> <ip>");
            Object[] objectArray = null;
            if (stringArray[0].equalsIgnoreCase("Brocade")) {
                objectArray = ZoneInfo.getBrocadeZones(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("Switch2GB")) {
                objectArray = ZoneInfo.getQlogicZones(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("Switch1GB")) {
                objectArray = ZoneInfo.get1GBSwitchZones(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("McData")) {
                objectArray = ZoneInfo.getMcDataZones(stringArray[1]);
            }
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                System.out.println("Zone Name " + zones.getZoneName());
                System.out.println("Zone Type " + zones.getZoneDescription());
                Object[] objectArray2 = zones.getMemberList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    System.out.println("\tPort Name " + (String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("java ZoneInfo -Dstorade.home=<$WORKSPACE>/build/demo  <Brocade/Switch2GB/Switch1GB/McData> <ip>");
        }
    }

    public static class Test
    extends UnitTest {
        private String brocadeZoneTestString = "Current Zoning Enforcement = Unknown\nZone Name = zone5\nPort = 12\nPort = 13\nZone Name = zone1\nPort = 7\nPort = 6\nPort = 5\nZone Name = zone2\nPort = 0\nPort = 1\nPort = 2\nPort = 3\nPort = 4\nZone Name = zone3\nWWN = 5000000000000344\nZone Name = zone4\nPort = 14\nWWN = 5000000000000345\nPort = 15\n";
        private String qlogicZoneTestString = "Switch domain id = 17\nNumber of zones = 2\nNumber of members in zone 0 is 6\nName = Zone2\nType = Soft\nWWN = 50020F2300000C6C\nWWN = 50020F230000095F\nWWN = 210100E08B22702A\nWWN = 210000E08B02702A\nPort = 11\nPort = 10\nNumber of members in zone 1 is 6\nName = Zone1a\nType = Soft\nPort = 3\nPort = 1\n";
        private String sun1gbZoneTestString = "Zone:  0, Enabled: yes\nPort: 1\nPort: 2\nPort: 3\nPort: 4\nZone:  1, Enabled: yes\nPort: 5\nPort: 6\nPort: 7\nPort: 8\nZone:  2, Enabled: no\nZone:  3, Enabled: no\nZone:  4, Enabled: no\nZone:  5, Enabled: no\nZone:  6, Enabled: no\nZone:  7, Enabled: no\nZone:  8, Enabled: no\nZone:  9, Enabled: no\nZone: 10, Enabled: no\nZone: 11, Enabled: no\nZone: 12, Enabled: no\nZone: 13, Enabled: no\nZone: 14, Enabled: no\nZone: 15, Enabled: no\n";
        private String qlogicZoneErrorString = "ERROR: Bad password. (Just a unit test check for the message)\n";

        public void testBrocadeZoneGenerator() {
            Object[] objectArray = ZoneInfo.parseBrocadeZoneInfo(this.brocadeZoneTestString);
            this.assertNotNull(objectArray);
            this.assertCondition(objectArray.length == 5);
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                this.assertNotNull(zones.getZoneName());
                Object[] objectArray2 = zones.getMemberList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    this.assertNotNull((String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }

        public void testSun1GBZoneGenerator() {
            ArrayList arrayList = new ArrayList();
            Object[] objectArray = ZoneInfo.parse1GBZoneInfo(arrayList, this.sun1gbZoneTestString, ZoneInfo.SOFT_ZONE_DESCRPTION);
            this.assertNotNull(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                this.assertNotNull(zones.getZoneName());
                Object[] objectArray2 = zones.getMemberList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    this.assertNotNull((String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }

        public void testqlogicZoneErrorGenerator() {
            ArrayList arrayList = new ArrayList();
            Object[] objectArray = ZoneInfo.parseQlogicZoneInfo(this.qlogicZoneErrorString);
            this.assertCondition(objectArray.length == 0);
        }

        public void testSun2GBZoneGenerator() {
            Object[] objectArray = ZoneInfo.parseQlogicZoneInfo(this.qlogicZoneTestString);
            this.assertNotNull(objectArray);
            this.assertCondition(objectArray.length == 2);
            int n = 0;
            while (n < objectArray.length) {
                Zones zones = (Zones)objectArray[n];
                this.assertEquals(zones.getZoneDescription(), "Soft");
                this.assertNotNull(zones.getZoneName());
                Object[] objectArray2 = zones.getMemberList();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    this.assertNotNull((String)objectArray2[n2]);
                    ++n2;
                }
                ++n;
            }
        }
    }
}

