/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;

public class SNMPToCIM_State_Status {
    private static final int FA_STATE_OTHER = 1;
    private static final int FA_STATE_ONLINE = 2;
    private static final int FA_STATE_OFFLINE = 3;
    private static final int FA_STATE_DIAGNOSTICS = 5;
    private static final int FA_STATUS_UNKNOWN = 1;
    private static final int FA_STATUS_UNUSED = 2;
    private static final int FA_STATUS_OK = 3;
    private static final int FA_STATUS_WARNING = 4;
    private static final int FA_STATUS_FAILED = 5;
    private static final int FA_STATUS_OLS = 9;
    private static final int FE_STATUS_ONLINE = 1;
    private static final int FE_STATUS_OFFLINE = 2;
    private static final int FE_STATUS_TESTING = 3;
    private static final int FE_STATUS_FAULTY = 4;
    private static final String UNKNOWN = "Unknown";
    private static final String ONLINE = "Online";
    private static final String OFFLINE = "Offline";
    private static final String DIAGNOSTICS = "Diagnostics";
    private static final String UNUSED = "Unused";
    private static final String OK = "OK";
    private static final String WARNING = "Warning";
    private static final String FAILED = "failed";
    private static final String TESTING = "Testing";
    private static final String ERROR_STRING = "Error  in converting to number :";
    private static final String LOG_TAG = "CIM_STATUS_TAG";
    private static final int SWSENSOR_STATUS_UNKNOWN = 1;
    private static final int SWSENSOR_STATUS_FAULTY = 2;
    private static final int SWSENSOR_STATUS_BELOWMIN = 3;
    private static final int SWSENSOR_STATUS_NOMINAL = 4;
    private static final int SWSENSOR_STATUS_ABOVEMAX = 5;
    private static final int SWSENSOR_STATUS_ABSENT = 6;
    public static final String sccs_id = "@(#)SNMPToCIM_State_Status.java\t1.6 05/16/03 SMI";

    public static String getOperationalStateString(String string) {
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.debug.log(LOG_TAG, (Object)(ERROR_STRING + string));
            n = 0;
        }
        switch (n) {
            case 1: {
                string2 = UNKNOWN;
                break;
            }
            case 2: {
                string2 = ONLINE;
                break;
            }
            case 3: {
                string2 = OFFLINE;
                break;
            }
            case 5: {
                string2 = DIAGNOSTICS;
                break;
            }
            default: {
                string2 = UNKNOWN;
            }
        }
        return string2;
    }

    public static String getOperationalStatusString(String string) {
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.debug.log(LOG_TAG, (Object)(ERROR_STRING + string));
            n = 0;
        }
        switch (n) {
            case 1: {
                string2 = UNKNOWN;
                break;
            }
            case 2: {
                string2 = UNUSED;
                break;
            }
            case 3: {
                string2 = OK;
                break;
            }
            case 4: {
                string2 = WARNING;
                break;
            }
            case 5: {
                string2 = FAILED;
                break;
            }
            case 9: {
                string2 = OFFLINE;
                break;
            }
            default: {
                string2 = UNKNOWN;
            }
        }
        return string2;
    }

    public static String getOperationalStatusString_FE(String string) {
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.debug.log(LOG_TAG, (Object)(ERROR_STRING + string));
            n = 0;
        }
        switch (n) {
            case 1: {
                string2 = OK;
                break;
            }
            case 2: {
                string2 = OFFLINE;
                break;
            }
            case 3: {
                string2 = TESTING;
                break;
            }
            case 4: {
                string2 = FAILED;
                break;
            }
            default: {
                string2 = UNKNOWN;
            }
        }
        return string2;
    }

    public static String getSensorStatusString_SW(String string) {
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.debug.log(LOG_TAG, (Object)(ERROR_STRING + string));
            n = 0;
        }
        switch (n) {
            case 4: {
                string2 = OK;
                break;
            }
            case 5: {
                string2 = WARNING;
                break;
            }
            case 3: {
                string2 = WARNING;
                break;
            }
            case 2: {
                string2 = FAILED;
                break;
            }
            case 1: {
                string2 = UNKNOWN;
                break;
            }
            case 6: {
                string2 = UNKNOWN;
                break;
            }
            default: {
                string2 = UNKNOWN;
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        System.out.println(SNMPToCIM_State_Status.getOperationalStateString("1"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStateString("2"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStateString("3"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStateString("5"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString("1"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString("2"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString("3"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString("4"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString("5"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString_FE("1"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString_FE("2"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString_FE("3"));
        System.out.println(SNMPToCIM_State_Status.getOperationalStatusString_FE("4"));
    }

    public static class Test
    extends UnitTest {
        public void testSNMPCIMStateStatus() {
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStateString("1"), SNMPToCIM_State_Status.UNKNOWN);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStateString("2"), SNMPToCIM_State_Status.ONLINE);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStateString("3"), SNMPToCIM_State_Status.OFFLINE);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStateString("5"), SNMPToCIM_State_Status.DIAGNOSTICS);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString("1"), SNMPToCIM_State_Status.UNKNOWN);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString("2"), SNMPToCIM_State_Status.UNUSED);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString("3"), SNMPToCIM_State_Status.OK);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString("4"), SNMPToCIM_State_Status.WARNING);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString("5"), SNMPToCIM_State_Status.FAILED);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString_FE("1"), SNMPToCIM_State_Status.OK);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString_FE("2"), SNMPToCIM_State_Status.OFFLINE);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString_FE("3"), SNMPToCIM_State_Status.TESTING);
            this.assertEquals(SNMPToCIM_State_Status.getOperationalStatusString_FE("4"), SNMPToCIM_State_Status.FAILED);
            this.assertEquals(SNMPToCIM_State_Status.getSensorStatusString_SW("4"), SNMPToCIM_State_Status.OK);
            this.assertEquals(SNMPToCIM_State_Status.getSensorStatusString_SW("5"), SNMPToCIM_State_Status.WARNING);
            this.assertEquals(SNMPToCIM_State_Status.getSensorStatusString_SW("2"), SNMPToCIM_State_Status.FAILED);
            this.assertEquals(SNMPToCIM_State_Status.getSensorStatusString_SW("6"), SNMPToCIM_State_Status.UNKNOWN);
        }
    }
}

