/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.util.unittest.UnitTest;

public class SNMPHexValueHandler {
    private static final String ZERO = "0";
    public static final String sccs_id = "@(#)SNMPHexValueHandler.java\t1.3 09/19/02 SMI";

    public static String toInvString(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = lArray.length - 1;
        while (n >= 0) {
            stringBuffer.append(lArray[n]);
            --n;
        }
        long l = 0L;
        try {
            l = Long.parseLong(stringBuffer.toString(), 10);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return Long.toString(l);
    }

    public static String toString(long[] lArray) {
        long l = 0L;
        String string = SNMPHexValueHandler.toHexString(lArray);
        try {
            l = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        return Long.toString(l);
    }

    public static String toHexString(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lArray.length) {
            String string = Long.toHexString(lArray[n]);
            if (string.length() == 1) {
                string = ZERO + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        long[] lArray = new long[]{0L, 0L, 0L, 0L, 0L, 21L, 187L, 125L};
        System.out.println(SNMPHexValueHandler.toString(lArray));
    }

    public static class Test
    extends UnitTest {
        public void testSNMPHexValueHandler() {
            long[] lArray = new long[]{16L, 0L, 0L, 192L, 221L, 0L, 183L, 218L};
            this.assertEquals(SNMPHexValueHandler.toInvString(lArray), "21818302211920016");
            this.assertEquals(SNMPHexValueHandler.toHexString(lArray), "100000c0dd00b7da");
            long[] lArray2 = new long[]{128L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
            this.assertEquals(SNMPHexValueHandler.toString(lArray2), SNMPHexValueHandler.ZERO);
            long[] lArray3 = new long[]{0L, 0L, 0L, 0L, 8L, 0L, 1L};
            this.assertEquals(SNMPHexValueHandler.toString(lArray3), "524289");
            long[] lArray4 = new long[]{0L, 0L, 0L, 0L, 8L, 0L, 218L};
            this.assertEquals(SNMPHexValueHandler.toString(lArray4), "524506");
        }
    }
}

