/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchModel;
import com.sun.jade.device.fcswitch.util.snmp.EF_6000_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.McData_FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.SW_Mibsnmp;
import com.sun.jade.device.util.GUIDGenerator;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;

public class SwitchModelHelper {
    private String switchModel;
    private String ip;
    private Properties p;
    private EF_6000_Mibsnmp efmibsnmp;
    private FA_Mibsnmp famibsnmp;
    private SW_Mibsnmp swmibsnmp;
    private static final String BRCD_FIRMWARE_VER2 = "v2";
    private static final String BRCD_FIRMWARE_VER3 = "v3";
    private static final String MODEL = "model";
    private static final String VENDOR = "vendor";
    public static final String sccs_id = "@(#)SwitchModelHelper.java\t1.10 06/16/03 SMI";

    public SwitchModelHelper(String string, String string2, Properties properties) {
        this.p = properties;
        this.switchModel = string2;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public SwitchModelHelper(String string, Properties properties) throws IllegalArgumentException {
        this.p = properties;
        this.switchModel = string;
        this.ip = this.p.getProperty("ip");
        if (this.ip == null) {
            this.ip = this.p.getProperty("remoteIP");
        }
        if (this.switchModel == null || this.ip == null) {
            new IllegalArgumentException("The IP or the Switch type property are null. Cannot determine the exact Switch Model ");
        }
    }

    public Properties getExtraSwitchProperties() {
        int n = SwitchModel.getSwitchModelInt(this.switchModel);
        switch (n) {
            case 1: {
                Sanbox sanbox;
                ChassisStatus chassisStatus;
                short s;
                String string = this.p.getProperty("remoteDiscovery");
                if ("Yes".equalsIgnoreCase(string) || (s = (chassisStatus = (sanbox = new Sanbox(this.ip)).getChassisStatus(0)).getNumOfPorts()) <= 0) break;
                this.p.setProperty("NumberOfPorts", s + "");
                break;
            }
            case 2: {
                this.setFA_MIBProperties();
                break;
            }
            case 3: {
                String string;
                int n2;
                this.swmibsnmp = new SW_Mibsnmp(this.ip);
                String string2 = (String)this.swmibsnmp.getPortCapacity().get("swFCPortCapacity");
                if (string2 != null) {
                    this.p.setProperty("NumberOfPorts", string2);
                }
                if ((n2 = this.swmibsnmp.getNumberOfSensors()) > 0) {
                    this.p.setProperty("NumberOfSensors", n2 + "");
                }
                if ((string = (String)this.swmibsnmp.getSystemProps().get("swFirmwareVersion")) == null) break;
                this.p.setProperty("FirmwareVersion", string);
                break;
            }
            case 4: {
                String string;
                McData_FA_Mibsnmp mcData_FA_Mibsnmp = new McData_FA_Mibsnmp(this.ip);
                HashMap hashMap = mcData_FA_Mibsnmp.getConnectivityProps();
                String string3 = (String)hashMap.get("fcConnUnitNumPorts");
                if (string3 != null) {
                    this.p.setProperty("NumberOfPorts", string3);
                }
                if ((string = (String)hashMap.get("fcConnUnitNumSensors")) != null) {
                    this.p.setProperty("NumberOfSensors", string);
                }
                this.efmibsnmp = new EF_6000_Mibsnmp(this.ip);
                String string4 = (String)this.efmibsnmp.getRevisionProps().get("ef6000SysConfigSpeed");
                if (string4 == null) break;
                this.p.setProperty("FirmwareVersion", string4);
                break;
            }
            case 5: {
                this.setFA_MIBProperties();
                break;
            }
            case 6: {
                this.setFA_MIBProperties();
                break;
            }
            case 0: {
                break;
            }
        }
        this.determineDeviceModel(this.p);
        String string = SwitchModelHelper.getGUID(this.p);
        if (this.p != null) {
            this.p.setProperty("GUID", string);
        }
        return this.p;
    }

    private static String getGUID(Properties properties) {
        String string = null;
        try {
            String string2 = properties.getProperty("VENDOR");
            String string3 = properties.getProperty("MODEL");
            String string4 = properties.getProperty("wwn");
            string = GUIDGenerator.generateGUID((String)"fc-switch", (String)string2, (String)"wwn", (String)string4);
        }
        catch (Exception exception) {
            Report.warning.log((Object)("Error getting GUID for switch " + properties.getProperty("ip")));
        }
        return string;
    }

    private Properties determineDeviceModel(Properties properties) {
        Object var2_2 = null;
        String string = properties.getProperty("NumberOfPorts");
        String string2 = properties.getProperty("FirmwareVersion");
        String string3 = "model." + SwitchModel.getSwitchModelInt(this.switchModel);
        if (string != null) {
            string3 = string3 + "." + string;
            if (string2 != null) {
                if (string2.startsWith(BRCD_FIRMWARE_VER2)) {
                    string2 = BRCD_FIRMWARE_VER2;
                }
                if (string2.startsWith(BRCD_FIRMWARE_VER3)) {
                    string2 = BRCD_FIRMWARE_VER3;
                }
                string3 = string3 + "." + string2;
            }
        }
        LocalizedString localizedString = new LocalizedString("com.sun.jade.device.fcswitch.fibrealliance.service.resource.SwitchModel", string3.trim(), this.switchModel);
        properties.setProperty("DeviceDisplayModel", localizedString.getString());
        properties.setProperty("MODEL", localizedString.getString());
        String string4 = "vendor." + SwitchModel.getSwitchModelInt(this.switchModel);
        LocalizedString localizedString2 = new LocalizedString("com.sun.jade.device.fcswitch.fibrealliance.service.resource.SwitchModel", string4.trim(), this.switchModel);
        properties.setProperty("VENDOR", localizedString2.getString());
        return properties;
    }

    private void setFA_MIBProperties() {
        String string;
        HashMap hashMap = new HashMap();
        this.famibsnmp = new FA_Mibsnmp(this.p);
        hashMap = this.famibsnmp.getConnectivityProps();
        String string2 = (String)hashMap.get("connUnitNumports");
        if (string2 != null) {
            this.p.setProperty("NumberOfPorts", string2);
        }
        if ((string = (String)hashMap.get("connUnitNumSensors")) != null) {
            this.p.setProperty("NumberOfSensors", string);
        }
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"172.20.67.132", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.133", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.134", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.135", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.140", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.141", "Sun StorEdge network FC 2Gig switch"}, {"172.20.67.174", "Sun StorEdge network FC switch"}, {"172.20.67.179", "Sun StorEdge network FC switch"}, {"172.20.67.180", "Brocade SilkWorm FC Switch"}, {"172.20.67.188", "Brocade SilkWorm FC Switch"}, {"172.20.67.181", "Brocade SilkWorm FC Switch"}, {"172.20.32.88", "Brocade SilkWorm FC Switch"}, {"172.20.32.89", "Brocade SilkWorm FC Switch"}, {"172.20.103.90", "McData Enterprise Director FC Switch"}, {"172.20.103.91", "McData Enterprise Director FC Switch"}, {"172.20.103.92", "McData Enterprise Director FC Switch"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            System.out.println(stringArrayArray[n][0]);
            Properties properties = new Properties();
            properties.setProperty("ip", stringArrayArray[n][0]);
            SwitchModelHelper switchModelHelper = new SwitchModelHelper(stringArrayArray[n][0], stringArrayArray[n][1], properties);
            switchModelHelper.getExtraSwitchProperties().list(System.out);
            ++n;
        }
    }

    public static class Test
    extends UnitTest {
        SwitchModelHelper sh = null;

        public void testBrocadeModelHelper(String string) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            properties.setProperty("NumberOfPorts", "8");
            properties.setProperty("FirmwareVersion", SwitchModelHelper.BRCD_FIRMWARE_VER2);
            try {
                this.sh = new SwitchModelHelper("Brocade SilkWorm FC Switch", properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.assertEquals("Brocade SilkWorm FC 1Gig switch-8", this.sh.determineDeviceModel(properties).getProperty("DeviceDisplayModel"));
        }

        public void testSun2G_ModelHelper(String string) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            properties.setProperty("NumberOfPorts", "16");
            try {
                this.sh = new SwitchModelHelper("Sun StorEdge network FC 2Gig switch", properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.assertEquals("Sun StorEdge Network 2Gig FC switch-16", this.sh.determineDeviceModel(properties).getProperty("DeviceDisplayModel"));
        }

        public void testSun1G_ModelHelper(String string) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            properties.setProperty("NumberOfPorts", "16");
            try {
                this.sh = new SwitchModelHelper("Sun StorEdge network FC switch", properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.assertEquals("Sun StorEdge Network FC switch-16", this.sh.determineDeviceModel(properties).getProperty("DeviceDisplayModel"));
        }

        public void testGUID() {
            Properties properties = new Properties();
            properties.setProperty("ip", "xx.xx.xx.xx");
            properties.setProperty("VENDOR", "brocade");
            properties.setProperty("MODEL", "Brocade 2GB 1200");
            properties.setProperty("wwn", "1111222233334444");
            String string = SwitchModelHelper.getGUID(properties);
            this.assertEquals(string, "1~FC-SWITCH~BROCADE~WWN~1111222233334444");
        }

        public static void main(String[] stringArray) {
            if (stringArray.length != 3) {
                System.out.println("Usage: java SwitchModelHelper <ipAddress_ofSun_1GBwithoutupdatedfirmware> <ipAddress_ofSun_2GB><ipAddress_ofBrocade>");
            }
            new Test().testSun1G_ModelHelper(stringArray[0]);
            new Test().testSun2G_ModelHelper(stringArray[1]);
            new Test().testBrocadeModelHelper(stringArray[2]);
        }
    }
}

