/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.FE_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.PortSpeedHelper;
import com.sun.jade.device.fcswitch.util.snmp.PrincipalSwitchHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToCIM_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToString_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.snmp.SW_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.SW_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.device.fcswitch.util.zones.ZoneInfo;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.snmp.SnmpStatusException;

public class BrocadeDeviceReport
implements ReportGenerator {
    private Properties props;
    private String ip;
    private String wwn;
    private HashMap systemProps = null;
    private HashMap portStatProps = null;
    private HashMap portStatus = null;
    private HashMap portConfig = null;
    private HashMap sensorProps = null;
    private HashMap sw_systemProps = null;
    private HashMap sw_portProps = null;
    private HashMap fa_portProps = null;
    private HashMap portResult = null;
    private HashMap portDeviceResult = null;
    private HashMap portConnectedDeviceWWNResult = null;
    private int portCount;
    private int moduleCount;
    private FE_Mibsnmp femibsnmp;
    private FA_Mibsnmp famibsnmp;
    private SW_Mibsnmp swmibsnmp;
    private static final String CIM_VERSION = "CIM 2.5";
    private static final String IP = "ip";
    private static final String WWN = "wwn";
    private static final String SYSTEM_VIEW = "SystemView";
    private static final String MODULE_COUNT_ERROR_MESSAGE = "Error in getting Module Count";
    private static final String LOG_TAG = "Brocade_Device_Report";
    private static final String NUMBER_OF_MODULES = "fcFeModuleCapacity";
    private static final String PORTS_PER_MODULE = "fcFeModuleFxPortCapacity";
    private static final String DEFAULT_PORT_TYPE = "1";
    private static final String DOT = ".";
    private static final String SW_MBTABLE_INDEX = "swNbIndex";
    private static final String SW_PORT_ID = "swNsPortID";
    private static final String SW_PORT_NAME = "swNsPortName";
    private static final String SW_ISL_PORT_ID = "swNbMyPort";
    private static final String SW_ISL_PORT_NAME = "swNbRemPortName";
    private static final String SENSOR_TYPE_FAN = "2";
    private static final String SENSOR_TYPE_TEMPERATURE = "1";
    private static final String SENSOR_TYPE_POWER = "3";
    private static final int WWN_OFFSET = 100;
    private static final int TEN = 10;
    private static final int HEX = 16;
    private int noOfZones;
    private int portsPerModule;
    private int noOfSensors;
    private Zones[] zones = null;
    public static final String sccs_id = "@(#)BrocadeDeviceReport.java\t1.36 08/28/03 SMI";

    public BrocadeDeviceReport(Properties properties) {
        this.props = properties;
        this.ip = properties.getProperty(IP);
        this.wwn = properties.getProperty(WWN);
        try {
            this.portCount = Integer.parseInt(properties.getProperty("NumberOfPorts"));
            this.noOfSensors = Integer.parseInt(properties.getProperty("NumberOfSensors"));
        }
        catch (Exception exception) {
            this.portCount = 0;
            this.noOfSensors = 0;
        }
        this.famibsnmp = new FA_Mibsnmp(this.ip);
        this.femibsnmp = new FE_Mibsnmp(this.ip);
        this.swmibsnmp = new SW_Mibsnmp(this.ip);
        this.moduleCount = this.getModuleCount();
        this.portsPerModule = this.getPortsPerModule();
    }

    public synchronized String generateReport() {
        int n;
        DeviceClass deviceClass = null;
        DeviceClass deviceClass2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        Object var8_8 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object[] objectArray = null;
        DeviceClass deviceClass5 = this.getReport();
        DeviceClass deviceClass6 = deviceClass5.newSubInstance();
        deviceClass6.setClassName("model");
        deviceClass6.setProperty("schema", CIM_VERSION);
        deviceClass6.setProperty("view", "system");
        deviceClass6.setProperty("type", "switch");
        deviceClass6.setProperty("prefix", "StorAdeSwitch");
        deviceClass6.setProperty("package", "com.sun.jade.cim.bean");
        try {
            string = this.swmibsnmp.resolveVarName(SW_MBTABLE_INDEX).getOid();
            string2 = this.swmibsnmp.resolveVarName(SW_PORT_ID).getOid();
            string3 = this.swmibsnmp.resolveVarName(SW_PORT_NAME).getOid();
        }
        catch (SnmpStatusException snmpStatusException) {
            // empty catch block
        }
        this.discoverConnectedSwitches(string);
        this.discoverConnectedDevice(string2);
        this.getConnectedDeviceWWN(string3);
        string4 = this.props.getProperty("password");
        if (string4 != null && !"".equals(string4)) {
            String string5 = this.props.getProperty("username");
            objectArray = ZoneInfo.getBrocadeZones(this.ip, string4, string5);
        } else {
            objectArray = ZoneInfo.getBrocadeZones(this.ip);
        }
        this.noOfZones = objectArray.length;
        Report.debug.log(LOG_TAG, (Object)("Number Of Zones " + objectArray.length));
        this.zones = new Zones[this.noOfZones];
        int n2 = 0;
        while (n2 < this.noOfZones) {
            this.zones[n2] = (Zones)objectArray[n2];
            ++n2;
        }
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        deviceClass7.setClassName(SYSTEM_VIEW);
        if (this.portCount == 0) {
            this.portCount = this.getNumberOfPorts();
        }
        this.sw_systemProps = this.swmibsnmp.getSystemProps();
        DeviceClass deviceClass8 = deviceClass7.newSubInstance();
        this.populateSwitchSystem(this.swmibsnmp, deviceClass8);
        int n3 = 1;
        while (n3 <= this.portCount) {
            int n4 = this.moduleCount * this.portsPerModule;
            if (n4 > 1) {
                int n5 = 1;
                while (n5 <= this.moduleCount) {
                    n = 1;
                    while (n <= this.portsPerModule) {
                        if (n5 * n == n3) {
                            this.portStatProps = this.femibsnmp.getPortStat(n5, n);
                        }
                        ++n;
                    }
                    ++n5;
                }
            } else {
                this.portStatProps = this.femibsnmp.getPortStat(1, n3);
            }
            this.sw_portProps = this.swmibsnmp.getFcPortProps(n3);
            this.fa_portProps = this.famibsnmp.getPortProps(n3);
            deviceClass2 = deviceClass8.newSubInstance();
            this.populateFibrePort(this.femibsnmp, deviceClass2, n3, n3);
            deviceClass = deviceClass2.newSubInstance();
            this.populateFibreCounters(this.femibsnmp, deviceClass, n3);
            deviceClass3 = deviceClass2.newSubInstance();
            this.populateProtocolEndPoint(this.femibsnmp, deviceClass3, n3);
            this.populateProtocolEndPoint2(this.swmibsnmp, deviceClass3, n3);
            ++n3;
        }
        DeviceClass deviceClass9 = deviceClass8.newSubInstance();
        this.populatePhysicalPackage(this.femibsnmp, deviceClass9);
        DeviceClass deviceClass10 = deviceClass8.newSubInstance();
        this.populateChassisDevice(this.swmibsnmp, deviceClass10);
        if (this.noOfZones > 0) {
            n = 0;
            while (n < this.noOfZones) {
                deviceClass4 = deviceClass8.newSubInstance();
                this.populateZones(deviceClass4, this.zones[n]);
                this.populateZoneMember(deviceClass6, this.zones[n]);
                ++n;
            }
        }
        return deviceClass5.toXML();
    }

    protected void populateFibrePort(FE_Mibsnmp fE_Mibsnmp, DeviceClass deviceClass, int n, int n2) {
        String string = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", "" + (n - 1));
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(n - 1);
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString_FE((String)this.sw_portProps.get("swFCPortOpStatus"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStatusString_FE((String)this.sw_portProps.get("swFCPortOpStatus"))));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = (String)this.portStatProps.get("fcFxPortSigLosses");
        deviceClass.setProperty("LossOfSignalCounter", string == null ? "0" : string);
        string = (String)this.portStatProps.get("fcFxPortSyncLosses");
        deviceClass.setProperty("LossOfSyncCounter", string == null ? "0" : string);
        string = (String)this.portStatProps.get("fcFxPortInvalidCrcs");
        deviceClass.setProperty("CRCErrors", string == null ? "0" : string);
        string = (String)this.portStatProps.get("fcFxPortInvalidTxWords");
        deviceClass.setProperty("InvalidTransmissionWords", string == null ? "0" : string);
        deviceClass.setProperty("FramesTooShort", "0");
        deviceClass.setProperty("FramesTooLong", "0");
        string = (String)this.fa_portProps.get("connUnitPortType");
        deviceClass.setProperty("Type", string == null ? SNMPPortType.getPortTypeString("1") : SNMPPortType.getPortTypeString(string));
        deviceClass.setProperty("Description", string == null ? SNMPPortType.getPortTypeString("1") : SNMPPortType.getPortTypeString(string));
        string = (String)this.fa_portProps.get("connUnitPortSpeed");
        if ("-1".equalsIgnoreCase(string)) {
            string = "0";
        }
        deviceClass.setProperty("Speed", string == null ? "0" : string);
        deviceClass.setProperty("PortOperatingSpeed", PortSpeedHelper.getPortSpeed(string));
        deviceClass.setProperty("OperatingStatus", SNMPToString_State_Status.getOperationalStatusString_FE((String)this.sw_portProps.get("swFCPortOpStatus")));
        deviceClass.setProperty("AdministrativeStatus", SNMPToString_State_Status.getOperationalStatusString_FE((String)this.sw_portProps.get("swFCPortAdmStatus")));
    }

    protected void populateFibreCounters(FE_Mibsnmp fE_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("DeviceStatisticalInformation");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("DeviceCreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePortEventCounters");
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(n - 1);
        deviceClass.setProperty("Name", string == null ? "" : string);
        string = (String)this.portStatProps.get("fcFxPortLinkFailures");
        deviceClass.setProperty("LinkFails", string == null ? "0" : string);
        string = (String)this.portStatProps.get("fcFxPortPrimSeqProtoErrors");
        deviceClass.setProperty("Prim_Seq_Errs", string == null ? "0" : string);
    }

    protected void populateSwitchSystem(SW_Mibsnmp sW_Mibsnmp, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.wwn);
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString_FE((String)this.sw_systemProps.get("swOperStatus"))));
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        string = this.props.getProperty("ipno");
        deviceClass.setProperty("OtherIdentifyingInfo", string == null ? this.ip : string);
        deviceClass.setProperty("IdentifyingDescriptions", "IPAddress");
        deviceClass.setProperty("PortCount", "" + this.getNumberOfPorts());
        deviceClass.setProperty("WWN", this.wwn);
        string = (String)this.sw_systemProps.get("swFirmwareVersion");
        deviceClass.setProperty("Flash", string == null ? "-" : string);
        deviceClass.setProperty("HW", "-");
        deviceClass.setProperty("MAC", "-");
        deviceClass.setProperty("PROM", "-");
        deviceClass.setProperty("ZoneTotal", "" + this.noOfZones);
        string = (String)this.sw_systemProps.get("swPrincipalSwitch");
        if (string != null) {
            string = PrincipalSwitchHelper.get_SW_PrincipalSwitchAttr(string);
        }
        deviceClass.setProperty("PrincipalSwitch", string == null ? "Unknown" : string);
    }

    protected void populatePhysicalPackage(FE_Mibsnmp fE_Mibsnmp, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("PhysicalPackage");
        deviceClass.setProperty("Tag", this.wwn);
        string = this.props.getProperty("DeviceDisplayModel");
        deviceClass.setProperty("Name", string == null ? "Brocade" : string);
        deviceClass.setProperty("Manufacturer", string == null ? "Brocade SilkWorm FC Switch" : string);
        string = (String)this.sw_systemProps.get("swSsn");
        deviceClass.setProperty("SerialNumber", string == null ? "-" : string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_PhysicalPackage");
        deviceClass.setProperty("Removable", "true");
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("HotSwappable", "true");
    }

    protected void populateChassisDevice(SW_Mibsnmp sW_Mibsnmp, DeviceClass deviceClass) {
        HashMap hashMap = null;
        String string = null;
        deviceClass.setClassName("LogicalDevice");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("DeviceID", "Chassis");
        deviceClass.setProperty("Name", "chassis");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_ChassisDevice");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", SNMPToCIM_State_Status.getOperationalStatusString_FE((String)this.sw_systemProps.get("swOperStatus")));
        deviceClass.setProperty("Availability", SENSOR_TYPE_POWER);
        deviceClass.setProperty("Description", "Switch Chassis");
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = sW_Mibsnmp.getSystemUpTimeString();
        deviceClass.setProperty("PowerOnTime", string == null ? "-" : string);
        deviceClass.setProperty("PowerOnSeconds", sW_Mibsnmp.getSystemUpTime() + "");
        if (this.noOfSensors == 0) {
            this.noOfSensors = this.swmibsnmp.getNumberOfSensors();
        }
        Report.debug.log(LOG_TAG, (Object)("Number of Sensors " + this.noOfSensors));
        int n = 1;
        while (n <= this.noOfSensors) {
            DeviceClass deviceClass2;
            hashMap = sW_Mibsnmp.getSensorProps(n);
            String string2 = (String)hashMap.get("swSensorType");
            if ("1".equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("TemperatureSensor");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)hashMap.get("swSensorInfo"));
                deviceClass2.setProperty("Name", (String)hashMap.get("swSensorInfo"));
                deviceClass2.setProperty("CreationClassName", "CIM_TemperatureSensor");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                String string3 = (String)hashMap.get("swSensorValue");
                if (string3.startsWith("-2")) {
                    string3 = "UnKnown";
                }
                deviceClass2.setProperty("SensorType", "1");
                deviceClass2.setProperty("OtherSensorTypeDescription", string3 == null ? "UnKnown" : string3);
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getSensorStatusString_SW((String)hashMap.get("swSensorStatus"))));
            }
            if (SENSOR_TYPE_FAN.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("Fan");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)hashMap.get("swSensorInfo"));
                deviceClass2.setProperty("Name", (String)hashMap.get("swSensorInfo"));
                deviceClass2.setProperty("CreationClassName", "CIM_Fan");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getSensorStatusString_SW((String)hashMap.get("swSensorStatus"))));
            }
            if (SENSOR_TYPE_POWER.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("PowerSupply");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)hashMap.get("swSensorInfo"));
                deviceClass2.setProperty("Name", (String)hashMap.get("swSensorInfo"));
                deviceClass2.setProperty("CreationClassName", "CIM_UninterruptiblePowerSupply");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getSensorStatusString_SW((String)hashMap.get("swSensorStatus"))));
            }
            ++n;
        }
    }

    protected void populateProtocolEndPoint(FE_Mibsnmp fE_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("ProtocolEndpoint");
        string = this.getPortWWN(n - 1);
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    protected void populateLogicalNetwork(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = this.props.getProperty("FabricName");
        deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalNetwork");
        deviceClass2.setProperty("Name", string);
        deviceClass2.setProperty("NetworkType", "Fibre Channel");
    }

    protected DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    protected void populateProtocolEndPoint2(SW_Mibsnmp sW_Mibsnmp, DeviceClass deviceClass, int n) {
        DeviceClass deviceClass2 = null;
        this.attachConnectedSwitch(sW_Mibsnmp, deviceClass, deviceClass2, n);
        this.attachConnectedDevice(sW_Mibsnmp, deviceClass, deviceClass2, n);
    }

    protected String getPortWWN(int n) {
        String string = (String)this.fa_portProps.get("connUnitPortWwn");
        if (string == null) {
            String string2 = Integer.toHexString(n);
            string = this.computePortWWN(string2);
        }
        try {
            if (string != null && string.length() > 16) {
                string = string.substring(0, 16);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return string;
    }

    private String computePortWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.wwn);
        stringBuffer.setCharAt(0, '2');
        if (string.length() > 1) {
            stringBuffer.setCharAt(2, string.charAt(0));
            stringBuffer.setCharAt(3, string.charAt(1));
            return stringBuffer.toString();
        }
        stringBuffer.setCharAt(3, string.charAt(0));
        return stringBuffer.toString();
    }

    protected void populateZones(DeviceClass deviceClass, Zones zones) {
        deviceClass.setClassName("Zone");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("Name", zones.getZoneName().trim());
        deviceClass.setProperty("REF", zones.getZoneName().trim());
        deviceClass.setProperty("ElementName", zones.getZoneName().trim());
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("OtherZoneTypeDescription", zones.getZoneDescription());
        deviceClass.setProperty("Active", "true");
        deviceClass.setProperty("ProtocolType", "1");
    }

    protected void populateZoneMember(DeviceClass deviceClass, Zones zones) {
        Object[] objectArray = zones.getMemberList();
        if (objectArray.length > 0) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ZoneMember");
            deviceClass2.setProperty("ZoneMemberType", "5");
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            deviceClass3.setClassName("Collection");
            deviceClass3.setProperty("REF", zones.getZoneName().trim());
            int n = 0;
            while (n < objectArray.length) {
                String string = ((String)objectArray[n]).trim();
                if (string != null) {
                    DeviceClass deviceClass4 = deviceClass2.newSubInstance();
                    deviceClass4.setClassName("Member");
                    if (string.length() == 16) {
                        this.addWWNZoneMember(deviceClass4, string);
                    } else {
                        deviceClass4.setProperty("REF", string);
                    }
                }
                ++n;
            }
        }
    }

    private void addWWNZoneMember(DeviceClass deviceClass, String string) {
        deviceClass.setProperty("CreationClassName", "CIM_ProtocolEndpoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
        deviceClass.setAlias("ProtocolEndPoint");
    }

    protected void discoverConnectedSwitches(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip, new SW_MIBOidTable());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties(SW_MBTABLE_INDEX, SW_ISL_PORT_ID);
        this.portResult = sNMPWalk.filterProperties(hashMap, string);
    }

    protected void discoverConnectedDevice(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip, new SW_MIBOidTable());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties(SW_PORT_ID, "swNsPortType");
        this.portDeviceResult = sNMPWalk.filterProperties(hashMap, string);
    }

    protected void getConnectedDeviceWWN(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip, new SW_MIBOidTable());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties(SW_PORT_NAME, "swNsPortSymb");
        this.portConnectedDeviceWWNResult = sNMPWalk.filterProperties(hashMap, string);
    }

    protected void attachConnectedSwitch(SW_Mibsnmp sW_Mibsnmp, DeviceClass deviceClass, DeviceClass deviceClass2, int n) {
        DeviceClass deviceClass3 = null;
        Set set = this.portResult.entrySet();
        Iterator iterator = set.iterator();
        Object var8_8 = null;
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            HashMap hashMap = sW_Mibsnmp.getNBProps(string);
            String string2 = (String)hashMap.get(SW_ISL_PORT_ID);
            try {
                n2 = Integer.parseInt(string2, 10);
            }
            catch (NumberFormatException numberFormatException) {
                Report.debug.log(LOG_TAG, (Object)numberFormatException);
            }
            if (n2 != n) continue;
            this.populateLogicalNetwork(deviceClass, deviceClass3);
            deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ProtocolEndpoint");
            String string3 = (String)hashMap.get(SW_ISL_PORT_NAME);
            Report.debug.log(LOG_TAG, (Object)("Connected Switch Port" + string2 + "\t Connected Switch WWN " + string3));
            deviceClass2.setProperty("Name", string3);
            deviceClass2.setProperty("NameFormat", "WWN");
            deviceClass2.setProperty("ProtocolType", "Fibre Channel");
        }
    }

    protected void attachConnectedDevice(SW_Mibsnmp sW_Mibsnmp, DeviceClass deviceClass, DeviceClass deviceClass2, int n) {
        DeviceClass deviceClass3 = null;
        Set set = this.portConnectedDeviceWWNResult.entrySet();
        Iterator iterator = set.iterator();
        Set set2 = this.portDeviceResult.entrySet();
        Iterator iterator2 = set2.iterator();
        Object var10_10 = null;
        int n2 = 0;
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String string = (String)entry.getValue();
            String string2 = (String)entry.getKey();
            int n3 = string2.lastIndexOf(DOT);
            String string3 = string2.substring(n3 + 1, string2.length());
            string = string.substring(4, 6);
            if (this.portCount <= 16) {
                string = string.substring(1, 2);
            }
            long l = 0L;
            try {
                l = Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            String string4 = string = Long.toString(l);
            try {
                n2 = Integer.parseInt(string4, 10);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            if (n2 + 1 != n) continue;
            this.populateLogicalNetwork(deviceClass, deviceClass3);
            deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ProtocolEndpoint");
            String string5 = null;
            while (iterator.hasNext()) {
                int n4;
                Map.Entry entry2 = iterator.next();
                String string6 = (String)entry2.getKey();
                String string7 = string6.substring((n4 = string6.lastIndexOf(DOT)) + 1, string6.length());
                if (!string7.equalsIgnoreCase(string3)) continue;
                string5 = (String)entry2.getValue();
            }
            Report.debug.log(LOG_TAG, (Object)("Connected Device Port" + string4 + "\t Connected Device WWN " + string5));
            deviceClass2.setProperty("Name", string5);
            deviceClass2.setProperty("NameFormat", "WWN");
            deviceClass2.setProperty("ProtocolType", "Fibre Channel");
        }
    }

    private int getNumberOfPorts() {
        int n = 0;
        String string = (String)this.swmibsnmp.getPortCapacity().get("swFCPortCapacity");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n == 0) {
            int n2 = this.getModuleCount();
            int n3 = this.getPortsPerModule();
            n = n3 * n2;
        }
        return n;
    }

    private int getModuleCount() {
        int n = 0;
        String string = (String)this.femibsnmp.getGroupConfig().get(NUMBER_OF_MODULES);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private int getPortsPerModule() {
        int n = 0;
        this.systemProps = this.femibsnmp.getModuleProps(1);
        try {
            n = Integer.parseInt((String)this.systemProps.get(PORTS_PER_MODULE));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        int n = 1;
        if (stringArray.length < 1) {
            System.out.println("Usage: java BrocadeDeviceReport <ipAddress> <noTimes>");
        }
        try {
            try {
                properties.put(IP, stringArray[0]);
                SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[0]);
                String string = switchWWNsnmp.getWWNString();
                String string2 = switchWWNsnmp.getFabricName();
                properties.put("FabricName", string2);
                properties.put(WWN, string);
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n > 1) {
                        Thread.sleep(30000L);
                    }
                    BrocadeDeviceReport brocadeDeviceReport = new BrocadeDeviceReport(properties);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[0] + ".xml." + n2));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.println(brocadeDeviceReport.generateReport());
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var11_13 = null;
                SingleSnmpSession.destroySnmpSession();
                SingleSnmpSession.destroyAsyncSnmpSession();
                return;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            SingleSnmpSession.destroySnmpSession();
            SingleSnmpSession.destroyAsyncSnmpSession();
            throw throwable;
        }
        SingleSnmpSession.destroySnmpSession();
        SingleSnmpSession.destroyAsyncSnmpSession();
    }

    public static class Test
    extends UnitTest {
        public void testBrocadeReportGenerator(String string) {
            Properties properties = new Properties();
            properties.put(BrocadeDeviceReport.IP, string);
            SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(string);
            String string2 = switchWWNsnmp.getWWNString();
            properties.put(BrocadeDeviceReport.WWN, string2);
            BrocadeDeviceReport brocadeDeviceReport = new BrocadeDeviceReport(properties);
            String string3 = new SwitchWWNsnmp(properties.getProperty(BrocadeDeviceReport.IP)).getWWNString();
            this.assertNotNull(string3);
            this.assertNotNull(brocadeDeviceReport.generateReport());
        }

        public static void main(String[] stringArray) {
            new Test().testBrocadeReportGenerator(stringArray[0]);
        }
    }
}

