/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.diag.switch2G;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.apps.command.CommandOutputListener;
import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.fcswitch.ancor.diag.Messages;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Switch2GTestExecutable
extends TestExecutableImpl {
    private static final String TEST_NAME = "Sun FC-2 Switch LoopBack and Pattern Test";
    private static final String TEST_PASSED = "\"Test Passed\"";
    private static final String TEST_FAILED = "\"Test Failed\"";
    private static final String DIAGS_DIR = "Diags";
    private static final String BIN = "bin";
    private static final String SADE_HOME = "storade.home";
    private static int curMsgCount;
    private static int prvMsgCount;
    private InetAddress hostAddress = null;
    private int portNum;
    private String passwd;
    private String switchip;
    private static String output;
    private static DiagnosticResult result;
    private static final String TYPE = "switch";
    private static int patternType;
    private String patternMode;
    private static long percentComplete;
    private static long maxMessages;
    private int xferSize;
    private int numberOfPasses;
    private int patternInt;
    private String testPattern = "0x00000000";
    private CommandExec command = null;
    private static final Localizer msgs;
    private boolean abort = false;
    public static final String sccs_id = "@(#)Switch2GTestExecutable.java\t1.8 05/06/03 SMI";

    public Switch2GTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
        Report.debug.log("Switch2GDiags", (Object)("new Switch2GTestExecutable: mse     =" + referenceForMSE));
        Report.debug.log("Switch2GDiags", (Object)("new Switch2GTestExecutable: setting =" + diagnosticSetting));
    }

    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        result = diagnosticResult;
        Report.trace.log("Switch2GDiags", (Object)"runTest");
        try {
            if (!this.parseLocalSettings()) {
                return;
            }
            this.parseSettings();
            this.switchip = this.hostAddress.getHostAddress();
            String string = System.getProperty(SADE_HOME) + File.separator + DIAGS_DIR + File.separator + BIN + File.separator;
            Report.debug.log("Switch2GDiags", (Object)("SADE HOME " + System.getProperty(SADE_HOME)));
            String string2 = string + "switch2test -v -o dev=" + this.portNum + ":" + this.switchip + ":|xfersize=" + this.xferSize + "|iterations=" + this.numberOfPasses + "|userpattern=" + this.testPattern + "|selectpattern=" + this.patternMode + "|passwd=" + this.passwd;
            Report.debug.log("Switch2GDiags", (Object)string2);
            this.command = new CommandExec(string2);
            OutputListener outputListener = new OutputListener();
            this.command.exec((CommandOutputListener)outputListener);
            int n = this.command.getReturnValue();
            percentComplete = 100L;
            diagnosticResult.setPercentComplete((short)percentComplete);
            if (n == 0) {
                diagnosticResult.setFinalResults(TestState.PASSED, output);
                diagnosticResult.update();
                percentComplete = 0L;
            } else if (!this.abort) {
                diagnosticResult.setFinalResults(TestState.FAILED, output);
                diagnosticResult.update();
                percentComplete = 0L;
            } else if (this.abort) {
                diagnosticResult.setFinalResults(TestState.STOPPED, output);
                diagnosticResult.update();
                percentComplete = 0L;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Report.error.log((Object)exception);
            if (this.reportErrors) {
                diagnosticResult.addTestResults(exception.getLocalizedMessage());
            }
            diagnosticResult.setFinalResults(TestState.FAILED);
            return;
        }
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log("Switch2GDiags", (Object)"abortTest");
        this.abort = true;
        result.addTestResults("Test is aborted for time out or other reason");
        this.command.abort();
        return true;
    }

    protected boolean parseLocalSettings() throws Exception {
        String string;
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("transferSize");
        if (testParameter != null) {
            string = (String)testParameter.getCurrentValue();
            this.xferSize = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("numberOfPasses")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.numberOfPasses = Integer.parseInt(string);
        }
        testParameter = this.setting.getTestParameter("PatternType");
        patternType = 0;
        if (testParameter != null) {
            patternType = testParameter.choiceValue(patternType);
        }
        if (patternType == 1 && (testParameter = this.setting.getTestParameter("UserPattern")) != null) {
            String string2 = (String)testParameter.getCurrentValue();
            this.testPattern = string2.startsWith("0x") ? string2 : "0x" + string2;
            Report.debug.log("Switch2GDiags", (Object)("User testPattern=" + this.testPattern));
        }
        switch (patternType) {
            case 0: {
                this.patternMode = "Critical";
                break;
            }
            case 1: {
                this.patternMode = "User";
                break;
            }
            case 2: {
                this.patternMode = "All";
            }
        }
        Report.debug.log("Switch2GDiags", (Object)("patternType=" + patternType));
        Report.debug.log("Switch2GDiags", (Object)("patternMode=" + this.patternMode));
        testParameter = this.setting.getTestParameter("Password");
        if (testParameter != null) {
            this.passwd = (String)testParameter.getCurrentValue();
        }
        Report.debug.log("Switch2GDiags", (Object)("patternType=" + patternType));
        Report.debug.log("Switch2GDiags", (Object)("testPattern=" + this.testPattern));
        Report.debug.log("Switch2GDiags", (Object)("Loopback test mse = " + this.mse.getCIMObjectPath()));
        Report.debug.log("Switch2GDiags", (Object)("System Name = " + this.mse.getSystemName()));
        try {
            this.hostAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Object)unknownHostException);
        }
        this.portNum = Integer.parseInt(this.mse.getKeyValue());
        return true;
    }

    static {
        patternType = 0;
        percentComplete = 0L;
        maxMessages = 0L;
        msgs = Messages.getLocalizer();
    }

    public static class OutputListener
    implements CommandOutputListener {
        public void stdOutput(String string) {
            try {
                output = string.trim();
                StringBuffer stringBuffer = new StringBuffer(output);
                int n = 0;
                while (n < stringBuffer.length()) {
                    if (stringBuffer.charAt(n) == '<') {
                        stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                    }
                    ++n;
                }
                boolean bl = false;
                if (output.trim().endsWith(Switch2GTestExecutable.TEST_PASSED)) {
                    bl = true;
                }
                if (output.trim().endsWith(Switch2GTestExecutable.TEST_FAILED)) {
                    bl = true;
                }
                if (!bl) {
                    output = stringBuffer.toString().trim();
                    result.addTestResults(output);
                    if (percentComplete == 0L) {
                        switch (patternType) {
                            case 0: {
                                maxMessages = 24L;
                                break;
                            }
                            case 1: {
                                maxMessages = 12L;
                                break;
                            }
                            case 2: {
                                maxMessages = 300L;
                            }
                        }
                    }
                    percentComplete += 100L / maxMessages;
                    result.setPercentComplete((short)percentComplete);
                    result.update();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LocalizedString localizedString = new LocalizedString(exception);
                result.setFinalResults(TestState.FAILED, localizedString.toString());
                return;
            }
        }

        public void errOutput(String string) {
            try {
                output = string.trim();
                StringBuffer stringBuffer = new StringBuffer(output);
                int n = 0;
                while (n < stringBuffer.length()) {
                    if (stringBuffer.charAt(n) == '<') {
                        stringBuffer = stringBuffer.replace(n, n + 1, "\t&lt;");
                    }
                    ++n;
                }
                boolean bl = false;
                if (output.trim().endsWith(Switch2GTestExecutable.TEST_PASSED)) {
                    bl = true;
                }
                if (output.trim().endsWith(Switch2GTestExecutable.TEST_FAILED)) {
                    bl = true;
                }
                if (!bl) {
                    output = stringBuffer.toString().trim();
                    result.addTestResults(output);
                    switch (patternType) {
                        case 0: {
                            maxMessages = 24L;
                            percentComplete += 100L / maxMessages;
                            break;
                        }
                        case 1: {
                            maxMessages = 12L;
                            percentComplete += 100L / maxMessages;
                            break;
                        }
                        case 2: {
                            maxMessages = 300L;
                            curMsgCount += 1;
                            if (curMsgCount != prvMsgCount + 3) break;
                            percentComplete += 1L;
                            prvMsgCount = curMsgCount;
                        }
                    }
                    result.setPercentComplete((short)percentComplete);
                    result.update();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LocalizedString localizedString = new LocalizedString(exception);
                result.setFinalResults(TestState.FAILED, localizedString.toString());
                return;
            }
        }

        public void finished(int n) {
        }
    }
}

