/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class WWNZone
extends SanboxHeader {
    private static final String sccs_id = "@(#)WWNZone.java\t1.3 10/08/01 SMI";
    private static final int NUM_RECORDS_WWN_UTIL_REQ_NAME = 4;
    private static final int COMMAND = 48;
    private static final int SUB_COMMAND = 60;
    private static VariableDefinition[] req = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("off_set", 4), new VariableDefinition("total_num_wwn_entries", 4), new VariableDefinition("include_name_info", 1), new VariableDefinition("reserved", 1, 3), new VariableDefinition("wwn_zones", 40, 4)};
    private static VariableDefinition[] ret = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("off_set", 4), new VariableDefinition("total_num_wwn_entries", 4), new VariableDefinition("include_name_info", 1), new VariableDefinition("reserved", 1, 3), new VariableDefinition("wwn_zones", 40, 4)};
    private static VariableDefinition[] wwn_zone = new VariableDefinition[]{new VariableDefinition("WoldWide_Name", 1, 8), new VariableDefinition("wwn_zones_bitmap", 4, 8)};

    public static byte[] getWWNZoneRequest() {
        SanboxHeader sanboxHeader = new SanboxHeader(req);
        sanboxHeader.setCommand(48);
        DataBlock dataBlock = sanboxHeader.getBlock();
        dataBlock.setVariable("sub_cmd", 60L);
        return sanboxHeader.getBytes();
    }

    public WWNZone(byte[] byArray) {
        super(ret);
        this.block.useData(byArray);
    }

    public int getTotalNumWWNEntries() {
        return (int)this.block.getVariableValue("total_num_wwn_entries");
    }

    public String getWoldWideName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        DataBlock dataBlock = new DataBlock(wwn_zone);
        dataBlock.useData(this.block.getVariableBytes("wwn_zones", n));
        int n2 = 0;
        while (n2 < 8) {
            stringBuffer.append((char)dataBlock.getVariableValue("WoldWide_Name", n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("total_num_wwn_entries ");
        stringBuffer.append(this.getTotalNumWWNEntries());
        int n = 0;
        while (n < 4) {
            stringBuffer.append("\nzone " + (n + 1) + " WWN ");
            stringBuffer.append(this.getWoldWideName(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            WWNZone wWNZone = new WWNZone(byArray);
            this.assertNotNull(wWNZone);
        }
    }
}

