/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class TestStatus
extends SanboxHeader {
    public static final int UT_ONLINE_TEST_MSG = 49;
    public static final int OL_STRT_LOOP_INTEG_LPBK = 13;
    public static final int OL_CHASSIS_STATUS_REQ = 10;
    public static final int OL_STOP_TST = 1;
    static VariableDefinition[] test_start_request = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("port_num", 1), new VariableDefinition("special_length", 1), new VariableDefinition("special_pattern", 1), new VariableDefinition("stop_on_error", 1), new VariableDefinition("length", 4), new VariableDefinition("pattern", 4), new VariableDefinition("test_count", 4)};
    static VariableDefinition[] test_status_request = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("first_port", 1), new VariableDefinition("reserved", 3)};
    static VariableDefinition[] test_status_return = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("first_port", 1), new VariableDefinition("num_of_ports", 1), new VariableDefinition("total_ports", 1), new VariableDefinition("reserved", 1), new VariableDefinition("test_fail_cnt", 4), new VariableDefinition("port_test_status", 1, 16), new VariableDefinition("port_test_count", 4, 16), new VariableDefinition("port_fail_count", 4, 16)};

    public static byte[] getTestStartBuffer(int n, int n2, int n3, int n4) {
        SanboxHeader sanboxHeader = new SanboxHeader(test_start_request);
        sanboxHeader.setCommand(49);
        DataBlock dataBlock = sanboxHeader.getBlock();
        dataBlock.setVariable("sub_cmd", 13L);
        dataBlock.setVariable("port_num", n);
        dataBlock.setVariable("special_length", 1L);
        dataBlock.setVariable("special_pattern", 1L);
        dataBlock.setVariable("stop_on_error", 0L);
        dataBlock.setVariable("length", n2);
        dataBlock.setVariable("pattern", n4);
        dataBlock.setVariable("test_count", n3);
        System.out.println(dataBlock);
        return sanboxHeader.getBytes();
    }

    public static byte[] getTestStatusBuffer() {
        SanboxHeader sanboxHeader = new SanboxHeader(test_status_request);
        sanboxHeader.setCommand(49);
        DataBlock dataBlock = sanboxHeader.getBlock();
        dataBlock.setVariable("sub_cmd", 10L);
        dataBlock.setVariable("first_port", 0L);
        return sanboxHeader.getBytes();
    }

    public TestStatus(byte[] byArray) {
        super(test_status_return);
        this.block.useData(byArray);
    }

    public long getTestFailCount() {
        return this.block.getVariableValue("test_fail_cnt");
    }

    public long getPortTestStatus(int n) {
        return this.block.getVariableValue("port_test_status", n);
    }

    public long getPortTestCount(int n) {
        return this.block.getVariableValue("port_test_count", n);
    }

    public long getPortFailCount(int n) {
        return this.block.getVariableValue("port_fail_count", n);
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            TestStatus testStatus = new TestStatus(byArray);
            this.assertNotNull(testStatus);
        }
    }
}

