/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class ChassisStatus
extends SanboxHeader {
    private static final String sccs_id = "@(#)ChassisStatus.java\t1.8 10/08/01 SMI";
    public static final int OK = 0;
    public static final int FAILURE = 1;
    public static final int WARM = 1;
    public static final int OVERHEAT = 2;
    public static final int UT_SWTCH_STATUS_REQ = 18;
    public static final int NUM_OF_PORTS = 16;
    static VariableDefinition[] reply = new VariableDefinition[]{new VariableDefinition("first_port_addr", 4), new VariableDefinition("num_of_ports", 1), new VariableDefinition("power_supply_failed", 1), new VariableDefinition("in_order_delivery_on", 1), new VariableDefinition("board_heat_status", 1), new VariableDefinition("board_temp", 4), new VariableDefinition("fan1_installed", 1), new VariableDefinition("fan2_installed", 1), new VariableDefinition("fan1_failure", 1), new VariableDefinition("fan2_failure", 1), new VariableDefinition("gbic_types", 1, 16), new VariableDefinition("fc_addr", 4, 16)};

    public static byte[] getChassisStatusRequest(int n) {
        SanboxHeader sanboxHeader = new SanboxHeader(18);
        return sanboxHeader.getBytes();
    }

    public ChassisStatus(byte[] byArray) {
        super(reply);
        this.block.useData(byArray);
    }

    public long getFirstPortAddr() {
        return this.block.getVariableValue("first_port_addr");
    }

    public short getNumOfPorts() {
        return (short)this.block.getVariableValue("num_of_ports");
    }

    public int getPowerSupplyFailed() {
        return (int)this.block.getVariableValue("power_supply_failed");
    }

    public String getPowerSupplyFailedString() {
        if ((int)this.block.getVariableValue("power_supply_failed") == 0) {
            return "OK";
        }
        return "FAILURE";
    }

    public boolean isInOrderDeliveryOn() {
        long l = this.block.getVariableValue("in_order_delivery_on");
        return l != 0L;
    }

    public int getBoardHeatStatus() {
        return (int)this.block.getVariableValue("board_heat_status");
    }

    public String getBoardHeatStatusString() {
        int n = (int)this.block.getVariableValue("board_heat_status");
        String string = new String();
        switch (n) {
            case 0: {
                string = "OK";
                break;
            }
            case 1: {
                string = "WARM";
                break;
            }
            case 2: {
                string = "OVERHEAT";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public int getBoardTemp() {
        return (int)this.block.getVariableValue("board_temp");
    }

    public boolean isFanInstalled(int n) {
        long l;
        switch (n) {
            case 1: {
                l = this.block.getVariableValue("fan1_installed");
                break;
            }
            case 2: {
                l = this.block.getVariableValue("fan2_installed");
                break;
            }
            default: {
                return false;
            }
        }
        return l != 0L;
    }

    public int getFanStatus(int n) {
        switch (n) {
            case 1: {
                return (int)this.block.getVariableValue("fan1_failure");
            }
            case 2: {
                return (int)this.block.getVariableValue("fan2_failure");
            }
        }
        return 1;
    }

    public String getFanStatusString(int n) {
        switch (n) {
            case 1: {
                if ((int)this.block.getVariableValue("fan1_failure") == 0) {
                    return "OK";
                }
                return "FAILURE";
            }
            case 2: {
                if ((int)this.block.getVariableValue("fan2_failure") == 0) {
                    return "OK";
                }
                return "FAILURE";
            }
        }
        return "FAILURE";
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            ChassisStatus chassisStatus = new ChassisStatus(byArray);
            this.assertNotNull(chassisStatus);
        }
    }

    public static interface GBIC_Types {
        public static final short OPTICAL_SW = 0;
        public static final short OPTICAL_LW = 1;
        public static final short OPTICAL_SW2 = 2;
        public static final short COPPER_STYLE_ACTIVE = 3;
        public static final short OPTICAL_LW2 = 4;
        public static final short COPPER_STYLE = 5;
        public static final short SERIAL_MODULE_DEFINITION = 6;
        public static final short GBIC_NOT_PRESENT = 7;
    }
}

