/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t4.service;

import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3HttpConnection;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.device.array.t3.util.ReportUtil;
import com.sun.jade.device.array.t4.service.T4StatusCalculator;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.RHBAConverter;
import com.sun.jade.device.util.ReportHandler;
import com.sun.jade.device.util.ReportTools;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AgentStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class T4ReportGenerator
implements ReportGenerator {
    private Properties props;
    private String systemName;
    private String ip;
    private int unitCount;
    private String[] pages = new String[]{"/system.htm", "/sysdata.htm", "/sysoper.htm", "/sysperf.htm", "/frudata.htm", "/fruprop.htm", "/log.htm", "/lun.htm", "/monitor.htm", "/ntp.htm", "/portperf.htm", "/portprop.htm", "/slice.htm", "/linkstat.htm", "/vol.htm", "/volperf.htm", "/volprop.htm"};
    private T3TokenList system;
    private ArrayList ibData;
    private static final String NOT_AVAILABLE_INBAND = "Data not available";
    private static final String UNAVAILABLE_INTEGER = "0";
    private static final String UNAVAILABLE_FLOAT = "0.0";
    private static final String NO_FABRIC_NAME = "0000000000000000";
    private static final String NO_DISKS_DISABLED = "No disks are currently disabled in this volume";
    private static final String NO_DISKS_SUBSTITUTED = "No disks are currently substituted in this volume";
    private static final String REPORT_OK = "OK";
    private static final String REPORT_FAIL = "FAILURE";
    private static final String BLANK = "";
    private static final String FULL_REDUNDANCY = "full";
    private static final String DEGRADED_REDUNDANCY = "degraded";
    private static final String LOST_REDUNDANCY = "lost";
    private static final String PCU_TYPE_NAME = "powerUnit";
    private static final String LOOP_TYPE_NAME = "loopCard";
    private static final String FAN_TYPE_NAME = "fan";
    private static final String DRIVE_TYPE_NAME = "diskDrive";
    private static final String VOLUME_TYPE_NAME = "volume";
    private static final String BATTERY_TYPE_NAME = "battery";
    private static final String CONTROLLER_TYPE_NAME = "controller";
    private static final int CONTROLLER = 1;
    private static final int PCU = 2;
    private static final int LOOP = 3;
    private static final int FAN = 4;
    private static final int DRIVE = 5;
    private static final int TEMPSENSOR = 6;
    private static final int VOLUME = 7;
    private static final int MIDPLANE = 8;
    private static final int FIBREPORT = 9;
    private static final int BATTERY = 10;
    private static final int LUN = 11;
    private static final int NUM_6120_UNIT_DRIVES = 14;
    private static final int DEFAULT_BLOCK_SIZE = 512;
    private static final String DATA_OK = "OK";
    private static final String DATA_STALE = "STALE";
    private static final String DATA_MISSING = "MISSING";
    private static final String TAG = "t4";
    public static final String sccs_id = "@(#)SERackReportGenerator.java\t1.0 05/09/02 SMI";

    public T4ReportGenerator(Properties properties) {
        this.props = properties;
        this.ip = this.props.getProperty("ip");
        this.systemName = this.props.getProperty("name");
    }

    public String generateReport() {
        DeviceClass deviceClass = null;
        this.ip = this.props.getProperty("ip");
        this.system = this.collectOutOfBandData();
        this.ibData = this.collectInBandData();
        if (this.system != null) {
            deviceClass = this.createNewReport();
        } else {
            deviceClass = ReportHandler.retrieveDeviceClasses((String)this.systemName, (String)TAG);
            if (deviceClass != null) {
                if (this.ibData != null) {
                    this.updateReport(deviceClass);
                } else {
                    deviceClass.setProperty("ReturnCode", REPORT_FAIL);
                }
            } else if (this.ibData != null) {
                deviceClass = this.createIBOnlyReport();
            } else {
                String string = "<report ReturnCode=\"FAILURE\">\n<exception Reason=\"Lost Comm\">No OOB or IB data available</exception>\n</report>\n";
                return string;
            }
        }
        this.system = null;
        this.ibData = null;
        return deviceClass.toXML();
    }

    public T3TokenList collectOutOfBandData() {
        T3TokenList t3TokenList = null;
        try {
            t3TokenList = this.getTokenList();
        }
        catch (T3Exception t3Exception) {
            Report.warning.log((Object)("Error geting oob data: " + t3Exception));
        }
        return t3TokenList;
    }

    private T3TokenList getTokenList() throws T3Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ip != null) {
            Object[] objectArray;
            T3HttpConnection t3HttpConnection = new T3HttpConnection(this.ip);
            int n = 0;
            while (n < this.pages.length) {
                t3HttpConnection.setPath(this.pages[n]);
                objectArray = t3HttpConnection.get();
                if (objectArray.length() == 0) {
                    Report.warning.log((Object)("Could not access " + this.pages[n]));
                }
                stringBuffer.append((String)objectArray);
                ++n;
            }
            if (stringBuffer.length() == 0) {
                objectArray = new Object[]{this.systemName};
                throw new T3Exception("t4.exception.noData", objectArray);
            }
        } else {
            Report.warning.log((Object)("No IP address for " + this.systemName));
            Object[] objectArray = new Object[]{this.systemName};
            throw new T3Exception("t4.exception.nullIP", objectArray);
        }
        return new T3TokenList(stringBuffer.toString());
    }

    private ArrayList collectInBandData() {
        ArrayList<DeviceClass> arrayList = null;
        String string = this.props.getProperty("name.ib");
        if (string == null) {
            string = this.props.getProperty("name");
        }
        if (string != null) {
            AgentStore agentStore = new AgentStore();
            Iterator iterator = agentStore.getTarget(string);
            if (iterator.hasNext()) {
                arrayList = new ArrayList<DeviceClass>();
                while (iterator.hasNext()) {
                    DeviceClass deviceClass = (DeviceClass)iterator.next();
                    arrayList.add(deviceClass);
                }
            }
        } else {
            Report.debug.log((Object)("No in band data since in band name is null for: " + this.systemName));
        }
        return arrayList;
    }

    private DeviceClass createNewReport() {
        int n;
        DeviceClass deviceClass;
        String string;
        T3Token t3Token;
        Object object;
        DeviceClass deviceClass2 = new DeviceClass();
        deviceClass2.setClassName("report");
        deviceClass2.setProperty("ReturnCode", "OK");
        deviceClass2.setProperty("OOB_DATA", "OK");
        if (this.ibData != null) {
            deviceClass2.setProperty("IB_DATA", "OK");
        } else {
            deviceClass2.setProperty("IB_DATA", DATA_MISSING);
        }
        DeviceClass deviceClass3 = deviceClass2.newSubInstance();
        deviceClass3.setClassName("model");
        deviceClass3.setProperty("schema", "CIM2.5");
        deviceClass3.setProperty("view", "system");
        deviceClass3.setProperty("type", "array");
        deviceClass3.setProperty("prefix", "StorEdgeArray");
        deviceClass3.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass4 = deviceClass3.newSubInstance();
        deviceClass4.setClassName("SystemView");
        try {
            this.unitCount = this.system.getIntValue("unitCount");
        }
        catch (T3Exception t3Exception) {
            this.unitCount = 0;
        }
        int n2 = 0;
        try {
            n2 = this.system.getIntValue("volCount");
        }
        catch (T3Exception t3Exception) {
            // empty catch block
        }
        DeviceClass deviceClass5 = deviceClass4.newSubInstance();
        this.resolveCluster(deviceClass5);
        String string2 = null;
        int n3 = 1;
        while (n3 <= this.unitCount) {
            DeviceClass deviceClass6;
            DeviceClass deviceClass7;
            DeviceClass deviceClass8;
            DeviceClass deviceClass9;
            object = deviceClass5.newSubInstance();
            this.resolveUnitaryComputerSystem((DeviceClass)object, n3);
            string2 = "u" + n3 + "ctr";
            t3Token = object.newSubInstance();
            this.resolveSCSIController((DeviceClass)t3Token, n3, string2);
            this.addPhysicalClasses((DeviceClass)t3Token, string2);
            string = t3Token.newSubInstance();
            this.resolveTemperatureSensor((DeviceClass)string, n3, string2, "Ctlr");
            deviceClass = object.newSubInstance();
            this.resolveFibrePort(deviceClass, n3, "u" + n3 + "p1");
            int n4 = 1;
            while (n4 <= 14) {
                string2 = "u" + n3 + "d" + (n4 < 10 ? UNAVAILABLE_INTEGER + n4 : Integer.toString(n4));
                DeviceClass deviceClass10 = object.newSubInstance();
                this.resolveDiskDrive(deviceClass10, n3, string2);
                this.addPhysicalClasses(deviceClass10, string2);
                deviceClass9 = deviceClass10.newSubInstance();
                this.resolveTemperatureSensor(deviceClass9, n3, string2, "Disk");
                ++n4;
            }
            n = 1;
            while (n <= 2) {
                string2 = "u" + n3 + "pcu" + n;
                deviceClass9 = object.newSubInstance();
                this.resolvePowerSupply(deviceClass9, n3, string2);
                this.addPhysicalClasses(deviceClass9, string2);
                deviceClass8 = deviceClass9.newSubInstance();
                this.resolveSensor(deviceClass8, n3, string2, "Power");
                deviceClass7 = deviceClass9.newSubInstance();
                this.resolveFan(deviceClass7, string2, 1);
                deviceClass6 = deviceClass9.newSubInstance();
                this.resolveFan(deviceClass6, string2, 2);
                DeviceClass deviceClass11 = deviceClass9.newSubInstance();
                this.resolveRedundancyGroup(deviceClass11, n3, 4, n);
                DeviceClass deviceClass12 = object.newSubInstance();
                this.resolveBattery(deviceClass12, n3, string2);
                this.addBatteryPhysicalClasses(deviceClass12, string2);
                ++n;
            }
            int n5 = 1;
            while (n5 <= 2) {
                string2 = "u" + n3 + "l" + n5;
                deviceClass8 = object.newSubInstance();
                this.resolveLoopController(deviceClass8, n3, string2);
                this.addCardPhysicalClasses(deviceClass8, n3, string2);
                deviceClass7 = deviceClass8.newSubInstance();
                this.resolveTemperatureSensor(deviceClass7, n3, string2, "Loop");
                ++n5;
            }
            string2 = "u" + n3 + "mpn";
            deviceClass8 = object.newSubInstance();
            this.resolveMidplane(deviceClass8, n3, string2);
            this.addCardPhysicalClasses(deviceClass8, n3, string2);
            deviceClass7 = object.newSubInstance();
            this.resolveRedundancyGroup(deviceClass7, n3, 2, 0);
            deviceClass6 = object.newSubInstance();
            this.resolveRedundancyGroup(deviceClass6, n3, 3, 0);
            ++n3;
        }
        object = this.system.findTokensWithKey("volStatus").iterator();
        while (object.hasNext()) {
            t3Token = (T3Token)object.next();
            string = t3Token.getPropertyValue();
            if (string == null || string.equals("deleted")) continue;
            string2 = t3Token.getElementID();
            deviceClass = deviceClass5.newSubInstance();
            this.resolveStorageVolume(deviceClass, string2);
            DeviceClass deviceClass13 = deviceClass.newSubInstance();
            this.resolveVolumeStatisticalInformation(deviceClass13, string2);
            this.resolveStorageRedundancyGroup(deviceClass, string2);
            n = 0;
            try {
                n = this.system.getIntValue(string2, "volSlicingCount");
            }
            catch (T3Exception t3Exception) {
                // empty catch block
            }
            if (n > 0) {
                int n6 = 0;
                while (n6 < n) {
                    this.resolveLogicalDisk(deviceClass5.newSubInstance(), string2, n6);
                    ++n6;
                }
                continue;
            }
            this.resolveLogicalDisk(deviceClass5.newSubInstance(), string2);
        }
        int n7 = 0;
        try {
            n7 = this.system.getIntValue("fruCtlrCount");
        }
        catch (T3Exception t3Exception) {
            // empty catch block
        }
        if (n7 > 1) {
            string = deviceClass5.newSubInstance();
            this.resolveRedundancyGroup((DeviceClass)string, 1, 1, n7);
        }
        int n8 = 1;
        while (n8 <= this.unitCount) {
            deviceClass = deviceClass4.newSubInstance();
            this.resolveRedundancyAssociation(deviceClass, n8, PCU_TYPE_NAME, 0);
            DeviceClass deviceClass14 = deviceClass4.newSubInstance();
            this.resolveRedundancyAssociation(deviceClass14, n8, FAN_TYPE_NAME, 1);
            DeviceClass deviceClass15 = deviceClass4.newSubInstance();
            this.resolveRedundancyAssociation(deviceClass15, n8, FAN_TYPE_NAME, 2);
            DeviceClass deviceClass16 = deviceClass4.newSubInstance();
            this.resolveRedundancyAssociation(deviceClass16, n8, LOOP_TYPE_NAME, 0);
            ++n8;
        }
        this.resolveVolumeRedundancyAssociation(deviceClass4);
        deviceClass = deviceClass5.newSubInstance();
        this.resolveSystemStatisticalInformation(deviceClass);
        return deviceClass2;
    }

    private void updateReport(DeviceClass deviceClass) {
        Object object;
        DeviceClass deviceClass2;
        Object object2;
        deviceClass.setProperty("IB_DATA", "OK");
        DeviceClass deviceClass3 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"CreationClassName", (String)"StorEdgeArray_Cluster");
        String string = deviceClass.getProperty("OOB_DATA");
        if ("OK".equals(string)) {
            deviceClass.setProperty("OOB_DATA", DATA_STALE);
            ReportTools.xmlAttr((DeviceClass)deviceClass3, (String)"Status", (String)"Lost Comm");
        }
        ArrayList arrayList = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"FCPTARGET.ASSET", (String)"PortWWN");
        int n = 0;
        while (n < arrayList.size()) {
            object2 = (DeviceClass)arrayList.get(n);
            String string2 = object2.getProperty("PortWWN");
            if (string2 != null) {
                deviceClass2 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"DeviceID", (String)string2);
                if (deviceClass2 != null) {
                    this.updateFibrePort(deviceClass2, (DeviceClass)object2);
                } else {
                    object = deviceClass3.newSubInstance();
                    this.resolveIBOnlyFibrePort((DeviceClass)object, (DeviceClass)object2);
                }
            }
            ++n;
        }
        object2 = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"LUN.ASSET", (String)"LUID");
        int n2 = 0;
        while (n2 < ((ArrayList)object2).size()) {
            deviceClass2 = (DeviceClass)((ArrayList)object2).get(n2);
            object = deviceClass2.getProperty("LUID");
            if (object != null) {
                DeviceClass deviceClass4 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"DeviceID", (String)(object = ((String)object).toUpperCase()));
                if (deviceClass4 != null) {
                    this.updateLogicalDisk(deviceClass4, deviceClass2);
                } else {
                    DeviceClass deviceClass5 = deviceClass3.newSubInstance();
                    this.resolveIBOnlyLogicalDisk(deviceClass5, deviceClass2);
                }
            }
            ++n2;
        }
    }

    private DeviceClass createIBOnlyReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        deviceClass.setProperty("OOB_DATA", DATA_MISSING);
        deviceClass.setProperty("IB_DATA", "OK");
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("model");
        deviceClass2.setProperty("schema", "CIM2.5");
        deviceClass2.setProperty("view", "system");
        deviceClass2.setProperty("type", "array");
        deviceClass2.setProperty("prefix", "StorEdgeArray");
        deviceClass2.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass3 = deviceClass2.newSubInstance();
        deviceClass3.setClassName("SystemView");
        ArrayList arrayList = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"FCPTARGET.ASSET", (String)"PortWWN");
        ArrayList arrayList2 = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"LUN.ASSET", (String)"LUID");
        DeviceClass deviceClass4 = deviceClass3.newSubInstance();
        this.resolveShortCluster(deviceClass4, arrayList.size(), arrayList2.size());
        int n = 0;
        while (n < arrayList.size()) {
            DeviceClass deviceClass5 = (DeviceClass)arrayList.get(n);
            this.resolveIBOnlyFibrePort(deviceClass4.newSubInstance(), deviceClass5);
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            DeviceClass deviceClass6 = (DeviceClass)arrayList2.get(n2);
            this.resolveIBOnlyLogicalDisk(deviceClass4.newSubInstance(), deviceClass6);
            ++n2;
        }
        return deviceClass;
    }

    private void addPhysicalClasses(DeviceClass deviceClass, String string) {
        if (this.isInstalled(deviceClass)) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            this.resolvePhysicalPackage(deviceClass2, string);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            this.resolveSlot(deviceClass3, string);
            DeviceClass deviceClass4 = deviceClass2.newSubInstance();
            this.resolveFRU(deviceClass4, string);
            DeviceClass deviceClass5 = deviceClass2.newSubInstance();
            this.resolveLocation(deviceClass5, string);
        }
    }

    private void addCardPhysicalClasses(DeviceClass deviceClass, int n, String string) {
        if (this.isInstalled(deviceClass)) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            this.resolveCard(deviceClass2, string);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            this.resolveSlot(deviceClass3, string);
            DeviceClass deviceClass4 = deviceClass2.newSubInstance();
            this.resolveFRU(deviceClass4, string);
            DeviceClass deviceClass5 = deviceClass2.newSubInstance();
            this.resolveLocation(deviceClass5, string);
        }
    }

    private void addBatteryPhysicalClasses(DeviceClass deviceClass, String string) {
        if (this.isInstalled(deviceClass)) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            this.resolveBatteryPhysicalPackage(deviceClass2, string);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            this.resolveBatterySlot(deviceClass3, string);
            DeviceClass deviceClass4 = deviceClass2.newSubInstance();
            this.resolveBatteryFRU(deviceClass4, string);
            DeviceClass deviceClass5 = deviceClass2.newSubInstance();
            this.resolveLocation(deviceClass5, string);
        }
    }

    private boolean isInstalled(DeviceClass deviceClass) {
        boolean bl = true;
        String string = deviceClass.getProperty("Availability");
        if ("11".equals(string)) {
            bl = false;
        }
        return bl;
    }

    private void xmlAttr(DeviceClass deviceClass, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        deviceClass.setProperty(string, string2);
    }

    private void xmlStringAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = BLANK;
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void xmlStringAttr(DeviceClass deviceClass, String string, String string2, String string3) {
        if (string2 == null) {
            string2 = string3 != null ? string3 : BLANK;
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void xmlIntAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = UNAVAILABLE_INTEGER;
        } else {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = UNAVAILABLE_INTEGER;
            }
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void xmlFloatAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = UNAVAILABLE_FLOAT;
        } else {
            try {
                Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = UNAVAILABLE_FLOAT;
            }
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void resolveCluster(DeviceClass deviceClass) {
        block3: {
            deviceClass.setClassName("Cluster");
            this.xmlAttr(deviceClass, "Name", this.systemName);
            this.xmlAttr(deviceClass, "Status", this.determineClusterStatus());
            this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Cluster");
            this.xmlAttr(deviceClass, "Description", "Sun StorEdge 6120 Array");
            this.xmlStringAttr(deviceClass, "InterconnectAddress", this.system.getStringValue("sysIpAddr"));
            this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.system.getStringValue("sysIpAddr"));
            this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
            this.xmlAttr(deviceClass, "StripeUnitSize", this.system.getStringValue("sysStripeUnitSize"));
            this.xmlAttr(deviceClass, "CacheMode", this.system.getStringValue("sysCacheMode"));
            this.xmlAttr(deviceClass, "CacheMirror", this.system.getStringValue("sysCacheMirror"));
            this.xmlAttr(deviceClass, "MpSupport", this.system.getStringValue("sysMpSupport"));
            this.xmlIntAttr(deviceClass, "ReadAhead", this.system.getStringValue("sysReadAhead"));
            this.xmlIntAttr(deviceClass, "ReconRate", this.system.getStringValue("sysReconRate"));
            this.xmlAttr(deviceClass, "SubNet", this.system.getStringValue("sysSubNet"));
            this.xmlAttr(deviceClass, "Gateway", this.system.getStringValue("sysGateway"));
            this.xmlAttr(deviceClass, "Loop1Split", this.system.getStringValue("sysLoop1Split"));
            this.xmlAttr(deviceClass, "User", "Not Specified");
            this.xmlIntAttr(deviceClass, "UnitCount", this.system.getStringValue("unitCount"));
            this.xmlIntAttr(deviceClass, "CtlrCount", this.system.getStringValue("fruCtlrCount"));
            this.xmlIntAttr(deviceClass, "MidplaneCount", this.system.getStringValue("fruMidplaneCount"));
            this.xmlIntAttr(deviceClass, "FruCount", this.system.getStringValue("fruCount"));
            this.xmlIntAttr(deviceClass, "PortCount", this.system.getStringValue("portCount"));
            this.xmlIntAttr(deviceClass, "FibrePortCount", this.system.getStringValue("portFibreCount"));
            this.xmlIntAttr(deviceClass, "LoopCount", this.system.getStringValue("fruLoopCount"));
            this.xmlIntAttr(deviceClass, "PowerCount", this.system.getStringValue("fruPowerCount"));
            this.xmlIntAttr(deviceClass, "DiskCount", this.system.getStringValue("fruDiskCount"));
            String string = this.system.getStringValue("sysRarpEnabled");
            string = "yes".equalsIgnoreCase(string) ? "true" : "false";
            this.xmlAttr(deviceClass, "RarpEnabled", string);
            String string2 = this.system.getStringValue("volCount");
            this.xmlAttr(deviceClass, "VolumeCount", string2);
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.xmlAttr(deviceClass, "HasVolumes", "true");
                    break block3;
                }
                this.xmlAttr(deviceClass, "HasVolumes", "false");
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void resolveShortCluster(DeviceClass deviceClass, int n, int n2) {
        deviceClass.setClassName("Cluster");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Description", "Sun StorEdge 6120 Array");
        this.xmlStringAttr(deviceClass, "InterconnectAddress", this.ip);
        this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.ip);
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlIntAttr(deviceClass, "PortCount", BLANK + n);
        this.xmlIntAttr(deviceClass, "FibrePortCount", BLANK + n);
        if (n > 0) {
            this.xmlIntAttr(deviceClass, "CtlrCount", BLANK + n);
        }
        if (n2 > 0) {
            this.xmlAttr(deviceClass, "HasVolumes", "true");
        } else {
            this.xmlAttr(deviceClass, "HasVolumes", "false");
        }
        this.xmlAttr(deviceClass, "Loop1Split", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "User", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "UnitCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "MidplaneCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "FruCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "LoopCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "PowerCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "VolumeCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "DiskCount", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "CacheMode", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "CacheMirror", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "MpSupport", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReconRate", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "StripeUnitSize", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "RarpEnabled", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReadAhead", UNAVAILABLE_INTEGER);
    }

    private void updateCluster(DeviceClass deviceClass, int n, int n2) {
        deviceClass.setClassName("Cluster");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "Status", "Lost Comm");
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Description", "Sun StorEdge 6120 Array");
        this.xmlStringAttr(deviceClass, "InterconnectAddress", this.ip, NOT_AVAILABLE_INBAND);
        this.xmlStringAttr(deviceClass, "OtherIdentifyingInfo", this.ip);
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlIntAttr(deviceClass, "PortCount", BLANK + n);
        this.xmlIntAttr(deviceClass, "FibrePortCount", BLANK + n);
        if (n > 0) {
            this.xmlIntAttr(deviceClass, "CtlrCount", BLANK + n);
        }
        if (n2 > 0) {
            this.xmlAttr(deviceClass, "HasVolumes", "true");
        } else {
            this.xmlAttr(deviceClass, "HasVolumes", "false");
        }
        this.xmlAttr(deviceClass, "Loop1Split", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "User", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "UnitCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "MidplaneCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "FruCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "LoopCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "PowerCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "VolumeCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "DiskCount", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "CacheMode", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "CacheMirror", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "MpSupport", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReconRate", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "StripeUnitSize", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "RarpEnabled", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReadAhead", UNAVAILABLE_INTEGER);
    }

    private void resolveSystemStatisticalInformation(DeviceClass deviceClass) {
        deviceClass.setClassName("SystemStatisticalInformation");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_SystemStatisticalInformation");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlIntAttr(deviceClass, "TotalRequests", this.system.getStringValue("sysTotalRequests"));
        this.xmlIntAttr(deviceClass, "WriteRequests", this.system.getStringValue("sysWriteRequests"));
        this.xmlIntAttr(deviceClass, "ReadRequests", this.system.getStringValue("sysReadRequests"));
        this.xmlIntAttr(deviceClass, "TotalBlocks", this.system.getStringValue("sysTotalBlocks"));
        this.xmlIntAttr(deviceClass, "BlocksWritten", this.system.getStringValue("sysBlocksWritten"));
        this.xmlIntAttr(deviceClass, "BlocksRead", this.system.getStringValue("sysBlocksRead"));
        this.xmlIntAttr(deviceClass, "CacheWriteHits", this.system.getStringValue("sysCacheWriteHits"));
        this.xmlIntAttr(deviceClass, "CacheWriteMisses", this.system.getStringValue("sysCacheWriteMisses"));
        this.xmlIntAttr(deviceClass, "CacheReadHits", this.system.getStringValue("sysCacheReadHits"));
        this.xmlIntAttr(deviceClass, "CacheReadMisses", this.system.getStringValue("sysCacheReadMisses"));
        this.xmlIntAttr(deviceClass, "CacheRmwFlushes", this.system.getStringValue("sysCacheRmwFlushes"));
        this.xmlIntAttr(deviceClass, "CacheReconFlushes", this.system.getStringValue("sysCacheReconFlushes"));
        this.xmlIntAttr(deviceClass, "CacheStripeFlushes", this.system.getStringValue("sysCacheStripeFlushes"));
        this.xmlFloatAttr(deviceClass, "SecTotalRequests", this.system.getStringValue("sysSecTotalRequests"));
        this.xmlFloatAttr(deviceClass, "SecWriteRequests", this.system.getStringValue("sysSecWriteRequests"));
        this.xmlFloatAttr(deviceClass, "SecReadRequests", this.system.getStringValue("sysSecReadRequests"));
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", this.system.getStringValue("sysSecTotalMBytes"));
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", this.system.getStringValue("sysSecMBytesWritten"));
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", this.system.getStringValue("sysSecMBytesRead"));
        this.xmlStringAttr(deviceClass, "LastRestart", this.system.getStringValue("sysLastRestart"));
    }

    private void resolveUnitaryComputerSystem(DeviceClass deviceClass, int n) {
        deviceClass.setClassName("UnitaryComputerSystem");
        this.xmlAttr(deviceClass, "Name", "unit" + n);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_UnitaryComputerSystem");
        this.xmlAttr(deviceClass, "Status", "OK");
        this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.system.getStringValue("sysIpAddr"));
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlAttr(deviceClass, "UnitIndex", Integer.toString(n));
        this.xmlAttr(deviceClass, "UnitType", this.system.getStringValue("u" + n, "unitType"));
        String string = this.system.getStringValue("u" + n, "unitStandby");
        String string2 = "false";
        if ("yes".equalsIgnoreCase(string)) {
            string2 = "true";
        }
        this.xmlAttr(deviceClass, "IsStandBy", string2);
    }

    private void resolveShortUnitaryComputerSystem(DeviceClass deviceClass, int n) {
        deviceClass.setClassName("UnitaryComputerSystem");
        this.xmlAttr(deviceClass, "Name", "unit" + n);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_UnitaryComputerSystem");
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.ip);
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlAttr(deviceClass, "UnitIndex", Integer.toString(n));
    }

    private void addLogicalDeviceInternals(DeviceClass deviceClass, String string, int n) {
        String string2;
        String string3 = "fru";
        switch (n) {
            case 1: {
                string2 = "StorEdgeArray_SCSIController";
                break;
            }
            case 2: {
                string2 = "StorEdgeArray_UninterruptiblePowerSupply";
                break;
            }
            case 10: {
                string2 = "StorEdgeArray_Battery";
                break;
            }
            case 3: {
                string2 = "StorEdgeArray_LoopController";
                break;
            }
            case 5: {
                string2 = "StorEdgeArray_DiskDrive";
                break;
            }
            case 6: {
                string2 = "StorEdgeArray_TemperatureSensor";
                break;
            }
            case 8: {
                string2 = "StorEdgeArray_MidPlaneDevice";
                break;
            }
            case 7: {
                string2 = "StorEdgeArray_StorageVolume";
                string3 = "vol";
                break;
            }
            case 9: {
                string2 = "StorEdgeArray_FibrePort";
                string3 = "port";
                break;
            }
            case 11: {
                string2 = "StorEdgeArray_LogicalDisk";
                string3 = "lun";
                break;
            }
            default: {
                return;
            }
        }
        String string4 = this.system.getStringValue(string, string3 + "Status");
        String string5 = this.system.getStringValue(string, string3 + "State");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        if (n == 10) {
            this.xmlAttr(deviceClass, "DeviceID", string + "bat");
            this.xmlAttr(deviceClass, "Name", BATTERY_TYPE_NAME);
        } else if (n == 7) {
            this.xmlAttr(deviceClass, "DeviceID", string);
            this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, "volName"));
        } else if (n == 9) {
            String string6 = this.system.getStringValue(string, "portWWN");
            if (string6 != null) {
                this.xmlAttr(deviceClass, "DeviceID", string6);
            } else {
                this.xmlAttr(deviceClass, "DeviceID", string);
            }
            this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, "portType"));
        } else {
            this.xmlAttr(deviceClass, "DeviceID", string);
            this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, string3 + "Type"));
        }
        this.xmlAttr(deviceClass, "CreationClassName", string2);
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string4));
        if (n == 9) {
            this.xmlAttr(deviceClass, "StatusInfo", this.convertToCIMStatusInfo(string4));
        } else {
            this.xmlAttr(deviceClass, "StatusInfo", this.convertToCIMStatusInfo(string5));
        }
        if (n == 7 || n == 9 || n == 10) {
            this.xmlAttr(deviceClass, "Availability", this.convertToCIMAvailability(string4));
        } else {
            this.xmlAttr(deviceClass, "Availability", this.convertToCIMAvailability(string4, string5));
        }
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
    }

    private void resolveSCSIController(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("SCSIController");
        this.addLogicalDeviceInternals(deviceClass, string, 1);
        this.xmlAttr(deviceClass, "REF", string);
        this.xmlAttr(deviceClass, "Description", "6120 Controller");
        this.xmlStringAttr(deviceClass, "CtlrRole", this.system.getStringValue(string, "fruCtlrRole"));
        String string2 = this.system.getStringValue(string, "fruCtlrPartnerId");
        this.xmlStringAttr(deviceClass, "CtlrPartnerId", string2, "None Defined");
        this.xmlStringAttr(deviceClass, "CtlrCpuDesc", this.system.getStringValue(string, "fruCtlrCpuDesc"));
        this.xmlAttr(deviceClass, "IsExpendable", this.system.getStringValue(string, "fruCtlrIsExpendable"));
        int n2 = 0;
        try {
            n2 = this.system.getIntValue(string, "fruCtlrConsoleBaud");
        }
        catch (T3Exception t3Exception) {
            // empty catch block
        }
        this.xmlAttr(deviceClass, "CtlrConsoleBaud", BLANK + n2);
    }

    private void resolveFibrePort(DeviceClass deviceClass, int n, String string) {
        DeviceClass deviceClass2;
        deviceClass.setClassName("FibrePort");
        this.addLogicalDeviceInternals(deviceClass, string, 9);
        this.xmlAttr(deviceClass, "Description", "Controller Embedded Fibre Channel Port");
        this.xmlAttr(deviceClass, "PortIndex", UNAVAILABLE_INTEGER);
        String string2 = this.system.getStringValue(string, "portWWN");
        this.xmlAttr(deviceClass, "PortWWN", string2);
        this.xmlAttr(deviceClass, "PortFruID", "u" + n + "ctr");
        this.xmlAttr(deviceClass, "CurrentPortType", UNAVAILABLE_INTEGER);
        String string3 = ReportTools.convertToLogicalString((String)this.system.getStringValue(string, "portSunHost"));
        this.xmlAttr(deviceClass, "SunHost", string3);
        this.xmlAttr(deviceClass, "FibreAlpaMode", this.system.getStringValue(string, "portFibreAlpaMode"));
        this.xmlIntAttr(deviceClass, "FibreAlpa", this.system.getStringValue(string, "portFibreAlpa"));
        this.xmlIntAttr(deviceClass, "TotalRequests", this.system.getStringValue(string, "portTotalRequests"));
        this.xmlIntAttr(deviceClass, "WriteRequests", this.system.getStringValue(string, "portWriteRequests"));
        this.xmlIntAttr(deviceClass, "ReadRequests", this.system.getStringValue(string, "portReadRequests"));
        this.xmlIntAttr(deviceClass, "BlocksWritten", this.system.getStringValue(string, "portBlocksWritten"));
        this.xmlIntAttr(deviceClass, "BlocksRead", this.system.getStringValue(string, "portBlocksRead"));
        this.xmlIntAttr(deviceClass, "TotalBlocks", this.system.getStringValue(string, "portTotalBlocks"));
        String string4 = this.system.getStringValue(string, "portSecTotalRequests");
        this.xmlIntAttr(deviceClass, "SecTotalRequests", ReportTools.truncate((String)string4));
        string4 = this.system.getStringValue(string, "portSecWriteRequests");
        this.xmlIntAttr(deviceClass, "SecWriteRequests", ReportTools.truncate((String)string4));
        string4 = this.system.getStringValue(string, "portSecReadRequests");
        this.xmlIntAttr(deviceClass, "SecReadRequests", ReportTools.truncate((String)string4));
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", this.system.getStringValue(string, "portSecTotalMBytes"));
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", this.system.getStringValue(string, "portSecMBytesWritten"));
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", this.system.getStringValue(string, "portSecMBytesRead"));
        this.xmlAttr(deviceClass, "AttachVolName0", this.system.getStringValue(string + "-a0", "attachVolName"));
        this.xmlAttr(deviceClass, "AttachVolOwner0", this.system.getStringValue(string + "-a0", "attachVolOwner"));
        this.xmlAttr(deviceClass, "AttachVolName1", this.system.getStringValue(string + "-a1", "attachVolName"));
        this.xmlAttr(deviceClass, "AttachVolOwner1", this.system.getStringValue(string + "-a1", "attachVolOwner"));
        int n2 = 2;
        String string5 = "unitId" + (n - 1) + "lnkstatIndex" + n2 + "Ctrl" + n + "Loop" + n2;
        this.xmlAttr(deviceClass, "LossOfSignalCounter", this.system.getStringValue(string5, "LossSignalCnt"));
        this.xmlAttr(deviceClass, "LossOfSyncCounter", this.system.getStringValue(string5, "LossSyncCnt"));
        this.xmlAttr(deviceClass, "InvalidTransmissionWords", this.system.getStringValue(string5, "InvTxWord"));
        this.xmlAttr(deviceClass, "CRCErrors", this.system.getStringValue(string5, "InvCRCCnt"));
        DeviceClass deviceClass3 = deviceClass.newSubInstance();
        deviceClass3.setClassName("ProtocolEndpoint");
        this.xmlAttr(deviceClass3, "Name", BLANK + this.system.getStringValue(string, "portWWN"));
        this.xmlAttr(deviceClass3, "NameFormat", "WWN");
        this.xmlAttr(deviceClass3, "ProtocolType", "Fibre Channel");
        if (this.ibData != null && (deviceClass2 = ReportTools.findPort((ArrayList)this.ibData, (String)string2)) != null) {
            DeviceClass deviceClass4;
            String string6 = deviceClass2.getProperty("PortType");
            this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string6));
            String string7 = deviceClass2.getProperty("PortSupportedSpeed");
            this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string7));
            String string8 = deviceClass2.getProperty("PortSpeed");
            this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string8));
            String string9 = deviceClass2.getProperty("FabricName");
            if (NO_FABRIC_NAME.equals(string9) && (deviceClass4 = deviceClass2.getParent()) != null) {
                DeviceClass deviceClass5 = deviceClass3.newSubInstance();
                deviceClass5.setClassName("ProtocolEndpoint");
                this.xmlAttr(deviceClass5, "Name", deviceClass4.getProperty("portWWN"));
                this.xmlAttr(deviceClass5, "NameFormat", "WWN");
                this.xmlAttr(deviceClass5, "ProtocolType", "Fibre Channel");
            }
        }
    }

    private void resolveIBOnlyFibrePort(DeviceClass deviceClass, DeviceClass deviceClass2) {
        DeviceClass deviceClass3;
        deviceClass.setClassName("FibrePort");
        this.xmlAttr(deviceClass, "Description", "Controller Embedded Fibre Channel Port");
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_FibrePort");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
        String string = deviceClass2.getProperty("PortFcID");
        String string2 = deviceClass2.getProperty("PortWWN");
        String string3 = deviceClass2.getProperty("PortState");
        String string4 = deviceClass2.getProperty("PortType");
        String string5 = deviceClass2.getProperty("PortSpeed");
        String string6 = deviceClass2.getProperty("PortSupportedSpeed");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "PortWWN", string2);
        this.xmlAttr(deviceClass, "Status", RHBAConverter.derivePortStatus((String)string3));
        this.xmlAttr(deviceClass, "State", RHBAConverter.derivePortState((String)string3));
        this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string4));
        this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string5));
        this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string6));
        this.xmlAttr(deviceClass, "PortIndex", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "PortFruID", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "SunHost", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "FibreAlpaMode", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "FibreAlpa", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "TotalRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "WriteRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "ReadRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "BlocksWritten", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "BlocksRead", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "TotalBlocks", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "SecTotalRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "SecWriteRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "SecReadRequests", UNAVAILABLE_INTEGER);
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", UNAVAILABLE_FLOAT);
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", UNAVAILABLE_FLOAT);
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", UNAVAILABLE_FLOAT);
        this.xmlAttr(deviceClass, "AttachVolOwner0", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "AttachVolOwner1", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "AttachVolName0", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "AttachVolName1", NOT_AVAILABLE_INBAND);
        DeviceClass deviceClass4 = deviceClass.newSubInstance();
        deviceClass4.setClassName("ProtocolEndpoint");
        this.xmlAttr(deviceClass4, "Name", string2);
        this.xmlAttr(deviceClass4, "NameFormat", "WWN");
        this.xmlAttr(deviceClass4, "ProtocolType", "Fibre Channel");
        String string7 = deviceClass2.getProperty("FabricName");
        if (NO_FABRIC_NAME.equals(string7) && (deviceClass3 = deviceClass2.getParent()) != null) {
            DeviceClass deviceClass5 = deviceClass4.newSubInstance();
            deviceClass5.setClassName("ProtocolEndpoint");
            this.xmlAttr(deviceClass5, "Name", deviceClass3.getProperty("portWWN"));
            this.xmlAttr(deviceClass5, "NameFormat", "WWN");
            this.xmlAttr(deviceClass5, "ProtocolType", "Fibre Channel");
        }
    }

    private void updateFibrePort(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = deviceClass2.getProperty("PortState");
        String string2 = deviceClass2.getProperty("PortType");
        String string3 = deviceClass2.getProperty("PortSpeed");
        String string4 = deviceClass2.getProperty("PortSupportedSpeed");
        this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string2));
        this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string4));
        this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string3));
        this.xmlAttr(deviceClass, "Status", RHBAConverter.derivePortStatus((String)string));
        this.xmlAttr(deviceClass, "Availability", RHBAConverter.derivePortAvailability((String)string));
    }

    private void resolveMidplane(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("LogicalDevice");
        this.addLogicalDeviceInternals(deviceClass, string, 8);
        this.xmlAttr(deviceClass, "Description", "6120 Midplane");
    }

    private void resolveLoopController(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("Controller");
        this.addLogicalDeviceInternals(deviceClass, string, 3);
        this.xmlAttr(deviceClass, "REF", string);
        this.xmlAttr(deviceClass, "LoopMode", this.system.getStringValue(string, "fruLoopMode"));
        this.xmlAttr(deviceClass, "LoopCable1State", this.system.getStringValue(string, "fruLoopCable1State"));
        this.xmlAttr(deviceClass, "LoopCable2State", this.system.getStringValue(string, "fruLoopCable2State"));
        this.xmlAttr(deviceClass, "Description", "6120 LoopController");
    }

    private void resolveDiskDrive(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("DiskDrive");
        this.addLogicalDeviceInternals(deviceClass, string, 5);
        this.xmlAttr(deviceClass, "REF", string);
        String string2 = this.system.getStringValue(string, "fruDiskStatusCode");
        if (string2 != null) {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "10";
            }
        } else {
            string2 = "10";
        }
        this.xmlAttr(deviceClass, "LastErrorCode", string2);
        this.xmlAttr(deviceClass, "ErrorDescription", BLANK + this.setDiskErrorDescription(string2));
        String string3 = this.system.getStringValue(string, "fruErrors");
        String string4 = "false";
        if (UNAVAILABLE_INTEGER.equals(string3)) {
            string4 = "true";
        }
        this.xmlAttr(deviceClass, "ErrorCleared", string4);
        this.xmlAttr(deviceClass, "NeedsCleaning", "false");
        this.xmlAttr(deviceClass, "Description", "6120 DiskDrive");
        this.xmlAttr(deviceClass, "NumberOfMediaSupported", "1");
        String string5 = this.system.getStringValue(string, "fruDiskCapacity");
        if (string5 != null) {
            this.xmlAttr(deviceClass, "MaxMediaSize", ReportTools.truncate((String)string5));
        }
        this.xmlAttr(deviceClass, "DiskPort1State", BLANK + this.system.getStringValue(string, "fruDiskPort1State"));
        this.xmlAttr(deviceClass, "DiskPort2State", BLANK + this.system.getStringValue(string, "fruDiskPort2State"));
        String string6 = this.system.getStringValue(string, "fruDiskRole");
        this.xmlAttr(deviceClass, "DiskRole", string6);
        String string7 = this.system.getStringValue(string, "fruDiskVolId");
        String string8 = this.system.getStringValue(string, "fruDiskVolIndex");
        String string9 = this.system.getStringValue(string, "fruDiskVolName");
        if (string7 != null && string6 != null && ("dataDisk".equals(string6) || "standbyDisk".equals(string6))) {
            this.xmlAttr(deviceClass, "VolId", string7);
            this.xmlIntAttr(deviceClass, "VolIndex", string8);
            this.xmlAttr(deviceClass, "VolName", string9);
        }
        String string10 = this.system.getStringValue(string, "fruDiskIsExpendable");
        String string11 = "true";
        if ("no".equalsIgnoreCase(string10)) {
            string11 = "false";
        }
        this.xmlAttr(deviceClass, "IsExpendable", string11);
        string10 = this.system.getStringValue(string, "fruDiskIsRebuildable");
        string11 = "true";
        if ("no".equalsIgnoreCase(string10)) {
            string11 = "false";
        }
        this.xmlAttr(deviceClass, "IsRebuildable", string11);
    }

    private String setDiskErrorDescription(String string) {
        String string2 = "No description";
        try {
            if (string.equals(UNAVAILABLE_INTEGER)) {
                string2 = "Good drive, good sys area";
            } else if (string.equals("2")) {
                string2 = "Unable to open the drive";
            } else if (string.equals("3")) {
                string2 = "Good drive, but not in any volume";
            } else if (string.equals("4")) {
                string2 = "Temporary state of drive before disable occurs";
            } else if (string.equals("7")) {
                string2 = "Drive is good, but has a bad sys area";
            } else if (string.equals("9")) {
                string2 = "Drive is bypassed or does not exist";
            } else if (string.equals("10")) {
                string2 = "No description available";
            }
        }
        catch (NullPointerException nullPointerException) {}
        return string2;
    }

    private void resolveStorageVolume(DeviceClass deviceClass, String string) {
        String string2;
        deviceClass.setClassName("StorageVolume");
        this.addLogicalDeviceInternals(deviceClass, string, 7);
        this.xmlAttr(deviceClass, "REF", string);
        String string3 = this.system.getStringValue(string, "volRaidLevel");
        if (string3.equalsIgnoreCase("raid0")) {
            string3 = "raid0";
            string2 = "false";
        } else if (string3.equalsIgnoreCase("raid1")) {
            string3 = "raid1";
            string2 = "true";
        } else if (string3.equalsIgnoreCase("raid5")) {
            string3 = "raid5";
            string2 = "true";
        } else {
            string3 = null;
            string2 = null;
        }
        this.xmlAttr(deviceClass, "MountStatus", this.system.getStringValue(string, "volStatus"));
        this.xmlAttr(deviceClass, "RaidLevel", string3);
        this.xmlAttr(deviceClass, "IsBasedOnUnderlyingRedundancy", string2);
        this.xmlAttr(deviceClass, "CacheMode", this.system.getStringValue(string, "volCacheMode"));
        this.xmlAttr(deviceClass, "CacheMirror", this.system.getStringValue(string, "volCacheMirror"));
        this.xmlIntAttr(deviceClass, "OperProgress", this.system.getStringValue(string, "volOperProgress"));
        this.xmlAttr(deviceClass, "Oper", this.system.getStringValue(string, "volOper"));
        this.xmlIntAttr(deviceClass, "InitRate", this.system.getStringValue(string, "volInitRate"));
        this.xmlIntAttr(deviceClass, "VerifyRate", this.system.getStringValue(string, "volVerifyRate"));
        this.xmlIntAttr(deviceClass, "ArrayWidth", this.system.getStringValue(string, "volArrayWidth"));
        this.xmlAttr(deviceClass, "WWN", this.system.getStringValue(string, "volWWN"));
        this.xmlAttr(deviceClass, "Description", "Storage pool");
        String string4 = this.system.getStringValue(string, "volSubstitutedDisk");
        if (string4 == null || BLANK.equals(string4)) {
            string4 = NO_DISKS_SUBSTITUTED;
        }
        this.xmlAttr(deviceClass, "VolumeDiskSubstituted", string4);
        String string5 = this.system.getStringValue(string, "volDisabledDisk");
        if (string5 == null || BLANK.equals(string5)) {
            string5 = NO_DISKS_DISABLED;
        }
        this.xmlAttr(deviceClass, "VolumeDiskDisabled", string5);
    }

    private void resolveLogicalDisk(DeviceClass deviceClass, String string, int n) {
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "Description", "Logical partition of a storage pool");
        this.xmlAttr(deviceClass, "SourceVolume", string);
        String string2 = this.system.getStringValue(string + "-s" + n, "slice");
        if (string2 == null) {
            return;
        }
        this.xmlAttr(deviceClass, "NumberOfBlocks", this.system.getStringValue(string2, "volSliceSize"));
        this.xmlAttr(deviceClass, "BlockSize", "512");
        StringBuffer stringBuffer = new StringBuffer(string2);
        this.xmlAttr(deviceClass, "Name", stringBuffer.toString());
        stringBuffer.delete(0, 5);
        String string3 = "lun" + stringBuffer;
        String string4 = this.system.getStringValue(string2, "volSliceWWN");
        if (string4 != null) {
            string3 = string4.trim().length() == 40 ? string4.substring(8) : string4;
        }
        this.xmlAttr(deviceClass, "DeviceID", string3);
        this.xmlAttr(deviceClass, "REF", string3);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        try {
            n2 = this.system.getIntValue("sys", "lunMaskNumInitiators");
        }
        catch (T3Exception t3Exception) {
            // empty catch block
        }
        int n3 = 0;
        while (n3 < n2) {
            this.resolveInitiator(deviceClass, n3, string3);
            ++n3;
        }
    }

    private void resolveLogicalDisk(DeviceClass deviceClass, String string) {
        DeviceClass deviceClass2;
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "Description", "Logical partition of a volume");
        this.xmlAttr(deviceClass, "SourceVolume", string);
        this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, "volName"));
        String string2 = null;
        String string3 = this.system.getStringValue(string, "volWWN");
        string2 = string3 != null ? (string3.trim().length() == 40 ? string3.substring(8) : string3) : this.system.getStringValue(string, "volId");
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "REF", string2);
        this.xmlAttr(deviceClass, "BlockSize", "512");
        String string4 = this.system.getStringValue(string, "volCapacity");
        long l = ReportUtil.calculateBlockCount(string4, 512, this.systemName, string);
        this.xmlAttr(deviceClass, "NumberOfBlocks", BLANK + l);
        if (this.ibData != null && (deviceClass2 = ReportTools.findLun((ArrayList)this.ibData, (String)string2)) != null) {
            String string5 = deviceClass2.getProperty("BlockSize");
            String string6 = deviceClass2.getProperty("NumBlocks");
            this.xmlAttr(deviceClass, "NumberOfBlocks", string6);
            this.xmlAttr(deviceClass, "BlockSize", string5);
        }
    }

    private void resolveIBOnlyLogicalDisk(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_LogicalDisk");
        this.xmlAttr(deviceClass, "Description", "A Logical unit as presented to a host.");
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "SourceVolume", NOT_AVAILABLE_INBAND);
        String string = deviceClass2.getProperty("FcpLunId");
        String string2 = deviceClass2.getProperty("LUID");
        String string3 = deviceClass2.getProperty("BlockSize");
        String string4 = deviceClass2.getProperty("NumBlocks");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "DeviceID", string2.toUpperCase());
        this.xmlAttr(deviceClass, "NumberOfBlocks", string4);
        this.xmlAttr(deviceClass, "BlockSize", string3);
    }

    private void updateLogicalDisk(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = deviceClass2.getProperty("BlockSize");
        String string2 = deviceClass2.getProperty("NumBlocks");
        this.xmlAttr(deviceClass, "NumberOfBlocks", string2);
        this.xmlAttr(deviceClass, "BlockSize", string);
    }

    private void resolveInitiator(DeviceClass deviceClass, int n, String string) {
        String string2 = this.system.getStringValue(string + "Initiator" + n, "lunMaskWWN");
        String string3 = this.system.getStringValue(string + "Initiator" + n, "lunMaskAccess");
        if (string2 == null) {
            return;
        }
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalElement");
        this.xmlAttr(deviceClass2, "CreationClassName", "StorEdgeArray_Initiator");
        this.xmlAttr(deviceClass2, "Name", string + ":" + string2);
        this.xmlAttr(deviceClass2, "InitiatorWWN", string2);
        this.xmlAttr(deviceClass2, "Access", string3);
    }

    private void resolvePowerSupply(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("UninterruptiblePowerSupply");
        this.addLogicalDeviceInternals(deviceClass, string, 2);
        this.xmlAttr(deviceClass, "REF", string);
        this.xmlAttr(deviceClass, "Description", "6120 Power Supply");
        this.xmlAttr(deviceClass, "PowerOutput", this.system.getStringValue(string, "fruPowerPowOutput"));
        this.xmlAttr(deviceClass, "PowerSource", this.system.getStringValue(string, "fruPowerPowSource"));
    }

    private void resolveBattery(DeviceClass deviceClass, int n, String string) {
        String string2 = this.system.getStringValue(string, "fruPowerBatState");
        deviceClass.setClassName("Battery");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "Description", "Power Supply Battery");
        this.xmlAttr(deviceClass, "DeviceID", string + "bat");
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
        this.xmlAttr(deviceClass, "Availability", this.convertToCIMAvailability(string2));
        this.xmlAttr(deviceClass, "StatusInfo", this.convertToCIMStatusInfo(string2));
        this.xmlAttr(deviceClass, "Name", BATTERY_TYPE_NAME);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Battery");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Description", "PCU Battery");
        this.xmlIntAttr(deviceClass, "BatteryLife", this.system.getStringValue(string, "fruPowerBatLife"));
        this.xmlIntAttr(deviceClass, "BatteryLifeUsed", this.system.getStringValue(string, "fruPowerBatUsed"));
    }

    private void resolveFan(DeviceClass deviceClass, String string, int n) {
        String string2 = this.system.getStringValue(string, "fruStatus");
        String string3 = this.system.getStringValue(string, "fruPowerFan" + n + "State");
        deviceClass.setClassName("Fan");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string + ":Fan" + n);
        this.xmlAttr(deviceClass, "REF", string + ":Fan" + n);
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
        this.xmlAttr(deviceClass, "StatusInfo", this.convertToCIMStatusInfo(string3));
        this.xmlAttr(deviceClass, "Name", Integer.toString(n));
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Fan");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Availability", this.convertToCIMAvailability(string2, string3));
        this.xmlAttr(deviceClass, "Description", "PCU Fan");
        this.xmlAttr(deviceClass, "VariableSpeed", "false");
        this.xmlAttr(deviceClass, "ActiveCooling", "true");
    }

    private void resolveTemperatureSensor(DeviceClass deviceClass, int n, String string, String string2) {
        deviceClass.setClassName("TemperatureSensor");
        this.addLogicalDeviceInternals(deviceClass, string, 6);
        this.xmlAttr(deviceClass, "DeviceID", string + ":TempSensor");
        this.xmlAttr(deviceClass, "Description", "Temperature Sensor");
        if ("Power".equals(string2)) {
            this.xmlAttr(deviceClass, "CurrentState", BLANK + this.system.getStringValue(string, "fru" + string2 + "PowTemp"));
        } else {
            String string3 = this.system.getStringValue(string, "fru" + string2 + "Temp");
            if (string3 != null) {
                this.xmlAttr(deviceClass, "CurrentReading", ReportTools.truncate((String)string3));
            }
            this.xmlAttr(deviceClass, "BaseUnits", "2");
        }
    }

    private void resolveSensor(DeviceClass deviceClass, int n, String string, String string2) {
        deviceClass.setClassName("Sensor");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeT3_Cluster");
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_Sensor");
        this.xmlAttr(deviceClass, "DeviceID", string + ":TempSensor");
        this.xmlAttr(deviceClass, "Caption", "Temperature Sensor");
        this.xmlAttr(deviceClass, "Description", "Sensor monitors the state of the power supply temperature.");
        this.xmlIntAttr(deviceClass, "SensorType", "2");
        String string3 = this.system.getStringValue(string, "fru" + string2 + "PowTemp");
        this.xmlStringAttr(deviceClass, "CurrentState", string3, "Unknown");
    }

    private void resolvePhysicalPackage(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("PhysicalPackage");
        this.addPhysicalPackageInternals(deviceClass, string);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_PhysicalPackage");
    }

    private void addPhysicalPackageInternals(DeviceClass deviceClass, String string) {
        String string2 = this.system.getStringValue(string, "fruStatus");
        String string3 = this.system.getStringValue(string, "fruVendor");
        String string4 = this.system.getStringValue(string, "fruModel");
        String string5 = this.system.getStringValue(string, "fruSerialNo");
        string3 = string3 == null ? BLANK : string3.trim();
        string4 = string4 == null ? BLANK : string4.trim();
        string5 = string5 == null ? BLANK : string5.trim();
        this.xmlAttr(deviceClass, "Manufacturer", string3);
        this.xmlAttr(deviceClass, "Model", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string5);
        this.xmlAttr(deviceClass, "Tag", string3 + "." + string4 + "." + string5);
        this.xmlAttr(deviceClass, "Version", BLANK + this.system.getStringValue(string, "fruRevision"));
        this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Removable", "true");
        this.xmlAttr(deviceClass, "Replaceable", "true");
        this.xmlAttr(deviceClass, "HotSwappable", BLANK);
    }

    private void resolveBatteryPhysicalPackage(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("PhysicalPackage");
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_PhysicalPackage");
        String string2 = this.system.getStringValue(string, "fruPowerBatState");
        String string3 = this.system.getStringValue(string, "fruPowerBatVendor");
        String string4 = this.system.getStringValue(string, "fruPowerBatModel");
        String string5 = this.system.getStringValue(string, "fruPowerBatSerialNo");
        string3 = string3 == null ? BLANK : string3.trim();
        string4 = string4 == null ? BLANK : string4.trim();
        string5 = string5 == null ? BLANK : string5.trim();
        this.xmlAttr(deviceClass, "Manufacturer", string3);
        this.xmlAttr(deviceClass, "Model", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string5);
        this.xmlAttr(deviceClass, "Tag", string3 + "." + string4 + "." + string5);
        this.xmlAttr(deviceClass, "Version", BLANK + this.system.getStringValue(string, "fruRevision"));
        this.xmlAttr(deviceClass, "Name", BATTERY_TYPE_NAME);
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Removable", "true");
        this.xmlAttr(deviceClass, "Replaceable", "true");
        this.xmlAttr(deviceClass, "HotSwappable", BLANK);
    }

    private void resolveCard(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("Card");
        this.addPhysicalPackageInternals(deviceClass, string);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Card");
        this.xmlAttr(deviceClass, "HostingBoard", BLANK);
        this.xmlAttr(deviceClass, "RequiresDaughterBoard", BLANK);
    }

    private void resolveSlot(DeviceClass deviceClass, String string) {
        String string2 = this.system.getStringValue(string, "fruStatus");
        String string3 = this.system.getStringValue(string, "fruVendor");
        String string4 = this.system.getStringValue(string, "fruModel");
        String string5 = this.system.getStringValue(string, "fruSerialNo");
        string3 = string3 == null ? BLANK : string3.trim();
        string4 = string4 == null ? BLANK : string4.trim();
        string5 = string5 == null ? BLANK : string5.trim();
        deviceClass.setClassName("Slot");
        this.xmlAttr(deviceClass, "Manufacturer", string3);
        this.xmlAttr(deviceClass, "Model", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string5);
        this.xmlAttr(deviceClass, "Tag", string3 + "." + string4 + "." + string5);
        this.xmlAttr(deviceClass, "Version", this.system.getStringValue(string, "fruRevision"));
        this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Slot");
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "SupportsHotPlug", "true");
    }

    private void resolveBatterySlot(DeviceClass deviceClass, String string) {
        String string2 = this.system.getStringValue(string, "fruPowerBatState");
        String string3 = this.system.getStringValue(string, "fruPowerBatVendor");
        String string4 = this.system.getStringValue(string, "fruPowerBatModel");
        String string5 = this.system.getStringValue(string, "fruPowerBatSerialNo");
        string3 = string3 == null ? BLANK : string3.trim();
        string4 = string4 == null ? BLANK : string4.trim();
        string5 = string5 == null ? BLANK : string5.trim();
        deviceClass.setClassName("Slot");
        this.xmlAttr(deviceClass, "Manufacturer", string3);
        this.xmlAttr(deviceClass, "Model", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string5);
        this.xmlAttr(deviceClass, "Tag", string3 + "." + string4 + "." + string5);
        this.xmlAttr(deviceClass, "Version", this.system.getStringValue(string, "fruRevision"));
        this.xmlAttr(deviceClass, "Name", BATTERY_TYPE_NAME);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_Slot");
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "SupportsHotPlug", "true");
    }

    private void resolveFRU(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("FRU");
        this.xmlAttr(deviceClass, "FRUNumber", string);
        this.xmlAttr(deviceClass, "IdentifyingNumber", string);
        this.xmlAttr(deviceClass, "Name", BLANK + this.system.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "Vendor", BLANK + this.system.getStringValue(string, "fruVendor"));
        this.xmlAttr(deviceClass, "RevisionLevel", BLANK + this.system.getStringValue(string, "fruRevision"));
    }

    private void resolveBatteryFRU(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("FRU");
        this.xmlAttr(deviceClass, "FRUNumber", string);
        this.xmlAttr(deviceClass, "IdentifyingNumber", string);
        this.xmlAttr(deviceClass, "Name", BATTERY_TYPE_NAME);
        this.xmlAttr(deviceClass, "Vendor", BLANK + this.system.getStringValue(string, "fruPowerBatVendor"));
        this.xmlAttr(deviceClass, "RevisionLevel", BLANK + this.system.getStringValue(string, "fruPowerBatRevision"));
    }

    private void resolveLocation(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("Location");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "PhysicalPosition", string);
        this.xmlAttr(deviceClass, "Address", BLANK);
    }

    private void resolveDeviceErrorCounts(DeviceClass deviceClass, String string, String string2) {
        deviceClass.setClassName("DeviceErrorCounts");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "Name", BLANK + this.system.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "DeviceCreationClassName", string2);
    }

    private void resolveDeviceStatisticalInformation(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("DeviceStatisticalInformation");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "Name", BLANK + this.system.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
    }

    private void resolveVolumeStatisticalInformation(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("DeviceStatisticalInformation");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_VolumeStatisticalInformation");
        this.xmlAttr(deviceClass, "DeviceCreationClassName", "StorEdgeArray_StorageVolume");
        this.xmlAttr(deviceClass, "SystemCreationClassName", "StorEdgeArray_Cluster");
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "Name", this.system.getStringValue(string, "volName"));
        this.xmlIntAttr(deviceClass, "ReadRequests", BLANK + this.system.getStringValue(string, "volReadRequests"));
        this.xmlIntAttr(deviceClass, "WriteRequests", BLANK + this.system.getStringValue(string, "volWriteRequests"));
        this.xmlIntAttr(deviceClass, "TotalRequests", BLANK + this.system.getStringValue(string, "volTotalRequests"));
        this.xmlIntAttr(deviceClass, "TotalBlocks", BLANK + this.system.getStringValue(string, "volTotalBlocks"));
        this.xmlIntAttr(deviceClass, "BlocksWritten", BLANK + this.system.getStringValue(string, "volBlocksWritten"));
        this.xmlIntAttr(deviceClass, "BlocksRead", BLANK + this.system.getStringValue(string, "volBlocksRead"));
        this.xmlIntAttr(deviceClass, "CacheWriteHits", BLANK + this.system.getStringValue(string, "volCacheWriteHits"));
        this.xmlIntAttr(deviceClass, "CacheWriteMisses", BLANK + this.system.getStringValue(string, "volCacheWriteMisses"));
        this.xmlIntAttr(deviceClass, "CacheReadHits", BLANK + this.system.getStringValue(string, "volCacheReadHits"));
        this.xmlIntAttr(deviceClass, "CacheReadMisses", BLANK + this.system.getStringValue(string, "volCacheReadMisses"));
        this.xmlIntAttr(deviceClass, "CacheRmwFlushes", BLANK + this.system.getStringValue(string, "volCacheRmwFlushes"));
        this.xmlIntAttr(deviceClass, "CacheReconFlushes", BLANK + this.system.getStringValue(string, "volCacheReconFlushes"));
        this.xmlIntAttr(deviceClass, "CacheStripeFlushes", BLANK + this.system.getStringValue(string, "volCacheStripeFlushes"));
        String string2 = this.system.getStringValue(string, "volSecTotalRequests");
        this.xmlFloatAttr(deviceClass, "SecTotalRequests", string2);
        String string3 = this.system.getStringValue(string, "volSecWriteRequests");
        this.xmlFloatAttr(deviceClass, "SecWriteRequests", string3);
        String string4 = this.system.getStringValue(string, "volSecReadRequests");
        this.xmlFloatAttr(deviceClass, "SecReadRequests", string4);
        String string5 = this.system.getStringValue(string, "volSecTotalMBytes");
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", string5);
        String string6 = this.system.getStringValue(string, "volSecMBytesWritten");
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", string6);
        String string7 = this.system.getStringValue(string, "volSecMBytesRead");
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", string7);
        this.xmlIntAttr(deviceClass, "SoftErrors", BLANK + this.system.getStringValue(string, "volSoftErrors"));
        this.xmlIntAttr(deviceClass, "FirmErrors", BLANK + this.system.getStringValue(string, "volFirmErrors"));
        this.xmlIntAttr(deviceClass, "HardErrors", BLANK + this.system.getStringValue(string, "volHardErrors"));
    }

    private void resolveRedundancyGroup(DeviceClass deviceClass, int n, int n2, int n3) {
        int n4;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        int n5 = n - 1;
        int n6 = n - 1;
        String string8 = "ready";
        String string9 = "enabled";
        switch (n2) {
            case 3: {
                string7 = "u" + n + LOOP_TYPE_NAME;
                string6 = "u" + n + "l1";
                string5 = "fruStatus";
                string4 = "fruState";
                string3 = "u" + n + "l2";
                string2 = "fruStatus";
                string = "fruState";
                break;
            }
            case 2: {
                string7 = "u" + n + PCU_TYPE_NAME;
                string6 = "u" + n + "pcu1";
                string5 = "fruStatus";
                string4 = "fruState";
                string3 = "u" + n + "pcu2";
                string2 = "fruStatus";
                string = "fruState";
                break;
            }
            case 4: {
                string7 = "u" + n + PCU_TYPE_NAME + n3 + FAN_TYPE_NAME;
                string6 = "u" + n + "pcu" + n3;
                string5 = null;
                string4 = "fruPowerFan1State";
                string3 = "u" + n + "pcu" + n3;
                string2 = null;
                string = "fruPowerFan2State";
                string8 = "normal";
                break;
            }
            case 1: {
                string7 = CONTROLLER_TYPE_NAME;
                string6 = "u1ctr";
                string5 = "fruStatus";
                string4 = "fruState";
                n5 = 0;
                string3 = "u2ctr";
                string2 = "fruStatus";
                string = "fruState";
                n6 = 1;
                break;
            }
            default: {
                return;
            }
        }
        String string10 = this.system.getStringValue(string6, string4);
        String string11 = this.system.getStringValue(string3, string);
        if (string9.equals(string10) && string9.equals(string11)) {
            n4 = 2;
            if (n2 != 4) {
                String string12 = this.system.getStringValue(string6, string5);
                String string13 = this.system.getStringValue(string3, string2);
                if (!string8.equals(string12) || !string8.equals(string13)) {
                    n4 = 4;
                }
            }
        } else {
            n4 = 4;
        }
        deviceClass.setClassName("RedundancyGroup");
        this.xmlAttr(deviceClass, "REF", string7);
        this.xmlAttr(deviceClass, "Name", string7);
        this.xmlAttr(deviceClass, "RedundancyStatus", Integer.toString(n4));
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeArray_RedundancyGroup");
    }

    private void resolveStorageRedundancyGroup(DeviceClass deviceClass, String string) {
        String string2 = "ready";
        String string3 = "enabled";
        int n = 0;
        String string4 = this.system.getStringValue(string, "volRaidLevel");
        if ("raid1".equals(string4) || "raid5".equals(string4)) {
            Object object;
            int n2;
            n = 2;
            try {
                n2 = this.system.getIntValue(string, "volArrayWidth");
            }
            catch (T3Exception t3Exception) {
                n2 = 0;
                n = 0;
            }
            int n3 = 0;
            while (n3 < n2) {
                object = string + "-d" + n3;
                String string5 = this.system.getStringValue((String)object, "volDiskFruId");
                if (string5 != null) {
                    String string6 = this.system.getStringValue(string5, "fruState");
                    String string7 = this.system.getStringValue(string5, "fruStatus");
                    if (!string2.equals(string7) || !string3.equals(string6)) {
                        n = 4;
                    }
                }
                ++n3;
            }
            object = deviceClass.newSubInstance();
            object.setClassName("RedundancyGroup");
            this.xmlAttr((DeviceClass)object, "REF", string + "Group");
            this.xmlAttr((DeviceClass)object, "Name", string + "Group");
            this.xmlAttr((DeviceClass)object, "RedundancyStatus", BLANK + n);
            this.xmlAttr((DeviceClass)object, "CreationClassName", "StorEdgeArray_RedundancyGroup");
        }
    }

    private void resolveRedundancyAssociation(DeviceClass deviceClass, int n, String string, int n2) {
        String[] stringArray;
        String string2 = null;
        if (LOOP_TYPE_NAME.equals(string)) {
            string2 = "u" + n + string;
            stringArray = new String[]{"u" + n + "l" + 1, "u" + n + "l" + 2};
        } else if (PCU_TYPE_NAME.equals(string)) {
            string2 = "u" + n + string;
            stringArray = new String[]{"u" + n + "pcu" + 1, "u" + n + "pcu" + 2};
        } else if (FAN_TYPE_NAME.equals(string)) {
            string2 = "u" + n + PCU_TYPE_NAME + n2 + string;
            stringArray = new String[]{"u" + n + "pcu" + n2 + ":Fan" + 1, "u" + n + "pcu" + n2 + ":Fan" + 2};
        } else if (DRIVE_TYPE_NAME.equals(string)) {
            string2 = "u" + n + string;
            stringArray = new String[14];
            int n3 = 1;
            while (n3 <= 14) {
                stringArray[n3 - 1] = "u" + n + "d" + (n3 < 10 ? UNAVAILABLE_INTEGER + n3 : BLANK + n3);
                ++n3;
            }
        } else if (CONTROLLER_TYPE_NAME.equals(string)) {
            string2 = string;
            stringArray = new String[]{"u1ctr", "u2ctr"};
        } else {
            return;
        }
        deviceClass.setClassName("RedundancyComponent");
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("GroupComponent");
        this.xmlAttr(deviceClass2, "REF", string2);
        int n4 = 0;
        while (n4 < stringArray.length) {
            DeviceClass deviceClass3 = deviceClass.newSubInstance();
            deviceClass3.setClassName("PartComponent");
            this.xmlAttr(deviceClass3, "REF", stringArray[n4]);
            ++n4;
        }
    }

    private void resolveVolumeRedundancyAssociation(DeviceClass deviceClass) {
        Iterator iterator = this.system.findTokensWithKey("volStatus").iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            int n;
            String string;
            String string2;
            T3Token t3Token = (T3Token)iterator.next();
            String string3 = t3Token.getPropertyValue();
            if (string3 == null || string3.equals("deleted") || !"raid1".equals(string2 = this.system.getStringValue(string = t3Token.getElementID(), "volRaidLevel")) && !"raid5".equals(string2)) continue;
            try {
                n = this.system.getIntValue(string, "volArrayWidth");
            }
            catch (T3Exception t3Exception) {
                n = 0;
            }
            Vector<DeviceClass> vector = new Vector<DeviceClass>();
            int n2 = 0;
            while (n2 < n) {
                object2 = string + "-d" + n2;
                object = this.system.getStringValue((String)object2, "volDiskFruId");
                if (object != null) {
                    vector.add((DeviceClass)object);
                }
                ++n2;
            }
            object2 = deviceClass.newSubInstance();
            object2.setClassName("RedundancyComponent");
            object = object2.newSubInstance();
            object.setClassName("GroupComponent");
            this.xmlAttr((DeviceClass)object, "REF", string + "Group");
            int n3 = 0;
            while (n3 < vector.size()) {
                DeviceClass deviceClass2 = object2.newSubInstance();
                deviceClass2.setClassName("PartComponent");
                this.xmlAttr(deviceClass2, "REF", (String)vector.get(n3));
                ++n3;
            }
        }
    }

    protected String convertToCIMStatus(String string) {
        String string2 = "Unknown";
        try {
            if (string.equalsIgnoreCase("ready") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("mounted") || string.equalsIgnoreCase("online")) {
                string2 = "OK";
            } else if (string.equalsIgnoreCase("fault")) {
                string2 = "Error";
            } else if (string.equalsIgnoreCase("offline") || string.equalsIgnoreCase("deleted")) {
                string2 = "NonRecover";
            } else if (string.equalsIgnoreCase("unmounted") || string.equalsIgnoreCase("uninitialized") || string.equalsIgnoreCase("refreshing")) {
                string2 = "Service";
            } else if (string.equalsIgnoreCase("booting")) {
                string2 = "Starting";
            } else if (string.equalsIgnoreCase("notinstalled")) {
                string2 = "Stopped";
            }
        }
        catch (NullPointerException nullPointerException) {}
        return string2;
    }

    protected String convertToCIMStatusInfo(String string) {
        int n = 2;
        try {
            if (string.equalsIgnoreCase("enabled") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("online")) {
                n = 3;
            } else if (string.equalsIgnoreCase("disabled") || string.equalsIgnoreCase("offline") || string.equalsIgnoreCase("notInstalled")) {
                n = 4;
            } else if (string.equalsIgnoreCase("other") || string.equalsIgnoreCase("fault")) {
                n = 1;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return Integer.toString(n);
    }

    protected String convertToCIMAvailability(String string, String string2) {
        int n;
        block11: {
            int n2;
            n = 2;
            String string3 = this.convertToCIMStatus(string);
            String string4 = this.convertToCIMStatusInfo(string2);
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 2;
            }
            try {
                if ("dummy".equalsIgnoreCase(string) || "notInstalled".equalsIgnoreCase(string)) {
                    n = 11;
                    break block11;
                }
                if (string3.equals("Starting")) {
                    n = 19;
                    break block11;
                }
                if (n2 == 4 || string3.equals("NonRecover")) {
                    n = 8;
                    break block11;
                }
                if (string3.equals("OK")) {
                    n = 3;
                    break block11;
                }
                if (!string3.equals("Error")) break block11;
                if (n2 == 3 || n2 == 2) {
                    n = 10;
                } else if (n2 == 3) {
                    n = 8;
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return Integer.toString(n);
    }

    protected String convertToCIMAvailability(String string) {
        int n = 2;
        String string2 = this.convertToCIMStatus(string);
        try {
            if ("dummy".equalsIgnoreCase(string) || "notInstalled".equalsIgnoreCase(string)) {
                n = 11;
            } else if ("uninitialized".equals(string)) {
                n = 20;
            } else if ("unmounted".equals(string)) {
                n = 8;
            } else if ("refreshing".equals(string)) {
                n = 16;
            } else if (string2.equals("OK")) {
                n = 3;
            } else if (string2.equals("Starting")) {
                n = 19;
            } else if (string2.equals("Error") || string2.equals("Service") || string2.equals("NonRecover")) {
                n = 8;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return Integer.toString(n);
    }

    private String determineClusterStatus() {
        Vector<T3Token> vector = new Vector<T3Token>();
        int n = 1;
        while (n <= this.unitCount) {
            T3Token t3Token = new T3Token("u" + n, "unitStatus", this.getUnitStatus(n));
            vector.add(t3Token);
            ++n;
        }
        return T4StatusCalculator.deriveClusterStatus(vector);
    }

    private String getUnitStatus(int n) {
        return T4StatusCalculator.deriveUnitStatus(this.system, n);
    }

    T3TokenList getCurrentTokenList() {
        return this.system;
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        if (stringArray.length > 1) {
            properties.setProperty("ip", stringArray[0]);
            properties.setProperty("name", stringArray[1]);
            T4ReportGenerator t4ReportGenerator = new T4ReportGenerator(properties);
            String string = t4ReportGenerator.generateReport();
            System.out.println(string);
        } else {
            System.out.println("Usage: T4ReportGenerator <ip address> <system name>");
        }
    }
}

