/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t4.service;

import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.device.array.t3.service.ParserException;
import com.sun.jade.device.array.t3.service.T3MF;
import com.sun.jade.device.array.t3.service.T3SyslogParser;
import com.sun.jade.device.array.t4.diags.SMI_T4VolumeVerifyTest;
import com.sun.jade.device.array.t4.service.T4Model;
import com.sun.jade.device.array.t4.service.T4ReportGenerator;
import com.sun.jade.device.array.t4.service.T4Views;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.view.ViewHelper;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.util.Properties;

public class T4MFImpl
extends AbstractMF
implements T4Model,
T3MF {
    private String wwn;
    private String ip;
    private String ipno;
    private InetAddress iaddr;
    private Properties p;
    private T3SyslogParser logParser;
    public static String CIM_CLASS_NAME = "StorEdgeArray_Cluster";

    public T4MFImpl(Properties properties) {
        super(properties);
        this.p = properties;
        this.ip = this.resolveIP(properties);
        this.ipno = properties.getProperty("ipno");
        String string = properties.getProperty("type");
        if ("t4".equalsIgnoreCase(string)) {
            this.wwn = properties.getProperty("wwn");
            if (this.wwn == null) {
                Report.debug.log((Object)("WWN not yet set for 6120 disk array ip = " + this.ip));
            }
        } else {
            throw new IllegalArgumentException("Expected t4, received: " + string);
        }
        this.setDeviceReport(new T4ReportGenerator(properties));
        this.startSyslogParsing();
        this.addDiagnosticTest((TestTemplate)new SMI_T4VolumeVerifyTest());
    }

    public String getClassName() {
        return CIM_CLASS_NAME;
    }

    public String getName() {
        return this.wwn;
    }

    public String getIPAddr() {
        return this.ip;
    }

    public String getIPNum() {
        return this.ipno;
    }

    public String getType() {
        return "t4";
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString("Sun StorEdge 6120");
    }

    protected void shutdown() {
        if (this.logParser != null) {
            this.logParser.removeDevice(this);
        }
    }

    public void startSyslogParsing() {
        block2: {
            if (this.logParser != null) break block2;
            try {
                this.logParser = T3SyslogParser.getParser(this);
                this.logParser.monitorDevice(this);
            }
            catch (ParserException parserException) {
                Report.error.log("SyslogError", (Object)parserException.getMessage());
            }
        }
    }

    protected ViewHelper newViewHelper() {
        return new T4Views(this);
    }
}

