/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t4.diags;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.device.array.t4.diags.Messages;
import com.sun.jade.device.array.t4.io.T4System;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import javax.wbem.cim.CIMDateTime;

public class SMI_T4VolumeVerifyTestExecutable
extends TestExecutableImpl {
    private static final Localizer msgs = Messages.getLocalizer();
    private static final int POLL_INTERVAL = 30000;
    private static final String LOG_TAG = "T4";
    private T4System t4 = null;
    private int operation;
    private int progress;
    private DiagnosticResult result = new DiagnosticResult();
    private boolean abort = false;
    private boolean isRunning = false;
    private boolean verifying = false;
    private boolean debug;
    private String userName = "guest";
    private String password = "";
    private String ip;
    private String wwn;
    private int rate = 1;
    private int fix = 0;
    private int lunNum = 0;
    private int unitNum = 0;
    private static final String sccs_id = "@(#)SMI_T4VolumeVerifyTestExecutable.java\t1.20 10/30/02 SMI";

    SMI_T4VolumeVerifyTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        block21: {
            block20: {
                block19: {
                    Report.trace.log((Object)"runTest");
                    this.parseSettings();
                    this.result = diagnosticResult;
                    if (null == this.ip || "".equals(this.ip)) {
                        diagnosticResult.setFinalResults(TestState.FAILED, msgs.getString("oob.noipaddr"));
                        return;
                    }
                    this.isRunning = true;
                    try {
                        try {
                            this.t4 = new T4System(this.ip);
                            this.t4.updateSystem();
                            this.checkVolumeStatus();
                            if (this.reportStatus) {
                                diagnosticResult.addTestResults(msgs.getString("volver.msg.checkVolumeStatusOK"));
                                diagnosticResult.update();
                            }
                            if (this.abort) {
                                diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("volver.aborted"));
                                Object var6_2 = null;
                                this.isRunning = false;
                                this.abort = false;
                                this.cleanUp();
                                return;
                            }
                            if (this.abort) {
                                diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("volver.aborted"));
                                break block19;
                            }
                            if (this.checkForVolumeOperation()) {
                                if (this.reportErrors) {
                                    diagnosticResult.addTestResults(msgs.getString("volver.msg.conflictingVolumeOp"));
                                    diagnosticResult.update();
                                }
                                this.verifying = true;
                            } else {
                                if (this.reportStatus) {
                                    diagnosticResult.addTestResults(msgs.getString("volver.msg.checkForVolOpOK"));
                                    diagnosticResult.update();
                                }
                                if (this.abort) {
                                    diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("volver.aborted"));
                                    break block20;
                                }
                                if (this.debug) {
                                    diagnosticResult.addTestResults(">volumeVerify begin");
                                    diagnosticResult.addTestResults(">   unitNum=" + this.unitNum);
                                    diagnosticResult.addTestResults(">   lunNum=" + this.lunNum);
                                    diagnosticResult.addTestResults(">   rate=" + this.rate);
                                    diagnosticResult.addTestResults(">   fix=" + this.fix);
                                    diagnosticResult.update();
                                }
                                this.t4.volumeVerify(this.unitNum, this.lunNum, this.userName, this.password, this.rate, this.fix);
                                this.verifying = true;
                            }
                            if (this.monitorTest()) {
                                diagnosticResult.setFinalResults(TestState.PASSED, msgs.getString("volver.msg.testPassed"));
                                break block21;
                            } else {
                                diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("volver.aborted"));
                            }
                            break block21;
                        }
                        catch (Exception exception) {
                            StringWriter stringWriter;
                            if (this.debug) {
                                stringWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(stringWriter);
                                exception.printStackTrace(printWriter);
                                diagnosticResult.addTestResults(stringWriter.toString());
                            }
                            stringWriter = new LocalizedString(exception);
                            diagnosticResult.addTestResults(stringWriter.toString());
                            if (!(exception instanceof DiagnosticException)) {
                                stringWriter = new DiagnosticException().getLocalizedString();
                                diagnosticResult.addTestResults(stringWriter.toString());
                            }
                            diagnosticResult.setFinalResults(TestState.FAILED);
                            Object var6_6 = null;
                            this.isRunning = false;
                            this.abort = false;
                            this.cleanUp();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        this.isRunning = false;
                        this.abort = false;
                        this.cleanUp();
                        throw throwable;
                    }
                }
                Object var6_3 = null;
                this.isRunning = false;
                this.abort = false;
                this.cleanUp();
                return;
            }
            Object var6_4 = null;
            this.isRunning = false;
            this.abort = false;
            this.cleanUp();
            return;
        }
        Object var6_5 = null;
        this.isRunning = false;
        this.abort = false;
        this.cleanUp();
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log((Object)"abortTest");
        if (!this.isRunning || this.abort) {
            return false;
        }
        this.abort = true;
        this.t4.abortUpdate();
        if (!this.cleanUp()) {
            throw new DiagnosticException("DIAG_ERR_FAILED");
        }
        ((Object)((Object)this)).notify();
        return true;
    }

    private void checkVolumeStatus() throws DiagnosticException, T3Exception {
        T3Token t3Token;
        Report.trace.log((Object)"checkVolumeStatus");
        T3TokenList[] t3TokenListArray = this.t4.getUnitProperties();
        T3TokenList t3TokenList = t3TokenListArray[this.unitNum];
        Collection collection = t3TokenList.findTokensWithKey("volIndex");
        String string = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            t3Token = (T3Token)iterator.next();
            int n = Integer.parseInt(t3Token.getPropertyValue());
            if (n != this.lunNum) continue;
            string = t3Token.getElementID();
        }
        if (string == null) {
            throw new DiagnosticException(msgs.getString("volver.msg.volumeNotCreated"));
        }
        t3Token = t3TokenList.findToken(string, "volStatus");
        String string2 = t3Token.getPropertyValue();
        if (this.debug) {
            this.result.addTestResults(">Volume status for " + string + " = " + string2);
        }
        if (!string2.equals("mounted")) {
            if (string2.equals("unmounted")) {
                throw new DiagnosticException(msgs.getString("volver.msg.volumeNotMounted"));
            }
            if (string2.equals("uninitialized")) {
                throw new DiagnosticException(msgs.getString("volver.msg.volumeNotInited"));
            }
            if (string2.equals("deleted")) {
                throw new DiagnosticException(msgs.getString("volver.msg.volumeDeleted"));
            }
            throw new DiagnosticException(msgs.getString("volver.msg.volumeStatusUnknown"));
        }
        this.result.setTestStartTime(new CIMDateTime());
        this.result.setTestState(TestState.IN_PROGRESS);
    }

    private boolean checkForVolumeOperation() throws DiagnosticException, T3Exception {
        T3TokenList t3TokenList = this.t4.getCurrentVolumeOperation(this.unitNum, this.lunNum);
        String string = t3TokenList.getStringValue("volOper");
        if (this.debug) {
            this.result.addTestResults(">Check volume index " + this.lunNum + " operation = " + string);
        }
        if (this.t4.getVolumeOperation(t3TokenList) != 0) {
            return true;
        }
        int n = 0;
        if (this.lunNum == 0) {
            n = 1;
        }
        T3TokenList t3TokenList2 = this.t4.getCurrentVolumeOperation(this.unitNum, n);
        string = t3TokenList2.getStringValue("volOper");
        if (this.debug) {
            this.result.addTestResults(">Check volume index " + n + " operation = " + string);
        }
        if (this.t4.getVolumeOperation(t3TokenList2) != 0) {
            this.result.addTestResults("Verify running on another volume. (LUN " + n + ")");
            this.result.update();
            this.lunNum = n;
            return true;
        }
        return false;
    }

    private synchronized boolean monitorTest() throws DiagnosticException, T3Exception {
        Report.trace.log((Object)"monitorTest");
        boolean bl = true;
        do {
            boolean bl2 = false;
            if (this.progress >= 98) {
                bl2 = true;
            }
            T3TokenList t3TokenList = this.t4.getCurrentVolumeOperation(this.unitNum, this.lunNum);
            this.progress = this.t4.getVolumeOperationProgress(t3TokenList);
            this.operation = this.t4.getVolumeOperation(t3TokenList);
            if (bl) {
                if (this.operation == 1) {
                    bl = false;
                    if (this.reportStatus) {
                        this.result.addTestResults(msgs.getString("volver.msg.confirmRunning"));
                    }
                }
            } else if (this.operation != 1) {
                this.progress = 100;
                this.verifying = false;
                if (!bl2) {
                    return false;
                }
            }
            this.result.setPercentComplete((short)this.progress);
            if (this.progress == 100) {
                return true;
            }
            try {
                ((Object)((Object)this)).wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.abort) continue;
            return false;
        } while (this.progress < 100);
        return true;
    }

    private boolean cleanUp() {
        Report.trace.log((Object)"cleanUp");
        if (!this.verifying) {
            return true;
        }
        this.verifying = false;
        try {
            this.t4.abortVolumeOperation(this.unitNum, this.lunNum, this.userName, this.password);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void warnBadWWN() throws DiagnosticException, T3Exception {
        if (this.wwn == null) {
            return;
        }
        if (this.wwn.equals("")) {
            return;
        }
        String string = this.wwn;
        if (this.wwn.length() > 16) {
            string = this.wwn.substring(0, 16);
        }
        boolean bl = true;
        String string2 = null;
        T3TokenList t3TokenList = this.t4.getSystemProperties();
        T3TokenList[] t3TokenListArray = this.t4.getUnitProperties();
        int n = t3TokenList.getIntValue("volCount");
        int n2 = t3TokenList.getIntValue("unitCount");
        int n3 = 1;
        while (n3 <= n2) {
            T3TokenList t3TokenList2 = t3TokenListArray[n3 - 1];
            T3Token t3Token = t3TokenList2.findToken("portWWN");
            if (t3Token != null && string.equals(string2 = t3Token.getPropertyValue())) {
                return;
            }
            int n4 = 1;
            while (n4 <= n) {
                String string3;
                String string4 = "u" + n3 + "vol" + n4;
                t3Token = t3TokenList2.findToken(string4, "volWWN");
                if (t3Token != null && string.equals(string3 = t3Token.getPropertyValue().substring(8, 24))) {
                    return;
                }
                ++n4;
            }
            ++n3;
        }
        if (bl && this.reportErrors) {
            this.result.addTestResults(msgs.getFormattedString("warn.wwn-ip-diff", (Object)this.wwn, string2));
        }
    }

    protected void parseSettings() {
        super.parseSettings();
        Report.trace.log((Object)"parseSettings");
        TestParameter testParameter = this.setting.getTestParameter("user");
        if (testParameter != null) {
            this.userName = (String)testParameter.getCurrentValue();
            Report.debug.log(LOG_TAG, (Object)("user=" + this.userName));
        }
        if ((testParameter = this.setting.getTestParameter("password")) != null) {
            this.password = (String)testParameter.getCurrentValue();
        }
        if ((testParameter = this.setting.getTestParameter("rate")) != null) {
            int n = testParameter.choiceValue(0);
            this.rate = (n + 1) * 2;
            Report.debug.log((Object)("Rate=" + this.rate));
        }
        if ((testParameter = this.setting.getTestParameter("fix")) != null) {
            Boolean bl = (Boolean)testParameter.getCurrentValue();
            this.fix = bl.equals(Boolean.TRUE) ? 1 : 0;
        }
        String string = this.mse.getKeyValue();
        Report.debug.log((Object)("KeyValue: " + string));
        if (string != null) {
            int n = string.indexOf("u");
            int n2 = string.indexOf("vol");
            if (n >= 0 && n2 >= 0) {
                String string2 = string.substring(n + 1, n2);
                String string3 = string.substring(n2 + 3);
                if (string2 != null) {
                    this.unitNum = new Integer(string2) - 1;
                    Report.debug.log((Object)("UNIT=" + this.unitNum));
                }
                if (string3 != null) {
                    this.lunNum = new Integer(string3) - 1;
                    Report.debug.log((Object)("LUN=" + this.lunNum));
                }
            }
        }
        if ((testParameter = this.setting.getTestParameter("ip")) != null) {
            this.ip = (String)testParameter.getCurrentValue();
            Report.debug.log(LOG_TAG, (Object)("ip=" + this.ip));
            this.wwn = this.mse.getKeyValue();
        }
        if (this.ip == null || "".equals(this.ip)) {
            this.ip = DiagUtil.getIP((ReferenceForMSE)this.mse);
        }
    }
}

