/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.service;

import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3HttpConnection;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.device.array.t3.service.T3ClusterStatusCalculator;
import com.sun.jade.device.array.t3.util.ReportUtil;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.RHBAConverter;
import com.sun.jade.device.util.ReportHandler;
import com.sun.jade.device.util.ReportTools;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AgentStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class T3ReportGenerator
implements ReportGenerator {
    public static final String CLASS_NAME = "StorEdgeT3_Cluster";
    private Properties props;
    private String systemName;
    private String ip;
    private int firmware;
    private T3TokenList sysprop;
    private T3TokenList[] unitprop;
    private T3TokenList lunData;
    private T3TokenList slice;
    private ArrayList ibData;
    private long updated;
    private static final String NOT_AVAILABLE_INBAND = "Data not available";
    private static final String UNAVAILABLE_INTEGER = "0";
    private static final String UNAVAILABLE_FLOAT = "0.0";
    private static final String NO_FABRIC_NAME = "0000000000000000";
    private static final String NO_DISKS_DISABLED = "No disks are currently disabled in this volume";
    private static final String NO_DISKS_SUBSTITUTED = "No disks are currently substituted in this volume";
    private static final String FULL_REDUNDANCY = "full";
    private static final String DEGRADED_REDUNDANCY = "degraded";
    private static final String LOST_REDUNDANCY = "lost";
    private static final String PCU_TYPE_NAME = "powerUnit";
    private static final String LOOP_TYPE_NAME = "loopCard";
    private static final String FAN_TYPE_NAME = "fan";
    private static final String DRIVE_TYPE_NAME = "diskDrive";
    private static final String VOLUME_TYPE_NAME = "volume";
    private static final String CONTROLLER_TYPE_NAME = "controller";
    private static final int CONTROLLER = 1;
    private static final int PCU = 2;
    private static final int LOOP = 3;
    private static final int FAN = 4;
    private static final int DRIVE = 5;
    private static final int TEMPSENSOR = 6;
    private static final int VOLUME = 7;
    private static final int MIDPLANE = 8;
    private static final int FIBREPORT = 9;
    private static final int LUN = 10;
    private static final int NUM_T3_UNIT_DRIVES = 9;
    private static final int FIRST_SLICE_RELEASE = 210;
    private static final int MASERATI_FIRMWARE = 30000;
    private static final int DEFAULT_BLOCK_SIZE = 512;
    private static final String DATA_OK = "OK";
    private static final String DATA_STALE = "STALE";
    private static final String DATA_MISSING = "MISSING";
    private static final String TAG = "t3";
    private static final String sccs_id = "@(#)T3ReportGenerator.java\t1.34 10/01/03 SMI";

    public T3ReportGenerator(Properties properties) {
        this.props = properties;
        this.ip = this.props.getProperty("ip");
        this.systemName = this.props.getProperty("name");
    }

    private synchronized void updateSystem() throws T3Exception {
        this.sysprop = this.getTokenList("/sysprop.htm");
        int n = this.sysprop.getIntValue("unitCount");
        this.unitprop = new T3TokenList[n];
        int n2 = 0;
        while (n2 < n) {
            this.unitprop[n2] = this.getTokenList("/elemprop.htm?unitIndex=" + n2);
            ++n2;
        }
        try {
            this.lunData = this.getTokenList("/lun.htm");
            this.slice = this.getTokenList("/slice.htm");
        }
        catch (T3Exception t3Exception) {
            Report.debug.log(TAG, (Object)"Exception accessing lun.htm or slice.htm");
        }
        this.updated = System.currentTimeMillis();
        try {
            this.firmware = this.sysprop.getIntValue("sysRevision");
        }
        catch (NumberFormatException numberFormatException) {
            this.firmware = 0;
        }
    }

    private T3TokenList getTokenList(String string) throws T3Exception {
        String string2 = null;
        if (this.ip != null) {
            T3HttpConnection t3HttpConnection = new T3HttpConnection(this.ip);
            t3HttpConnection.setPath(string);
            string2 = t3HttpConnection.get();
            if (string2.equals("")) {
                Object[] objectArray = new Object[]{this.systemName};
                throw new T3Exception("t3.exception.noData", objectArray);
            }
        } else {
            Object[] objectArray = new Object[]{this.systemName};
            throw new T3Exception("t3.exception.nullIP", objectArray);
        }
        return new T3TokenList(string2);
    }

    private synchronized void updateSystem(int n) throws T3Exception {
        long l = System.currentTimeMillis();
        if (l - this.updated > (long)(n * 1000)) {
            this.updateSystem();
        }
    }

    public void updateIfNeeded() throws T3Exception {
        if (this.updated == 0L) {
            this.updateSystem();
        }
    }

    private ArrayList collectInBandData() {
        ArrayList<DeviceClass> arrayList = null;
        String string = this.props.getProperty("name.ib");
        if (string == null) {
            string = this.props.getProperty("name");
        }
        if (string != null) {
            AgentStore agentStore = new AgentStore();
            Iterator iterator = agentStore.getTarget(string);
            if (iterator.hasNext()) {
                arrayList = new ArrayList<DeviceClass>();
                while (iterator.hasNext()) {
                    DeviceClass deviceClass = (DeviceClass)iterator.next();
                    arrayList.add(deviceClass);
                }
            }
        } else {
            Report.debug.log((Object)("In band name is null for: " + this.systemName));
        }
        return arrayList;
    }

    public String generateReport() {
        DeviceClass deviceClass = null;
        this.ip = this.props.getProperty("ip");
        this.ibData = this.collectInBandData();
        try {
            this.updateSystem();
            deviceClass = this.createNewReport();
        }
        catch (T3Exception t3Exception) {
            deviceClass = ReportHandler.retrieveDeviceClasses((String)this.systemName, (String)TAG);
            if (deviceClass != null) {
                if (this.ibData != null) {
                    this.updateReport(deviceClass);
                } else {
                    deviceClass.setProperty("ReturnCode", "FAILURE");
                }
            }
            if (this.ibData != null) {
                deviceClass = this.createIBOnlyReport();
            }
            String string = "<report ReturnCode=\"FAILURE\">\n<exception Reason=\"Lost Comm\">No OOB or IB data available</exception>\n</report>\n";
            return string;
        }
        catch (Exception exception) {
            Report.debug.log((Object)("Exception while getting OOB data for T3 " + this.systemName + " " + exception.toString()));
        }
        this.sysprop = null;
        this.unitprop = null;
        this.lunData = null;
        this.slice = null;
        this.ibData = null;
        String string = null;
        if (deviceClass != null) {
            string = deviceClass.toXML();
        }
        return string;
    }

    private DeviceClass createNewReport() {
        DeviceClass deviceClass;
        DeviceClass deviceClass2;
        DeviceClass deviceClass3;
        Object object;
        DeviceClass deviceClass4;
        Object object2;
        DeviceClass deviceClass5 = new DeviceClass();
        deviceClass5.setClassName("report");
        deviceClass5.setProperty("ReturnCode", DATA_OK);
        deviceClass5.setProperty("OOB_DATA", DATA_OK);
        if (this.ibData != null) {
            deviceClass5.setProperty("IB_DATA", DATA_OK);
        } else {
            deviceClass5.setProperty("IB_DATA", DATA_MISSING);
        }
        DeviceClass deviceClass6 = deviceClass5.newSubInstance();
        deviceClass6.setClassName("model");
        deviceClass6.setProperty("schema", "CIM2.5");
        deviceClass6.setProperty("view", "system");
        deviceClass6.setProperty("type", "array");
        deviceClass6.setProperty("prefix", "StorEdgeT3");
        deviceClass6.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        deviceClass7.setClassName("SystemView");
        String[] stringArray = new String[this.unitprop.length];
        String string = DATA_OK;
        Vector<DeviceClass> vector = new Vector<DeviceClass>();
        int n = 1;
        while (n <= this.unitprop.length) {
            object2 = new T3Token("u" + n, "unitStatus", this.getUnitStatus(n));
            vector.add((DeviceClass)object2);
            ++n;
        }
        string = T3ClusterStatusCalculator.deriveClusterStatus(vector);
        object2 = deviceClass7.newSubInstance();
        this.addCluster((DeviceClass)object2, string);
        int n2 = 1;
        while (n2 <= this.unitprop.length) {
            DeviceClass deviceClass8;
            Object object3;
            Object object4;
            Object object5;
            DeviceClass deviceClass9;
            DeviceClass deviceClass10;
            int n3;
            deviceClass4 = object2.newSubInstance();
            this.addUnitaryComputerSystem(deviceClass4, n2);
            object = "u" + n2 + "ctr";
            deviceClass3 = deviceClass4.newSubInstance();
            this.addSCSIController(deviceClass3, n2, (String)object);
            deviceClass2 = deviceClass3.newSubInstance();
            this.addTemperatureSensor(deviceClass2, n2, (String)object, "Ctlr");
            this.addPhysicalClasses(deviceClass3, n2, (String)object);
            deviceClass = deviceClass4.newSubInstance();
            this.addFibrePort(deviceClass, n2, "u" + n2 + "p1");
            try {
                n3 = this.sysprop.getIntValue("fruDiskCount");
            }
            catch (T3Exception t3Exception) {
                n3 = 0;
            }
            int n4 = 1;
            while (n4 <= n3 / this.unitprop.length) {
                object = this.firmware >= 30000 ? "u" + n2 + "d0" + n4 : "u" + n2 + "d" + n4;
                DeviceClass deviceClass11 = deviceClass4.newSubInstance();
                this.addDiskDrive(deviceClass11, n2, (String)object);
                deviceClass10 = deviceClass11.newSubInstance();
                this.addTemperatureSensor(deviceClass10, n2, (String)object, "Disk");
                this.addPhysicalClasses(deviceClass11, n2, (String)object);
                ++n4;
            }
            int n5 = 1;
            while (n5 <= 2) {
                object = "u" + n2 + "pcu" + n5;
                deviceClass10 = deviceClass4.newSubInstance();
                this.addPowerSupply(deviceClass10, n2, (String)object);
                deviceClass9 = deviceClass10.newSubInstance();
                this.addSensor(deviceClass9, n2, (String)object, "Power");
                object5 = deviceClass10.newSubInstance();
                this.addBattery((DeviceClass)object5, n2, (String)object);
                object4 = deviceClass10.newSubInstance();
                this.addFan((DeviceClass)object4, n2, (String)object, 1);
                object3 = deviceClass10.newSubInstance();
                this.addFan((DeviceClass)object3, n2, (String)object, 2);
                this.addPhysicalClasses(deviceClass10, n2, (String)object);
                deviceClass8 = deviceClass10.newSubInstance();
                this.addRedundancyGroup(deviceClass8, n2, 4, n5);
                ++n5;
            }
            int n6 = 1;
            while (n6 <= 2) {
                object = "u" + n2 + "l" + n6;
                deviceClass9 = deviceClass4.newSubInstance();
                this.addController(deviceClass9, n2, (String)object);
                object5 = deviceClass9.newSubInstance();
                this.addTemperatureSensor((DeviceClass)object5, n2, (String)object, "Loop");
                this.addCardPhysicalClasses(deviceClass9, n2, (String)object);
                ++n6;
            }
            object = "u" + n2 + "mpn";
            deviceClass9 = deviceClass4.newSubInstance();
            this.addLogicalDevice(deviceClass9, n2, (String)object);
            this.addCardPhysicalClasses(deviceClass9, n2, (String)object);
            object5 = this.unitprop[n2 - 1].findTokensWithKey("volStatus").iterator();
            while (object5.hasNext()) {
                int n7;
                object4 = (T3Token)object5.next();
                object3 = ((T3Token)object4).getPropertyValue();
                if (object3 == null || ((String)object3).equals("deleted")) continue;
                object = ((T3Token)object4).getElementID();
                deviceClass8 = deviceClass4.newSubInstance();
                this.addStorageVolume(deviceClass8, n2, (String)object);
                DeviceClass deviceClass12 = deviceClass8.newSubInstance();
                this.addVolumeStatisticalInformation(deviceClass12, n2, (String)object);
                this.addStorageRedundancyGroup(deviceClass8, n2, (String)object);
                try {
                    n7 = this.slice.getIntValue((String)object, "volSlicingCount");
                }
                catch (Exception exception) {
                    n7 = 0;
                }
                if (n7 > 0) {
                    int n8 = 0;
                    while (n8 < n7) {
                        this.addLogicalDisk(deviceClass4.newSubInstance(), n2, (String)object, n8);
                        ++n8;
                    }
                    continue;
                }
                this.addLogicalDisk(deviceClass4.newSubInstance(), n2, (String)object);
            }
            object4 = deviceClass4.newSubInstance();
            this.addRedundancyGroup((DeviceClass)object4, n2, 2, 0);
            object3 = deviceClass4.newSubInstance();
            this.addRedundancyGroup((DeviceClass)object3, n2, 3, 0);
            ++n2;
        }
        deviceClass4 = object2.newSubInstance();
        this.addSystemStatisticalInformation(deviceClass4);
        if (this.unitprop.length > 1) {
            object = object2.newSubInstance();
            this.addRedundancyGroup((DeviceClass)object, 0, 1, 0);
        }
        int n9 = 1;
        while (n9 <= this.unitprop.length) {
            deviceClass3 = deviceClass7.newSubInstance();
            this.addRedundancyAssociations(deviceClass3, n9, PCU_TYPE_NAME, 0);
            deviceClass2 = deviceClass7.newSubInstance();
            this.addRedundancyAssociations(deviceClass2, n9, FAN_TYPE_NAME, 1);
            deviceClass = deviceClass7.newSubInstance();
            this.addRedundancyAssociations(deviceClass, n9, FAN_TYPE_NAME, 2);
            DeviceClass deviceClass13 = deviceClass7.newSubInstance();
            this.addRedundancyAssociations(deviceClass13, n9, LOOP_TYPE_NAME, 0);
            this.addVolumeRedundancyAssociations(deviceClass7, n9);
            ++n9;
        }
        if (this.unitprop.length > 1) {
            deviceClass3 = deviceClass7.newSubInstance();
            this.addRedundancyAssociations(deviceClass3, 0, CONTROLLER_TYPE_NAME, 0);
        }
        return deviceClass5;
    }

    private void updateReport(DeviceClass deviceClass) {
        Object object;
        DeviceClass deviceClass2;
        Object object2;
        deviceClass.setProperty("IB_DATA", DATA_OK);
        DeviceClass deviceClass3 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"CreationClassName", (String)CLASS_NAME);
        String string = deviceClass.getProperty("OOB_DATA");
        if (DATA_OK.equals(string)) {
            deviceClass.setProperty("OOB_DATA", DATA_STALE);
            ReportTools.xmlAttr((DeviceClass)deviceClass3, (String)"Status", (String)"Lost Comm");
        }
        ArrayList arrayList = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"FCPTARGET.ASSET", (String)"PortWWN");
        int n = 0;
        while (n < arrayList.size()) {
            object2 = (DeviceClass)arrayList.get(n);
            String string2 = object2.getProperty("PortWWN");
            if (string2 != null) {
                deviceClass2 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"PortWWN", (String)string2);
                if (deviceClass2 != null) {
                    this.updateFibrePort(deviceClass2, (DeviceClass)object2);
                } else {
                    object = deviceClass3.newSubInstance();
                    this.addIBOnlyFibrePort((DeviceClass)object, (DeviceClass)object2);
                }
            }
            ++n;
        }
        object2 = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"LUN.ASSET", (String)"LUID");
        int n2 = 0;
        while (n2 < ((ArrayList)object2).size()) {
            deviceClass2 = (DeviceClass)((ArrayList)object2).get(n2);
            object = deviceClass2.getProperty("LUID");
            if (object != null) {
                DeviceClass deviceClass4 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"DeviceID", (String)(object = ((String)object).toUpperCase()));
                if (deviceClass4 != null) {
                    this.updateLogicalDisk(deviceClass4, deviceClass2);
                } else {
                    DeviceClass deviceClass5 = deviceClass3.newSubInstance();
                    this.addIBOnlyLogicalDisk(deviceClass5, deviceClass2);
                }
            }
            ++n2;
        }
    }

    private DeviceClass createIBOnlyReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", DATA_OK);
        deviceClass.setProperty("OOB_DATA", DATA_MISSING);
        deviceClass.setProperty("IB_DATA", DATA_OK);
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("model");
        deviceClass2.setProperty("schema", "CIM2.5");
        deviceClass2.setProperty("view", "system");
        deviceClass2.setProperty("type", "array");
        deviceClass2.setProperty("prefix", "StorEdgeT3");
        deviceClass2.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass3 = deviceClass2.newSubInstance();
        deviceClass3.setClassName("SystemView");
        ArrayList arrayList = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"FCPTARGET.ASSET", (String)"PortWWN");
        ArrayList arrayList2 = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"LUN.ASSET", (String)"LUID");
        DeviceClass deviceClass4 = deviceClass3.newSubInstance();
        this.addIBOnlyCluster(deviceClass4, arrayList.size(), arrayList2.size());
        int n = 0;
        while (n < arrayList.size()) {
            DeviceClass deviceClass5 = (DeviceClass)arrayList.get(n);
            this.addIBOnlyFibrePort(deviceClass4.newSubInstance(), deviceClass5);
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            DeviceClass deviceClass6 = (DeviceClass)arrayList2.get(n2);
            this.addIBOnlyLogicalDisk(deviceClass4.newSubInstance(), deviceClass6);
            ++n2;
        }
        return deviceClass;
    }

    private void addPhysicalClasses(DeviceClass deviceClass, int n, String string) {
        if (ReportUtil.isInstalled(deviceClass)) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            this.addPhysicalPackage(deviceClass2, n, string);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            this.addSlot(deviceClass3, n, string);
            DeviceClass deviceClass4 = deviceClass2.newSubInstance();
            this.addFRU(deviceClass4, n, string);
            DeviceClass deviceClass5 = deviceClass2.newSubInstance();
            this.addLocation(deviceClass5, n, string);
        }
    }

    private void addCardPhysicalClasses(DeviceClass deviceClass, int n, String string) {
        if (ReportUtil.isInstalled(deviceClass)) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            this.addCard(deviceClass2, n, string);
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            this.addSlot(deviceClass3, n, string);
            DeviceClass deviceClass4 = deviceClass2.newSubInstance();
            this.addFRU(deviceClass4, n, string);
            DeviceClass deviceClass5 = deviceClass2.newSubInstance();
            this.addLocation(deviceClass5, n, string);
        }
    }

    private String getUnitStatus(int n) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        String string = T3ClusterStatusCalculator.deriveUnitStatus(t3TokenList, n);
        return string;
    }

    private void addCluster(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("Cluster");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "Status", string);
        this.xmlAttr(deviceClass, "CreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Description", "StorEdge T3");
        this.xmlAttr(deviceClass, "InterconnectAddress", this.sysprop.getStringValue("sysIpAddr"));
        this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.sysprop.getStringValue("sysIpAddr"));
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlAttr(deviceClass, "StripeUnitSize", this.sysprop.getStringValue("sysStripeUnitSize"));
        this.xmlAttr(deviceClass, "CacheMode", this.sysprop.getStringValue("sysCacheMode"));
        this.xmlAttr(deviceClass, "CacheMirror", this.sysprop.getStringValue("sysCacheMirror"));
        this.xmlAttr(deviceClass, "MpSupport", this.sysprop.getStringValue("sysMpSupport"));
        this.xmlIntAttr(deviceClass, "ReadAhead", this.sysprop.getStringValue("sysReadAhead"));
        this.xmlIntAttr(deviceClass, "ReconRate", this.sysprop.getStringValue("sysReconRate"));
        this.xmlIntAttr(deviceClass, "FruRemovalShutDown", this.sysprop.getStringValue("sysFruRemovalShutdown"));
        this.xmlAttr(deviceClass, "SubNet", this.sysprop.getStringValue("sysSubNet"));
        this.xmlAttr(deviceClass, "Gateway", this.sysprop.getStringValue("sysGateway"));
        String string2 = this.sysprop.getStringValue("sysRarpEnabled");
        string2 = "yes".equalsIgnoreCase(string2) ? "true" : "false";
        this.xmlAttr(deviceClass, "RarpEnabled", string2);
        String string3 = this.sysprop.getStringValue("sysHasVolumes");
        string3 = "yes".equalsIgnoreCase(string3) ? "true" : "false";
        this.xmlAttr(deviceClass, "HasVolumes", string3);
        this.xmlAttr(deviceClass, "Loop1Split", this.sysprop.getStringValue("sysLoop1Split"));
        this.xmlAttr(deviceClass, "User", this.sysprop.getStringValue("sysUser"));
        this.xmlIntAttr(deviceClass, "UnitCount", this.sysprop.getStringValue("unitCount"));
        this.xmlIntAttr(deviceClass, "CtlrCount", this.sysprop.getStringValue("fruCtlrCount"));
        this.xmlIntAttr(deviceClass, "MidplaneCount", this.sysprop.getStringValue("fruMidplaneCount"));
        this.xmlIntAttr(deviceClass, "FruCount", this.sysprop.getStringValue("fruCount"));
        this.xmlIntAttr(deviceClass, "PortCount", this.sysprop.getStringValue("portCount"));
        this.xmlIntAttr(deviceClass, "FibrePortCount", this.sysprop.getStringValue("portFibreCount"));
        this.xmlIntAttr(deviceClass, "LoopCount", this.sysprop.getStringValue("fruLoopCount"));
        this.xmlIntAttr(deviceClass, "PowerCount", this.sysprop.getStringValue("fruPowerCount"));
        this.xmlIntAttr(deviceClass, "VolumeCount", this.sysprop.getStringValue("volCount"));
        this.xmlIntAttr(deviceClass, "DiskCount", this.sysprop.getStringValue("fruDiskCount"));
    }

    private void addIBOnlyCluster(DeviceClass deviceClass, int n, int n2) {
        deviceClass.setClassName("Cluster");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "CreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Description", "Sun StorEdge T3 Array");
        this.xmlAttr(deviceClass, "InterconnectAddress", this.ip);
        this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.ip);
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlIntAttr(deviceClass, "PortCount", "" + n);
        this.xmlIntAttr(deviceClass, "FibrePortCount", "" + n);
        if (n > 0) {
            this.xmlIntAttr(deviceClass, "CtlrCount", "" + n);
        }
        if (n2 > 0) {
            this.xmlAttr(deviceClass, "HasVolumes", "true");
        }
        this.xmlAttr(deviceClass, "Loop1Split", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "User", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "UnitCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "MidplaneCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "FruCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "LoopCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "PowerCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "VolumeCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "DiskCount", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "CacheMode", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "CacheMirror", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "MpSupport", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReconRate", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "StripeUnitSize", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "RarpEnabled", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReadAhead", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "FruRemovalShutDown", UNAVAILABLE_INTEGER);
    }

    private void updateCluster(DeviceClass deviceClass, int n, int n2) {
        deviceClass.setClassName("Cluster");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "Status", "Lost Comm");
        this.xmlAttr(deviceClass, "CreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Description", "Sun StorEdge T3 Array");
        this.xmlStringAttr(deviceClass, "InterconnectAddress", this.ip, NOT_AVAILABLE_INBAND);
        this.xmlStringAttr(deviceClass, "OtherIdentifyingInfo", this.ip);
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlIntAttr(deviceClass, "PortCount", "" + n);
        this.xmlIntAttr(deviceClass, "FibrePortCount", "" + n);
        if (n > 0) {
            this.xmlIntAttr(deviceClass, "CtlrCount", "" + n);
        }
        if (n2 > 0) {
            this.xmlAttr(deviceClass, "HasVolumes", "true");
        } else {
            this.xmlAttr(deviceClass, "HasVolumes", "false");
        }
        this.xmlAttr(deviceClass, "Loop1Split", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "User", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "UnitCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "MidplaneCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "FruCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "LoopCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "PowerCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "VolumeCount", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "DiskCount", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "CacheMode", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "CacheMirror", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "MpSupport", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReconRate", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "StripeUnitSize", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "RarpEnabled", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "ReadAhead", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "FruRemovalShutDown", UNAVAILABLE_INTEGER);
    }

    private void addSystemStatisticalInformation(DeviceClass deviceClass) {
        deviceClass.setClassName("SystemStatisticalInformation");
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_SystemStatisticalInformation");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlIntAttr(deviceClass, "TotalRequests", this.sysprop.getStringValue("sysTotalRequests"));
        this.xmlIntAttr(deviceClass, "WriteRequests", this.sysprop.getStringValue("sysWriteRequests"));
        this.xmlIntAttr(deviceClass, "ReadRequests", this.sysprop.getStringValue("sysReadRequests"));
        this.xmlIntAttr(deviceClass, "TotalBlocks", this.sysprop.getStringValue("sysTotalBlocks"));
        this.xmlIntAttr(deviceClass, "BlocksWritten", this.sysprop.getStringValue("sysBlocksWritten"));
        this.xmlIntAttr(deviceClass, "BlocksRead", this.sysprop.getStringValue("sysBlocksRead"));
        this.xmlIntAttr(deviceClass, "CacheWriteHits", this.sysprop.getStringValue("sysCacheWriteHits"));
        this.xmlIntAttr(deviceClass, "CacheWriteMisses", this.sysprop.getStringValue("sysCacheWriteMisses"));
        this.xmlIntAttr(deviceClass, "CacheReadHits", this.sysprop.getStringValue("sysCacheReadHits"));
        this.xmlIntAttr(deviceClass, "CacheReadMisses", this.sysprop.getStringValue("sysCacheReadMisses"));
        this.xmlIntAttr(deviceClass, "CacheRmwFlushes", this.sysprop.getStringValue("sysCacheRmwFlushes"));
        this.xmlIntAttr(deviceClass, "CacheReconFlushes", this.sysprop.getStringValue("sysCacheReconFlushes"));
        this.xmlIntAttr(deviceClass, "CacheStripeFlushes", this.sysprop.getStringValue("sysCacheStripeFlushes"));
        this.xmlFloatAttr(deviceClass, "SecTotalRequests", this.sysprop.getStringValue("sysSecTotalRequests"));
        this.xmlFloatAttr(deviceClass, "SecWriteRequests", this.sysprop.getStringValue("sysSecWriteRequests"));
        this.xmlFloatAttr(deviceClass, "SecReadRequests", this.sysprop.getStringValue("sysSecReadRequests"));
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", this.sysprop.getStringValue("sysSecTotalMBytes"));
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", this.sysprop.getStringValue("sysSecMBytesWritten"));
        this.xmlAttr(deviceClass, "SecMBytesRead", this.sysprop.getStringValue("sysSecMBytesRead"));
        this.xmlStringAttr(deviceClass, "LastRestart", this.sysprop.getStringValue("sysLastRestart"));
    }

    private void addUnitaryComputerSystem(DeviceClass deviceClass, int n) {
        deviceClass.setClassName("UnitaryComputerSystem");
        this.xmlAttr(deviceClass, "Name", "unit" + n);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_UnitaryComputerSystem");
        this.xmlAttr(deviceClass, "Status", DATA_OK);
        this.xmlAttr(deviceClass, "OtherIdentifyingInfo", this.sysprop.getStringValue("sysIpAddr"));
        this.xmlAttr(deviceClass, "IdentifyingDescriptions", "IP Address");
        this.xmlAttr(deviceClass, "UnitIndex", "" + n);
        this.xmlAttr(deviceClass, "UnitType", this.unitprop[n - 1].getStringValue("unitType"));
        String string = this.unitprop[n - 1].getStringValue("unitStandby");
        String string2 = "false";
        if ("yes".equalsIgnoreCase(string)) {
            string2 = "true";
        }
        this.xmlAttr(deviceClass, "IsStandBy", string2);
    }

    private void addLogicalDeviceInternals(DeviceClass deviceClass, int n, String string, int n2) {
        String string2;
        String string3 = "fru";
        switch (n2) {
            case 1: {
                string2 = "StorEdgeT3_SCSIController";
                break;
            }
            case 2: {
                string2 = "StorEdgeT3_UninterruptiblePowerSupply";
                break;
            }
            case 3: {
                string2 = "StorEdgeT3_LoopController";
                break;
            }
            case 5: {
                string2 = "StorEdgeT3_DiskDrive";
                break;
            }
            case 6: {
                string2 = "StorEdgeT3_TemperatureSensor";
                break;
            }
            case 8: {
                string2 = "StorEdgeT3_MidPlaneDevice";
                break;
            }
            case 7: {
                string2 = "StorEdgeT3_StorageVolume";
                string3 = "vol";
                break;
            }
            case 9: {
                string2 = "StorEdgeT3_FibrePort";
                string3 = "port";
                break;
            }
            case 10: {
                string2 = "StorEdgeT3_LogicalDisk";
                string3 = "lun";
                break;
            }
            default: {
                return;
            }
        }
        String string4 = this.unitprop[n - 1].getStringValue(string, string3 + "Status");
        String string5 = this.unitprop[n - 1].getStringValue(string, string3 + "State");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "CreationClassName", string2);
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Status", ReportUtil.convertToCIMStatus(string4));
        if (n2 == 9) {
            this.xmlAttr(deviceClass, "StatusInfo", ReportUtil.convertToCIMStatusInfo(string4));
        } else {
            this.xmlAttr(deviceClass, "StatusInfo", ReportUtil.convertToCIMStatusInfo(string5));
        }
        if (n2 == 7 || n2 == 9) {
            this.xmlAttr(deviceClass, "Availability", ReportUtil.convertToCIMAvailability(string4));
            this.xmlAttr(deviceClass, "Name", this.unitprop[n - 1].getStringValue(string, string3 + "Name"));
        } else {
            this.xmlAttr(deviceClass, "Availability", ReportUtil.convertToCIMAvailability(string4, string5));
            this.xmlAttr(deviceClass, "Name", this.unitprop[n - 1].getStringValue(string, string3 + "Type"));
        }
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
    }

    private void addSCSIController(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("SCSIController");
        this.addLogicalDeviceInternals(deviceClass, n, string, 1);
        this.xmlAttr(deviceClass, "Description", "T3 Controller");
        this.xmlAttr(deviceClass, "REF", string);
        this.xmlStringAttr(deviceClass, "CtlrRole", t3TokenList.getStringValue(string, "fruCtlrRole"));
        String string2 = t3TokenList.getStringValue(string, "fruCtlrPartnerId");
        this.xmlStringAttr(deviceClass, "CtlrPartnerId", string2, "None Defined");
        this.xmlStringAttr(deviceClass, "CtlrCpuDesc", t3TokenList.getStringValue(string, "fruCtlrCpuDesc"));
        this.xmlAttr(deviceClass, "IsExpendable", t3TokenList.getStringValue(string, "fruCtlrIsExpendable"));
        int n2 = 0;
        try {
            n2 = this.unitprop[n - 1].getIntValue(string, "fruCtlrConsoleBaud");
        }
        catch (T3Exception t3Exception) {
            // empty catch block
        }
        this.xmlAttr(deviceClass, "CtlrConsoleBaud", "" + n2);
    }

    private void addLogicalDevice(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("LogicalDevice");
        this.addLogicalDeviceInternals(deviceClass, n, string, 8);
        this.xmlAttr(deviceClass, "Description", "T3 Midplane");
    }

    private void addController(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("Controller");
        this.addLogicalDeviceInternals(deviceClass, n, string, 3);
        this.xmlAttr(deviceClass, "REF", string);
        this.xmlAttr(deviceClass, "LoopMode", this.unitprop[n - 1].getStringValue(string, "fruLoopMode"));
        this.xmlAttr(deviceClass, "LoopCable1State", this.unitprop[n - 1].getStringValue(string, "fruLoopCable1State"));
        this.xmlAttr(deviceClass, "LoopCable2State", this.unitprop[n - 1].getStringValue(string, "fruLoopCable2State"));
        this.xmlAttr(deviceClass, "Description", "T3 LoopController");
    }

    private void addStorageVolume(DeviceClass deviceClass, int n, String string) {
        String string2;
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("StorageVolume");
        this.addLogicalDeviceInternals(deviceClass, n, string, 7);
        this.xmlAttr(deviceClass, "REF", string);
        String string3 = t3TokenList.getStringValue(string, "volRaidLevel");
        if (string3.equalsIgnoreCase("raid0")) {
            string3 = "raid0";
            string2 = "false";
        } else if (string3.equalsIgnoreCase("raid1")) {
            string3 = "raid1";
            string2 = "true";
        } else if (string3.equalsIgnoreCase("raid5")) {
            string3 = "raid5";
            string2 = "true";
        } else {
            string3 = null;
            string2 = null;
        }
        this.xmlAttr(deviceClass, "MountStatus", t3TokenList.getStringValue(string, "volStatus"));
        this.xmlAttr(deviceClass, "RaidLevel", string3);
        this.xmlAttr(deviceClass, "IsBasedOnUnderlyingRedundancy", string2);
        this.xmlAttr(deviceClass, "CacheMode", t3TokenList.getStringValue(string, "volCacheMode"));
        this.xmlAttr(deviceClass, "CacheMirror", t3TokenList.getStringValue(string, "volCacheMirror"));
        this.xmlIntAttr(deviceClass, "OperProgress", t3TokenList.getStringValue(string, "volOperProgress"));
        this.xmlAttr(deviceClass, "Oper", t3TokenList.getStringValue(string, "volOper"));
        this.xmlIntAttr(deviceClass, "InitRate", t3TokenList.getStringValue(string, "volInitRate"));
        this.xmlIntAttr(deviceClass, "VerifyRate", t3TokenList.getStringValue(string, "volVerifyRate"));
        this.xmlIntAttr(deviceClass, "ArrayWidth", t3TokenList.getStringValue(string, "volArrayWidth"));
        this.xmlAttr(deviceClass, "WWN", t3TokenList.getStringValue(string, "volWWN"));
        this.xmlAttr(deviceClass, "Description", "Storage pool");
        String string4 = t3TokenList.getStringValue(string, "volSubstitutedDisk");
        if (string4 == null || "".equals(string4)) {
            string4 = NO_DISKS_SUBSTITUTED;
        }
        this.xmlAttr(deviceClass, "VolumeDiskSubstituted", string4);
        String string5 = t3TokenList.getStringValue(string, "volDisabledDisk");
        if (string5 == null || "".equals(string5)) {
            string5 = NO_DISKS_DISABLED;
        }
        this.xmlAttr(deviceClass, "VolumeDiskDisabled", string5);
    }

    private void addLogicalDisk(DeviceClass deviceClass, int n, String string, int n2) {
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "Description", "Logical partition of a storage pool");
        this.xmlAttr(deviceClass, "SourceVolume", string);
        String string2 = this.slice.getStringValue(string + "-s" + n2, "slice");
        if (string2 == null) {
            return;
        }
        this.xmlAttr(deviceClass, "NumberOfBlocks", this.slice.getStringValue(string2, "volSliceSize"));
        this.xmlAttr(deviceClass, "BlockSize", "512");
        StringBuffer stringBuffer = new StringBuffer(string2);
        this.xmlAttr(deviceClass, "Name", stringBuffer.toString());
        stringBuffer.delete(0, 5);
        String string3 = "lun" + stringBuffer;
        String string4 = this.slice.getStringValue(string2, "volSliceWWN");
        if (string4 != null) {
            string3 = string4.trim().length() == 40 ? string4.substring(8) : string4;
        }
        this.xmlAttr(deviceClass, "DeviceID", string3);
        this.xmlAttr(deviceClass, "REF", string3);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        try {
            n3 = this.slice.getIntValue("sys", "lunMaskNumInitiators");
        }
        catch (T3Exception t3Exception) {
            // empty catch block
        }
        int n4 = 0;
        while (n4 < n3) {
            this.addInitiator(deviceClass, n4, string3);
            ++n4;
        }
    }

    private void addLogicalDisk(DeviceClass deviceClass, int n, String string) {
        DeviceClass deviceClass2;
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "Description", "Logical partition of a storage pool");
        this.xmlAttr(deviceClass, "SourceVolume", string);
        this.xmlAttr(deviceClass, "Name", t3TokenList.getStringValue(string, "volName"));
        String string2 = null;
        String string3 = t3TokenList.getStringValue(string, "volWWN");
        string2 = string3 != null ? (string3.trim().length() == 40 ? string3.substring(8) : string3) : t3TokenList.getStringValue(string, "volId");
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "REF", string2);
        this.xmlAttr(deviceClass, "BlockSize", "512");
        String string4 = t3TokenList.getStringValue(string, "volCapacity");
        long l = ReportUtil.calculateBlockCount(string4, 512, this.systemName, string);
        if (this.ibData != null && (deviceClass2 = ReportTools.findLun((ArrayList)this.ibData, (String)string2)) != null) {
            String string5 = deviceClass2.getProperty("BlockSize");
            String string6 = deviceClass2.getProperty("NumBlocks");
            this.xmlAttr(deviceClass, "NumberOfBlocks", string6);
            this.xmlAttr(deviceClass, "BlockSize", string5);
        }
    }

    private void addIBOnlyLogicalDisk(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_LogicalDisk");
        this.xmlAttr(deviceClass, "Description", "A Logical unit as presented to a host.");
        this.xmlAttr(deviceClass, "Status", "Unknown");
        this.xmlAttr(deviceClass, "SourceVolume", NOT_AVAILABLE_INBAND);
        String string = deviceClass2.getProperty("FcpLunId");
        String string2 = deviceClass2.getProperty("LUID");
        String string3 = deviceClass2.getProperty("BlockSize");
        String string4 = deviceClass2.getProperty("NumBlocks");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "DeviceID", string2.toUpperCase());
        this.xmlAttr(deviceClass, "NumberOfBlocks", string4);
        this.xmlAttr(deviceClass, "BlockSize", string3);
    }

    private void updateLogicalDisk(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = deviceClass2.getProperty("BlockSize");
        String string2 = deviceClass2.getProperty("NumBlocks");
        this.xmlAttr(deviceClass, "NumberOfBlocks", string2);
        this.xmlAttr(deviceClass, "BlockSize", string);
    }

    private void addInitiator(DeviceClass deviceClass, int n, String string) {
        String string2 = null;
        String string3 = null;
        try {
            string2 = this.lunData.getStringValue(string + "Initiator" + n, "lunMaskWWN");
            string3 = this.lunData.getStringValue(string + "Initiator" + n, "lunMaskAccess");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null) {
            return;
        }
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalElement");
        this.xmlAttr(deviceClass2, "CreationClassName", "StorEdgeArray_Initiator");
        this.xmlAttr(deviceClass2, "SystemName", this.systemName);
        this.xmlAttr(deviceClass2, "Name", string + ":" + string2);
        this.xmlAttr(deviceClass2, "Lun", string);
        this.xmlAttr(deviceClass2, "InitiatorWWN", string2);
        this.xmlAttr(deviceClass2, "Access", string3);
    }

    private void addFibrePort(DeviceClass deviceClass, int n, String string) {
        DeviceClass deviceClass2;
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("FibrePort");
        this.addLogicalDeviceInternals(deviceClass, n, string, 9);
        this.xmlAttr(deviceClass, "Description", "Controller Embedded Fibre Channel Port");
        String string2 = t3TokenList.getStringValue(string, "portWWN");
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "PortWWN", string2);
        this.xmlAttr(deviceClass, "PortFruID", "u" + n + "ctr");
        this.xmlAttr(deviceClass, "PortIndex", t3TokenList.getStringValue(string, "portIndex"));
        this.xmlAttr(deviceClass, "CurrentPortType", UNAVAILABLE_INTEGER);
        String string3 = ReportUtil.convertToLogicalString(t3TokenList.getStringValue(string, "portSunHost"));
        this.xmlAttr(deviceClass, "SunHost", string3);
        this.xmlAttr(deviceClass, "FibreAlpaMode", t3TokenList.getStringValue(string, "portFibreAlpaMode"));
        this.xmlIntAttr(deviceClass, "FibreAlpa", t3TokenList.getStringValue(string, "portFibreAlpa"));
        this.xmlIntAttr(deviceClass, "TotalRequests", t3TokenList.getStringValue(string, "portTotalRequests"));
        this.xmlIntAttr(deviceClass, "WriteRequests", t3TokenList.getStringValue(string, "portWriteRequests"));
        this.xmlIntAttr(deviceClass, "ReadRequests", t3TokenList.getStringValue(string, "portReadRequests"));
        this.xmlIntAttr(deviceClass, "BlocksWritten", t3TokenList.getStringValue(string, "portBlocksWritten"));
        this.xmlIntAttr(deviceClass, "BlocksRead", t3TokenList.getStringValue(string, "portBlocksRead"));
        this.xmlIntAttr(deviceClass, "TotalBlocks", t3TokenList.getStringValue(string, "portTotalBlocks"));
        String string4 = t3TokenList.getStringValue(string, "portSecTotalRequests");
        this.xmlIntAttr(deviceClass, "SecTotalRequests", ReportUtil.truncate(string4));
        string4 = t3TokenList.getStringValue(string, "portSecWriteRequests");
        this.xmlIntAttr(deviceClass, "SecWriteRequests", ReportUtil.truncate(string4));
        string4 = t3TokenList.getStringValue(string, "portSecReadRequests");
        this.xmlIntAttr(deviceClass, "SecReadRequests", ReportUtil.truncate(string4));
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", t3TokenList.getStringValue(string, "portSecTotalMBytes"));
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", t3TokenList.getStringValue(string, "portSecMBytesWritten"));
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", t3TokenList.getStringValue(string, "portSecMBytesRead"));
        this.xmlAttr(deviceClass, "AttachVolOwner0", t3TokenList.getStringValue(string + "-a-0", "attachVolOwner"));
        this.xmlAttr(deviceClass, "AttachVolOwner1", t3TokenList.getStringValue(string + "-a-1", "attachVolOwner"));
        this.xmlAttr(deviceClass, "AttachVolName0", t3TokenList.getStringValue(string + "-a-0", "attachVolName"));
        this.xmlAttr(deviceClass, "AttachVolName1", t3TokenList.getStringValue(string + "-a-1", "attachVolName"));
        DeviceClass deviceClass3 = deviceClass.newSubInstance();
        deviceClass3.setClassName("ProtocolEndpoint");
        this.xmlAttr(deviceClass3, "Name", t3TokenList.getStringValue(string, "portWWN"));
        this.xmlAttr(deviceClass3, "NameFormat", "WWN");
        this.xmlAttr(deviceClass3, "ProtocolType", "Fibre Channel");
        if (this.ibData != null && (deviceClass2 = ReportTools.findPort((ArrayList)this.ibData, (String)string2)) != null) {
            DeviceClass deviceClass4;
            String string5 = deviceClass2.getProperty("PortType");
            this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string5));
            String string6 = deviceClass2.getProperty("PortSupportedSpeed");
            this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string6));
            String string7 = deviceClass2.getProperty("PortSpeed");
            this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string7));
            String string8 = deviceClass2.getProperty("FabricName");
            if (NO_FABRIC_NAME.equals(string8) && (deviceClass4 = deviceClass2.getParent()) != null) {
                DeviceClass deviceClass5 = deviceClass3.newSubInstance();
                deviceClass5.setClassName("ProtocolEndpoint");
                this.xmlAttr(deviceClass5, "Name", deviceClass4.getProperty("portWWN"));
                this.xmlAttr(deviceClass5, "NameFormat", "WWN");
                this.xmlAttr(deviceClass5, "ProtocolType", "Fibre Channel");
            }
        }
    }

    private void addIBOnlyFibrePort(DeviceClass deviceClass, DeviceClass deviceClass2) {
        DeviceClass deviceClass3;
        deviceClass.setClassName("FibrePort");
        this.xmlAttr(deviceClass, "Description", "Controller Embedded Fibre Channel Port");
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_FibrePort");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
        String string = deviceClass2.getProperty("PortFcID");
        String string2 = deviceClass2.getProperty("PortWWN");
        String string3 = deviceClass2.getProperty("PortState");
        String string4 = deviceClass2.getProperty("PortType");
        String string5 = deviceClass2.getProperty("PortSpeed");
        String string6 = deviceClass2.getProperty("PortSupportedSpeed");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "PortWWN", string2);
        this.xmlAttr(deviceClass, "Status", RHBAConverter.derivePortStatus((String)string3));
        this.xmlAttr(deviceClass, "State", RHBAConverter.derivePortState((String)string3));
        this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string4));
        this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string5));
        this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string6));
        this.xmlAttr(deviceClass, "PortIndex", UNAVAILABLE_INTEGER);
        this.xmlAttr(deviceClass, "PortFruID", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "SunHost", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "FibreAlpaMode", NOT_AVAILABLE_INBAND);
        this.xmlIntAttr(deviceClass, "FibreAlpa", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "TotalRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "WriteRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "ReadRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "BlocksWritten", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "BlocksRead", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "TotalBlocks", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "SecTotalRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "SecWriteRequests", UNAVAILABLE_INTEGER);
        this.xmlIntAttr(deviceClass, "SecReadRequests", UNAVAILABLE_INTEGER);
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", UNAVAILABLE_FLOAT);
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", UNAVAILABLE_FLOAT);
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", UNAVAILABLE_FLOAT);
        this.xmlAttr(deviceClass, "AttachVolOwner0", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "AttachVolOwner1", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "AttachVolName0", NOT_AVAILABLE_INBAND);
        this.xmlAttr(deviceClass, "AttachVolName1", NOT_AVAILABLE_INBAND);
        DeviceClass deviceClass4 = deviceClass.newSubInstance();
        deviceClass4.setClassName("ProtocolEndpoint");
        this.xmlAttr(deviceClass4, "Name", string2);
        this.xmlAttr(deviceClass4, "NameFormat", "WWN");
        this.xmlAttr(deviceClass4, "ProtocolType", "Fibre Channel");
        String string7 = deviceClass2.getProperty("FabricName");
        if (NO_FABRIC_NAME.equals(string7) && (deviceClass3 = deviceClass2.getParent()) != null) {
            DeviceClass deviceClass5 = deviceClass4.newSubInstance();
            deviceClass5.setClassName("ProtocolEndpoint");
            this.xmlAttr(deviceClass5, "Name", deviceClass3.getProperty("portWWN"));
            this.xmlAttr(deviceClass5, "NameFormat", "WWN");
            this.xmlAttr(deviceClass5, "ProtocolType", "Fibre Channel");
        }
    }

    private void updateFibrePort(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = deviceClass2.getProperty("PortState");
        String string2 = deviceClass2.getProperty("PortType");
        String string3 = deviceClass2.getProperty("PortSpeed");
        String string4 = deviceClass2.getProperty("PortSupportedSpeed");
        this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string2));
        this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string4));
        this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string3));
        this.xmlAttr(deviceClass, "Status", RHBAConverter.derivePortStatus((String)string));
        this.xmlAttr(deviceClass, "Availability", RHBAConverter.derivePortAvailability((String)string));
    }

    private void xmlAttr(DeviceClass deviceClass, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        deviceClass.setProperty(string, string2);
    }

    private void xmlStringAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void xmlStringAttr(DeviceClass deviceClass, String string, String string2, String string3) {
        if (string2 == null) {
            string2 = string3 != null ? string3 : "";
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void xmlIntAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = UNAVAILABLE_INTEGER;
        } else {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = UNAVAILABLE_INTEGER;
            }
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void xmlFloatAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = UNAVAILABLE_FLOAT;
        } else {
            try {
                Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = UNAVAILABLE_FLOAT;
            }
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    private void addDiskDrive(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("DiskDrive");
        this.addLogicalDeviceInternals(deviceClass, n, string, 5);
        this.xmlAttr(deviceClass, "REF", string);
        String string2 = t3TokenList.getStringValue(string, "fruDiskStatusCode");
        if (string2 != null) {
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = UNAVAILABLE_INTEGER;
            }
        } else {
            string2 = UNAVAILABLE_INTEGER;
        }
        this.xmlAttr(deviceClass, "LastErrorCode", string2);
        this.xmlAttr(deviceClass, "ErrorDescription", ReportUtil.translateDiskCode(string2));
        String string3 = t3TokenList.getStringValue(string, "fruErrors");
        String string4 = "false";
        if (UNAVAILABLE_INTEGER.equals(string3)) {
            string4 = "true";
        }
        this.xmlAttr(deviceClass, "ErrorCleared", string4);
        this.xmlAttr(deviceClass, "NeedsCleaning", "false");
        this.xmlAttr(deviceClass, "Description", "T3 DiskDrive");
        this.xmlAttr(deviceClass, "NumberOfMediaSupported", "1");
        String string5 = t3TokenList.getStringValue(string, "fruDiskCapacity");
        if (string5 != null) {
            this.xmlAttr(deviceClass, "MaxMediaSize", ReportUtil.truncate(string5));
        }
        this.xmlAttr(deviceClass, "DiskPort1State", t3TokenList.getStringValue(string, "fruDiskPort1State"));
        this.xmlAttr(deviceClass, "DiskPort2State", t3TokenList.getStringValue(string, "fruDiskPort2State"));
        String string6 = t3TokenList.getStringValue(string, "fruDiskRole");
        this.xmlAttr(deviceClass, "DiskRole", string6);
        String string7 = t3TokenList.getStringValue(string, "fruDiskVolId");
        String string8 = t3TokenList.getStringValue(string, "fruDiskVolIndex");
        String string9 = t3TokenList.getStringValue(string, "fruDiskVolName");
        if (string7 != null && string6 != null && ("dataDisk".equals(string6) || "standbyDisk".equals(string6))) {
            this.xmlAttr(deviceClass, "VolId", string7);
            this.xmlIntAttr(deviceClass, "VolIndex", string8);
            this.xmlAttr(deviceClass, "VolName", string9);
        }
        String string10 = t3TokenList.getStringValue(string, "fruDiskIsExpendable");
        String string11 = "true";
        if ("no".equalsIgnoreCase(string10)) {
            string11 = "false";
        }
        this.xmlAttr(deviceClass, "IsExpendable", string11);
        string10 = t3TokenList.getStringValue(string, "fruDiskIsRebuildable");
        string11 = "true";
        if ("no".equalsIgnoreCase(string10)) {
            string11 = "false";
        }
        this.xmlAttr(deviceClass, "IsRebuildable", string11);
    }

    private void addPowerSupply(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("UninterruptiblePowerSupply");
        this.addLogicalDeviceInternals(deviceClass, n, string, 2);
        this.xmlAttr(deviceClass, "REF", string);
        this.xmlAttr(deviceClass, "Description", "T3 Power Supply");
        this.xmlAttr(deviceClass, "PowerOutput", t3TokenList.getStringValue(string, "fruPowerPowOutput"));
        this.xmlAttr(deviceClass, "PowerSource", t3TokenList.getStringValue(string, "fruPowerPowSource"));
    }

    private void addBattery(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        String string2 = t3TokenList.getStringValue(string, "fruPowerBatState");
        deviceClass.setClassName("Battery");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string + ":Battery");
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
        this.xmlAttr(deviceClass, "Availability", ReportUtil.convertToCIMAvailability(string2));
        this.xmlAttr(deviceClass, "StatusInfo", ReportUtil.convertToCIMStatusInfo(string2));
        this.xmlAttr(deviceClass, "Name", t3TokenList.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_Battery");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Status", ReportUtil.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Description", "PCU Battery");
        this.xmlIntAttr(deviceClass, "BatteryLife", t3TokenList.getStringValue(string, "fruPowerBatLife"));
        this.xmlIntAttr(deviceClass, "BatteryLifeUsed", t3TokenList.getStringValue(string, "fruPowerBatUsed"));
    }

    private void addFan(DeviceClass deviceClass, int n, String string, int n2) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        String string2 = t3TokenList.getStringValue(string, "fruStatus");
        String string3 = t3TokenList.getStringValue(string, "fruPowerFan" + n2 + "State");
        deviceClass.setClassName("Fan");
        this.xmlAttr(deviceClass, "REF", string + ":Fan" + n2);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string + ":Fan" + n2);
        this.xmlAttr(deviceClass, "PowerManagementSupported", "false");
        this.xmlAttr(deviceClass, "StatusInfo", ReportUtil.convertToCIMStatusInfo(string3));
        this.xmlAttr(deviceClass, "Name", "" + n2);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_Fan");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Status", ReportUtil.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Availability", ReportUtil.convertToCIMAvailability(string2, string3));
        this.xmlAttr(deviceClass, "Description", "PCU Fan");
        this.xmlAttr(deviceClass, "VariableSpeed", "false");
        this.xmlAttr(deviceClass, "ActiveCooling", "true");
    }

    private void addTemperatureSensor(DeviceClass deviceClass, int n, String string, String string2) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("TemperatureSensor");
        this.addLogicalDeviceInternals(deviceClass, n, string, 6);
        this.xmlAttr(deviceClass, "DeviceID", string + ":TempSensor");
        this.xmlAttr(deviceClass, "Caption", "Temperature Sensor");
        if ("Power".equals(string2)) {
            this.xmlAttr(deviceClass, "Description", "Monitors the current temperature state");
            this.xmlAttr(deviceClass, "CurrentState", t3TokenList.getStringValue(string, "fru" + string2 + "PowTemp"));
        } else {
            this.xmlAttr(deviceClass, "Description", "Measures the current temperature");
            String string3 = t3TokenList.getStringValue(string, "fru" + string2 + "Temp");
            if (string3 != null) {
                this.xmlAttr(deviceClass, "CurrentReading", ReportUtil.truncate(string3));
            }
            this.xmlAttr(deviceClass, "BaseUnits", "2");
        }
    }

    private void addSensor(DeviceClass deviceClass, int n, String string, String string2) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("Sensor");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_Sensor");
        this.xmlAttr(deviceClass, "DeviceID", string + ":TempSensor");
        this.xmlAttr(deviceClass, "Caption", "Temperature Sensor");
        this.xmlAttr(deviceClass, "Description", "Sensor monitors the state of the power supply temperature.");
        this.xmlIntAttr(deviceClass, "SensorType", "2");
        String string3 = t3TokenList.getStringValue(string, "fru" + string2 + "PowTemp");
        this.xmlStringAttr(deviceClass, "CurrentState", string3, "Unknown");
    }

    private void addPhysicalPackage(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("PhysicalPackage");
        this.addPhysicalPackageInternals(deviceClass, n, string);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_PhysicalPackage");
    }

    private void addPhysicalPackageInternals(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        String string2 = t3TokenList.getStringValue(string, "fruStatus");
        String string3 = t3TokenList.getStringValue(string, "fruVendor");
        String string4 = t3TokenList.getStringValue(string, "fruModel");
        String string5 = t3TokenList.getStringValue(string, "fruSerialNo");
        string3 = string3 == null ? "" : string3.trim();
        string4 = string4 == null ? "" : string4.trim();
        string5 = string5 == null ? "" : string5.trim();
        this.xmlAttr(deviceClass, "Manufacturer", string3);
        this.xmlAttr(deviceClass, "Model", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string5);
        this.xmlAttr(deviceClass, "Tag", string3 + "." + string4 + "." + string5);
        this.xmlAttr(deviceClass, "Version", t3TokenList.getStringValue(string, "fruRevision"));
        this.xmlAttr(deviceClass, "Name", t3TokenList.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "Status", ReportUtil.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "Removable", "true");
        this.xmlAttr(deviceClass, "Replaceable", "true");
        this.xmlAttr(deviceClass, "HotSwappable", "");
    }

    private void addCard(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("Card");
        this.addPhysicalPackageInternals(deviceClass, n, string);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_Card");
        this.xmlAttr(deviceClass, "HostingBoard", "");
        this.xmlAttr(deviceClass, "RequiresDaughterBoard", "");
    }

    private void addSlot(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        String string2 = t3TokenList.getStringValue(string, "fruStatus");
        String string3 = t3TokenList.getStringValue(string, "fruVendor");
        String string4 = t3TokenList.getStringValue(string, "fruModel");
        String string5 = t3TokenList.getStringValue(string, "fruSerialNo");
        string3 = string3 == null ? "" : string3.trim();
        string4 = string4 == null ? "" : string4.trim();
        string5 = string5 == null ? "" : string5.trim();
        deviceClass.setClassName("Slot");
        this.xmlAttr(deviceClass, "Manufacturer", string3);
        this.xmlAttr(deviceClass, "Model", string4);
        this.xmlAttr(deviceClass, "SerialNumber", string5);
        this.xmlAttr(deviceClass, "Tag", string3 + "." + string4 + "." + string5);
        this.xmlAttr(deviceClass, "Version", t3TokenList.getStringValue(string, "fruRevision"));
        this.xmlAttr(deviceClass, "Name", t3TokenList.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_Slot");
        this.xmlAttr(deviceClass, "Status", ReportUtil.convertToCIMStatus(string2));
        this.xmlAttr(deviceClass, "SupportsHotPlug", "true");
    }

    private void addFRU(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("FRU");
        this.xmlAttr(deviceClass, "FRUNumber", t3TokenList.getStringValue(string, "fruIndex"));
        this.xmlAttr(deviceClass, "IdentifyingNumber", string);
        this.xmlAttr(deviceClass, "Name", t3TokenList.getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "Vendor", t3TokenList.getStringValue(string, "fruVendor"));
        this.xmlAttr(deviceClass, "RevisionLevel", t3TokenList.getStringValue(string, "fruRevision"));
    }

    private void addLocation(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("Location");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "PhysicalPosition", this.unitprop[n - 1].getStringValue(string, "fruIndex"));
        this.xmlAttr(deviceClass, "Address", "");
    }

    private void addDeviceErrorCounts(DeviceClass deviceClass, int n, String string, String string2) {
        deviceClass.setClassName("DeviceErrorCounts");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "Name", this.unitprop[n - 1].getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "DeviceCreationClassName", string2);
    }

    private void addDeviceStatisticalInformation(DeviceClass deviceClass, int n, String string) {
        deviceClass.setClassName("DeviceStatisticalInformation");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "Name", this.unitprop[n - 1].getStringValue(string, "fruType"));
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
    }

    private void addVolumeStatisticalInformation(DeviceClass deviceClass, int n, String string) {
        T3TokenList t3TokenList = this.unitprop[n - 1];
        deviceClass.setClassName("DeviceStatisticalInformation");
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_VolumeStatisticalInformation");
        this.xmlAttr(deviceClass, "DeviceCreationClassName", "StorEdgeT3_VolumeSet");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "DeviceID", string);
        this.xmlAttr(deviceClass, "Name", t3TokenList.getStringValue(string, "volName"));
        this.xmlIntAttr(deviceClass, "ReadRequests", t3TokenList.getStringValue(string, "volReadRequests"));
        this.xmlIntAttr(deviceClass, "WriteRequests", t3TokenList.getStringValue(string, "volWriteRequests"));
        this.xmlIntAttr(deviceClass, "TotalRequests", t3TokenList.getStringValue(string, "volTotalRequests"));
        this.xmlIntAttr(deviceClass, "TotalBlocks", t3TokenList.getStringValue(string, "volTotalBlocks"));
        this.xmlIntAttr(deviceClass, "BlocksWritten", t3TokenList.getStringValue(string, "volBlocksWritten"));
        this.xmlIntAttr(deviceClass, "BlocksRead", t3TokenList.getStringValue(string, "volBlocksRead"));
        this.xmlIntAttr(deviceClass, "CacheWriteHits", t3TokenList.getStringValue(string, "volCacheWriteHits"));
        this.xmlIntAttr(deviceClass, "CacheWriteMisses", t3TokenList.getStringValue(string, "volCacheWriteMisses"));
        this.xmlIntAttr(deviceClass, "CacheReadHits", t3TokenList.getStringValue(string, "volCacheReadHits"));
        this.xmlIntAttr(deviceClass, "CacheReadMisses", t3TokenList.getStringValue(string, "volCacheReadMisses"));
        this.xmlIntAttr(deviceClass, "CacheRmwFlushes", t3TokenList.getStringValue(string, "volCacheRmwFlushes"));
        this.xmlIntAttr(deviceClass, "CacheReconFlushes", t3TokenList.getStringValue(string, "volCacheReconFlushes"));
        this.xmlIntAttr(deviceClass, "CacheStripeFlushes", t3TokenList.getStringValue(string, "volCacheStripeFlushes"));
        this.xmlFloatAttr(deviceClass, "SecTotalRequests", t3TokenList.getStringValue(string, "volSecTotalRequests"));
        this.xmlFloatAttr(deviceClass, "SecWriteRequests", t3TokenList.getStringValue(string, "volSecWriteRequests"));
        this.xmlFloatAttr(deviceClass, "SecReadRequests", t3TokenList.getStringValue(string, "volSecReadRequests"));
        this.xmlFloatAttr(deviceClass, "SecTotalMBytes", t3TokenList.getStringValue(string, "volSecTotalMBytes"));
        this.xmlFloatAttr(deviceClass, "SecMBytesWritten", t3TokenList.getStringValue(string, "volSecMBytesWritten"));
        this.xmlFloatAttr(deviceClass, "SecMBytesRead", t3TokenList.getStringValue(string, "volSecMBytesRead"));
        this.xmlIntAttr(deviceClass, "SoftErrors", t3TokenList.getStringValue(string, "volSoftErrors"));
        this.xmlIntAttr(deviceClass, "FirmErrors", t3TokenList.getStringValue(string, "volFirmErrors"));
        this.xmlIntAttr(deviceClass, "HardErrors", t3TokenList.getStringValue(string, "volHardErrors"));
    }

    private void addRedundancyGroup(DeviceClass deviceClass, int n, int n2, int n3) {
        int n4;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        int n5 = n - 1;
        int n6 = n - 1;
        String string8 = "ready";
        String string9 = "enabled";
        switch (n2) {
            case 3: {
                string7 = "u" + n + LOOP_TYPE_NAME;
                string6 = "u" + n + "l1";
                string5 = "fruStatus";
                string4 = "fruState";
                string3 = "u" + n + "l2";
                string2 = "fruStatus";
                string = "fruState";
                break;
            }
            case 2: {
                string7 = "u" + n + PCU_TYPE_NAME;
                string6 = "u" + n + "pcu1";
                string5 = "fruStatus";
                string4 = "fruState";
                string3 = "u" + n + "pcu2";
                string2 = "fruStatus";
                string = "fruState";
                break;
            }
            case 4: {
                string7 = "u" + n + PCU_TYPE_NAME + n3 + FAN_TYPE_NAME;
                string6 = "u" + n + "pcu" + n3;
                string5 = null;
                string4 = "fruPowerFan1State";
                string3 = "u" + n + "pcu" + n3;
                string2 = null;
                string = "fruPowerFan2State";
                string8 = "normal";
                break;
            }
            case 1: {
                string7 = CONTROLLER_TYPE_NAME;
                string6 = "u1ctr";
                string5 = "fruStatus";
                string4 = "fruState";
                n5 = 0;
                string3 = "u2ctr";
                string2 = "fruStatus";
                string = "fruState";
                n6 = 1;
                break;
            }
            default: {
                return;
            }
        }
        String string10 = this.unitprop[n5].getStringValue(string6, string4);
        String string11 = this.unitprop[n6].getStringValue(string3, string);
        if (string9.equals(string10) && string9.equals(string11)) {
            n4 = 2;
            if (n2 != 4) {
                String string12 = this.unitprop[n5].getStringValue(string6, string5);
                String string13 = this.unitprop[n6].getStringValue(string3, string2);
                if (!string8.equals(string12) || !string8.equals(string13)) {
                    n4 = 4;
                }
            }
        } else {
            n4 = 4;
        }
        deviceClass.setClassName("RedundancyGroup");
        this.xmlAttr(deviceClass, "REF", string7);
        this.xmlAttr(deviceClass, "Name", string7);
        this.xmlAttr(deviceClass, "RedundancyStatus", "" + n4);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdgeT3_RedundancyGroup");
    }

    private void addStorageRedundancyGroup(DeviceClass deviceClass, int n, String string) {
        String string2 = "ready";
        String string3 = "enabled";
        int n2 = 0;
        String string4 = this.unitprop[n - 1].getStringValue(string, "volRaidLevel");
        if ("raid1".equals(string4) || "raid5".equals(string4)) {
            Object object;
            int n3;
            n2 = 2;
            try {
                n3 = this.unitprop[n - 1].getIntValue(string, "volArrayWidth");
            }
            catch (T3Exception t3Exception) {
                n3 = 0;
                n2 = 0;
            }
            int n4 = 0;
            while (n4 < n3) {
                object = string + "-d" + n4;
                String string5 = this.unitprop[n - 1].getStringValue((String)object, "volDiskFruId");
                if (string5 != null) {
                    String string6 = this.unitprop[n - 1].getStringValue(string5, "fruState");
                    String string7 = this.unitprop[n - 1].getStringValue(string5, "fruStatus");
                    if (!string2.equals(string7) || !string3.equals(string6)) {
                        n2 = 4;
                    }
                }
                ++n4;
            }
            object = deviceClass.newSubInstance();
            object.setClassName("RedundancyGroup");
            this.xmlAttr((DeviceClass)object, "REF", string + "Group");
            this.xmlAttr((DeviceClass)object, "Name", string + "Group");
            this.xmlAttr((DeviceClass)object, "RedundancyStatus", "" + n2);
            this.xmlAttr((DeviceClass)object, "CreationClassName", "StorEdgeArray_RedundancyGroup");
        }
    }

    private void addRedundancyAssociations(DeviceClass deviceClass, int n, String string, int n2) {
        String[] stringArray;
        String string2 = null;
        if (LOOP_TYPE_NAME.equals(string)) {
            string2 = "u" + n + LOOP_TYPE_NAME;
            stringArray = new String[]{"u" + n + "l" + 1, "u" + n + "l" + 2};
        } else if (PCU_TYPE_NAME.equals(string)) {
            string2 = "u" + n + PCU_TYPE_NAME;
            stringArray = new String[]{"u" + n + "pcu" + 1, "u" + n + "pcu" + 2};
        } else if (FAN_TYPE_NAME.equals(string)) {
            string2 = "u" + n + PCU_TYPE_NAME + n2 + FAN_TYPE_NAME;
            stringArray = new String[]{"u" + n + "pcu" + n2 + ":Fan" + 1, "u" + n + "pcu" + n2 + ":Fan" + 2};
        } else if (DRIVE_TYPE_NAME.equals(string)) {
            string2 = "u" + n + DRIVE_TYPE_NAME;
            stringArray = new String[9];
            int n3 = 0;
            while (n3 < 9) {
                stringArray[n3] = "u" + n + "d" + (n3 + 1);
                ++n3;
            }
        } else if (CONTROLLER_TYPE_NAME.equals(string)) {
            string2 = CONTROLLER_TYPE_NAME;
            stringArray = new String[]{"u1ctr", "u2ctr"};
        } else {
            return;
        }
        deviceClass.setClassName("RedundancyComponent");
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("GroupComponent");
        this.xmlAttr(deviceClass2, "REF", string2);
        int n4 = 0;
        while (n4 < stringArray.length) {
            DeviceClass deviceClass3 = deviceClass.newSubInstance();
            deviceClass3.setClassName("PartComponent");
            this.xmlAttr(deviceClass3, "REF", stringArray[n4]);
            ++n4;
        }
    }

    private void addVolumeRedundancyAssociations(DeviceClass deviceClass, int n) {
        Iterator iterator = this.unitprop[n - 1].findTokensWithKey("volStatus").iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            int n2;
            String string;
            String string2;
            T3Token t3Token = (T3Token)iterator.next();
            String string3 = t3Token.getPropertyValue();
            if (string3 == null || string3.equals("deleted") || !"raid1".equals(string2 = this.unitprop[n - 1].getStringValue(string = t3Token.getElementID(), "volRaidLevel")) && !"raid5".equals(string2)) continue;
            try {
                n2 = this.unitprop[n - 1].getIntValue(string, "volArrayWidth");
            }
            catch (T3Exception t3Exception) {
                n2 = 0;
            }
            Vector<DeviceClass> vector = new Vector<DeviceClass>();
            int n3 = 0;
            while (n3 < n2) {
                object2 = string + "-d-" + n3;
                object = this.unitprop[n - 1].getStringValue((String)object2, "volDiskFruId");
                if (object != null) {
                    vector.add((DeviceClass)object);
                }
                ++n3;
            }
            object2 = deviceClass.newSubInstance();
            object2.setClassName("RedundancyComponent");
            object = object2.newSubInstance();
            object.setClassName("GroupComponent");
            this.xmlAttr((DeviceClass)object, "REF", string + "Group");
            int n4 = 0;
            while (n4 < vector.size()) {
                DeviceClass deviceClass2 = object2.newSubInstance();
                deviceClass2.setClassName("PartComponent");
                this.xmlAttr(deviceClass2, "REF", (String)vector.get(n4));
                ++n4;
            }
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        if (stringArray.length > 1) {
            properties.setProperty("ip", stringArray[0]);
            properties.setProperty("name", stringArray[1]);
            T3ReportGenerator t3ReportGenerator = new T3ReportGenerator(properties);
            String string = t3ReportGenerator.generateReport();
            System.out.println(string);
        } else {
            System.out.println("Usage: T3ReportGenerator <ip address> <system name>");
        }
    }

    public static class Test
    extends UnitTest {
        public void testCreator() {
            Properties properties = new Properties();
            properties.setProperty("ip", "localhost");
            T3ReportGenerator t3ReportGenerator = new T3ReportGenerator(properties);
        }
    }
}

