/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.io;

import com.sun.jade.device.array.t3.io.SUN_T300_MIBOidTable;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class T3snmp {
    private static String[] sysProp = new String[]{"sysId", "sysRevision", "sysVendor", "sysModel", "sysLastRestart", "sysStripeUnitSize", "sysCacheMode", "sysCacheMirror", "sysMpSupport", "sysReadAhead", "sysReconRate", "sysLoop1Split", "sysOndgMode", "sysOndgTimeslice", "sysFruRemovalShutdown", "sysRarpEnabled", "sysIpAddr", "sysSubNet", "sysGateway", "sysBootMode", "sysBootDelay", "sysTftpHost", "sysTftpFile", "sysTimezone", "sysDate", "sysTime", "sysCtime", "sysWriteRequests", "sysReadRequests", "sysBlocksWritten", "sysBlocksRead", "sysCacheWriteHits", "sysCacheWriteMisses", "sysCacheReadHits", "sysCacheReadMisses", "sysCacheRmwFlushes", "sysCacheReconFlushes", "sysCacheStripeFlushes", "sysHasVolumes", "unitCount", "fruCtlrCount", "fruMidplaneCount", "fruCount", "portCount", "portFibreCount", "volCount", "loopCount", "fruDiskCount", "fruLoopCount", "fruPowerCount"};
    private static String[] ondgOper = new String[]{"ondgOper", "ondgOperProgress", "ondgOperPending", "ondgError"};
    private static String[] unitProp = new String[]{"unitIndex", "unitId", "unitType", "unitStandby"};
    private static String[] fruProp = new String[]{"fruId", "fruIndex", "fruType", "fruStatus", "fruState", "fruVendor", "fruModel", "fruRevision", "fruSerialNo", "fruErrors"};
    private static String[] diskProp = new String[]{"fruDiskRole", "fruDiskPort1State", "fruDiskPort2State", "fruDiskCapacity", "fruDiskStatusCode", "fruDiskVolName", "fruDiskTemp"};
    private static String[] ctrlProp = new String[]{"fruCtlrCpuDesc", "fruCtlrRole", "fruCtlrPartnerId", "fruCtlrCtState", "fruCtlrCacheSize", "fruCtlrTemp", "fruCtlrMdate", "fruCtlrConsoleBaud"};
    private static String[] mpnProp = new String[]{"fruMidplaneMdat"};
    private static String[] loopProp = new String[]{"fruLoopMode", "fruLoopTemp", "fruLoopCable1State", "fruLoopCable2State", "fruLoopMdate"};
    private static String[] pcuProp = new String[]{"fruPowerPowOutput", "fruPowerPowSource", "fruPowerPowTemp", "fruPowerFan1State", "fruPowerFan2State", "fruPowerBatState", "fruPowerBatLife", "fruPowerBatUsed", "fruPowerPowMdate", "fruPowerBatMdate"};
    private static String[] portProp = new String[]{"portIndex", "portId", "portType", "portFruId", "portWriteRequests", "portReadRequests", "portBlocksWritten", "portBlocksRead", "portSunHost", "portWWN", "portStatus", "portErrors"};
    private static String[] volProp = new String[]{"volIndex", "volId", "volName", "volWWN", "volStatus", "volCacheMode", "volCacheMirror", "volCapacity", "volArrayWidth", "volRaidLevel", "volWriteRequests", "volReadRequests", "volBlocksWritten", "volBlocksRead", "volSoftErrors", "volFirmErrors", "volHardErrors", "volCacheWriteHits", "volCacheWriteMisses", "volCacheReadHits", "volCacheReadMisses", "volCacheRmwFlushes", "volCacheReconFlushes", "volCacheStripeFlushes", "volDisabledDisk", "volSubstitutedDisk", "volOper", "volOperProgress", "volInitRate", "volVerifyRate"};
    private static String[] attachProp = new String[]{"attachIndex", "attachLun", "attachMode", "attachVolId", "attachVolName", "attachVolOwner"};
    private static String[] logProp = new String[]{"logStatus", "logTo", "logFile", "logLevel", "logPort"};
    private static String[] ondgProp = new String[]{"ondgOper", "ondgOperPending", "ondgOperProgress", "ondgError", "ondgId"};
    private String host;
    private String ipno;
    private static int TIMEOUT = 1200000;
    private static final String sccs_id = "@(#)T3snmp.java\t1.4 06/14/02 SMI";

    public T3snmp(String string) {
        this.host = string;
        this.ipno = string;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ipno = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public T3TokenList getSystemProperties() {
        Vector vector = new Vector();
        this.getTokens(vector, sysProp, "0", this.ipno);
        return new T3TokenList(vector);
    }

    public T3TokenList getElemProp(int n) {
        Vector vector = new Vector();
        this.getTokens(vector, unitProp, "" + n, "unit" + n);
        return new T3TokenList(vector);
    }

    public T3TokenList getFruProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, fruProp, n + "." + n2, "fru" + n2);
        return new T3TokenList(vector);
    }

    public T3TokenList getDiskProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, diskProp, n + "." + n2, "u" + n + "d" + n2);
        return new T3TokenList(vector);
    }

    public T3TokenList getCtrlProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, ctrlProp, n + "." + n2, "u" + (n + 1) + "ctr");
        return new T3TokenList(vector);
    }

    public T3TokenList getPortProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, portProp, n + "." + n2, "u" + (n + 1) + "p" + (n2 + 1));
        return new T3TokenList(vector);
    }

    public T3TokenList getVolProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, volProp, n + "." + n2, "u" + (n + 1) + "vol" + (n2 + 1));
        return new T3TokenList(vector);
    }

    public T3TokenList getPcuProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, pcuProp, n + "." + n2, "u" + (n + 1) + "pcu" + (n2 + 1));
        return new T3TokenList(vector);
    }

    public T3TokenList getLoopProp(int n, int n2) {
        Vector vector = new Vector();
        this.getTokens(vector, loopProp, n + "." + n2, "u" + (n + 1) + "l" + (n2 + 1));
        return new T3TokenList(vector);
    }

    public void getTokens(List list, String[] stringArray, String string, String string2) {
        SUN_T300_MIBOidTable sUN_T300_MIBOidTable = new SUN_T300_MIBOidTable();
        SnmpOid.setSnmpOidTable((SnmpOidTable)sUN_T300_MIBOidTable);
        SnmpPeer snmpPeer = null;
        SnmpRequest snmpRequest = null;
        SnmpSession snmpSession = null;
        boolean bl = false;
        try {
            snmpPeer = new SnmpPeer(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Throwable)unknownHostException, (Object)"host not found");
            return;
        }
        try {
            SnmpParameters snmpParameters = new SnmpParameters("public", "private");
            snmpPeer.setSnmpParam(snmpParameters);
            snmpSession = new SnmpSession("SyncManager session");
            snmpSession.setDefaultPeer(snmpPeer);
            SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SNMP.SystemProperties");
            int n = 0;
            while (n < stringArray.length) {
                snmpVarBindList.addVarBind(stringArray[n] + "." + string);
                ++n;
            }
            snmpRequest = snmpSession.snmpGetRequest(null, snmpVarBindList);
            bl = snmpRequest.waitForCompletion((long)TIMEOUT);
            if (!bl) {
                return;
            }
            int n2 = snmpRequest.getErrorStatus();
            if (n2 != 0) {
                if (snmpRequest.getErrorIndex() != 0) {
                    Report.error.log((Object)("Error status = " + SnmpRequest.snmpErrorToString((int)n2)));
                    Report.error.log((Object)("Error index = " + snmpRequest.getErrorIndex()));
                }
                return;
            }
            SnmpVarBindList snmpVarBindList2 = snmpRequest.getResponseVarBindList();
            int n3 = snmpVarBindList2.getVarBindCount();
            int n4 = 0;
            while (n4 < n3) {
                SnmpVarBind snmpVarBind = snmpVarBindList2.getVarBindAt(n4);
                if (snmpVarBind != null && snmpVarBind.isValidValue()) {
                    T3Token t3Token = new T3Token(string2, stringArray[n4], snmpVarBind.getStringValue());
                    list.add(t3Token);
                }
                ++n4;
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            Report.error.log((Throwable)snmpStatusException, (Object)"SNMP error");
            return;
        }
        snmpSession.destroySession();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("usage <t3-ip-addresss> <type> [unit] [index]");
            System.exit(1);
        }
        T3snmp t3snmp = new T3snmp(stringArray[0]);
        String string = stringArray[1];
        int n = 0;
        if (stringArray.length > 2) {
            n = Integer.parseInt(stringArray[2]);
        }
        int n2 = 0;
        if (stringArray.length > 3) {
            n2 = Integer.parseInt(stringArray[3]);
        }
        T3TokenList t3TokenList = null;
        if ("sys".equals(string)) {
            t3TokenList = t3snmp.getSystemProperties();
        } else if ("unit".equals(string)) {
            t3TokenList = t3snmp.getElemProp(n);
        } else if ("fru".equals(string)) {
            t3TokenList = t3snmp.getFruProp(n, n2);
        } else if ("vol".equals(string)) {
            t3TokenList = t3snmp.getVolProp(n, n2);
        } else if ("disk".equals(string)) {
            t3TokenList = t3snmp.getDiskProp(n, n2);
        } else if ("port".equals(string)) {
            t3TokenList = t3snmp.getPortProp(n, n2);
        } else if ("loop".equals(string)) {
            t3TokenList = t3snmp.getLoopProp(n, n2);
        } else if ("pcu".equals(string)) {
            t3TokenList = t3snmp.getPcuProp(n, n2);
        } else if ("ctrl".equals(string)) {
            t3TokenList = t3snmp.getCtrlProp(n, n2);
        } else {
            System.out.println("bad type=" + string);
            System.out.println("[sys|unit|fru|vol|disk|port|loop|pcu|ctr]");
            System.exit(0);
        }
        if (t3TokenList == null) {
            System.out.println("No data returned");
            System.exit(0);
        }
        Iterator iterator = t3TokenList.list.iterator();
        while (iterator.hasNext()) {
            T3Token t3Token = (T3Token)iterator.next();
            System.out.println(t3Token.toString());
        }
    }
}

