/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.io;

import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3HttpConnection;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Date;
import java.util.Iterator;

public class T3System {
    public static final String CLASS_NAME = "StorEdgeT3_Cluster";
    public static final int VOLUME_UNKNOWN = 0;
    public static final int VOLUME_MOUNTED = 1;
    public static final int VOLUME_UNMOUNTED = 2;
    public static final int VOLUME_UNINITIALIZED = 3;
    public static final int VOLUME_DELETED = 4;
    public static final int OPERATION_UNKNOWN = 0;
    public static final int OPERATION_VERIFYING = 1;
    public static final int OPERATION_INITIALIZING = 2;
    public static final int OPERATION_RECONSTRUCTING = 3;
    public static final int OPERATION_RECONSTRUCTING_TO_STANDBY = 4;
    public static final int OPERATION_COPYING_FROM_STANDBY = 5;
    public static final int OPERATION_COPYING_TO_STANDBY = 6;
    public static final int LOOPOP_UNKNOWN = 0;
    public static final int LOOPOP_TEST = 1;
    public static final int LOOPOP_FIND = 2;
    public static final int LOOPOP_FAST_TEST = 3;
    public static final int LOOPOP_FAST_FIND = 4;
    public static final int LOOPOP_HEALTH_CHECK = 5;
    private static final String FULL_REDUNDANCY = "full";
    private static final String DEGRADED_REDUNDANCY = "degraded";
    private static final String LOST_REDUNDANCY = "lost";
    private static final String PCU_TYPE_NAME = "powerUnit";
    private static final String LOOP_TYPE_NAME = "loopCard";
    private static final String FAN_TYPE_NAME = "fan";
    private static final String DRIVE_TYPE_NAME = "diskDrive";
    private static final String VOLUME_TYPE_NAME = "volume";
    private static final String CONTROLLER_TYPE_NAME = "controller";
    private static final int CONTROLLER = 1;
    private static final int PCU = 2;
    private static final int LOOP = 3;
    private static final int FAN = 4;
    private static final int DRIVE = 5;
    private static final int TEMPSENSOR = 6;
    private static final int VOLUME = 7;
    private static final int MIDPLANE = 8;
    private static final int FIBREPORT = 9;
    private static final int NUM_T3_UNIT_DRIVES = 9;
    private static final String TAG = "t3";
    private String host;
    private String systemName;
    private String systemID;
    private String systemWWN;
    private T3TokenList sysprop;
    private T3TokenList voloper;
    private T3TokenList ofdgoper;
    private T3TokenList[] unitprop;
    private T3HttpConnection connection;
    private long updated;
    private static final String sccs_id = "@(#)T3System.java\t1.56 01/08/03 SMI";

    public T3System(String string) {
        this.host = string;
        this.systemName = null;
        this.connection = new T3HttpConnection(string, "/sysprop.htm");
    }

    public String ftp(String string) {
        return null;
    }

    public void setAuthentication(String string, String string2) {
    }

    public String getHostName() {
        return this.host;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void abortUpdate() {
        this.connection.abort();
    }

    public synchronized void flushSystem() {
        Report.trace.log(TAG, (Object)"flushSystem");
        this.sysprop = null;
        this.unitprop = null;
        this.updated = 0L;
        if (this.unitprop != null) {
            int n = 0;
            while (n < this.unitprop.length) {
                this.unitprop[n] = null;
                ++n;
            }
        }
    }

    public synchronized void updateSystem() throws T3Exception {
        Report.trace.log(TAG, (Object)"updateSystem enter");
        this.sysprop = this.getTokenList("/sysprop.htm");
        int n = this.sysprop.getIntValue("unitCount");
        this.unitprop = new T3TokenList[n];
        int n2 = 0;
        while (n2 < n) {
            this.unitprop[n2] = this.getTokenList("/elemprop.htm?unitIndex=" + n2);
            ++n2;
        }
        this.updated = System.currentTimeMillis();
        this.systemName = this.systemWWN = this.unitprop[0].getStringValue("u1p1", "portWWN");
        this.systemID = this.sysprop.getStringValue("sysId");
        Report.trace.log(TAG, (Object)"updateSystem return");
    }

    public synchronized void updateSystem(int n) throws T3Exception {
        long l = System.currentTimeMillis();
        if (l - this.updated > (long)(n * 1000)) {
            this.updateSystem();
        }
    }

    public void updateIfNeeded() throws T3Exception {
        if (this.updated == 0L) {
            this.updateSystem();
        }
    }

    public void sysApplySettings(String string, String string2, String string3, String string4) throws T3Exception {
        String string5 = "/update?" + string + "=" + string2;
        String string6 = "sysApplySettings=Apply";
        this.connection.setPath(string5);
        this.connection.setAuthentication(string3, string4);
        this.connection.post(string6);
    }

    public int getMasterUnitIndex() {
        if (this.unitprop != null) {
            int n = 0;
            while (n < this.unitprop.length) {
                String string = this.unitprop[n].getStringValue("unitType");
                String string2 = this.unitprop[n].getStringValue("unitStandby");
                if (string.equals(CONTROLLER_TYPE_NAME) && string2.equals("no")) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getMasterUnitIndex();
        try {
            this.updateSystem();
        }
        catch (T3Exception t3Exception) {
            return "Error getting system info.";
        }
        stringBuffer.append("OK\n");
        stringBuffer.append("_created\t");
        stringBuffer.append(new Date() + "\n");
        stringBuffer.append("_deviceName\t");
        stringBuffer.append(this.sysprop.getStringValue("sysId") + "\n");
        stringBuffer.append("_name\t");
        stringBuffer.append(this.sysprop.getStringValue("sysId") + "\n");
        stringBuffer.append("_ip\t");
        stringBuffer.append(this.sysprop.getStringValue("sysIpAddr") + "\n");
        stringBuffer.append("_logFile\t/var/adm/messages.t300\n");
        stringBuffer.append("_accessName\t");
        stringBuffer.append(this.unitprop[n].getStringValue("portWWN") + "\n");
        stringBuffer.append("_active\tY\n");
        stringBuffer.append("_display\t");
        stringBuffer.append(this.sysprop.getStringValue("sysId"));
        stringBuffer.append(" (ip=" + this.sysprop.getStringValue("sysIpAddr") + ")\n");
        stringBuffer.append("_category\tt3\n");
        stringBuffer.append("id.ip\t");
        stringBuffer.append(this.sysprop.getStringValue("sysIpAddr") + "\n");
        stringBuffer.append("id.ipno\t");
        stringBuffer.append(this.sysprop.getStringValue("sysIpAddr") + "\n");
        stringBuffer.append("id.name\t");
        stringBuffer.append(this.sysprop.getStringValue("sysId") + "\n");
        stringBuffer.append("id.wwn\t");
        stringBuffer.append(this.unitprop[n].getStringValue("portWWN") + "\n");
        try {
            int n2 = this.sysprop.getIntValue("fruCtlrCount");
            int n3 = this.sysprop.getIntValue("fruDiskCount");
            stringBuffer.append("controller.count\t");
            stringBuffer.append(n2 + "\n");
            stringBuffer.append("disk.count\t");
            stringBuffer.append(n3 + "\n");
        }
        catch (T3Exception t3Exception) {
            stringBuffer.append("controller.header\n");
            stringBuffer.append("disk.header\n");
        }
        stringBuffer.append("loopcard.header\n");
        stringBuffer.append("midplane.header\n");
        stringBuffer.append("port.header\n");
        stringBuffer.append("power.header\n");
        stringBuffer.append("unit.header\n");
        int n4 = 0;
        while (n4 < this.unitprop.length) {
            this.addTokenList(stringBuffer, this.unitprop[n4]);
            ++n4;
        }
        Iterator iterator = this.sysprop.list.iterator();
        while (iterator.hasNext()) {
            T3Token t3Token = (T3Token)iterator.next();
            stringBuffer.append("system.");
            stringBuffer.append(t3Token.getPropertyKey());
            stringBuffer.append("\t");
            stringBuffer.append(t3Token.getPropertyValue());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void addTokenList(StringBuffer stringBuffer, T3TokenList t3TokenList) {
        Iterator iterator = t3TokenList.list.iterator();
        while (iterator.hasNext()) {
            T3Token t3Token = (T3Token)iterator.next();
            this.addToken(stringBuffer, this.getTag(t3Token.getElementID()), t3Token);
        }
    }

    private void addToken(StringBuffer stringBuffer, String string, T3Token t3Token) {
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(t3Token.getElementID());
        stringBuffer.append(".");
        stringBuffer.append(t3Token.getPropertyKey());
        stringBuffer.append("\t");
        stringBuffer.append(t3Token.getPropertyValue());
        stringBuffer.append("\n");
    }

    private String getTag(String string) {
        if (string.startsWith("ctr", 2)) {
            return CONTROLLER_TYPE_NAME;
        }
        if (string.charAt(2) == 'd') {
            return "disk";
        }
        if (string.charAt(2) == 'l') {
            return "disk";
        }
        if (string.startsWith("mpn", 2)) {
            return "midplane";
        }
        if (string.length() == 8) {
            return "port";
        }
        if (string.startsWith("pcu", 2)) {
            return "power";
        }
        if (string.charAt(2) == 'p') {
            return "port";
        }
        if (string.startsWith("unit")) {
            return "unit";
        }
        if (string.length() == 10) {
            return "volume_disk";
        }
        if (string.startsWith("vol", 2)) {
            return VOLUME_TYPE_NAME;
        }
        return "FRU";
    }

    public T3TokenList getCurrentVolumeOperation(int n, int n2) throws T3Exception {
        return this.getTokenList("/voloper.htm?unitIndex=" + n + "&volIndex=" + n2);
    }

    public int getVolumeStatus(int n, int n2) {
        if (n + 1 > this.unitprop.length) {
            return 0;
        }
        String string = this.getVolumeName(n, n2);
        T3Token t3Token = this.unitprop[n].findToken(string, "volStatus");
        if (t3Token == null) {
            return 0;
        }
        String string2 = t3Token.getPropertyValue();
        if (string2.equals("mounted")) {
            return 1;
        }
        if (string2.equals("unmounted")) {
            return 2;
        }
        if (string2.equals("uninitialized")) {
            return 3;
        }
        if (string2.equals("deleted")) {
            return 4;
        }
        return 0;
    }

    public int getVolumeOperationProgress(T3TokenList t3TokenList) {
        T3Token t3Token = t3TokenList.findToken("volOperProgress");
        if (t3Token == null) {
            return -1;
        }
        return Integer.parseInt(t3Token.getPropertyValue());
    }

    public int getVolumeOperation(T3TokenList t3TokenList) {
        T3Token t3Token = t3TokenList.findToken("volOper");
        if (t3Token == null) {
            return 0;
        }
        return this.volOperValue(t3Token.getPropertyValue());
    }

    public int volOperValue(String string) {
        if (string.equals("verifying")) {
            return 1;
        }
        if (string.equals("initializing")) {
            return 2;
        }
        if (string.equals("reconstructing")) {
            return 3;
        }
        if (string.equals("reconstructingToStandby")) {
            return 4;
        }
        if (string.equals("copyingFromStandby")) {
            return 5;
        }
        if (string.equals("copyingToStandby")) {
            return 6;
        }
        return 0;
    }

    public void volumeVerify(int n, int n2, String string, String string2, int n3, int n4) throws T3Exception {
        String string3 = "/update?unitIndex=" + n + "&volIndex=" + n2 + "&volVerifyRate=" + n3 + "&volSaftey=" + n4;
        String string4 = "volVerify=Verify";
        this.connection.setPath(string3);
        this.connection.setAuthentication(string, string2);
        this.connection.post(string4);
    }

    public void abortVolumeOperation(int n, int n2, String string, String string2) throws T3Exception {
        String string3 = "/update?unitIndex=" + n + "&volIndex=" + n2;
        String string4 = "volAbort=Abort";
        this.connection.setPath(string3);
        this.connection.setAuthentication(string, string2);
        this.connection.post(string4);
    }

    public void updateLoopOperation() throws T3Exception {
        this.ofdgoper = this.getTokenList("/ofdgoper.htm");
    }

    public int getLoopOperationProgress() {
        T3Token t3Token = this.ofdgoper.findToken("ondgOperProgress");
        try {
            Integer n = new Integer(t3Token.getPropertyValue());
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean getLoopOperationPending() {
        T3Token t3Token = this.ofdgoper.findToken("ondgOperPending");
        if (t3Token == null) {
            return false;
        }
        String string = t3Token.getPropertyValue();
        return string.equals("yes");
    }

    public int getLoopOperation() {
        T3Token t3Token = this.ofdgoper.findToken("ondgOper");
        if (t3Token == null) {
            return 0;
        }
        String string = t3Token.getPropertyValue();
        if (string.equals("find")) {
            return 2;
        }
        if (string.equals("test")) {
            return 1;
        }
        if (string.equals("fastFind")) {
            return 4;
        }
        if (string.equals("fastTest")) {
            return 3;
        }
        if (string.equals("healthCheck")) {
            return 5;
        }
        return 0;
    }

    public int getLoopErrors(int n, int n2) {
        T3Token t3Token = this.ofdgoper.findToken("ondgError");
        if (t3Token == null) {
            return 0;
        }
        String string = t3Token.getPropertyValue();
        if (t3Token.getPropertyValue() == null) {
            return 0;
        }
        if (string.indexOf("pass") < 0) {
            return 1;
        }
        return 0;
    }

    public String getLoopError() {
        T3Token t3Token = this.ofdgoper.findToken("ondgError");
        if (t3Token == null) {
            return null;
        }
        return t3Token.getPropertyValue();
    }

    public void healthCheck(int n, int n2, String string, String string2) throws T3Exception {
        this.sysApplySettings("sysOndgMode", "on", string, string2);
        this.loopCommand("ondgHealthCheck=HealthCheck", n, n2, string, string2);
    }

    public void loopTest(int n, int n2, String string, String string2) throws T3Exception {
        this.sysApplySettings("sysOndgMode", "on", string, string2);
        this.loopCommand("ondgTest=Test", n, n2, string, string2);
    }

    public void loopFastFind(int n, int n2, String string, String string2) throws T3Exception {
        this.sysApplySettings("sysOndgMode", "on", string, string2);
        this.loopCommand("ondgFastFind=FastFind", n, n2, string, string2);
    }

    public void loopFastTest(int n, int n2, String string, String string2) throws T3Exception {
        this.sysApplySettings("sysOndgMode", "on", string, string2);
        this.loopCommand("ondgFastTest=FastTest", n, n2, string, string2);
    }

    public void loopFind(int n, int n2, String string, String string2) throws T3Exception {
        this.sysApplySettings("sysOndgMode", "on", string, string2);
        this.loopCommand("ondgFind=Find", n, n2, string, string2);
    }

    public void loopAbort(int n, int n2, String string, String string2) throws T3Exception {
        this.connection.setPath("update?ondgAbort=Abort");
        this.connection.setAuthentication(string, string2);
        this.connection.post("sysApplySettings=Apply");
    }

    public T3TokenList getSystemProperties() {
        return this.sysprop;
    }

    public T3TokenList[] getUnitProperties() {
        return this.unitprop;
    }

    private String getVolumeName(int n, int n2) {
        return "u" + ++n + "vol" + ++n2;
    }

    private String getLoopName(int n, int n2) {
        return "u" + ++n + "lp" + ++n2;
    }

    private void loopCommand(String string, int n, int n2, String string2, String string3) throws T3Exception {
        String string4 = "/update?unitIndex=" + n + "&loopIndex=" + n2;
        this.connection.setPath(string4);
        this.connection.setAuthentication(string2, string3);
        this.connection.post(string);
    }

    private T3TokenList getTokenList(String string) throws T3Exception {
        this.connection.setPath(string);
        String string2 = this.connection.get();
        if (string2.equals("")) {
            throw new T3Exception("No tokens");
        }
        return new T3TokenList(string2);
    }

    public static void main(String[] stringArray) {
        block19: {
            if (stringArray.length < 2) {
                System.out.println("usage <host> <command>");
                System.exit(-1);
            }
            T3System t3System = new T3System(stringArray[0]);
            try {
                if (stringArray[1].equalsIgnoreCase("VERIFY")) {
                    if (stringArray.length != 8) {
                        System.out.println("usage <host> VERIFY <unit> <volume> <rate> <fix> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n2 = Integer.parseInt(stringArray[3]);
                    int n3 = Integer.parseInt(stringArray[4]);
                    int n4 = Integer.parseInt(stringArray[5]);
                    t3System.volumeVerify(n, n2, stringArray[6], stringArray[7], n3, n4);
                    System.out.println("Started Volume Verify");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("ABORT")) {
                    if (stringArray.length != 6) {
                        System.out.println("usage <host> ABORT <unit> <volume> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n5 = Integer.parseInt(stringArray[3]);
                    t3System.abortVolumeOperation(n, n5, stringArray[4], stringArray[5]);
                    System.out.println("Volume Operation Aborted.");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("LOOP_TEST")) {
                    if (stringArray.length != 6) {
                        System.out.println("usage <host> LOOP_TEST <unit> <loop> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n6 = Integer.parseInt(stringArray[3]);
                    t3System.loopTest(n, n6, stringArray[4], stringArray[5]);
                    System.out.println("Loop Test Started.");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("LOOP_FIND")) {
                    if (stringArray.length != 6) {
                        System.out.println("usage <host> LOOP_FIND <unit> <loop> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n7 = Integer.parseInt(stringArray[3]);
                    t3System.loopFind(n, n7, stringArray[4], stringArray[5]);
                    System.out.println("Loop Find Started.");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("LOOP_FAST_TEST")) {
                    if (stringArray.length != 6) {
                        System.out.println("usage <host> LOOP_TEST <unit> <loop> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n8 = Integer.parseInt(stringArray[3]);
                    t3System.loopFastTest(n, n8, stringArray[4], stringArray[5]);
                    System.out.println("Loop Fast Test Started.");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("LOOP_FAST_FIND")) {
                    if (stringArray.length != 6) {
                        System.out.println("usage <host> LOOP_FIND <unit> <loop> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n9 = Integer.parseInt(stringArray[3]);
                    t3System.loopFastFind(n, n9, stringArray[4], stringArray[5]);
                    System.out.println("Loop Fast Find Started.");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("LOOP_ABORT")) {
                    if (stringArray.length != 6) {
                        System.out.println("usage <host> LOOP_ABORT <unit> <loop> <user> <password>");
                        System.exit(-1);
                    }
                    int n = Integer.parseInt(stringArray[2]);
                    int n10 = Integer.parseInt(stringArray[3]);
                    t3System.loopAbort(n, n10, stringArray[4], stringArray[5]);
                    System.out.println("Loop Operation Aborted.");
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("REPORT")) {
                    System.out.println(t3System.toString());
                    break block19;
                }
                if (stringArray[1].equalsIgnoreCase("XML")) {
                    System.out.println("This function is no longer supported.");
                    System.out.println("Use T3ReportGenerator");
                    break block19;
                }
                System.out.println("Operation " + stringArray[1] + " not supported");
                System.exit(-1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(exception.toString());
            }
        }
    }

    public static class Test
    extends UnitTest {
        public void testCreator() {
            T3System t3System = new T3System("localhost");
        }
    }
}

