/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.diags;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.array.t3.diags.Messages;
import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3System;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;

public class SMI_T3StatusTestExecutable
extends TestExecutableImpl {
    private static final float maxTemp = 48.0f;
    private static final String LOG_TAG = "T3";
    private static final Localizer msgs = Messages.getLocalizer();
    private T3System t3 = null;
    private DiagnosticResult result;
    private boolean abort = false;
    private boolean isRunning = false;
    private boolean testing = false;
    private int failCnt = 0;
    private T3TokenList systemProp;
    private T3TokenList oldSystemProp;
    private T3TokenList[] unitProp;
    private T3TokenList[] oldUnitProp;
    private String ip;
    private String wwn;
    private static final String sccs_id = "@(#)SMI_T3StatusTestExecutable.java\t1.20 10/11/02 SMI";

    SMI_T3StatusTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
    }

    protected void parseSettings() {
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("ip");
        if (testParameter != null) {
            this.ip = (String)testParameter.getCurrentValue();
            Report.debug.log(LOG_TAG, (Object)("ip=" + this.ip));
        }
        if (this.ip == null || "".equals(this.ip)) {
            this.ip = DiagUtil.getIP((ReferenceForMSE)this.mse);
        }
        this.wwn = this.mse.getKeyValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        Report.debug.log((Object)"runTest");
        this.result = diagnosticResult;
        this.parseSettings();
        if (null == this.ip || "".equals(this.ip)) {
            diagnosticResult.setFinalResults(TestState.FAILED, msgs.getString("oob.noipaddr"));
            return;
        }
        this.isRunning = true;
        this.abort = false;
        try {
            block9: {
                try {
                    if (this.reportStatus) {
                        diagnosticResult.addTestResults(msgs.getString("status.msg.starting"));
                        diagnosticResult.update();
                    }
                    Report.debug.log(LOG_TAG, (Object)"Starting status test");
                    this.t3 = new T3System(this.ip);
                    this.t3.updateSystem();
                    this.systemProp = this.t3.getSystemProperties();
                    this.unitProp = this.t3.getUnitProperties();
                    this.oldSystemProp = this.systemProp;
                    this.oldUnitProp = this.unitProp;
                    this.checkSystem();
                    if (this.failCnt == 0) {
                        diagnosticResult.setFinalResults(TestState.PASSED, msgs.getString("status.msg.testPassed"));
                        break block9;
                    }
                    diagnosticResult.setFinalResults(TestState.FAILED);
                }
                catch (Exception exception) {
                    if (this.abort) {
                        diagnosticResult.addTestResults(msgs.getString("status.aborted"));
                    }
                    LocalizedString localizedString = new LocalizedString(exception);
                    diagnosticResult.addTestResults(localizedString.toString());
                    if (!(exception instanceof DiagnosticException)) {
                        localizedString = new DiagnosticException().getLocalizedString();
                        diagnosticResult.addTestResults(localizedString.toString());
                    }
                    diagnosticResult.setFinalResults(TestState.FAILED);
                    Object var5_3 = null;
                    this.isRunning = false;
                    this.abort = false;
                    this.failCnt = 0;
                    return;
                }
            }
            Object var5_2 = null;
            this.isRunning = false;
            this.abort = false;
            this.failCnt = 0;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.isRunning = false;
            this.abort = false;
            this.failCnt = 0;
            throw throwable;
        }
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        Report.trace.log((Object)"abortTest");
        this.abort = true;
        this.t3.abortUpdate();
        return true;
    }

    private boolean checkSystem() throws T3Exception, DiagnosticException {
        Report.trace.log((Object)"checkSystem");
        if (this.systemProp.assertCondition("sysHasVolumes", "no")) {
            // empty if block
        }
        int n = this.systemProp.getIntValue("unitCount");
        int n2 = this.systemProp.getIntValue("volCount");
        Report.debug.log(LOG_TAG, (Object)("System unit count =" + n));
        Report.debug.log(LOG_TAG, (Object)("System vol  count =" + n2));
        int n3 = 1;
        while (n3 <= n) {
            this.checkDisk(n3, 1);
            this.checkDisk(n3, 2);
            this.checkDisk(n3, 3);
            this.checkDisk(n3, 4);
            this.checkDisk(n3, 5);
            this.checkDisk(n3, 6);
            this.checkDisk(n3, 7);
            this.checkDisk(n3, 8);
            this.checkDisk(n3, 9);
            this.checkController(n3);
            this.checkLoop(n3, 1);
            this.checkLoop(n3, 2);
            this.checkPower(n3, 1);
            this.checkPower(n3, 2);
            this.checkMidplane(n3);
            this.checkPort(n3, 1);
            int n4 = 1;
            while (n4 <= n2) {
                if (!this.checkVolume(n3, n4)) break;
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    private void showAsset(T3TokenList t3TokenList, String string, String string2) {
        String string3 = t3TokenList.getStringValue(string, string2);
        this.result.addTestResults(msgs.getFormattedString(string2, (Object)string3));
    }

    private boolean checkVolume(int n, int n2) throws T3Exception, DiagnosticException {
        Report.trace.log((Object)("checkVolume: unit=" + n + ", volume=" + n2));
        String string = "u" + n + "vol" + n2;
        T3TokenList t3TokenList = this.unitProp[n - 1];
        String string2 = t3TokenList.getStringValue(string, "volName");
        if (string2 != null) {
            try {
                int n3;
                int n4;
                int n5;
                if (this.reportStatus) {
                    this.showAsset(t3TokenList, string, "volName");
                    this.showAsset(t3TokenList, string, "volCapacity");
                    this.showAsset(t3TokenList, string, "volWWN");
                    this.result.addTestResults(" ");
                }
                if (!t3TokenList.assertCondition(string, "volStatus", "mounted")) {
                    Report.debug.log((Object)(string + " Not mounted"));
                    this.softError(msgs.getFormattedString("status.softError.volNotMounted", (Object)string2));
                }
                if ((n5 = t3TokenList.getIntValue(string, "volSoftErrors")) > 0) {
                    this.softError(msgs.getFormattedString("status.softError.volSoftErrors", (Object)string2, (Object)new Integer(n5)));
                }
                if ((n4 = t3TokenList.getIntValue(string, "volFirmErrors")) > 0) {
                    this.softError(msgs.getFormattedString("status.softError.volFirmErrors", (Object)string2, (Object)new Integer(n4)));
                }
                if ((n3 = t3TokenList.getIntValue(string, "volHardErrors")) > 0) {
                    this.failure(msgs.getFormattedString("status.softError.volHardErrors", (Object)string2, (Object)new Integer(n3)));
                }
            }
            catch (T3Exception t3Exception) {
                return false;
            }
        }
        return true;
    }

    private boolean checkDisk(int n, int n2) throws T3Exception, DiagnosticException {
        Report.trace.log((Object)("checkDisk:unit=" + n + ", + disk =" + n2));
        String string = "u" + n + "d" + n2;
        T3TokenList t3TokenList = this.unitProp[n - 1];
        T3TokenList t3TokenList2 = this.oldUnitProp[n - 1];
        boolean bl = true;
        String string2 = t3TokenList.getStringValue(string, "fruDiskVolName");
        if (t3TokenList.assertCondition(string, "fruStatus", "fault")) {
            this.failure(msgs.getFormattedString("status.failure.diskFault", (Object)new Integer(n), (Object)new Integer(n2), (Object)string2));
        } else if (!t3TokenList.assertCondition(string, "fruStatus", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.diskStatus", (Object)new Integer(n), (Object)new Integer(n2), (Object)string2));
        }
        if (!t3TokenList.assertCondition(string, "fruState", "enabled")) {
            bl = false;
            this.softError(msgs.getFormattedString("status.failure.diskState", (Object)new Integer(n), (Object)new Integer(n2), (Object)string2));
        }
        if (!t3TokenList.assertCondition(string, "fruDiskPort1State", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.diskPort", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(1), (Object)string2));
        }
        if (!t3TokenList.assertCondition(string, "fruDiskPort2State", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.diskPort", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(2), (Object)string2));
        }
        if (bl) {
            int n3;
            int n4;
            float f;
            if (!t3TokenList.assertCondition(string, "fruIsSubstituted", "no")) {
                this.softError(msgs.getFormattedString("status.softError.diskSub", (Object)new Integer(n), (Object)new Integer(n2), (Object)string2));
            }
            if ((f = (float)t3TokenList.getIntValue(string, "fruDiskTemp")) > 48.0f) {
                this.failure(msgs.getFormattedString("status.softError.diskTemp", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Float(f), (Object)string2));
            }
            if ((n4 = t3TokenList.getIntValue(string, "fruErrors")) != (n3 = t3TokenList2.getIntValue(string, "fruErrors"))) {
                this.failure(msgs.getFormattedString("status.softError.diskErrors", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(n4 - n3), (Object)string2));
            }
        }
        return true;
    }

    private boolean checkController(int n) throws T3Exception, DiagnosticException {
        int n2;
        float f;
        Report.trace.log((Object)("checkController: unit=" + n));
        String string = "u" + n + "ctr";
        T3TokenList t3TokenList = this.unitProp[n - 1];
        T3TokenList t3TokenList2 = this.oldUnitProp[n - 1];
        if (!t3TokenList.assertCondition(string, "fruStatus", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.ctrlStatus", (Object)new Integer(n)));
        }
        if (!t3TokenList.assertCondition(string, "fruState", "enabled")) {
            this.status(msgs.getFormattedString("status.failure.ctrlState", (Object)new Integer(n)));
        }
        if ((f = t3TokenList.getFloatValue(string, "fruCtlrTemp")) > 48.0f) {
            this.failure(msgs.getFormattedString("status.softError.ctrlTemp", (Object)new Integer(n), (Object)new Float(f)));
        }
        if ((n2 = t3TokenList.getIntValue(string, "fruErrors")) > 0) {
            this.failure(msgs.getFormattedString("status.softError.ctrlErrors", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        return true;
    }

    private boolean checkLoop(int n, int n2) throws T3Exception, DiagnosticException {
        int n3;
        Report.trace.log((Object)("checkLoop:unit=" + n + ", loop=" + n2));
        String string = "u" + n + "l" + n2;
        T3TokenList t3TokenList = this.unitProp[n - 1];
        T3TokenList t3TokenList2 = this.oldUnitProp[n - 1];
        if (!t3TokenList.assertCondition(string, "fruState", "enabled")) {
            this.status(msgs.getFormattedString("status.failure.loopState", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruStatus", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.loopStatus", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruLoopCable1State", "installed") && !t3TokenList.assertCondition(string, "fruLoopCable2State", "installed")) {
            this.failure(msgs.getFormattedString("status.failure.loopCable", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruIsSubstituted", "no")) {
            this.failure(msgs.getFormattedString("status.failure.loopSubstituted", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        Report.debug.log((Object)"Fru OK");
        float f = t3TokenList.getFloatValue(string, "fruLoopTemp");
        if (f > 48.0f) {
            this.failure(msgs.getFormattedString("status.softError.loopTemp", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Float(f)));
        }
        if ((n3 = t3TokenList.getIntValue(string, "fruErrors")) > 0) {
            this.failure(msgs.getFormattedString("status.softError.loopErrors", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(n3)));
        }
        return true;
    }

    private boolean checkPower(int n, int n2) throws T3Exception, DiagnosticException {
        int n3;
        Report.trace.log((Object)("checkPower:unit=" + n + ", pcu=" + n2));
        String string = "u" + n + "pcu" + n2;
        T3TokenList t3TokenList = this.unitProp[n - 1];
        T3TokenList t3TokenList2 = this.oldUnitProp[n - 1];
        if (!t3TokenList.assertCondition(string, "fruStatus", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.pcuStatus", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruState", "enabled")) {
            this.failure(msgs.getFormattedString("status.failure.pcuState", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruPowerPowSource", "line")) {
            this.failure(msgs.getFormattedString("status.softError.pcuSource", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruPowerPowOutput", "normal")) {
            this.failure(msgs.getFormattedString("status.failure.pcuOutput", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruPowerBatState", "normal")) {
            this.softError(msgs.getFormattedString("status.softError.pcuBat", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruPowerPowTemp", "normal")) {
            this.failure(msgs.getFormattedString("status.failure.pcuTemp", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruPowerFan1State", "normal")) {
            this.failure(msgs.getFormattedString("status.failure.pcuFan1", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if (!t3TokenList.assertCondition(string, "fruPowerFan2State", "normal")) {
            this.failure(msgs.getFormattedString("status.failure.pcuFan2", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if ((n3 = t3TokenList.getIntValue(string, "fruErrors")) > 0) {
            this.failure(msgs.getFormattedString("status.softError.mpnErrors", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(n3)));
        }
        return true;
    }

    private boolean checkMidplane(int n) throws T3Exception, DiagnosticException {
        int n2;
        Report.trace.log((Object)("checkMidplane:unit=" + n));
        String string = "u" + n + "mpn";
        T3TokenList t3TokenList = this.unitProp[n - 1];
        T3TokenList t3TokenList2 = this.oldUnitProp[n - 1];
        if (!t3TokenList.assertCondition(string, "fruStatus", "ready")) {
            this.failure(msgs.getFormattedString("status.failure.mpnStatus", (Object)new Integer(n)));
        }
        if (!t3TokenList.assertCondition(string, "fruState", "enabled")) {
            this.failure(msgs.getFormattedString("status.failure.mpnState", (Object)new Integer(n)));
        }
        if ((n2 = t3TokenList.getIntValue(string, "fruErrors")) > 0) {
            this.failure(msgs.getFormattedString("status.softError.mpnErrors", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        return true;
    }

    private boolean checkPort(int n, int n2) throws T3Exception, DiagnosticException {
        int n3;
        Report.trace.log((Object)("checkPort:unit=" + n + ", port=" + n2));
        String string = "u" + n + "p" + n2;
        T3TokenList t3TokenList = this.unitProp[n - 1];
        if (!t3TokenList.assertCondition(string, "portStatus", "online")) {
            this.failure(msgs.getFormattedString("status.failure.portOffline", (Object)new Integer(n), (Object)new Integer(n2)));
        }
        if ((n3 = t3TokenList.getIntValue(string, "portErrors")) > 0) {
            this.failure(msgs.getFormattedString("status.softError.portErrors", (Object)new Integer(n), (Object)new Integer(n2), (Object)new Integer(n3)));
        }
        if (this.reportStatus) {
            this.showAsset(t3TokenList, string, "portIndex");
            this.showAsset(t3TokenList, string, "portWWN");
            this.result.addTestResults(" ");
        }
        return true;
    }

    private void failure(String string) throws T3Exception, DiagnosticException {
        ++this.failCnt;
        if (this.haltOnError) {
            throw new DiagnosticException(string);
        }
        this.result.addTestResults(string);
    }

    private void softError(String string) throws T3Exception, DiagnosticException {
        if (this.reportErrors) {
            this.result.addTestResults(string);
        }
    }

    private void status(String string) {
        if (this.reportStatus) {
            this.result.addTestResults(string);
        }
    }

    private void warnBadWWN() throws DiagnosticException, T3Exception {
        if (this.wwn == null) {
            return;
        }
        if (this.wwn.equals("")) {
            return;
        }
        String string = this.wwn;
        if (this.wwn.length() > 16) {
            string = this.wwn.substring(0, 16);
        }
        boolean bl = true;
        String string2 = null;
        int n = this.systemProp.getIntValue("unitCount");
        int n2 = this.systemProp.getIntValue("volCount");
        int n3 = 1;
        while (n3 <= n) {
            T3TokenList t3TokenList = this.unitProp[n3 - 1];
            T3Token t3Token = t3TokenList.findToken("portWWN");
            if (t3Token != null && string.equals(string2 = t3Token.getPropertyValue())) {
                return;
            }
            int n4 = 1;
            while (n4 <= n2) {
                String string3;
                String string4 = "u" + n3 + "vol" + n4;
                t3Token = t3TokenList.findToken(string4, "volWWN");
                if (t3Token != null && string.equals(string3 = t3Token.getPropertyValue().substring(8, 24))) {
                    return;
                }
                ++n4;
            }
            ++n3;
        }
        if (bl && this.reportErrors) {
            this.result.addTestResults(msgs.getFormattedString("warn.wwn-ip-diff", (Object)this.wwn, string2));
        }
    }
}

