/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.host.rhba.service;

import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.GUIDGenerator;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.RAClient;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class RemoteHBAProbe
implements Probe {
    public static final String OS_NAME = "rhba.osName";
    public static final String HOST_NAME = "rhba.hostName";
    public static final String OS_RELEASE_VERSION = "rhba.osReleaseVersion";
    public static final String OS_VERSION = "rhba.osVersion";
    public static final String MACHINE_TYPE = "rhba.machineType";
    public static final String UNIQUE_IDENTIFIER = "rhba.uniqueIdentifier";
    public static final String PORT = "rhba.port";
    private Properties probeProps;
    public static final String sccs_id = "@(#)RemoteHBAProbe.java\t1.16 07/08/03 SMI";

    public RemoteHBAProbe(Properties properties) {
        this.probeProps = properties;
    }

    public String getName() {
        return "rhba";
    }

    public ProbeResult probe(Properties properties) {
        LinkedList<Properties> linkedList = new LinkedList<Properties>();
        int n = 0;
        try {
            n = Integer.parseInt(properties.getProperty("timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = properties.getProperty("ipno");
        if (string == null) {
            try {
                string = InetAddress.getByName(properties.getProperty("ip")).toString();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            properties.setProperty("ipno", string);
        }
        String string2 = string;
        String string3 = this.probeProps.getProperty(PORT);
        if (string3 != null && !"".equals(string3) && !"DEFAULT".equals(string3)) {
            string2 = string + ":" + string3;
        }
        try {
            RAClient rAClient = new RAClient();
            DeviceClass deviceClass = rAClient.getHost(string2, n);
            Iterator iterator = deviceClass.getChildren();
            while (iterator.hasNext()) {
                DeviceClass deviceClass2 = (DeviceClass)iterator.next();
                Properties properties2 = deviceClass2.getProperties();
                Iterator iterator2 = deviceClass2.getChildren();
                while (iterator2.hasNext()) {
                    Properties properties3 = new Properties();
                    DeviceClass deviceClass3 = (DeviceClass)iterator2.next();
                    Properties properties4 = deviceClass3.getProperties();
                    properties3.setProperty("type", "rhba");
                    String string4 = properties4.getProperty("HostName");
                    if (string4 != null) {
                        properties3.setProperty("logicalName", string4);
                    } else {
                        properties3.setProperty("logicalName", string);
                    }
                    String string5 = properties4.getProperty("UniqueIdentifier");
                    String string6 = properties.getProperty("ip");
                    String string7 = properties.getProperty("ipno");
                    if (string5 != null) {
                        properties3.setProperty("name", string5);
                    } else {
                        properties3.setProperty("name", string);
                    }
                    if (string6 != null) {
                        properties3.setProperty("ip", string6);
                    }
                    if (string7 != null) {
                        properties3.setProperty("ipno", string7);
                    }
                    this.setProperty("HostName", properties4, HOST_NAME, properties3);
                    this.setProperty("OsName", properties4, OS_NAME, properties3);
                    this.setProperty("OsReleaseVersion", properties4, OS_RELEASE_VERSION, properties3);
                    this.setProperty("OsVersion", properties4, OS_VERSION, properties3);
                    this.setProperty("MachineType", properties4, MACHINE_TYPE, properties3);
                    if (properties4.getProperty("MachineType").equals("sun4u")) {
                        properties3.setProperty("VENDOR", "Sun");
                    } else {
                        this.setProperty("OsName", properties4, "VENDOR", properties3);
                    }
                    this.setProperty("MachineType", properties4, "MODEL", properties3);
                    String string8 = "unknown";
                    String string9 = "unknown";
                    String string10 = "unknown";
                    if (properties4.getProperty("MachineType").equals("sun4u")) {
                        string8 = "sun";
                        string9 = "SOLARIS";
                    } else {
                        string8 = properties4.getProperty("MachineType");
                    }
                    string10 = "HOSTID";
                    String string11 = GUIDGenerator.generateGUID((String)"host", (String)string8, (String)string9, (String)string10, (String)properties4.getProperty("UniqueIdentifier"));
                    properties3.setProperty("GUID", string11);
                    if (string3 != null && !"".equals(string3) && !"DEFAULT".equals(string3)) {
                        string2 = string + ":" + string3;
                        properties3.setProperty(PORT, string3);
                    }
                    linkedList.add(properties3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ProbeResult(properties, linkedList);
    }

    private void setProperty(String string, Properties properties, String string2, Properties properties2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            properties2.setProperty(string2, string3);
        }
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            Properties properties = new Properties();
            RemoteHBAProbe remoteHBAProbe = new RemoteHBAProbe(properties);
            this.assertEquals(remoteHBAProbe.getName(), "rhba");
        }

        public static void main(String[] stringArray) {
            try {
                String string = stringArray[0];
                Properties properties = new Properties();
                properties.setProperty("timeout", "100");
                properties.setProperty("ip", string);
                RemoteHBAProbe remoteHBAProbe = new RemoteHBAProbe(properties);
                ProbeResult probeResult = remoteHBAProbe.probe(properties);
                System.out.println("Probe result....");
                probeResult.getProbeProperties().list(System.out);
                Iterator iterator = probeResult.getDevices().iterator();
                while (iterator.hasNext()) {
                    Properties properties2 = (Properties)iterator.next();
                    System.out.println("Device found...");
                    properties2.list(System.out);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            System.exit(0);
        }
    }
}

