/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.host.rhba.service;

import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.RAClient;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.RAClientException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class RHBADeviceReport
implements ReportGenerator {
    private Properties props;
    private static final String CIM_VERSION = "CIM 2.5";
    private static final String LOG_TAG = "RHBADeviceReport";
    private DeviceClass hostData = new DeviceClass();
    private DeviceClass hbaSystem = new DeviceClass();
    private Vector uniqLuns;
    private Vector processedLUIDs;
    private String ip;
    private String name;
    private String reason = "UNKNOWN";
    private String reportStatus = "OK";
    private String systemStatus = "OK";
    private static final int RACLIENT_TIMEOUT = 10;
    private static final int EXISTENCE_QUERY = 0;
    private static final int HBA_QUERY = 1;
    private static final int TARGET_MAPPING_QUERY = 2;
    public static final int UNKNOWN = 1;
    public static final int ONLINE = 2;
    public static final int OFFLINE = 3;
    public static final int BYPASSED = 4;
    public static final int DIAGNOSTICS = 5;
    public static final int LINKDOWN = 6;
    public static final int PORTERROR = 7;
    public static final int LOOPBACK = 8;
    public static final String sccs_id = "@(#)RHBADeviceReport.java\t1.27 04/02/04 SMI";

    public RHBADeviceReport(Properties properties) {
        this.props = properties;
        this.ip = this.props.getProperty("ipno");
        this.name = this.props.getProperty("name");
    }

    private String getQuery(int n) {
        this.reportStatus = "bad";
        RAClient rAClient = new RAClient();
        try {
            switch (n) {
                case 0: {
                    this.hostData = rAClient.getHost(this.ip, 10);
                    if (Report.debug.isEnabled()) {
                        Report.debug.log((Object)this.hostData.toXML());
                    }
                    break;
                }
                case 1: {
                    this.hostData = rAClient.getHBA(this.ip, 10);
                    if (Report.debug.isEnabled()) {
                        Report.debug.log((Object)this.hostData.toXML());
                    }
                    break;
                }
                default: {
                    return this.reportStatus;
                }
            }
        }
        catch (RAClientException rAClientException) {
            Report.warning.log((Object)("Error getting host data " + rAClientException.toString()));
            this.reason = "Lost Comm\">\"No OOB data available";
            return this.reportStatus;
        }
        this.reportStatus = "OK";
        return this.reportStatus;
    }

    /*
     * Unable to fully structure code
     */
    public String generateReport() {
        block13: {
            var1_1 = new HashMap<String, String>();
            this.uniqLuns = new Vector<E>();
            this.processedLUIDs = new Vector<E>();
            Report.debug.log("RHBADeviceReport", (Object)"Generating Device Report");
            var2_2 = this.getQuery(0);
            if (!this.reportStatus.equals("OK")) break block13;
            var3_3 = this.getReport();
            var4_5 = var3_3.newSubInstance();
            var4_5.setClassName("model");
            var4_5.setProperty("schema", "CIM 2.5");
            var4_5.setProperty("view", "system");
            var4_5.setProperty("type", "host");
            var4_5.setProperty("prefix", "CIM");
            var4_5.setProperty("package", "com.sun.jade.cim.bean");
            this.hbaSystem = var4_5.newSubInstance();
            var5_6 = this.hostData.getChildren();
            while (var5_6.hasNext()) {
                var6_7 = (DeviceClass)var5_6.next();
                if (!var6_7.getClassName().equals("RHBA")) continue;
                var7_8 = var6_7.getChildren();
                while (var7_8.hasNext()) {
                    var8_9 = (DeviceClass)var7_8.next();
                    if (!var8_9.getClassName().equals("HOST.ASSET")) continue;
                    this.populateHBASystem(this.hbaSystem, var8_9);
                }
            }
            var2_2 = this.getQuery(1);
            var6_7 = this.hostData.getChildren();
            if (var6_7 == null) {
                Report.debug.log("RHBADeviceReport", (Object)("Host" + this.ip + "has no HBAs"));
                return var3_3.toXML();
            }
            var8_9 = new DeviceClass();
            while (var6_7.hasNext()) {
                var9_10 = (DeviceClass)var6_7.next();
                if (var9_10.getClassName().equals("ADAPTER.ASSET")) {
                    var8_9 = this.hbaSystem.newSubInstance();
                    this.populateFCAdapter(var8_9, var9_10);
                }
                if ((var7_8 = var9_10.getChildren()) != null) ** GOTO lbl101
                continue;
lbl-1000:
                // 1 sources

                {
                    var10_11 = (DeviceClass)var7_8.next();
                    if (!var10_11.getClassName().equals("PORT.ASSET")) continue;
                    var11_12 = var8_9.newSubInstance();
                    this.populateFibrePort(var11_12, var10_11);
                    try {
                        var12_13 = new DeviceClass[]{var10_11.getProperty("PortWWN")};
                        var13_15 = new RAClient();
                        var14_16 = var13_15.getTargetMappings((String[])var12_13, this.ip, 10);
                        Report.debug.log("RHBADeviceReport", (Object)"");
                        Report.debug.log("RHBADeviceReport", (Object)("Called TargetMap with adapterPWWN:" + (String)var12_13[0]));
                        Report.debug.log("RHBADeviceReport", (Object)var14_16.toXML());
                        var15_17 = var14_16.getChildren();
                        while (var15_17.hasNext()) {
                            var16_18 = (DeviceClass)var15_17.next();
                            if (!var16_18.getClassName().equals("TARGET.MAPPING.RESPONSE")) continue;
                            var1_1.put("PortWWN", var16_18.getProperty("PortWWN"));
                            var1_1.put("PortIsSpecific", var16_18.getProperty("PortIsSpecific"));
                            var17_19 = var16_18.getChildren();
                            if (var17_19 == null) continue;
                            var18_20 = new DeviceClass();
                            while (var17_19.hasNext()) {
                                var19_21 = (DeviceClass)var17_19.next();
                                if (var19_21.getClassName().equals("FCPSCSIENTRY") && (var20_22 = var19_21.getChildren()) != null) ** GOTO lbl91
                                continue;
lbl-1000:
                                // 1 sources

                                {
                                    var21_23 = (DeviceClass)var20_22.next();
                                    if (var21_23.getClassName().equals("FCPID")) {
                                        var1_1.put("FcId", var21_23.getProperty("FcId"));
                                        var1_1.put("TargetNodeWWN", var21_23.getProperty("NodeWWN"));
                                        var1_1.put("TargetPortWWN", var21_23.getProperty("PortWWN"));
                                        var1_1.put("FcpLun", var21_23.getProperty("FcpLun"));
                                    }
                                    if (!var21_23.getClassName().equals("SCSIID")) continue;
                                    var1_1.put("OSDeviceName", var21_23.getProperty("OSDeviceName"));
                                    var1_1.put("ScsiBusNumber", var21_23.getProperty("ScsiBusNumber"));
                                    var1_1.put("ScsiTargetNumber", var21_23.getProperty("ScsiTargetNumber"));
                                    var1_1.put("ScsiOSLun", var21_23.getProperty("ScsiOSLun"));
                                    if (Report.debug.isEnabled()) {
                                        Report.debug.log("RHBADeviceReport", (Object)"");
                                        Report.debug.log("RHBADeviceReport", (Object)"Calling populateTargMap with");
                                        Report.debug.log("RHBADeviceReport", (Object)("HBAportWWN:" + var1_1.get("PortWWN") + "TargetPortWWN:" + var1_1.get("TargetPortWWN")));
                                        Report.debug.log((Object)var14_16.toXML());
                                    }
                                    this.populateTargetMap(var1_1);
lbl91:
                                    // 3 sources

                                    ** while (var20_22.hasNext())
                                }
lbl92:
                                // 1 sources

                            }
                        }
                    }
                    catch (RAClientException var12_14) {
                        Report.warning.log((Object)("Error getting host data " + var12_14.toString()));
                    }
                    var12_13 = var11_12.newSubInstance();
                    this.populateProtocolEndPoint(var12_13, var10_11);
                    var13_15 = var12_13.newSubInstance();
                    this.populateLogicalNetwork((DeviceClass)var13_15, var10_11);
lbl101:
                    // 3 sources

                    ** while (var7_8.hasNext())
                }
lbl102:
                // 1 sources

            }
            this.uniqLuns = null;
            this.processedLUIDs = null;
            return var3_3.toXML();
        }
        var3_4 = this.getBadReport();
        this.uniqLuns = null;
        this.processedLUIDs = null;
        return var3_4;
    }

    private void populateHBASystem(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("Name", this.name);
        deviceClass.setProperty("Caption", deviceClass2.getProperty("MachineType"));
        deviceClass.setProperty("IPAddress", this.ip);
        deviceClass.setProperty("HostID", deviceClass2.getProperty("UniqueIdentifier"));
        deviceClass.setProperty("HostName", deviceClass2.getProperty("HostName"));
        deviceClass.setProperty("OsName", deviceClass2.getProperty("OsName"));
        deviceClass.setProperty("OsReleaseVersion", deviceClass2.getProperty("OsReleaseVersion"));
        deviceClass.setProperty("OsVersion", deviceClass2.getProperty("OsVersion"));
        deviceClass.setProperty("Status", this.systemStatus);
    }

    private void populateFCAdapter(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("FibreChannelAdapter");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_FibreChannelAdapter");
        deviceClass.setProperty("SystemName", this.name);
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("DeviceID", deviceClass2.getProperty("NodeWWN"));
        deviceClass.setProperty("Name", deviceClass2.getProperty("NodeWWN"));
        deviceClass.setProperty("NodeWWN", deviceClass2.getProperty("NodeWWN"));
        deviceClass.setProperty("Description", deviceClass2.getProperty("ModelDescription"));
        deviceClass.setProperty("DriverName", deviceClass2.getProperty("DriverName"));
    }

    private void populateFibrePort(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("SystemName", this.name);
        deviceClass.setProperty("Name", deviceClass2.getProperty("PortWWN"));
        deviceClass.setProperty("DeviceID", deviceClass2.getProperty("PortWWN"));
        deviceClass.setProperty("PortWWN", deviceClass2.getProperty("PortWWN"));
        deviceClass.setProperty("Caption", deviceClass2.getProperty("OSDeviceName"));
        deviceClass.setProperty("Description", "Fibre Channel Port");
        Integer n = new Integer(deviceClass2.getProperty("PortState"));
        switch (n) {
            case 1: {
                deviceClass.setProperty("PortState", "UNKNOWN");
                break;
            }
            case 2: {
                deviceClass.setProperty("PortState", "Online");
                break;
            }
            case 3: {
                deviceClass.setProperty("PortState", "Offline");
                break;
            }
            case 4: {
                deviceClass.setProperty("PortState", "Bypassed");
                break;
            }
            case 5: {
                deviceClass.setProperty("PortState", "Diagnostic Mode");
                break;
            }
            case 6: {
                deviceClass.setProperty("PortState", "Link Down");
                break;
            }
            case 7: {
                deviceClass.setProperty("PortState", "Port Error");
                break;
            }
            case 8: {
                deviceClass.setProperty("PortState", "Loopback");
                break;
            }
            default: {
                deviceClass.setProperty("PortState", "UNKNOWN");
            }
        }
        this.xmlAttr(deviceClass, "CRCErrors", deviceClass2.getProperty("InvalidCRCCount"));
        this.xmlAttr(deviceClass, "InvalidTransmissionWords", deviceClass2.getProperty("InvalidTxWordCount"));
        this.xmlAttr(deviceClass, "LossOfSyncCounter", deviceClass2.getProperty("LossOfSyncCount"));
        this.xmlAttr(deviceClass, "LinkFailureCount", deviceClass2.getProperty("LinkFailureCount"));
        this.xmlAttr(deviceClass, "ProtocolErrorCount", deviceClass2.getProperty("PrimitiveSeqProtocolErrCount"));
    }

    private void populateProtocolEndPoint(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("ProtocolEndPoint");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_ProtocolEndPoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("SystemName", this.name);
        deviceClass.setProperty("Name", deviceClass2.getProperty("PortWWN"));
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    private void populateLogicalNetwork(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("LogicalNetwork");
        deviceClass.setProperty("CreationClassName", "CIM_LogicalNetwork");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("Name", deviceClass2.getProperty("FabricName"));
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    /*
     * Unable to fully structure code
     */
    private void populateTargetMap(HashMap var1_1) {
        try {
            var2_2 = new RAClient();
            var3_4 = new String[]{(String)var1_1.get("PortWWN")};
            var4_5 = new String[]{(String)var1_1.get("TargetPortWWN")};
            var5_6 = var2_2.getLUN(var3_4, var4_5, this.ip, 10);
            Report.debug.log("RHBADeviceReport", (Object)var5_6.toXML());
            var6_7 = var5_6.getChildren();
            if (var6_7 != null) ** GOTO lbl59
            return;
lbl-1000:
            // 1 sources

            {
                var7_8 = (DeviceClass)var6_7.next();
                if (var7_8.getClassName().equals("FCPTARGET.LUNINFO") && (var8_9 = var7_8.getChildren()) != null) ** GOTO lbl58
                continue;
lbl-1000:
                // 1 sources

                {
                    var9_10 = (DeviceClass)var8_9.next();
                    if (!var9_10.getClassName().equals("LUN.ASSET") || !(var10_11 = (String)var1_1.get("TargetPortWWN") + (String)var1_1.get("FcpLun")).equals(var11_12 = var7_8.getProperty("TargetPWWN") + var9_10.getProperty("FcpLunId"))) continue;
                    if (var9_10.getProperty("LUID") != null && this.processedLUIDs.contains(var9_10.getProperty("LUID"))) {
                        var12_13 = this.hbaSystem.getChildren();
                        while (var12_13.hasNext()) {
                            var13_14 = (DeviceClass)var12_13.next();
                            if (var13_14 == null || var13_14.getProperty("DeviceID") == null || !var13_14.getProperty("DeviceID").equals(var9_10.getProperty("LUID"))) continue;
                            var14_15 = var13_14.getProperty("OSDeviceName");
                            var15_16 = var14_15 + ", " + this.props.getProperty("rhba.hostName") + ":" + (String)var1_1.get("OSDeviceName");
                            var13_14.setProperty("OSDeviceName", var15_16);
                            var16_17 = var13_14.getProperty("PortWWN");
                            var17_18 = var16_17 + ", " + (String)var1_1.get("PortWWN");
                            var13_14.setProperty("PortWWN", var17_18);
                            continue block3;
                        }
                    } else {
                        this.processedLUIDs.add(var9_10.getProperty("LUID"));
                        var12_13 = this.hbaSystem.newSubInstance();
                        var12_13.setClassName("CIM_StorageExtent");
                        var12_13.setProperty("CreationClassName", "StorAdeHBA_TargetMap");
                        var12_13.setProperty("SystemCreationClassName", "StorAdeHBA_System");
                        var12_13.setProperty("SystemName", this.name);
                        this.xmlAttr((DeviceClass)var12_13, "DeviceID", var9_10.getProperty("LUID"));
                        this.xmlAttr((DeviceClass)var12_13, "PortWWN", (String)var1_1.get("PortWWN"));
                        this.xmlAttr((DeviceClass)var12_13, "PortIsSpecific", (String)var1_1.get("PortIsSpecific"));
                        this.xmlAttr((DeviceClass)var12_13, "FcId", (String)var1_1.get("FcId"));
                        this.xmlAttr((DeviceClass)var12_13, "TargetNodeWWN", (String)var1_1.get("TargetNodeWWN"));
                        this.xmlAttr((DeviceClass)var12_13, "TargetPortWWN", (String)var1_1.get("TargetPortWWN"));
                        this.xmlAttr((DeviceClass)var12_13, "FcpLun", (String)var1_1.get("FcpLun"));
                        this.xmlAttr((DeviceClass)var12_13, "OSDeviceName", this.props.getProperty("rhba.hostName") + ":" + (String)var1_1.get("OSDeviceName"));
                        this.xmlAttr((DeviceClass)var12_13, "ScsiBusNumber", (String)var1_1.get("ScsiBusNumber"));
                        this.xmlAttr((DeviceClass)var12_13, "ScsiTargetNumber", (String)var1_1.get("ScsiTargetNumber"));
                        this.xmlAttr((DeviceClass)var12_13, "ScsiOSLun", (String)var1_1.get("ScsiOSLun"));
                        this.xmlAttr((DeviceClass)var12_13, "FcpLunId", var9_10.getProperty("FcpLunId"));
                        if (var9_10.getProperty("LUID") == null) {
                            Report.debug.log("RHBADeviceReport", (Object)("LUID is null for /rdsk:" + (String)var1_1.get("OSDeviceName")));
                        }
                        this.xmlAttr((DeviceClass)var12_13, "LUID", var9_10.getProperty("LUID"));
                        if (var9_10.getProperty("NumBlocks") == null) {
                            this.xmlAttr((DeviceClass)var12_13, "NumberOfBlocks", "0");
                        } else {
                            this.xmlAttr((DeviceClass)var12_13, "NumberOfBlocks", var9_10.getProperty("NumBlocks"));
                        }
                        if (var9_10.getProperty("BlockSize") == null) {
                            this.xmlAttr((DeviceClass)var12_13, "BlockSize", "0");
                            continue;
                        }
                        this.xmlAttr((DeviceClass)var12_13, "BlockSize", var9_10.getProperty("BlockSize"));
                    }
lbl58:
                    // 6 sources

                    ** while (var8_9.hasNext())
                }
lbl59:
                // 3 sources

                ** while (var6_7.hasNext())
            }
lbl60:
            // 1 sources

        }
        catch (RAClientException var2_3) {
            Report.warning.log((Object)("Error getting host data " + var2_3.toString()));
        }
    }

    private DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    private String getBadReport() {
        String string = "<report\nReturnCode=\"FAILURE\">\n<exception\nReason=\"Lost Comm\">\nNo OOB data available\n</exception>\n</report>\n";
        return string;
    }

    private void xmlAttr(DeviceClass deviceClass, String string, String string2) {
        if (string == null || string2 == null) {
            Report.debug.log(LOG_TAG, (Object)("xmlAttr received null for: " + string + ":" + string2));
            return;
        }
        deviceClass.setProperty(string, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: RHBADeviceReport ip");
            System.exit(1);
        }
        System.out.println("Running RHBADeviceReport");
        Properties properties = new Properties();
        properties.setProperty("ip", stringArray[0]);
        properties.setProperty("name", "80c9b619");
        RHBADeviceReport rHBADeviceReport = new RHBADeviceReport(properties);
        String string = rHBADeviceReport.generateReport();
        System.out.println(string);
    }

    public static class Test
    extends UnitTest {
        public void test() {
            Properties properties = new Properties();
            properties.setProperty("ipnum", "172.20.104.27");
            properties.setProperty("name", "spetest1");
            RHBADeviceReport rHBADeviceReport = new RHBADeviceReport(properties);
            DeviceClass deviceClass = new DeviceClass();
            deviceClass.setClassName("HOST.ASSET");
            deviceClass.setProperty("MachineType", "sun4u");
            deviceClass.setProperty("ip", "spetest1");
            deviceClass.setProperty("UniqueIdentifier", "80c0eb1a");
            deviceClass.setProperty("HostName", "spetest1");
            deviceClass.setProperty("OsName", "SunOS");
            deviceClass.setProperty("OsReleaseVersion", "5.9");
            deviceClass.setProperty("OsVersion", "Generic");
            DeviceClass deviceClass2 = new DeviceClass();
            rHBADeviceReport.populateHBASystem(deviceClass2, deviceClass);
            this.assertEquals(deviceClass2.getProperty("Caption"), "sun4u");
            this.assertEquals(deviceClass2.getProperty("IPAddress"), deviceClass.getProperty("ipnum"));
            DeviceClass deviceClass3 = new DeviceClass();
            deviceClass3.setClassName("ADAPTER.ASSET");
            deviceClass3.setProperty("DeviceID", "0123456789abcdef");
            deviceClass3.setProperty("Name", "0123456789abcdef");
            deviceClass3.setProperty("NodeWWN", "0123456789abcdef");
            deviceClass3.setProperty("ModelDescription", "Sun StorEdge SBus ");
            deviceClass3.setProperty("DriverName", "qlc");
            DeviceClass deviceClass4 = new DeviceClass();
            rHBADeviceReport.populateFCAdapter(deviceClass4, deviceClass3);
            this.assertEquals(deviceClass4.getProperty("DeviceID"), deviceClass3.getProperty("DeviceID"));
            this.assertEquals(deviceClass4.getProperty("Description"), deviceClass3.getProperty("ModelDescription"));
            DeviceClass deviceClass5 = new DeviceClass();
            deviceClass5.setClassName("PORT.ASSET");
            deviceClass5.setProperty("SystemName", "spetest1");
            deviceClass5.setProperty("PortWWN", "0123456789abcdef");
            deviceClass5.setProperty("OSDeviceName", "/device/pci1@0/fp/qlc0,4");
            deviceClass5.setProperty("Description", "Fibre Channel Port");
            deviceClass5.setProperty("PortState", "5");
            DeviceClass deviceClass6 = new DeviceClass();
            rHBADeviceReport.populateFibrePort(deviceClass6, deviceClass5);
            this.assertEquals(deviceClass6.getProperty("SystemName"), deviceClass5.getProperty("SystemName"));
            this.assertEquals(deviceClass6.getProperty("PortWWN"), deviceClass5.getProperty("PortWWN"));
            this.assertEquals(deviceClass6.getProperty("PortState"), "Diagnostic Mode");
            DeviceClass deviceClass7 = rHBADeviceReport.getReport();
            this.assertEquals(deviceClass7.getProperty("ReturnCode"), "OK");
        }
    }
}

