/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.hba.sun.service;

import com.sun.jade.device.hba.sun.service.HBADeviceReport;
import com.sun.jade.device.hba.sun.service.HBAFactory;
import com.sun.jade.device.protocol.agent.AgentReport;
import com.sun.jade.device.protocol.agent.AgentReportListener;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceHandler;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Properties;

public class HBAMF
extends AbstractMF
implements AgentReportListener,
ReportGenerator {
    private Properties props;
    private String name;
    private AgentReport report;
    private long lastUpdate;
    private long REPORT_TIMEOUT = 1800000L;
    private static final long MINUTES = 60000L;
    private static final String WAIT_REPORT = "<report ReturnCode='FAILURE'> <exception Reason='No Contact'/></report>";
    private static final String LOSTCOM_REPORT = "<report ReturnCode='FAILURE'> <exception Reason='Lost Comm'/></report>";
    public static final String sccs_id = "@(#)HBAMF.java\t1.17 01/29/03 SMI";

    public HBAMF(Properties properties) {
        super(properties);
        this.props = properties;
        String string = this.resolveIP(properties);
        String string2 = properties.getProperty("push");
        if (string2 == null) {
            this.setDeviceReport(new HBADeviceReport(properties));
            this.name = properties.getProperty("name");
            if (this.name == null) {
                this.name = string;
                properties.setProperty("name", string);
                this.updateDeviceConfig();
            }
        } else {
            this.setDeviceReport(this);
            HBAFactory.getDispatcher().subscribeListener(string2, (AgentReportListener)this);
            this.name = properties.getProperty("name");
        }
        Properties properties2 = DevInfo.getDeviceProperties((String)"agent_host");
        String string3 = properties2.getProperty("agent.update.timeout");
        int n = 30;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            Report.error.log((Throwable)exception, (Object)"Bad device property: agent.update.timeout");
        }
        this.REPORT_TIMEOUT = 60000L * (long)n;
    }

    public String getClassName() {
        return "StorAdeHBA_System";
    }

    public String getName() {
        return this.name;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString("Data Host");
    }

    public void notify(AgentReport agentReport) {
        this.report = agentReport;
        this.lastUpdate = System.currentTimeMillis();
        DeviceHandler.getDeviceHandler().parseReport((AbstractMF)this, this.generateReport());
    }

    public String generateReport() {
        if (this.report == null) {
            return WAIT_REPORT;
        }
        long l = System.currentTimeMillis() - this.lastUpdate;
        if (l > this.REPORT_TIMEOUT) {
            return LOSTCOM_REPORT;
        }
        HBADeviceReport hBADeviceReport = new HBADeviceReport(this.report, this.name);
        return hBADeviceReport.generateReport();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            System.out.println("Testing HBAMF");
        }
    }
}

