/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.hba.sun.service;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.device.hba.sun.io.TokenList;
import com.sun.jade.device.protocol.agent.AgentReport;
import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.jade.device.protocol.agent.HTTPException;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.DeviceProperties;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class HBADeviceReport
implements ReportGenerator {
    private Properties props;
    private static final String CIM_VERSION = "CIM 2.5";
    private static final String LOG_TAG = "HBADeviceReport";
    public static final int AGENT_PORT = 7654;
    private DeviceProperties hbaInfo;
    private String ip;
    private String name;
    private String reason;
    private String reportStatus = "OK";
    private String systemStatus = "OK";
    public static final String sccs_id = "@(#)HBADeviceReport.java\t1.28 02/12/03 SMI";

    public HBADeviceReport(Properties properties) {
        this.props = properties;
        this.ip = this.props.getProperty("ip");
        this.name = this.props.getProperty("ip");
    }

    public HBADeviceReport(AgentReport agentReport, String string) {
        this.hbaInfo = agentReport;
        this.name = string;
    }

    private String collectData() {
        this.reportStatus = "bad";
        HTTPConnection hTTPConnection = new HTTPConnection(this.ip, 7654);
        try {
            String string = hTTPConnection.get(HTTPConnection.HBA_REPORT);
            this.hbaInfo = new TokenList(string);
            String string2 = this.hbaInfo.getStringValue("error", "sys_error");
            int n = 0;
            try {
                n = this.hbaInfo.getIntValue("hba_count");
            }
            catch (Exception exception) {
                Report.warning.log((Object)("Error getting hba count " + exception.toString()));
            }
            if (string2 == null && hTTPConnection.getResponseCode() == 200 && n > 0) {
                this.reportStatus = "OK";
            } else {
                this.reason = string2;
                if (this.reason == null) {
                    this.reason = "UNKNOWN";
                }
            }
        }
        catch (HTTPException hTTPException) {
            Report.warning.log((Object)("Comm error getting inst report: " + hTTPException.toString()));
            this.reason = "Lost Comm";
        }
        catch (IOException iOException) {
            Report.warning.log((Object)("IO error getting inst report: " + iOException.toString()));
            this.reason = "Lost Comm";
        }
        return this.reportStatus;
    }

    public String generateReport() {
        Report.debug.log(LOG_TAG, (Object)"Generating Device Report");
        if (this.getDeviceData()) {
            DeviceClass deviceClass = this.getReport();
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("model");
            deviceClass2.setProperty("schema", CIM_VERSION);
            deviceClass2.setProperty("view", "system");
            deviceClass2.setProperty("type", "host");
            deviceClass2.setProperty("prefix", "CIM");
            deviceClass2.setProperty("package", "com.sun.jade.cim.bean");
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            this.populateHBASystem(deviceClass3);
            int n = 0;
            n = this.getHbaCount(this.hbaInfo);
            int n2 = 0;
            while (n2 < n) {
                DeviceClass deviceClass4 = deviceClass3.newSubInstance();
                this.populateFCAdapter(deviceClass4, n2);
                DeviceClass deviceClass5 = deviceClass4.newSubInstance();
                this.populateFibrePort(deviceClass5, n2, deviceClass3);
                DeviceClass deviceClass6 = deviceClass5.newSubInstance();
                this.populateFibreCounters(deviceClass6, n2);
                DeviceClass deviceClass7 = deviceClass5.newSubInstance();
                this.populateProtocolEndPoint(deviceClass7, n2);
                ++n2;
            }
            Report.debug.log("hba", (Object)deviceClass.toXML());
            return deviceClass.toXML();
        }
        DeviceClass deviceClass = this.getBadReport();
        return deviceClass.toXML();
    }

    private int getHbaCount(DeviceProperties deviceProperties) {
        String string = this.getInfoString(deviceProperties, "hba_count");
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private String getInfoString(DeviceProperties deviceProperties, String string) {
        String string2 = deviceProperties.getStringValue(string);
        if (string2 == null) {
            return deviceProperties.getStringValue("info", string);
        }
        return string2;
    }

    private void populateProtocolEndPoint(DeviceClass deviceClass, int n) {
        deviceClass.setClassName("ProtocolEndPoint");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_ProtocolEndPoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("SystemName", this.name);
        deviceClass.setProperty("Name", this.hbaInfo.getStringValue("hba." + n, "PortWWN"));
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "Fibre Channel");
    }

    private void populateFibreCounters(DeviceClass deviceClass, int n) {
        deviceClass.setClassName("FibrePortEventCounters");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_FibrePortEventCounters");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_FibrePort");
        deviceClass.setProperty("SystemName", this.name);
    }

    private void populateFibrePort(DeviceClass deviceClass, int n, DeviceClass deviceClass2) {
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("SystemName", this.name);
        deviceClass.setProperty("Name", this.hbaInfo.getStringValue("hba." + n, "RegisterName"));
        deviceClass.setProperty("DeviceID", this.hbaInfo.getStringValue("hba." + n, "RegisterName"));
        deviceClass.setProperty("PortWWN", this.hbaInfo.getStringValue("hba." + n, "PortWWN"));
        deviceClass.setProperty("Caption", this.hbaInfo.getStringValue("hba." + n, "path"));
        deviceClass.setProperty("Description", this.hbaInfo.getStringValue("hba." + n, "LGroup"));
        String string = this.hbaInfo.getStringValue("hba." + n, "Mode");
        deviceClass.setProperty("Mode", string);
        deviceClass.setProperty("Status", "OK");
        String string2 = this.hbaInfo.getStringValue("hba." + n, "RDLS call failed");
        deviceClass.setProperty("CRCErrors", this.hbaInfo.getStringValue("hba." + n, "CRC errors"));
        deviceClass.setProperty("InvalidTransmissionWords", this.hbaInfo.getStringValue("hba." + n, "Invalid words"));
        deviceClass.setProperty("LossOfSyncCounter", this.hbaInfo.getStringValue("hba." + n, "Sync Loss"));
        deviceClass.setProperty("LossOfSignalCounter", this.hbaInfo.getStringValue("hba." + n, "Signal loss"));
        deviceClass.setProperty("LinkFailureCount", this.hbaInfo.getStringValue("hba." + n, "Link failures"));
        deviceClass.setProperty("ProtocolErrorCount", this.hbaInfo.getStringValue("hba." + n, "Sequence error"));
    }

    private void populateFCAdapter(DeviceClass deviceClass, int n) {
        deviceClass.setClassName("FibreChannelAdapter");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_FibreChannelAdapter");
        deviceClass.setProperty("SystemName", this.name);
        deviceClass.setProperty("SystemCreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("DeviceID", this.hbaInfo.getStringValue("hba." + n, "RegisterName"));
        deviceClass.setProperty("Name", this.hbaInfo.getStringValue("hba." + n, "RegisterName"));
        deviceClass.setProperty("NodeWWN", this.hbaInfo.getStringValue("hba." + n, "NodeWWN"));
        if (this.hbaInfo.getStringValue("hba." + n, "BoardSlotPort").equals("::")) {
            deviceClass.setProperty("BoardSlotPort", "Not available for this host type.");
        } else {
            deviceClass.setProperty("BoardSlotPort", this.hbaInfo.getStringValue("hba." + n, "BoardSlotPort"));
        }
        deviceClass.setProperty("DriverName", this.hbaInfo.getStringValue("hba." + n, "DriverName"));
    }

    private void populateHBASystem(DeviceClass deviceClass) {
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("CreationClassName", "StorAdeHBA_System");
        deviceClass.setProperty("HostIP", this.name);
        deviceClass.setProperty("Name", this.name);
        deviceClass.setProperty("Status", this.systemStatus);
    }

    private DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    private DeviceClass getBadReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "'FAILURE'");
        DeviceClass deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("exception");
        deviceClass2.setProperty("Reason", this.reason);
        return deviceClass;
    }

    private boolean getDeviceData() {
        if (this.ip == null && this.hbaInfo != null) {
            return true;
        }
        String string = this.collectData();
        return string.equals("OK");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: HBADeviceReport diag245");
            System.exit(1);
        }
        Properties properties = new Properties();
        properties.setProperty("ip", stringArray[0]);
        HBADeviceReport hBADeviceReport = new HBADeviceReport(properties);
        FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/test.out"));
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println(hBADeviceReport.generateReport());
        DeviceReport deviceReport = new DeviceReport(hBADeviceReport.generateReport());
        Collection collection = deviceReport.toBeans();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            System.out.println("Adding bean to file...");
            CIMBean cIMBean = (CIMBean)iterator.next();
            printStream.println("bean # " + n++);
            printStream.println(((CIMBeanBase)cIMBean).toBeanXML() + "\n");
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            System.out.println("Testing HBADeviceReport");
        }
    }
}

