/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.netstorage.mgmt.esm.util.l10n.doclet.ResourceWriter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ResourceDoclet
extends Doclet {
    private static final String SCCS_ID = "@(#)ResourceDoclet.java 1.3   03/04/24 SMI";
    public static final String RESOURCE_TAG = "resource";
    public static final String ARGUMENT_TAG = "argument";
    public static final String BUNDLE_NAME_DEFAULT = "Localization";
    public static final String EXAMPLE_FORMAT = "{0} free form message format: {1}";
    private static RootDoc ourRootDoc = null;
    private static boolean ourDebug = false;
    private static int ourTrace = 0;
    private static int ourIndent = 4;
    private static boolean ourBackup = false;
    private static boolean ourDump = false;
    private static boolean ourNoop = false;
    public static final String UTIL_PACKAGE_DEFAULT = "com.sun.netstorage.mgmt.esm.util.l10n";
    private static String ourUtilPackage = "com.sun.netstorage.mgmt.esm.util.l10n";
    private static HashMap ourPackageBundleMap = new HashMap();
    private static String[] ourResourceWriterNames = null;
    private static HashMap ourResourceWriterShortcuts = new HashMap();
    private static List ourResourceWriters;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter;

    private static void setRootDoc(RootDoc rootDoc) {
        ourRootDoc = rootDoc;
        if (ourRootDoc != null) {
            ResourceDoclet.processOptions();
        }
    }

    private static void processOptions() {
        String[][] stringArray = ourRootDoc.options();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string;
                String[] stringArray2 = stringArray[n];
                ResourceDoclet.trace(2, "opt[" + n + "] = " + stringArray2[0]);
                int n2 = 1;
                while (n2 < stringArray2.length) {
                    string = stringArray2[n2];
                    ResourceDoclet.trace(2, "\tvalue[" + n2 + "] = " + string);
                    ++n2;
                }
                if ("-trace".equals(stringArray2[0])) {
                    string = stringArray2[1];
                    try {
                        ourTrace = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResourceDoclet.warning("illegal value given for -trace option: " + string, null);
                    }
                } else if ("-indent".equals(stringArray2[0])) {
                    string = stringArray2[1];
                    try {
                        int n3 = Integer.parseInt(string);
                        if (n3 > 8) {
                            ResourceDoclet.warning("the -indent option value range is 1-8: " + string, null);
                            n3 = 4;
                        }
                        ourIndent = n3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResourceDoclet.warning("illegal numeric value given for -indent option: " + string, null);
                    }
                } else if ("-utilpackage".equals(stringArray2[0])) {
                    ResourceDoclet.setUtilPackage(stringArray2[1]);
                }
                ++n;
            }
        }
    }

    private static void error(String string, SourcePosition sourcePosition) {
        if (ourRootDoc != null) {
            if (sourcePosition != null) {
                ourRootDoc.printError(sourcePosition, string);
            } else {
                ourRootDoc.printError(string);
            }
        } else {
            ResourceDoclet.print("error", string, sourcePosition);
        }
    }

    private static void warning(String string, SourcePosition sourcePosition) {
        if (ourRootDoc != null) {
            if (sourcePosition != null) {
                ourRootDoc.printWarning(sourcePosition, string);
            } else {
                ourRootDoc.printWarning(string);
            }
        } else {
            ResourceDoclet.print("warning", string, sourcePosition);
        }
    }

    private static void notice(String string, SourcePosition sourcePosition) {
        if (ourRootDoc != null) {
            if (sourcePosition != null) {
                ourRootDoc.printNotice(sourcePosition, string);
            } else {
                ourRootDoc.printNotice(string);
            }
        } else {
            ResourceDoclet.print("notice", string, sourcePosition);
        }
    }

    private static void print(String string, String string2, SourcePosition sourcePosition) {
        System.err.print(string);
        System.err.print(": ");
        System.err.print(string2);
        if (sourcePosition != null) {
            System.err.print(": (");
            System.err.print(sourcePosition);
            System.err.print(")");
        }
        System.err.println();
    }

    private static void setDebug(boolean bl) {
        ourDebug = bl;
    }

    private static void debug(String string) {
        if (ourDebug) {
            System.out.print("debug: ");
            System.out.println(string);
        }
    }

    private static void trace(int n, String string) {
        if (ourTrace >= n && n != 0) {
            System.out.print("trace-");
            System.out.print(n);
            System.out.print(": ");
            System.out.println(string);
        }
    }

    private static int getIndent() {
        return ourIndent;
    }

    private static boolean isBackup() {
        return ourBackup;
    }

    private static void setBackup(boolean bl) {
        ourBackup = bl;
    }

    private static boolean isDump() {
        return ourDump;
    }

    private static void setDump(boolean bl) {
        ourDump = bl;
    }

    private static boolean isNoop() {
        return ourNoop;
    }

    private static void setNoop(boolean bl) {
        ourNoop = bl;
    }

    public static String getUtilPackage() {
        return ourUtilPackage;
    }

    public static void setUtilPackage(String string) {
        ourUtilPackage = string;
    }

    private static Map getPackageBundles(String string) {
        HashMap hashMap = (HashMap)ourPackageBundleMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap(17);
            ourPackageBundleMap.put(string, hashMap);
        }
        return hashMap;
    }

    private static ResourceWriter[] getResourceWriters(String string, String string2) {
        Map map = ResourceDoclet.getPackageBundles(string);
        ResourceWriter[] resourceWriterArray = (ResourceWriter[])map.get(string2);
        if (resourceWriterArray == null) {
            resourceWriterArray = ResourceDoclet.createResourceWriters(string, string2);
            map.put(string2, resourceWriterArray);
            ResourceDoclet.addResourceWriters(resourceWriterArray);
        }
        return resourceWriterArray;
    }

    private static ResourceWriter[] createResourceWriters(String string, String string2) {
        ArrayList<ResourceWriter> arrayList = new ArrayList<ResourceWriter>(10);
        String[] stringArray = ResourceDoclet.getResourceWriterNames();
        int n = 0;
        while (n < stringArray.length) {
            ResourceWriter resourceWriter = ResourceDoclet.createResourceWriter(stringArray[n], string, string2);
            if (resourceWriter != null) {
                arrayList.add(resourceWriter);
            }
            ++n;
        }
        return arrayList.toArray(new ResourceWriter[arrayList.size()]);
    }

    private static ResourceWriter createResourceWriter(String string, String string2, String string3) {
        ResourceWriter resourceWriter = null;
        try {
            String string4 = ResourceDoclet.qualifyResourceWriterName(string);
            Class<?> clazz = Class.forName(string4);
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ResourceDoclet.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ResourceDoclet.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{string2, string3};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            resourceWriter = (ResourceWriter)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("problem constructing a specified resource writer (");
            stringBuffer.append(string);
            stringBuffer.append(") because:\n\t");
            stringBuffer.append(exception);
            ResourceDoclet.error(stringBuffer.toString(), null);
        }
        return resourceWriter;
    }

    private static String[] getResourceWriterNames() {
        if (ourResourceWriterNames == null) {
            ourResourceWriterNames = new String[]{"BundleWriter", "ConstantsWriter"};
        }
        return ourResourceWriterNames;
    }

    private static void setResourceWriterNames(String[] stringArray) {
        ourResourceWriterNames = stringArray;
    }

    private static String qualifyResourceWriterName(String string) {
        String string2 = (String)ourResourceWriterShortcuts.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    private static ResourceWriter[] getResourceWriters() {
        return ourResourceWriters.toArray(new ResourceWriter[ourResourceWriters.size()]);
    }

    private static void addResourceWriters(ResourceWriter[] resourceWriterArray) {
        ourResourceWriters.addAll(Arrays.asList(resourceWriterArray));
    }

    private static void dumpResourceWriters() {
        ResourceWriter[] resourceWriterArray = ResourceDoclet.getResourceWriters();
        int n = 0;
        while (resourceWriterArray != null && n < resourceWriterArray.length) {
            System.out.println(resourceWriterArray[n].toString());
            ++n;
        }
    }

    private static void listResourceWriters() {
        ResourceWriter[] resourceWriterArray = ResourceDoclet.getResourceWriters();
        int n = 0;
        while (resourceWriterArray != null && n < resourceWriterArray.length) {
            System.out.println(resourceWriterArray[n].getFilename());
            ++n;
        }
    }

    private static void flushResourceWriters() {
        ResourceWriter[] resourceWriterArray = ResourceDoclet.getResourceWriters();
        int n = 0;
        while (resourceWriterArray != null && n < resourceWriterArray.length) {
            try {
                resourceWriterArray[n].writeFile(ResourceDoclet.isBackup());
            }
            catch (Exception exception) {
                if (ourDebug) {
                    exception.printStackTrace();
                }
                ResourceDoclet.error("failed to write resource artifacts: \n\tbecause: " + exception.getMessage(), null);
            }
            ++n;
        }
    }

    private static void processRoot(RootDoc rootDoc) {
        if (rootDoc != null) {
            PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
            int n = 0;
            while (packageDocArray != null && n < packageDocArray.length) {
                ResourceDoclet.processPackage(packageDocArray[n]);
                ++n;
            }
        }
    }

    private static void processPackage(PackageDoc packageDoc) {
        if (packageDoc != null) {
            String string = packageDoc.name();
            ClassDoc[] classDocArray = packageDoc.allClasses();
            ResourceDoclet.trace(1, "processing package " + string);
            int n = 0;
            while (classDocArray != null && n < classDocArray.length) {
                ResourceDoclet.processClass(classDocArray[n]);
                ++n;
            }
        }
    }

    private static void processClass(ClassDoc classDoc) {
        if (classDoc != null) {
            String string = classDoc.name();
            FieldDoc[] fieldDocArray = classDoc.fields();
            ResourceDoclet.trace(1, "processing class " + string);
            int n = 0;
            while (fieldDocArray != null && n < fieldDocArray.length) {
                ResourceDoclet.processField(fieldDocArray[n]);
                ++n;
            }
        }
    }

    private static void processField(FieldDoc fieldDoc) {
        if (fieldDoc != null) {
            Tag[] tagArray;
            String string = fieldDoc.name();
            Object object = fieldDoc.constantValue();
            ResourceDoclet.trace(1, "processing field " + string);
            if (object instanceof String && (tagArray = fieldDoc.tags(RESOURCE_TAG)) != null && tagArray.length > 0) {
                if (tagArray[0] != null) {
                    ResourceDoclet.processResourceTag(tagArray[0], fieldDoc);
                }
                int n = 1;
                while (n < tagArray.length) {
                    ResourceDoclet.warning("multiple @resource tags found", tagArray[n].position());
                    ++n;
                }
            }
        }
    }

    private static void processResourceTag(Tag tag, FieldDoc fieldDoc) {
        String string = fieldDoc.name();
        ClassDoc classDoc = fieldDoc.containingClass();
        String string2 = classDoc.name();
        PackageDoc packageDoc = fieldDoc.containingPackage();
        String string3 = packageDoc.name();
        String string4 = string;
        String string5 = (String)fieldDoc.constantValue();
        String[] stringArray = ResourceDoclet.getArgumentDocs(fieldDoc, string5);
        String string6 = BUNDLE_NAME_DEFAULT;
        StringTokenizer stringTokenizer = new StringTokenizer(tag.text());
        int n = stringTokenizer.countTokens();
        ResourceDoclet.trace(1, "processing tag " + tag.name());
        if (n >= 1) {
            string4 = stringTokenizer.nextToken();
        }
        if (n == 2) {
            string6 = stringTokenizer.nextToken();
        }
        if (n > 2) {
            ResourceDoclet.warning("extraneous argements for @resource tag", tag.position());
        }
        ResourceDoclet.debug("  package: " + string3);
        ResourceDoclet.debug("    class: " + string2);
        ResourceDoclet.debug("      bundle  = " + string6);
        ResourceDoclet.debug("      trinket = " + string4);
        ResourceDoclet.debug("      message = " + string5);
        ResourceWriter[] resourceWriterArray = ResourceDoclet.getResourceWriters(string3, string6);
        int n2 = 0;
        while (n2 < resourceWriterArray.length) {
            if (!resourceWriterArray[n2].hasSource()) {
                File file = fieldDoc.position().file();
                resourceWriterArray[n2].setSource(file);
            }
            resourceWriterArray[n2].printEntry(string2, string, string4, string5, stringArray);
            ++n2;
        }
    }

    private static String[] getArgumentDocs(FieldDoc fieldDoc, String string) {
        Tag[] tagArray = fieldDoc.tags(ARGUMENT_TAG);
        int n = tagArray != null ? tagArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (tagArray != null && n2 < tagArray.length) {
            ResourceDoclet.trace(1, "processing tag " + tagArray[n2].name());
            stringArray[n2] = tagArray[n2].text();
            ++n2;
        }
        MessageFormat messageFormat = new MessageFormat(string);
        Format[] formatArray = messageFormat.getFormatsByArgumentIndex();
        if (formatArray != null && formatArray.length != n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("a message format constant (");
            stringBuffer.append(fieldDoc.name());
            stringBuffer.append(") ");
            if (formatArray.length > n) {
                stringBuffer.append("specifies more format arguments (");
                stringBuffer.append(formatArray.length);
                stringBuffer.append(") than are documented (");
                stringBuffer.append(n);
                stringBuffer.append(")");
            } else if (formatArray.length < n) {
                stringBuffer.append("documents more format arguments (");
                stringBuffer.append(n);
                stringBuffer.append(") than are specified (");
                stringBuffer.append(formatArray.length);
                stringBuffer.append(")");
            }
            ResourceDoclet.warning(stringBuffer.toString(), fieldDoc.position());
        }
        return stringArray;
    }

    public static boolean start(RootDoc rootDoc) {
        ResourceDoclet.setRootDoc(rootDoc);
        ResourceDoclet.trace(1, "starting...");
        ResourceDoclet.processRoot(rootDoc);
        ResourceDoclet.trace(1, "finishing...");
        if (ResourceDoclet.isDump()) {
            ResourceDoclet.dumpResourceWriters();
        }
        if (ResourceDoclet.isNoop()) {
            ResourceDoclet.listResourceWriters();
        } else {
            ResourceDoclet.flushResourceWriters();
        }
        return true;
    }

    public static int optionLength(String string) {
        ResourceDoclet.trace(1, "optionLength: " + string);
        if ("-debug".equals(string)) {
            ResourceDoclet.setDebug(true);
            return 1;
        }
        if ("-trace".equals(string)) {
            return 2;
        }
        if ("-indent".equals(string)) {
            return 2;
        }
        if ("-dump".equals(string)) {
            ResourceDoclet.setDump(true);
            return 1;
        }
        if ("-noop".equals(string)) {
            ResourceDoclet.setNoop(true);
            return 1;
        }
        if ("-backup".equals(string)) {
            ResourceDoclet.setBackup(true);
            return 1;
        }
        if ("-utilpackage".equals(string)) {
            return 2;
        }
        if ("-writers".equals(string)) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                String[] stringArray2 = stringArray[n];
                String string = stringArray2[0];
                ResourceDoclet.trace(2, "opt[" + n + "] = " + string);
                int n2 = 1;
                while (n2 < stringArray2.length) {
                    object = stringArray2[n2];
                    ResourceDoclet.trace(2, "\tvalue[" + n2 + "] = " + (String)object);
                    ++n2;
                }
                if ("-trace".equals(string)) {
                    object = stringArray2[1];
                    try {
                        ourTrace = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResourceDoclet.warning("illegal value given for -trace option: " + (String)object, null);
                    }
                } else if ("-indent".equals(string)) {
                    object = stringArray2[1];
                    try {
                        int n3 = Integer.parseInt((String)object);
                        if (n3 > 8) {
                            ResourceDoclet.warning("the -indent option value range is 1-8: " + (String)object, null);
                            n3 = 4;
                        }
                        ourIndent = n3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ResourceDoclet.warning("illegal numeric value given for -indent option: " + (String)object, null);
                    }
                } else if ("-utilpackage".equals(string)) {
                    ResourceDoclet.setUtilPackage(stringArray2[1]);
                } else if ("-writers".equals(string)) {
                    object = new StringTokenizer(stringArray2[1], ",:");
                    int n4 = ((StringTokenizer)object).countTokens();
                    String[] stringArray3 = new String[n4];
                    int n5 = 0;
                    while (n5 < n4) {
                        stringArray3[n5] = ((StringTokenizer)object).nextToken();
                        ++n5;
                    }
                    ResourceDoclet.setResourceWriterNames(stringArray3);
                }
                ++n;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ourResourceWriterShortcuts.put("bundle", (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter = ResourceDoclet.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.BundleWriter")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter).getName());
        ourResourceWriterShortcuts.put("BundleWriter", (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter = ResourceDoclet.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.BundleWriter")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$BundleWriter).getName());
        ourResourceWriterShortcuts.put("constants", (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter = ResourceDoclet.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.ConstantsWriter")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter).getName());
        ourResourceWriterShortcuts.put("ConstantsWriter", (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter = ResourceDoclet.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.ConstantsWriter")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ConstantsWriter).getName());
        ourResourceWriterShortcuts.put("keys", (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter = ResourceDoclet.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.KeysWriter")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter).getName());
        ourResourceWriterShortcuts.put("KeysWriter", (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter = ResourceDoclet.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.KeysWriter")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$KeysWriter).getName());
        ourResourceWriters = new ArrayList();
    }
}

