/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n;

import com.sun.netstorage.mgmt.esm.util.l10n.Contract;
import com.sun.netstorage.mgmt.esm.util.l10n.Formattable;
import com.sun.netstorage.mgmt.esm.util.l10n.FormatterException;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;

public class Formatter
implements Formattable,
Serializable {
    private static final String SCCS_ID = "@(#)Formatter.java 1.3   03/05/01 SMI";
    static final long serialVersionUID = 2208663780501649316L;
    private final Resource myResource;

    public static final String[] toStrings(Object[] objectArray) {
        int n = objectArray != null ? objectArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String string = null;
            string = object instanceof String ? (String)object : (object != null ? object.toString() : null);
            stringArray[n2] = string;
            ++n2;
        }
        return stringArray;
    }

    public Formatter(Resource resource) {
        Contract.requires(resource != null, "theResource != null");
        this.myResource = resource;
    }

    public final Resource getResource() {
        return this.myResource;
    }

    public final String getResourceBundleName() {
        return this.myResource.getResourceBundleName();
    }

    public final String[] getLocalizedArgs(String[] stringArray, Locale locale) {
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Resource resource = new Resource(this.getResourceBundleName(), string, string);
            String string2 = resource.getLocalizedText(locale);
            if (string2 == null) {
                string2 = string;
            }
            stringArray2[n2] = string2;
            ++n2;
        }
        Contract.ensures(stringArray2 != null, "String[] != null");
        return stringArray2;
    }

    public final String getLiteralFormattedText(String[] stringArray) throws FormatterException {
        String string = this.myResource.getLiteralText();
        String[] stringArray2 = stringArray;
        String string2 = this.getFormattedText(string, stringArray2);
        return string2;
    }

    protected final String getFormattedText(String string, String[] stringArray) throws FormatterException {
        String string2 = null;
        if (string != null) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            try {
                string2 = MessageFormat.format(string, stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FormatterException.IllegalArguments(this, (Throwable)illegalArgumentException, string, stringArray);
            }
        }
        return string2;
    }

    public final String getFormattedText(String[] stringArray) throws FormatterException {
        return this.getFormattedText(stringArray, Locale.getDefault());
    }

    public final String getFormattedText(String[] stringArray, Locale locale) throws FormatterException {
        String string = this.myResource.getLocalizedText(locale);
        String[] stringArray2 = this.getLocalizedArgs(stringArray, locale);
        String string2 = this.getFormattedText(string, stringArray2);
        return string2;
    }

    public int getFormatArgumentCount() {
        return this.getFormatArgumentCount(Locale.getDefault());
    }

    public int getFormatArgumentCount(Locale locale) {
        MessageFormat messageFormat;
        Format[] formatArray;
        String string;
        int n = 0;
        String string2 = this.myResource.getLocalizedText(locale);
        String string3 = string = string2 != null ? string2 : this.myResource.getLiteralText();
        if (string != null && (formatArray = (messageFormat = new MessageFormat(string)).getFormatsByArgumentIndex()) != null) {
            n = formatArray.length;
        }
        return n;
    }
}

