/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.http;

import com.sun.jade.util.http.EnhancedURLConnectionInitializationException;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class EnhancedURLConnection {
    private String authStr;
    Properties props;
    private String URLPrefix;
    private static final String sccs_id = "@(#)EnhancedURLConnection.java\t1.2 01/11/02 SMI";

    public EnhancedURLConnection(Properties properties) throws EnhancedURLConnectionInitializationException {
        this.props = properties;
        this.init();
    }

    public URLConnection getConnection(String string) throws MalformedURLException, IOException {
        URLConnection uRLConnection = this.getUnconnectedConnection();
        if (string != null) {
            OutputStream outputStream = ((HttpURLConnection)uRLConnection).getOutputStream();
            outputStream.write(string.getBytes());
        }
        uRLConnection.connect();
        return uRLConnection;
    }

    public URLConnection getUnconnectedConnection() throws MalformedURLException, IOException {
        String string = this.URLPrefix;
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        if (this.authStr != null) {
            uRLConnection.setRequestProperty("Authorization", this.authStr);
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        return uRLConnection;
    }

    public String getUrlPrefix() {
        return this.URLPrefix;
    }

    private void init() throws EnhancedURLConnectionInitializationException {
        String string;
        String string2;
        String string3;
        String string4 = this.props.getProperty("server");
        String string5 = this.props.getProperty("port");
        String string6 = this.props.getProperty("resource");
        int n = 0;
        if (string4 == null || string5 == null || string6 == null) {
            throw new EnhancedURLConnectionInitializationException("Property server or port or resource not set.");
        }
        try {
            n = new Integer(string5);
        }
        catch (Exception exception) {
            throw new EnhancedURLConnectionInitializationException("Could not parse port as int.  Aborting...");
        }
        if (this.props.getProperty("enableHttps") != null) {
            string3 = this.props.getProperty("javax.net.ssl.trustStore");
            if (string3 == null) {
                throw new EnhancedURLConnectionInitializationException("javax.net.ssl.trustStore is not defined.  Aborting...");
            }
            System.setProperty("javax.net.ssl.trustStore", string3);
            this.URLPrefix = "https://" + string4 + ":" + n;
            Security.addProvider((java.security.Provider)new Provider());
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            if (this.props.getProperty("enableProxy") != null) {
                string2 = this.props.getProperty("https.proxyHost");
                string = this.props.getProperty("https.proxyPort");
                if (string2 == null || string == null) {
                    throw new EnhancedURLConnectionInitializationException("https.proxyHost is not defined.  Aborting...");
                }
                System.setProperty("https.proxyHost", string2);
                System.setProperty("https.proxyPort", string);
            }
            if (System.getProperty("debugHttps") != null) {
                System.setProperty("javax.net.debug", "ssl,handshake,data,trustmanager");
            }
        } else {
            this.URLPrefix = "http://" + string4 + ":" + n;
            if (this.props.getProperty("enableProxy") != null) {
                string3 = this.props.getProperty("http.proxyHost");
                string2 = this.props.getProperty("http.proxyPort");
                if (string3 == null || string2 == null) {
                    throw new EnhancedURLConnectionInitializationException("https.proxyHost is not defined.  Aborting...");
                }
                System.setProperty("http.proxyHost", string3);
                System.setProperty("http.proxyPort", string2);
            }
        }
        this.URLPrefix = this.URLPrefix + string6;
        string3 = this.props.getProperty("authType");
        if (string3 != null && string3.equals("basic")) {
            string2 = this.props.getProperty("authUser");
            string = this.props.getProperty("authPass");
            String string7 = string2 + ":" + string;
            byte[] byArray = string7.getBytes();
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            this.authStr = "Basic " + bASE64Encoder.encode(string7.getBytes());
        }
    }
}

