/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.message;

import com.sun.jade.message.MessageCode;
import com.sun.jade.util.log.Report;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;

public class MessageGroup {
    private String name;
    private String catResource;
    public static final String sccs_id = "@(#)MessageGroup.java\t1.4 10/11/02 SMI";

    public MessageGroup(String string) {
        this.name = string;
        this.catResource = "com.sun.jade.message." + string + "." + "MessageCategory";
    }

    private String[] getCatagoryNames() {
        int n;
        Object object;
        ResourceBundle resourceBundle = MessageCode.getResourceBundle(this.catResource);
        if (resourceBundle == null) {
            return new String[0];
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!((String)object).endsWith(".id") || (n = ((String)object).length() - 3) <= 0) continue;
            arrayList.add(((String)object).substring(0, n));
        }
        object = new String[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            object[n] = (String)arrayList.get(n);
            ++n;
        }
        return object;
    }

    public Map getMessagePropertiesMap() {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        String[] stringArray = this.getCatagoryNames();
        int n = 0;
        while (n < stringArray.length) {
            ResourceBundle resourceBundle = MessageCode.getResourceBundle("com.sun.jade.message." + this.name + "." + stringArray[n]);
            if (resourceBundle != null) {
                MessageCode messageCode = new MessageCode(this.name + "." + stringArray[n], 0);
                String string = messageCode.getMessageCode();
                int n2 = Integer.parseInt(string, 16);
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    int n3;
                    String string2 = enumeration.nextElement();
                    int n4 = string2.indexOf(".");
                    if (n4 <= 0) continue;
                    String string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    try {
                        n3 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Report.warning.log("Bad format for message code (" + this.name + "." + stringArray[n] + "." + string2 + ")");
                        continue;
                    }
                    String string5 = Integer.toHexString(n2 + n3);
                    Properties properties = (Properties)hashMap.get(string5);
                    if (properties != null) {
                        properties.setProperty(string4, resourceBundle.getString(string2));
                        continue;
                    }
                    properties = new Properties();
                    properties.setProperty(string4, resourceBundle.getString(string2));
                    hashMap.put(string5, properties);
                }
            }
            ++n;
        }
        return hashMap;
    }

    public static class Test {
        public static void main(String[] stringArray) {
            MessageGroup messageGroup = new MessageGroup(stringArray[0]);
            Map map = messageGroup.getMessagePropertiesMap();
            TreeMap treeMap = new TreeMap(map);
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Properties properties = (Properties)entry.getValue();
                System.out.println("Message Code " + string);
                properties.list(System.out);
            }
        }
    }
}

