/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.util;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class CIMReference
extends CIMObjectPath {
    private String beanClassName;

    public CIMReference() {
    }

    public CIMReference(String string) {
        super(string);
    }

    public CIMReference(String string, String string2) {
        super(string, string2);
    }

    public CIMReference(String string, Vector vector) {
        super(string, vector);
    }

    public CIMReference(CIMObjectPath cIMObjectPath) {
        if (cIMObjectPath != null) {
            this.setObjectName(cIMObjectPath.getObjectName());
            this.setKeys(cIMObjectPath.getKeys());
        }
    }

    public CIMReference(CIMBean cIMBean) {
        if (cIMBean != null) {
            this.setObjectName(cIMBean.getCIMObjectPath().getObjectName());
            this.setKeys(cIMBean.getCIMObjectPath().getKeys());
            this.beanClassName = cIMBean.getClass().getName();
        }
    }

    public static CIMReference valueOf(String string) {
        return new CIMReference();
    }

    public String toString() {
        return super.toString();
    }

    public CIMValue getKeyValue(String string) {
        Vector vector = this.getKeys();
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(n);
            if (cIMProperty.getName().equalsIgnoreCase(string)) {
                return cIMProperty.getValue();
            }
            ++n;
        }
        return null;
    }

    public CIMBean createBean() {
        CIMBean cIMBean;
        Class<?> clazz;
        if (this.beanClassName == null) {
            return null;
        }
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            clazz = classLoader.loadClass(this.beanClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            cIMBean = (CIMBean)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        return cIMBean;
    }

    public static CIMReference getRelativeObjectPath(CIMObjectPath cIMObjectPath) {
        if (cIMObjectPath == null) {
            return null;
        }
        CIMReference cIMReference = new CIMReference();
        cIMReference.setObjectName(cIMObjectPath.getObjectName());
        cIMReference.setKeys(cIMObjectPath.getKeys());
        return cIMReference;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            CIMBean cIMBean = null;
            Vector<CIMProperty> vector = null;
            String string = "abba";
            CIMReference cIMReference = new CIMReference();
            cIMReference = new CIMReference("CIM_ManagedElement");
            cIMReference = new CIMReference("CIM_ManagedElement", "/root/namespace");
            cIMReference = new CIMReference("CIM_ManagedElement", vector);
            vector = new Vector<CIMProperty>();
            vector.add(new CIMProperty("Name", new CIMValue((Object)string)));
            cIMReference = new CIMReference("CIM_ManagedElement", vector);
            cIMReference = new CIMReference(cIMReference);
            CIMValue cIMValue = cIMReference.getKeyValue("Name");
            this.assertEquals((String)cIMValue.getValue(), string);
            cIMReference = new CIMReference(cIMBean);
        }
    }
}

