/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryServiceImpl;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class DiscoveryScheduler {
    static final int MILLISECONDS_IN_MINUTE = 60000;
    private static final String INBAND_INTERVAL = "CC_DeviceHandler.discovery_polling_interval";
    private Timer timer;
    private PollingTask polling;
    private int delayInterval = 300000;
    private DiscoveryServiceImpl disco;
    public static final String sccs_id = "@(#)DiscoveryScheduler.java\t1.4 04/02/04 SMI";

    DiscoveryScheduler(DiscoveryServiceImpl discoveryServiceImpl) {
        this.disco = discoveryServiceImpl;
        this.startPolling();
    }

    public void startPolling() {
        if (this.timer == null) {
            int n = 1;
            try {
                Properties properties = PropertiesPersister.restoreProperties((String)"InstallerService.properties");
                String string = properties.getProperty(INBAND_INTERVAL);
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Report.warning.log("Unable to parse inband interval; defaulting to 1 hour", (Object)exception);
                n = 1;
            }
            Report.info.log((Object)("Discovery polling interval is " + n));
            if (n > 0) {
                this.timer = new Timer(true);
                this.polling = new PollingTask();
                this.polling.run();
                this.timer.schedule((TimerTask)this.polling, this.delayInterval, (long)(n * 60 * 60000));
            }
        }
    }

    private class PollingTask
    extends TimerTask {
        private PollingTask() {
        }

        public void run() {
            SearchConfig[] searchConfigArray = DiscoveryScheduler.this.disco.getConfiguredSearches();
            if (searchConfigArray != null) {
                int n = 0;
                while (n < searchConfigArray.length) {
                    try {
                        SearchConfig searchConfig = searchConfigArray[n];
                        DiscoveryScheduler.this.disco.runSearch(searchConfig);
                    }
                    catch (Throwable throwable) {
                        PACKAGE.ERROR("Error running interval search", throwable);
                    }
                    ++n;
                }
            }
        }
    }
}

