/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.OID;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AdapterSticher;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AgentStore;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.AgentSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryStatusEvent;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.FCPProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.IEProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

class AgentSearchRun
implements Runnable {
    private AgentSearchConfig config;
    private SearchResultImpl sr;
    private boolean stop;
    private FCPProbe fcpProbe;
    private IEProbe ieProbe;
    private String host;
    private int numTargets;
    private int numIES;
    private int numFound;
    public static final String sccs_id = "@(#)AgentSearchRun.java\t1.8 08/15/03 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    AgentSearchRun(SearchResultImpl searchResultImpl) {
        this.sr = searchResultImpl;
        this.config = (AgentSearchConfig)searchResultImpl.getSearchConfig();
    }

    public void run() {
        if (!this.parseInput()) {
            return;
        }
        this.init();
        this.doDiscovery();
    }

    public void abort() {
        this.stop = true;
    }

    private boolean parseInput() {
        this.host = this.config.getHost();
        if (this.host == null) {
            this.sr.setErrorMsg("Host undefined.");
            return false;
        }
        return true;
    }

    private void init() {
        this.fcpProbe = new FCPProbe();
        this.ieProbe = new IEProbe();
        this.numFound = 0;
        this.numTargets = 0;
        this.numIES = 0;
    }

    private void doDiscovery() {
        try {
            Iterator iterator;
            Collection collection;
            AdapterSticher adapterSticher = new AdapterSticher(this.host);
            adapterSticher.instrumentAgent();
            AgentStore agentStore = new AgentStore();
            agentStore.storeHostData(adapterSticher);
            Collection collection2 = adapterSticher.getTargets();
            if (collection2 != null) {
                this.numTargets = collection2.size();
            }
            if ((collection = adapterSticher.getInterconnectElements()) != null) {
                this.numIES = collection.size();
            }
            int n = 0;
            if (this.numTargets > 0) {
                iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    this.probeFCPTarget((DeviceClass)iterator.next());
                    this.updateResult(++n, 0);
                }
            }
            if (this.numIES > 0) {
                iterator = collection.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    this.probeIE((DeviceClass)iterator.next());
                    this.updateResult(this.numTargets, ++n);
                }
            }
        }
        catch (Exception exception) {
            PACKAGE.ERROR("Agent Search Failed", exception);
            DiscoveryStatusEvent.postFailedStatus("Agent", this.host, new LocalizedString(exception));
            this.sr.setErrorMsg(exception.toString());
            return;
        }
        DiscoveryStatusEvent.postStatus("Agent", this.host, this.numFound);
        this.sr.setComplete();
    }

    private void probeFCPTarget(DeviceClass deviceClass) {
        Properties properties = new Properties();
        this.setProperty(properties, "RHBA.Host", this.host);
        this.setProperty(properties, "RHBA.FCPTARGET.DeviceType", deviceClass.getProperty("DeviceType"));
        this.setProperty(properties, "RHBA.FCPTARGET.FabricName", deviceClass.getProperty("FabricName"));
        this.setProperty(properties, "RHBA.FCPTARGET.IpAddress", deviceClass.getProperty("IpAddress"));
        this.setProperty(properties, "RHBA.FCPTARGET.NodeWWN", deviceClass.getProperty("NodeWWN"));
        this.setProperty(properties, "RHBA.FCPTARGET.OSDeviceName", deviceClass.getProperty("OSDeviceName"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortFcID", deviceClass.getProperty("PortFcID"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortMaxFrameSize", deviceClass.getProperty("PortMaxFrameSize"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortSpeed", deviceClass.getProperty("PortSpeed"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortState", deviceClass.getProperty("PortState"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortSupportedSpeed", deviceClass.getProperty("PortSupportedSpeed"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortType", deviceClass.getProperty("PortType"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortWWN", deviceClass.getProperty("PortWWN"));
        this.setProperty(properties, "RHBA.FCPTARGET.ProductId", deviceClass.getProperty("ProductId"));
        this.setProperty(properties, "RHBA.FCPTARGET.ProductRevision", deviceClass.getProperty("ProductRevision"));
        this.setProperty(properties, "RHBA.FCPTARGET.VendorId", deviceClass.getProperty("VendorId"));
        this.setProperty(properties, "RHBA.FCPTARGET.SystemId", deviceClass.getProperty("SystemId"));
        ProbeResult probeResult = this.fcpProbe.probe(properties);
        Iterator iterator = probeResult.getDevices().iterator();
        while (iterator.hasNext()) {
            Properties properties2 = (Properties)iterator.next();
            if (!this.checkProperties(properties2)) continue;
            this.installDevice(properties2);
            this.sr.addElement(properties2);
        }
    }

    private void probeIE(DeviceClass deviceClass) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = deviceClass.getChildren();
        while (iterator.hasNext()) {
            object2 = (DeviceClass)iterator.next();
            object = object2.getProperty("Address");
            if (object == null) continue;
            stringBuffer.append((String)object);
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        object2 = new Properties();
        this.setProperty((Properties)object2, "RHBA.Host", this.host);
        this.setProperty((Properties)object2, "RHBA.IE.Address", stringBuffer.toString());
        this.setProperty((Properties)object2, "RHBA.IE.DomainId", deviceClass.getProperty("DomainId"));
        this.setProperty((Properties)object2, "RHBA.IE.FabricName", deviceClass.getProperty("FabricName"));
        this.setProperty((Properties)object2, "RHBA.IE.LogicalName", deviceClass.getProperty("LogicalName"));
        this.setProperty((Properties)object2, "RHBA.IE.MgmtId", deviceClass.getProperty("MgmtId"));
        this.setProperty((Properties)object2, "RHBA.IE.ModelName", deviceClass.getProperty("ModelName"));
        this.setProperty((Properties)object2, "RHBA.IE.ReleaseCode", deviceClass.getProperty("ReleaseCode"));
        this.setProperty((Properties)object2, "RHBA.IE.Type", deviceClass.getProperty("Type"));
        this.setProperty((Properties)object2, "RHBA.IE.VendorName", deviceClass.getProperty("VendorName"));
        this.setProperty((Properties)object2, "RHBA.IE.VendorSpecificInfo", deviceClass.getProperty("VendorSpecificInfo"));
        this.setProperty((Properties)object2, "RHBA.IE.WWN", deviceClass.getProperty("WWN"));
        object = this.ieProbe.probe((Properties)object2);
        Iterator iterator2 = ((ProbeResult)object).getDevices().iterator();
        while (iterator2.hasNext()) {
            Properties properties = (Properties)iterator2.next();
            if (!this.checkProperties(properties)) continue;
            this.installDevice(properties);
            this.sr.addElement(properties);
        }
    }

    private void setProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private boolean checkProperties(Properties properties) {
        String string;
        String string2 = properties.getProperty("type");
        if (string2 == null || string2.equals("")) {
            return false;
        }
        if (null == properties.getProperty("OID")) {
            properties.setProperty("OID", OID.getKey());
        }
        if ((string = properties.getProperty("search.ib")) == null || string.equals("")) {
            properties.setProperty("search.ib", "" + System.currentTimeMillis());
        }
        properties.setProperty("active", "Y");
        return true;
    }

    private void installDevice(Properties properties) {
        try {
            FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = AgentSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
            if (facadeFactory == null) {
                Report.error.log((Object)"Error finding MF factory.");
                return;
            }
            facadeFactory.discoverDevice(properties);
            ++this.numFound;
        }
        catch (Exception exception) {
            Report.error.log((Throwable)exception, (Object)"error loading device.");
        }
    }

    private void updateResult(int n, int n2) {
        int n3 = this.numTargets + this.numIES;
        int n4 = n + n2;
        if (n3 > 0) {
            this.sr.setPercentComplete((n4 *= 100) / n3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Test
    extends UnitTest {
        public void test() throws Exception {
            SearchResultImpl searchResultImpl = new SearchResultImpl(new AgentSearchConfig());
            AgentSearchRun agentSearchRun = new AgentSearchRun(searchResultImpl);
            agentSearchRun.run();
            this.assertCondition(searchResultImpl.getStatus() == 3);
        }
    }
}

