/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.client;

import com.sun.jade.apps.command.DebugCommand;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DeviceDetail;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.IPSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceType;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class DiscoDebug
implements DebugCommand {
    public static String ROOT = "/jade/debug/discovery";
    private DiscoveryService disco;
    public static final String sccs_id = "@(#)DiscoDebug.java\t1.11 05/16/03 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService;

    public String getHelp() {
        return "Run discovery.";
    }

    public int execute(Properties properties, PrintWriter printWriter) throws IOException {
        String string = properties.getProperty("cmd");
        if ("ip".equals(string)) {
            this.runSearch(properties, printWriter);
        } else if ("list".equals(string)) {
            this.listRunningSearches(printWriter);
            this.listConfiguredSearches(printWriter);
        } else if ("stop".equals(string)) {
            this.stopSearch(properties, printWriter);
        } else if ("devs".equals(string)) {
            this.listDiscoveredDevices(properties, printWriter);
        } else if ("enable".equals(string)) {
            this.enable(properties, printWriter, true);
        } else if ("disable".equals(string)) {
            this.enable(properties, printWriter, false);
        } else if ("purge".equals(string)) {
            this.purge(properties, printWriter);
        } else if ("inband".equals(string)) {
            this.runConfiguredSearch(properties, printWriter);
        } else {
            this.printUsage(printWriter);
        }
        return 0;
    }

    private void enable(Properties properties, PrintWriter printWriter, boolean bl) {
        try {
            String string = properties.getProperty("dev");
            DiscoveryService discoveryService = this.getDiscoveryService();
            discoveryService.setDeviceMonitoring(string, bl);
            printWriter.println("<H1>Command completed</H1>");
            this.printUsage(printWriter);
        }
        catch (Exception exception) {
            printWriter.println("<H1>Error running command.</H1>");
            exception.printStackTrace(printWriter);
        }
    }

    private void purge(Properties properties, PrintWriter printWriter) {
        try {
            String string = properties.getProperty("dev");
            DiscoveryService discoveryService = this.getDiscoveryService();
            discoveryService.removeUnmonitoredDevices();
            printWriter.println("<H1>Command completed</H1>");
            this.printUsage(printWriter);
        }
        catch (Exception exception) {
            printWriter.println("<H1>Error running command.</H1>");
            exception.printStackTrace(printWriter);
        }
    }

    private void runSearch(Properties properties, PrintWriter printWriter) {
        try {
            String string = properties.getProperty("ipstart");
            String string2 = properties.getProperty("ipend");
            String string3 = properties.getProperty("timeout");
            IPSearchConfig iPSearchConfig = new IPSearchConfig();
            iPSearchConfig.setIpStart(string);
            iPSearchConfig.setIpEnd(string2);
            iPSearchConfig.setTimeout(Integer.parseInt(string3));
            DiscoveryService discoveryService = this.getDiscoveryService();
            SearchResult searchResult = discoveryService.runSearch(iPSearchConfig);
            printWriter.println("Started discovery with the following values:<UL>");
            printWriter.println("<LI>Start ip = " + string);
            printWriter.println("<LI>End   ip = " + string2);
            printWriter.println("<LI>Timeout  = " + string3);
            printWriter.println("</UL>");
            printWriter.println("<P>Search Result ID=" + searchResult.getId());
            printWriter.println("<p>View Discovery <A HREF=\"");
            printWriter.print(ROOT);
            printWriter.println("?cmd=list\">Searches</A>");
        }
        catch (Exception exception) {
            printWriter.println("<H1>Error running command.</H1>");
            exception.printStackTrace(printWriter);
        }
    }

    private void listConfiguredSearches(PrintWriter printWriter) {
        try {
            DiscoveryService discoveryService = this.getDiscoveryService();
            SearchConfig[] searchConfigArray = discoveryService.getConfiguredSearches();
            if (searchConfigArray != null) {
                printWriter.println("Configured Searches <UL>");
                int n = 0;
                while (n < searchConfigArray.length) {
                    SearchConfig searchConfig = searchConfigArray[n];
                    printWriter.print("<LI>");
                    printWriter.print(searchConfig.getName());
                    printWriter.println("<UL>");
                    this.printPropList(searchConfig.getSearchProperties(), printWriter);
                    printWriter.println("</UL>");
                    ++n;
                }
                printWriter.println("</UL>");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void runConfiguredSearch(Properties properties, PrintWriter printWriter) {
        try {
            DiscoveryService discoveryService = this.getDiscoveryService();
            SearchConfig[] searchConfigArray = discoveryService.getConfiguredSearches();
            if (searchConfigArray != null) {
                int n = 0;
                while (n < searchConfigArray.length) {
                    SearchConfig searchConfig = searchConfigArray[n];
                    SearchResult searchResult = discoveryService.runSearch(searchConfig);
                    ++n;
                }
                this.listRunningSearches(printWriter);
            } else {
                printWriter.println("<H1>No Configured searches to run.</H1><HR>");
            }
            this.printUsage(printWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void listRunningSearches(PrintWriter printWriter) {
        try {
            DiscoveryService discoveryService = this.getDiscoveryService();
            SearchResult[] searchResultArray = discoveryService.getRunningSearches();
            if (searchResultArray != null) {
                printWriter.println("Running Searches <UL>");
                int n = 0;
                while (n < searchResultArray.length) {
                    String string;
                    SearchResult searchResult = searchResultArray[n];
                    printWriter.print("<LI>");
                    printWriter.print(searchResult.getId());
                    printWriter.print(" started=" + searchResult.getStartTime());
                    printWriter.print(" " + searchResult.getPercentComplete() + "%");
                    if (null != searchResult.getCompletionTime()) {
                        printWriter.print(" finished=" + searchResult.getCompletionTime());
                    }
                    switch (searchResult.getStatus()) {
                        case 1: {
                            string = "running";
                            break;
                        }
                        case 2: {
                            string = "finished";
                            break;
                        }
                        case 3: {
                            string = "failed";
                            break;
                        }
                        default: {
                            string = "unknown";
                        }
                    }
                    printWriter.println(" Status=" + string);
                    printWriter.println(" <A HREF=\"");
                    printWriter.print(ROOT);
                    printWriter.print("?cmd=stop&id=");
                    printWriter.print(searchResult.getId());
                    printWriter.println("\">[Stop]</A>");
                    Iterator iterator = searchResult.getResults();
                    printWriter.println(" Results: <UL>");
                    while (iterator.hasNext()) {
                        Properties properties = (Properties)iterator.next();
                        printWriter.println(" Discovered Device : <UL>");
                        this.printPropList(properties, printWriter);
                        printWriter.println("</UL>");
                    }
                    printWriter.println("</UL>");
                    ++n;
                }
                printWriter.println("</UL>");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void listDiscoveredDevices(Properties properties, PrintWriter printWriter) {
        try {
            Object object;
            int n = 1;
            try {
                object = properties.getProperty("filter");
                if (object != null) {
                    n = Integer.parseInt((String)object);
                }
            }
            catch (Exception exception) {
                printWriter.println("Using filter DEVICE_FILTER_ALL");
            }
            object = this.getDiscoveryService();
            DeviceDetail[] deviceDetailArray = object.getDiscoveredDevices(n);
            printWriter.println("Found " + deviceDetailArray.length + " Discovered Devices (filter=" + n + ")<ul>");
            int n2 = 0;
            while (n2 < deviceDetailArray.length) {
                DeviceDetail deviceDetail = deviceDetailArray[n2];
                String string = deviceDetail.getDeviceKey();
                DeviceType deviceType = deviceDetail.getDeviceType();
                Date date = deviceDetail.getLastDiscovery();
                String string2 = "unknown";
                int n3 = deviceDetail.getSearchType();
                string2 = n3 == 1 ? "OOB" : (n3 == 2 ? "IB" : "OOB&IB");
                printWriter.print("<LI>" + deviceType.getFlavor() + ":" + deviceType.getVendor() + ":" + deviceType.getModel());
                printWriter.print(":" + deviceDetailArray[n2].getDisplayName());
                printWriter.print(":" + date);
                printWriter.print(":" + string2);
                printWriter.print(" <A HREF=\"");
                printWriter.print(ROOT);
                if (deviceDetailArray[n2].getMonitorState()) {
                    printWriter.println("?cmd=disable&dev=" + string + "\">disable</A>");
                } else {
                    printWriter.println("?cmd=enable&dev=" + string + "\">enable</A>");
                }
                ++n2;
            }
            printWriter.println("</ul>");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void stopSearch(Properties properties, PrintWriter printWriter) throws IOException {
        try {
            DiscoveryService discoveryService = this.getDiscoveryService();
            discoveryService.stopSearch(properties.getProperty("id"));
            this.listRunningSearches(printWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void printPropList(Properties properties, PrintWriter printWriter) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            printWriter.print("<LI>");
            printWriter.print(string);
            printWriter.print("=");
            printWriter.println(string2);
        }
    }

    private synchronized DiscoveryService getDiscoveryService() {
        if (this.disco == null) {
            try {
                Registry registry = LocateRegistry.getRegistry("localhost");
                this.disco = (DiscoveryService)registry.lookup((class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService == null ? (class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService = DiscoDebug.class$("com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService")) : class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService).getPackage().getName());
            }
            catch (Exception exception) {
                Report.error.log("Error getting discovery.", (Object)exception);
                return null;
            }
        }
        return this.disco;
    }

    private void printUsage(PrintWriter printWriter) throws IOException {
        printWriter.println("<H1>Discovery</H1>");
        printWriter.println("commands:<ul>");
        printWriter.print("<li>View Discovery <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?cmd=list\">Searches</A>");
        printWriter.print("<li>View Discovered <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?cmd=devs\">Devices</A>");
        printWriter.print("<li>Purge Unmanaged <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?cmd=purge\">Devices</A>");
        printWriter.print("<li>Run all configured searches <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?cmd=inband\">Now</A>");
        printWriter.println("<li>Run Discovery.");
        printWriter.println("<FORM METHOD=GET ACTION=\"" + ROOT + "\">");
        printWriter.println("Out of band discovery:");
        printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"cmd\" VALUE=\"ip\">");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"ipstart\" VALUE=\"\" SIZE=\"32\">Start IP Address");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"ipend\" VALUE=\"\" SIZE=\"32\">End IP Address");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"timeout\" VALUE=\"10\" SIZE=\"16\">Timeout (seconds)");
        printWriter.println("<INPUT TYPE=\"submit\" VALUE=\"Submit\">");
        printWriter.println("<INPUT TYPE=\"reset\">");
        printWriter.println("</FORM>");
        printWriter.println("</ul>");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

