/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.hds.service;

import com.sun.jade.device.array.hds.io.HDS_9900_Mibsnmp;
import com.sun.jade.device.array.hds.service.Messages;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.RHBAConverter;
import com.sun.jade.device.util.ReportHandler;
import com.sun.jade.device.util.ReportTools;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AgentStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class HDSReportGenerator
implements ReportGenerator {
    public static final String CLASS_NAME = "StorEdge9900_System";
    public static final int SYSTEM = 0;
    public static final int CONTROL_UNIT = 1;
    public static final int DISK_UNIT = 2;
    private Properties props;
    private String systemName;
    private String ip;
    private String serialNumber;
    private String model;
    private HashMap oobData;
    private ArrayList ibData;
    private String[] attrs = new String[]{"dkcHWProcessor", "dkcHWCSW", "dkcHWCache", "dkcHWSM", "dkcHWPS", "dkcHWBattery", "dkcHWFan", "dkcHWEnvironment", "dkuHWPS", "dkuHWFan", "dkuHWEnvironment", "dkuHWDrive"};
    private String[] dkcAttrs = new String[]{"dkcHWCSW", "dkcHWCache", "dkcHWSM", "dkcHWPS", "dkcHWBattery", "dkcHWFan", "dkcHWEnvironment"};
    private String[] dkuAttrs = new String[]{"dkuHWPS", "dkuHWFan", "dkuHWEnvironment", "dkuHWDrive"};
    private static final Localizer msgs = Messages.getLocalizer();
    private static final String NO_FABRIC_NAME = "0000000000000000";
    private static final String HDS_TYPE = "hds";
    private static final String OK = "OK";
    private static final String ACUTE = "Acute Error";
    private static final String SERIOUS = "Serious Error";
    private static final String MODERATE = "Moderate Error";
    private static final String SERVICE = "Service";
    private static final String UNKNOWN = "Unknown";
    private static final String TAG = "hds";
    private static final String sccs_id = "@(#)HDSReportGenerator.java\t1.9 02/20/03 SMI";

    public HDSReportGenerator(Properties properties) {
        this.props = properties;
        this.ip = this.props.getProperty("ip");
        this.systemName = this.props.getProperty("name");
        this.serialNumber = this.props.getProperty("serialNumber");
        this.model = this.props.getProperty("MODEL");
    }

    public String generateReport() {
        this.ip = this.props.getProperty("ip");
        this.serialNumber = this.props.getProperty("serialNumber");
        this.ibData = this.collectInBandData();
        this.oobData = this.collectOOBData();
        DeviceClass deviceClass = null;
        if (this.oobData != null) {
            deviceClass = this.createReport();
        } else {
            deviceClass = ReportHandler.retrieveDeviceClasses((String)this.systemName, (String)"hds");
            if (deviceClass != null) {
                if (this.ibData != null) {
                    this.updateReport(deviceClass);
                } else {
                    deviceClass.setProperty("ReturnCode", "FAILURE");
                }
            } else if (this.ibData != null) {
                deviceClass = this.createReport();
            } else {
                String string = "<report ReturnCode=\"FAILURE\">\n<exception Reason=\"Lost Comm\">No OOB or IB data available</exception>\n</report>\n";
                return string;
            }
        }
        String string = null;
        if (deviceClass != null) {
            string = deviceClass.toXML();
        }
        this.oobData = null;
        this.ibData = null;
        return string;
    }

    private HashMap collectOOBData() {
        HashMap hashMap = null;
        if (this.ip != null) {
            HDS_9900_Mibsnmp hDS_9900_Mibsnmp = new HDS_9900_Mibsnmp(this.ip);
            hashMap = hDS_9900_Mibsnmp.getDKCProps(this.serialNumber);
            HashMap hashMap2 = hDS_9900_Mibsnmp.getDKUProps(this.serialNumber);
            if (hashMap == null || hashMap2 == null) {
                hashMap = null;
                Report.error.log((Object)("Error accessing snmp on " + this.systemName));
            } else if (hashMap.size() == 0 || hashMap2.size() == 0) {
                hashMap = null;
                Report.error.log((Object)("Error accessing snmp on " + this.systemName));
            } else {
                hashMap.putAll(hashMap2);
            }
        } else {
            Report.warning.log((Object)("No IP address for " + this.systemName));
        }
        return hashMap;
    }

    private ArrayList collectInBandData() {
        ArrayList<DeviceClass> arrayList = null;
        String string = this.props.getProperty("name.ib");
        if (string != null) {
            AgentStore agentStore = new AgentStore();
            Iterator iterator = agentStore.getTarget(string);
            if (iterator.hasNext()) {
                arrayList = new ArrayList<DeviceClass>();
                while (iterator.hasNext()) {
                    DeviceClass deviceClass = (DeviceClass)iterator.next();
                    arrayList.add(deviceClass);
                }
            }
        } else {
            Report.debug.log((Object)("In band name is null for: " + this.systemName));
        }
        return arrayList;
    }

    private DeviceClass createReport() {
        DeviceClass deviceClass;
        DeviceClass deviceClass2;
        Object object;
        Object object2;
        DeviceClass deviceClass3 = new DeviceClass();
        deviceClass3.setClassName("report");
        deviceClass3.setProperty("ReturnCode", OK);
        DeviceClass deviceClass4 = deviceClass3.newSubInstance();
        deviceClass4.setClassName("model");
        deviceClass4.setProperty("schema", "CIM2.5");
        deviceClass4.setProperty("view", "system");
        deviceClass4.setProperty("type", "array");
        deviceClass4.setProperty("prefix", "StorEdge9900");
        deviceClass4.setProperty("package", "com.sun.jade.cim.bean");
        DeviceClass deviceClass5 = deviceClass4.newSubInstance();
        deviceClass5.setClassName("SystemView");
        DeviceClass deviceClass6 = deviceClass5.newSubInstance();
        this.addSystem(deviceClass6);
        if (this.oobData != null) {
            object2 = deviceClass6.newSubInstance();
            this.addBattery((DeviceClass)object2);
            DeviceClass deviceClass7 = deviceClass6.newSubInstance();
            this.addCacheSwitch(deviceClass7);
            object = deviceClass6.newSubInstance();
            this.addCache((DeviceClass)object);
            deviceClass2 = deviceClass6.newSubInstance();
            this.addSharedMemory(deviceClass2);
            deviceClass = deviceClass6.newSubInstance();
            this.addDiskDrive(deviceClass);
            DeviceClass deviceClass8 = deviceClass6.newSubInstance();
            this.addFan(deviceClass8, "dkcHWFan");
            DeviceClass deviceClass9 = deviceClass6.newSubInstance();
            this.addFan(deviceClass9, "dkuHWFan");
            DeviceClass deviceClass10 = deviceClass6.newSubInstance();
            this.addMonitor(deviceClass10, "dkcHWEnvironment");
            DeviceClass deviceClass11 = deviceClass6.newSubInstance();
            this.addMonitor(deviceClass11, "dkuHWEnvironment");
            DeviceClass deviceClass12 = deviceClass6.newSubInstance();
            this.addPower(deviceClass12, "dkcHWPS");
            DeviceClass deviceClass13 = deviceClass6.newSubInstance();
            this.addPower(deviceClass13, "dkuHWPS");
            DeviceClass deviceClass14 = deviceClass6.newSubInstance();
            this.addProcessor(deviceClass14);
        }
        if (this.ibData != null) {
            object2 = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"FCPTARGET.ASSET", (String)"PortWWN");
            int n = 0;
            while (n < ((ArrayList)object2).size()) {
                object = (DeviceClass)((ArrayList)object2).get(n);
                deviceClass2 = deviceClass6.newSubInstance();
                this.addFibrePort(deviceClass2, (DeviceClass)object);
                this.addProtocolEndpoint(deviceClass2.newSubInstance(), (DeviceClass)object);
                ++n;
            }
            object = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"LUN.ASSET", (String)"LUID");
            int n2 = 0;
            while (n2 < ((ArrayList)object).size()) {
                deviceClass = (DeviceClass)((ArrayList)object).get(n2);
                this.addLogicalDisk(deviceClass6.newSubInstance(), deviceClass);
                ++n2;
            }
        }
        return deviceClass3;
    }

    private void updateReport(DeviceClass deviceClass) {
        if (this.ibData != null) {
            Object object;
            DeviceClass deviceClass2;
            Object object2;
            DeviceClass deviceClass3 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"CreationClassName", (String)CLASS_NAME);
            this.updateSystem(deviceClass3);
            ArrayList arrayList = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"FCPTARGET.ASSET", (String)"PortWWN");
            int n = 0;
            while (n < arrayList.size()) {
                object2 = (DeviceClass)arrayList.get(n);
                String string = object2.getProperty("PortWWN");
                deviceClass2 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"DeviceID", (String)string);
                if (deviceClass2 != null) {
                    this.addFibrePort(deviceClass2, (DeviceClass)object2);
                } else {
                    object = deviceClass3.newSubInstance();
                    this.addFibrePort((DeviceClass)object, (DeviceClass)object2);
                    this.addProtocolEndpoint(object.newSubInstance(), (DeviceClass)object2);
                }
                ++n;
            }
            object2 = ReportTools.getRHBATarget((ArrayList)this.ibData, (String)"LUN.ASSET", (String)"LUID");
            int n2 = 0;
            while (n2 < ((ArrayList)object2).size()) {
                deviceClass2 = (DeviceClass)((ArrayList)object2).get(n2);
                object = deviceClass2.getProperty("LUID");
                DeviceClass deviceClass4 = ReportTools.findTarget((DeviceClass)deviceClass, (String)"DeviceID", (String)object);
                if (deviceClass4 != null) {
                    this.addLogicalDisk(deviceClass4, deviceClass2);
                } else {
                    DeviceClass deviceClass5 = deviceClass3.newSubInstance();
                    this.addLogicalDisk(deviceClass5, deviceClass2);
                }
                ++n2;
            }
        }
    }

    private void addSystem(DeviceClass deviceClass) {
        deviceClass.setClassName("System");
        this.xmlAttr(deviceClass, "CreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "Name", this.systemName);
        if (this.oobData != null) {
            this.xmlAttr(deviceClass, "Status", this.deriveStatus(0));
        } else {
            this.xmlAttr(deviceClass, "Status", UNKNOWN);
        }
        this.xmlAttr(deviceClass, "UnitType", this.model);
        if (this.serialNumber != null) {
            this.xmlAttr(deviceClass, "SerialNumber", this.serialNumber);
        } else {
            String string = null;
            if (this.systemName.length() > 4) {
                string = this.systemName.substring(4);
            }
            try {
                this.serialNumber = Integer.valueOf(string, 16).toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.xmlStringAttr(deviceClass, "SerialNumber", this.serialNumber);
        }
    }

    private void updateSystem(DeviceClass deviceClass) {
        this.xmlAttr(deviceClass, "Name", this.systemName);
        this.xmlAttr(deviceClass, "UnitType", this.model);
        if (this.serialNumber != null) {
            this.xmlAttr(deviceClass, "SerialNumber", this.serialNumber);
        } else {
            String string = null;
            if (this.systemName.length() > 4) {
                string = this.systemName.substring(4);
            }
            try {
                this.serialNumber = Integer.valueOf(string, 16).toString();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.xmlStringAttr(deviceClass, "SerialNumber", this.serialNumber);
        }
    }

    private void addBattery(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Battery");
        this.xmlAttr(deviceClass, "Description", "Non volatile cache batteries");
        this.xmlAttr(deviceClass, "Name", "Battery");
        this.xmlAttr(deviceClass, "DeviceID", "bat");
        this.setHealth(deviceClass, "dkcHWBattery");
    }

    private void addBus(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Bus");
        this.xmlAttr(deviceClass, "Description", "Internal Bus");
        this.xmlAttr(deviceClass, "Name", "Bus");
        this.xmlAttr(deviceClass, "DeviceID", "bus");
        this.setHealth(deviceClass, "dkcHWBusy");
    }

    private void addCacheSwitch(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_CacheSwitch");
        this.xmlAttr(deviceClass, "Description", "Cache switch cards");
        this.xmlAttr(deviceClass, "Name", "CSW");
        this.xmlAttr(deviceClass, "DeviceID", "csw");
        this.setHealth(deviceClass, "dkcHWCSW");
    }

    private void addCache(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Cache");
        this.xmlAttr(deviceClass, "Description", "Cache memory cards");
        this.xmlAttr(deviceClass, "Name", "Cache cards");
        this.xmlAttr(deviceClass, "DeviceID", "cache");
        this.setHealth(deviceClass, "dkcHWCache");
    }

    private void addSharedMemory(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_SharedMemory");
        this.xmlAttr(deviceClass, "Description", "Shared Memory");
        this.xmlAttr(deviceClass, "Name", "Shared Memory");
        this.xmlAttr(deviceClass, "DeviceID", "smem");
        this.setHealth(deviceClass, "dkcHWSM");
    }

    private void addDiskDrive(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_DiskDrive");
        this.xmlAttr(deviceClass, "Description", "Disk Drives");
        this.xmlAttr(deviceClass, "Name", "Disk Drives");
        this.xmlAttr(deviceClass, "DeviceID", "disk");
        this.setHealth(deviceClass, "dkuHWDrive");
    }

    private void addFan(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Fan");
        this.xmlAttr(deviceClass, "Description", "Fan Assembly");
        this.xmlAttr(deviceClass, "Name", "Fan");
        if (string.startsWith("dkc")) {
            this.xmlAttr(deviceClass, "DeviceID", "dkcf");
        } else {
            this.xmlAttr(deviceClass, "DeviceID", "dkuf");
        }
        this.setHealth(deviceClass, string);
    }

    private void addMonitor(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Monitor");
        this.xmlAttr(deviceClass, "Name", "Monitor");
        if (string.startsWith("dkc")) {
            this.xmlAttr(deviceClass, "Description", "Control Unit Environmental Monitor");
            this.xmlAttr(deviceClass, "DeviceID", "dkcm");
        } else {
            this.xmlAttr(deviceClass, "Description", "Disk Unit Environmental Monitor");
            this.xmlAttr(deviceClass, "DeviceID", "dkum");
        }
        this.setHealth(deviceClass, string);
    }

    private void addPower(DeviceClass deviceClass, String string) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Power");
        this.xmlAttr(deviceClass, "Name", "Power Supply");
        if (string.startsWith("dkc")) {
            this.xmlAttr(deviceClass, "Description", "Control Unit Power Supplies");
            this.xmlAttr(deviceClass, "DeviceID", "dkcp");
        } else {
            this.xmlAttr(deviceClass, "Description", "Disk Unit Power Supplies");
            this.xmlAttr(deviceClass, "DeviceID", "dkup");
        }
        this.setHealth(deviceClass, string);
    }

    private void addProcessor(DeviceClass deviceClass) {
        deviceClass.setClassName("LogicalDevice");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_Processor");
        this.xmlAttr(deviceClass, "Description", "Control Processor");
        this.xmlAttr(deviceClass, "Name", "Control Processors");
        this.xmlAttr(deviceClass, "DeviceID", "dkccp");
        this.setHealth(deviceClass, "dkcHWProcessor");
    }

    private void addFibrePort(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("FibrePort");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_FibrePort");
        this.xmlAttr(deviceClass, "Description", "Fibre channel port");
        String string = deviceClass2.getProperty("PortFcID");
        String string2 = deviceClass2.getProperty("PortWWN");
        String string3 = deviceClass2.getProperty("PortState");
        String string4 = deviceClass2.getProperty("PortType");
        String string5 = deviceClass2.getProperty("PortSpeed");
        String string6 = deviceClass2.getProperty("PortSupportedSpeed");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "Status", RHBAConverter.derivePortStatus((String)string3));
        this.xmlAttr(deviceClass, "State", RHBAConverter.derivePortState((String)string3));
        this.xmlAttr(deviceClass, "CurrentPortType", RHBAConverter.derivePortType((String)string4));
        this.xmlAttr(deviceClass, "Speed", RHBAConverter.derivePortSpeed((String)string5));
        this.xmlAttr(deviceClass, "MaxSpeed", RHBAConverter.derivePortSpeed((String)string6));
    }

    private void addProtocolEndpoint(DeviceClass deviceClass, DeviceClass deviceClass2) {
        DeviceClass deviceClass3;
        String string = deviceClass2.getProperty("PortWWN");
        deviceClass.setClassName("ProtocolEndpoint");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "NameFormat", "WWN");
        this.xmlAttr(deviceClass, "ProtocolType", "Fibre Channel");
        String string2 = deviceClass2.getProperty("FabricName");
        if (NO_FABRIC_NAME.equals(string2) && (deviceClass3 = deviceClass2.getParent()) != null) {
            DeviceClass deviceClass4 = deviceClass.newSubInstance();
            deviceClass4.setClassName("ProtocolEndpoint");
            this.xmlAttr(deviceClass4, "Name", deviceClass3.getProperty("portWWN"));
            this.xmlAttr(deviceClass4, "NameFormat", "WWN");
            this.xmlAttr(deviceClass4, "ProtocolType", "Fibre Channel");
        }
    }

    private void addLogicalDisk(DeviceClass deviceClass, DeviceClass deviceClass2) {
        deviceClass.setClassName("LogicalDisk");
        this.xmlAttr(deviceClass, "SystemCreationClassName", CLASS_NAME);
        this.xmlAttr(deviceClass, "SystemName", this.systemName);
        this.xmlAttr(deviceClass, "CreationClassName", "StorEdge9900_LogicalDisk");
        this.xmlAttr(deviceClass, "Description", "A volume as presented to a host.");
        String string = deviceClass2.getProperty("FcpLunId");
        String string2 = deviceClass2.getProperty("LUID");
        String string3 = deviceClass2.getProperty("BlockSize");
        String string4 = deviceClass2.getProperty("NumBlocks");
        this.xmlAttr(deviceClass, "Name", string);
        this.xmlAttr(deviceClass, "DeviceID", string2);
        this.xmlAttr(deviceClass, "NumberOfBlocks", string4);
        this.xmlAttr(deviceClass, "BlockSize", string3);
        this.xmlAttr(deviceClass, "Status", UNKNOWN);
    }

    private void setHealth(DeviceClass deviceClass, String string) {
        int n = this.parseState(string);
        this.xmlAttr(deviceClass, "Status", this.convertToCIMStatus(n));
        this.xmlAttr(deviceClass, "Availability", this.convertToCIMAvailability(n));
        this.xmlAttr(deviceClass, "State", this.getState(n));
    }

    private String getState(int n) {
        String string = UNKNOWN;
        switch (n) {
            case 1: {
                string = OK;
                break;
            }
            case 2: {
                string = ACUTE;
                break;
            }
            case 3: {
                string = SERIOUS;
                break;
            }
            case 4: {
                string = MODERATE;
                break;
            }
            case 5: {
                string = SERVICE;
                break;
            }
            default: {
                string = UNKNOWN;
            }
        }
        return string;
    }

    private String getState(String string) {
        String string2 = UNKNOWN;
        int n = this.parseState(string);
        return this.getState(n);
    }

    private int parseState(String string) {
        int n = 0;
        String string2 = (String)this.oobData.get(string);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    private String deriveStatus(int n) {
        String string = UNKNOWN;
        int n2 = 0;
        switch (n) {
            case 1: 
            case 2: {
                n2 = this.deriveUnitStatus(n);
                break;
            }
            case 0: {
                n2 = this.deriveSystemStatus();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        switch (n2) {
            case 1: {
                string = OK;
                break;
            }
            case 2: {
                string = "NonRecover";
                break;
            }
            case 3: {
                string = "Error";
                break;
            }
            case 4: {
                string = "Degraded";
                break;
            }
            case 5: {
                string = SERVICE;
                break;
            }
            default: {
                string = UNKNOWN;
            }
        }
        return string;
    }

    private int deriveSystemStatus() {
        int n = 0;
        int n2 = this.deriveUnitStatus(1);
        int n3 = this.deriveUnitStatus(2);
        n = this.worstCase(n2, n3);
        return n;
    }

    private int deriveUnitStatus(int n) {
        int n2 = 0;
        int n3 = 0;
        String[] stringArray = null;
        if (n == 1) {
            stringArray = this.dkcAttrs;
        } else if (n == 2) {
            stringArray = this.dkuAttrs;
        } else {
            return n2;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            n3 = this.parseState(stringArray[n4]);
            n2 = this.worstCase(n2, n3);
            ++n4;
        }
        return n2;
    }

    private int worstCase(int n, int n2) {
        int n3 = n;
        if (n3 == 0) {
            n3 = n2;
        } else if (n3 == 1 && n2 > 1) {
            n3 = n2;
        } else if (n2 > 1 && n2 < n3) {
            n3 = n2;
        }
        return n3;
    }

    private void xmlAttr(DeviceClass deviceClass, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        deviceClass.setProperty(string, string2);
    }

    private void xmlStringAttr(DeviceClass deviceClass, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.xmlAttr(deviceClass, string, string2);
    }

    protected String convertToCIMStatus(int n) {
        String string = UNKNOWN;
        switch (n) {
            case 1: {
                string = OK;
                break;
            }
            case 2: {
                string = "Error";
                break;
            }
            case 3: {
                string = "Error";
                break;
            }
            case 4: {
                string = "Degraded";
                break;
            }
            case 5: {
                string = SERVICE;
                break;
            }
            default: {
                string = UNKNOWN;
            }
        }
        return string;
    }

    protected String convertToCIMAvailability(int n) {
        int n2 = 2;
        switch (n) {
            case 1: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 4;
            }
        }
        return Integer.toString(n2);
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        if (stringArray.length > 0) {
            properties.setProperty("ip", stringArray[0]);
            properties.setProperty("serialNumber", stringArray[1]);
            HDSReportGenerator hDSReportGenerator = new HDSReportGenerator(properties);
            String string = hDSReportGenerator.generateReport();
            System.out.println(string);
        } else {
            System.out.println("Usage: HDSReportGenerator <ip address> <serial number>");
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            Properties properties = new Properties();
            properties.setProperty("ip", "localhost");
            HDSReportGenerator hDSReportGenerator = new HDSReportGenerator(properties);
            hDSReportGenerator.oobData = new HashMap();
            hDSReportGenerator.oobData.put("dkcHWProcessor", "1");
            hDSReportGenerator.oobData.put("dkcHWCSW", "2");
            hDSReportGenerator.oobData.put("dkcHWCache", "3");
            hDSReportGenerator.oobData.put("dkcHWSM", "4");
            hDSReportGenerator.oobData.put("dkcHWPS", "5");
            hDSReportGenerator.oobData.put("dkcHWBattery", "0");
            hDSReportGenerator.oobData.put("dkcHWFan", "fan");
            hDSReportGenerator.oobData.put("dkcHWEnvironment", "1.5");
            hDSReportGenerator.oobData.put("dkuHWPS", "");
            hDSReportGenerator.oobData.put("dkuHWFan", "1");
            hDSReportGenerator.oobData.put("dkuHWEnvironment", "1");
            this.assertEquals(HDSReportGenerator.OK, hDSReportGenerator.getState("dkcHWProcessor"));
            this.assertEquals(HDSReportGenerator.ACUTE, hDSReportGenerator.getState("dkcHWCSW"));
            this.assertEquals(HDSReportGenerator.SERIOUS, hDSReportGenerator.getState("dkcHWCache"));
            this.assertEquals(HDSReportGenerator.MODERATE, hDSReportGenerator.getState("dkcHWSM"));
            this.assertEquals(HDSReportGenerator.SERVICE, hDSReportGenerator.getState("dkcHWPS"));
            this.assertEquals(HDSReportGenerator.UNKNOWN, hDSReportGenerator.getState("dkcHWBattery"));
            this.assertEquals(HDSReportGenerator.UNKNOWN, hDSReportGenerator.getState("dkcHWFan"));
            this.assertEquals(HDSReportGenerator.UNKNOWN, hDSReportGenerator.getState("dkcHWEnvironment"));
            this.assertEquals(HDSReportGenerator.UNKNOWN, hDSReportGenerator.getState("dkuHWPS"));
            this.assertEquals(HDSReportGenerator.OK, hDSReportGenerator.getState("dkuHWFan"));
            this.assertEquals(HDSReportGenerator.OK, hDSReportGenerator.getState("dkuHWEnvironment"));
            this.assertEquals(HDSReportGenerator.UNKNOWN, hDSReportGenerator.getState("dkuHWDrive"));
            this.assertCondition(0 == hDSReportGenerator.worstCase(0, 0));
            this.assertCondition(1 == hDSReportGenerator.worstCase(0, 1));
            this.assertCondition(1 == hDSReportGenerator.worstCase(1, 0));
            this.assertCondition(3 == hDSReportGenerator.worstCase(1, 3));
            this.assertCondition(3 == hDSReportGenerator.worstCase(3, 1));
            this.assertCondition(2 == hDSReportGenerator.worstCase(2, 5));
            this.assertCondition(2 == hDSReportGenerator.worstCase(5, 2));
            this.assertCondition(4 == hDSReportGenerator.worstCase(0, 4));
            this.assertCondition(4 == hDSReportGenerator.worstCase(4, 0));
            this.assertCondition(2 == hDSReportGenerator.deriveUnitStatus(1));
            this.assertCondition(1 == hDSReportGenerator.deriveUnitStatus(2));
            this.assertCondition(2 == hDSReportGenerator.deriveSystemStatus());
            String string = "NonRecover";
            this.assertCondition(string.equals(hDSReportGenerator.deriveStatus(0)));
            String string2 = "2";
            this.assertCondition(string2.equals(hDSReportGenerator.convertToCIMAvailability(0)));
            string2 = "3";
            this.assertCondition(string2.equals(hDSReportGenerator.convertToCIMAvailability(1)));
            string2 = "4";
            this.assertCondition(string2.equals(hDSReportGenerator.convertToCIMAvailability(2)));
            this.assertCondition(string2.equals(hDSReportGenerator.convertToCIMAvailability(3)));
            this.assertCondition(string2.equals(hDSReportGenerator.convertToCIMAvailability(4)));
            this.assertCondition(string2.equals(hDSReportGenerator.convertToCIMAvailability(5)));
        }
    }
}

