/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.client;

import com.sun.opencard.cmd.OCFDisable;
import com.sun.opencard.cmd.OCFEnable;
import com.sun.smartcard.gui.client.plugin.ClientPluginGuiCtx;
import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginException;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import com.sun.smartcard.gui.supplemental.plugins.client.DesktopConfig;
import com.sun.smartcard.mgt.util.ResourceManager;
import java.util.Properties;
import java.util.ResourceBundle;

public class CDEClientPlugin
implements SmartCardPlugin {
    private boolean enableSmartCard;
    private boolean ignoreCardRemoval;
    private boolean reauthAfterCardRemoval;
    private int cardRemovalTimeout;
    private int cardRemovalTimeoutMax = 120;
    private int reauthTimeout;
    private int reauthTimeoutMax = 120;
    private int cardRemovalLogoutWait;
    private int cardRemovalLogoutWaitMax = 120;
    private static final String useSmartCardProp = "desktop.useSmartCard";
    private static final String ignoreCardRemovalProp = "desktop.ignoreCardRemoval";
    private static final String reauthAfterCardRemovalProp = "desktop.reauthAfterCardRemoval";
    private static final String cardRemovalTimeoutProp = "desktop.cardRemovalTimeout";
    private static final String reauthTimeoutProp = "desktop.reauthTimeout";
    private static final String cardRemovalLogoutWaitProp = "desktop.cardRemovalLogoutWait";
    private PluginSlider cardRemovalTimeoutSlider;
    private PluginSlider reauthTimeoutSlider;
    private PluginSlider cardRemovalLogoutWaitSlider;
    private PluginCheckBox ignoreCardRemovalCheckbox;
    private PluginCheckBox reauthAfterCardRemovalCheckbox;
    private ClientPluginGuiCtx pgc;
    private Properties cfgProps;
    private static ResourceBundle toolBundle;
    private boolean debug;

    public CDEClientPlugin(Properties p) throws PluginException {
        this.debug = System.getProperty("debug") != null;
        System.out.println("WRONG CONSTRUCTOR!");
    }

    public CDEClientPlugin(Properties p, ClientPluginGuiCtx guicontext) throws PluginException {
        boolean bl = this.debug = System.getProperty("debug") != null;
        if (this.debug) {
            System.out.println("\n======= CDEClientPlugin =========================================");
        }
        toolBundle = ResourceManager.getBundle((String)"com.sun.smartcard.gui.ListResourceBundle.ScConsoleResources", this.getClass());
        this.cfgProps = p;
        this.pgc = guicontext;
        if (this.pgc == null) {
            throw new PluginException("Error with ClientPluginGuiCtx (null)");
        }
        this.pgc.setCallback((SmartCardPlugin)this);
        String str = DesktopConfig.getProp(useSmartCardProp);
        this.enableSmartCard = Boolean.valueOf(str);
        this.cfgProps.setProperty("enabled", this.enableSmartCard ? "True" : "False");
        this.cardRemovalTimeout = this.getIntPropValue(cardRemovalTimeoutProp);
        this.reauthTimeout = this.getIntPropValue(reauthTimeoutProp);
        this.cardRemovalLogoutWait = this.getIntPropValue(cardRemovalLogoutWaitProp);
        this.ignoreCardRemoval = this.getBoolPropValue(ignoreCardRemovalProp);
        this.reauthAfterCardRemoval = this.getBoolPropValue(reauthAfterCardRemovalProp);
        if (this.debug) {
            System.out.println("[Constructor] CDEClientPlugin Parameters:\n          enableSmartCard = " + this.enableSmartCard + "\n" + "       cardRemovalTimeout = " + this.cardRemovalTimeout + "\n" + "        ignoreCardRemoval = " + this.ignoreCardRemoval + "\n" + "   reauthAfterCardRemoval = " + this.reauthAfterCardRemoval + "\n" + "            reauthTimeout = " + this.reauthTimeout + "\n" + "    cardRemovalLogoutWait = " + this.cardRemovalLogoutWait);
        }
        PluginTab tab1 = this.pgc.addTab(this.resourceString("CDEClientPluginTimeouts"));
        this.cardRemovalTimeoutSlider = tab1.addSlider(this.resourceString("CDEClientPluginRemovalTimeout") + " (seconds)", 0, this.cardRemovalTimeoutMax);
        this.cardRemovalTimeoutSlider.setValue(this.cardRemovalTimeout);
        this.reauthTimeoutSlider = tab1.addSlider(this.resourceString("CDEClientPluginReauthTimeout") + " (seconds)", 0, this.reauthTimeoutMax);
        this.reauthTimeoutSlider.setValue(this.reauthTimeout);
        this.cardRemovalLogoutWaitSlider = tab1.addSlider(this.resourceString("CDEClientPluginLoginTimeout") + " (seconds)", 0, this.cardRemovalLogoutWaitMax);
        this.cardRemovalLogoutWaitSlider.setValue(this.cardRemovalLogoutWait);
        PluginTab tab2 = this.pgc.addTab(this.resourceString("CDEClientPluginOptions"));
        this.ignoreCardRemovalCheckbox = tab2.addCheckBox(this.resourceString("CDEClientPluginIgnoreCardRemoval"));
        if (this.ignoreCardRemoval) {
            this.ignoreCardRemovalCheckbox.setChecked();
        } else {
            this.ignoreCardRemovalCheckbox.setUnchecked();
        }
        this.reauthAfterCardRemovalCheckbox = tab2.addCheckBox(this.resourceString("CDEClientPluginReauthenticate"));
        if (this.reauthAfterCardRemoval) {
            this.reauthAfterCardRemovalCheckbox.setChecked();
        } else {
            this.reauthAfterCardRemovalCheckbox.setUnchecked();
        }
    }

    public Properties okButtonPushed(boolean activeState) {
        if (this.debug) {
            System.out.println("[OK|Apply] CDEClientPlugin Parameters:\n              activeState = " + activeState + "\n" + "          enableSmartCard = " + this.enableSmartCard + "\n" + "       cardRemovalTimeout = " + this.cardRemovalTimeout + "\n" + "        ignoreCardRemoval = " + this.ignoreCardRemoval + "\n" + "   reauthAfterCardRemoval = " + this.reauthAfterCardRemoval + "\n" + "            reauthTimeout = " + this.reauthTimeout + "\n" + "    cardRemovalLogoutWait = " + this.cardRemovalLogoutWait);
        }
        boolean stateChange = activeState != this.enableSmartCard;
        this.enableSmartCard = activeState;
        this.cfgProps.setProperty("enabled", this.enableSmartCard ? "True" : "False");
        this.saveCDESettings();
        if (stateChange) {
            if (this.enableSmartCard) {
                this.enablePAMsmartcard();
            } else {
                this.disablePAMsmartcard();
            }
        }
        return this.cfgProps;
    }

    public boolean cancelOperation() {
        return true;
    }

    public void sliderAction(PluginSlider sl) {
        if (sl == this.cardRemovalTimeoutSlider) {
            this.cardRemovalTimeout = this.cardRemovalTimeoutSlider.getValue();
        }
        if (sl == this.reauthTimeoutSlider) {
            this.reauthTimeout = this.reauthTimeoutSlider.getValue();
        }
        if (sl == this.cardRemovalLogoutWaitSlider) {
            this.cardRemovalLogoutWait = this.cardRemovalLogoutWaitSlider.getValue();
        }
    }

    public void checkBoxAction(PluginCheckBox cb) {
        if (cb == this.ignoreCardRemovalCheckbox) {
            this.ignoreCardRemoval = this.ignoreCardRemovalCheckbox.getState();
        }
        if (cb == this.reauthAfterCardRemovalCheckbox) {
            this.reauthAfterCardRemoval = this.reauthAfterCardRemovalCheckbox.getState();
        }
    }

    private int getIntPropValue(String propName) {
        String propValue = DesktopConfig.getProp(propName);
        if (propValue == null) {
            propValue = this.cfgProps.getProperty(propName);
        }
        if (propValue == null) {
            return 0;
        }
        return Integer.parseInt(propValue);
    }

    private boolean getBoolPropValue(String propName) {
        String propValue = DesktopConfig.getProp(propName);
        if (propValue == null) {
            propValue = this.cfgProps.getProperty(propName);
        }
        if (propValue == null) {
            return false;
        }
        return Boolean.valueOf(propValue);
    }

    private void enablePAMsmartcard() {
        try {
            new OCFEnable().enablePAMForSC();
        }
        catch (Exception e) {
            this.pgc.popupError("Error Enabling PAM for Smart Card Authentication", e.toString());
        }
    }

    private void disablePAMsmartcard() {
        try {
            new OCFDisable().disablePAMForSC();
        }
        catch (Exception e) {
            this.pgc.popupError("Error Disabling PAM for Smart Card Authentication", e.toString());
        }
    }

    private void saveCDESettings() {
        try {
            DesktopConfig.setProp(cardRemovalTimeoutProp, Integer.toString(this.cardRemovalTimeout));
            DesktopConfig.setProp(reauthTimeoutProp, Integer.toString(this.reauthTimeout));
            DesktopConfig.setProp(cardRemovalLogoutWaitProp, Integer.toString(this.cardRemovalLogoutWait));
            DesktopConfig.setProp(ignoreCardRemovalProp, this.ignoreCardRemoval ? "True" : "False");
            DesktopConfig.setProp(reauthAfterCardRemovalProp, this.reauthAfterCardRemoval ? "True" : "False");
            DesktopConfig.setProp(useSmartCardProp, this.enableSmartCard ? "True" : "False");
        }
        catch (Exception e) {
            if (this.debug) {
                System.out.println("saveCDESettings failed: " + e.toString());
            }
            this.pgc.popupError("Error Saving CDE Settings", "There was an error saving your settings.\nCheck ocfserv and try again.");
        }
    }

    private String resourceString(String key) {
        return ResourceManager.getString((String)key, (ResourceBundle)toolBundle);
    }

    public void activeState(boolean state) {
    }

    public void comboAction(PluginComboBox cb) {
    }

    public void textAction(PluginTextField tf) {
    }

    public void passwordAction(PluginPassword pp) {
    }

    public void toggleButtonAction(boolean toggleButtonState) {
    }

    public void buttonAction(PluginButton b) {
    }

    static {
        useSmartCardProp = useSmartCardProp;
        ignoreCardRemovalProp = ignoreCardRemovalProp;
        reauthAfterCardRemovalProp = reauthAfterCardRemovalProp;
        cardRemovalTimeoutProp = cardRemovalTimeoutProp;
        reauthTimeoutProp = reauthTimeoutProp;
        cardRemovalLogoutWaitProp = cardRemovalLogoutWaitProp;
        toolBundle = null;
    }
}

