#!/sbin/sh -
# %W% %G% %U% - %Q%
#ident "%Z%unixvm:%M% %I%"

# Copyright (c) 1999 VERITAS Software Corporation.  ALL RIGHTS RESERVED.
# UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT
# LAWS OF THE UNITED STATES.  USE OF A COPYRIGHT NOTICE
# IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION
# OR DISCLOSURE.
#
# THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND
# TRADE SECRETS OF VERITAS SOFTWARE.  USE, DISCLOSURE,
# OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
# EXPRESS WRITTEN PERMISSION OF VERITAS SOFTWARE.
#
#	       RESTRICTED RIGHTS LEGEND
# USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS
# SUBJECT TO RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH
# (C) (1) (ii) OF THE RIGHTS IN TECHNICAL DATA AND
# COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013.
#	       VERITAS SOFTWARE
# 1600 PLYMOUTH STREET, MOUNTAIN VIEW, CA 94043

 ${VOLROOT_DIR:=$__VXVM_ROOT_DIR}
. ${VOL_SCRIPTS_LIB:-$VOLROOT_DIR/usr/lib/vxvm/lib}/vxcommon

#
# Parameters : 	$1 - pathname (/dev/rdsk/...)
#		$2 - major (an 'out' parameter)
#		$3 - minor (an 'out' parameter)
#
get_longlisting()
{
	longlisting=`ls -l $DISK_RAWPATH/$1`
	set -- $longlisting
	shift 10
	longlisting=`ls -l $DISK_RAWPATH/$1`
	longlisting=`echo $longlisting | sed 's/,/ /'`
	set -- $longlisting
	echo $5 $6
}

check_exclude_all()
{
	string=VxVM
	[ $1 = vxvm ] || { string=DMP; }
	vxdmpadm checkexclude $1 all 2>/dev/null
	if [ $? -eq 3 ]
	then
		export string; ewritemsg -M vxvmshm:1127 \
"All disks have already been excluded from $string."
		voladm_continue -n
		quit
	fi
}

exclude_all()
{
	if [ $1 = vxvm ]
	then
		check_exclude_all vxvm
		ewritemsg -M vxvmshm:1134 \
"All disks will be excluded from VxVM as a result of this operation !"
	else
		vxdmpadm checkexclude vxvm all 2>/dev/null
		if [ $? -eq 3 ]
		then
			ewritemsg -M vxvmshm:1126 \
"All disks are currently excluded from VxVM. Include all disks in VxVM to
  proceed with the operation."
			voladm_continue -n
			quit
		fi
		check_exclude_all vxdmp
		ewritemsg -M vxvmshm:1182 \
"No disk will be multipathed by vxdmp as a result of this operation !"
	fi

	voladm_yorn -M vxvmshm:115 "Continue operation?" n
	if [ $? -ne 0 ]
	then
		quit 0
	fi
	vxdmpadm exclude $1 all 2>/dev/null
	touch $excltmpfile2
	reboot_message
}

match_vidpid()
{
	if [ "X$1" = "X:" ]
	then
		false
		return
	fi
	
	input_len=`strlen $1`

	match_len=`expr $1 : '\*:\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '[^\*][^\*]*:\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '[^\*][^\*]*\*:\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '\*:[^\*][^\*]*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '[^\*][^\*]*:[^\*][^\*]*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '[^\*][^\*]*\*:[^\*][^\*]*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '\*:[^\*][^\*]*\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '[^\*][^\*]*:[^\*][^\*]*\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	match_len=`expr $1 : '[^\*][^\*]*\*:[^\*][^\*]*\*'`
	if [ "$input_len" -eq "$match_len" ]
	then
		true
		return
	fi

	false
	return
}

check_pathgroup()
{
	valid=1
	for path in "$@"
	do
		input_len=`strlen $path`
		match_len=`expr $path : 'c[0-9][0-9]*t[0-9][0-9]*d[0-9][0-9]*'`
		if [ "$input_len" -ne "$match_len" ]
		then
			valid=0
			break
		fi
	done

	[ $valid -eq 1 ]
}

do_exclude_ctlr()
{
	enclrlist=`vxdmpadm listctlr ctlr=$2 | tail +3 | awk '{ print $4; }'`

	string=VxVM
	[ $1 = vxvm ] || { string=DMP; }

	input_ctlr=$2
	if [ $1 = vxdmp ]
	then
		vxdmpadm checkexclude vxvm ctlr=$2:$3 2>/dev/null
		ret=$?
		if [ $ret -eq 0 ]
		then
			export input_ctlr; ewritemsg -M vxvmshm:1313 \
"Controller $input_ctlr is currently excluded from VxVM. Include the controller in VxVM
  to proceed with the operation."
			voladm_continue -n
			quit
		elif [ $ret -eq 3 ]
		then
			ewritemsg -M vxvmshm:1126 \
"All disks are currently excluded from VxVM. Include all disks in VxVM to
  proceed with the operation."
			voladm_continue -n
			quit
		fi
	fi

	vxdmpadm checkexclude $1 ctlr=$2:$3 2>/dev/null
	ret=$?
	if [ $ret -eq 3 ]
	then
		export string; ewritemsg -M vxvmshm:1127 \
"All disks have already been excluded from $string."
		voladm_continue -n
		quit
	fi

	if [ $ret -eq 0 ]
	then
		export string input_ctlr;ewritemsg -M vxvmshm:1312 \
"Controller $input_ctlr has already been excluded from $string."
		voladm_continue -n
		quit
	fi

	after_reboot=no
	if [ $1 = vxvm ]
	then
		if not check_ctlr_for_enclosures $2 enclosure_list
		then
			ewritemsg -M vxvmshm:1233 \
"This is the last controller through which some or all disk(s) in the
  following enclosures are accesible:"
			print_line $enclosure_list
			voladm_yorn -M vxvmshm:115 "Continue operation?" y
			if [ $? -ne 0 ]
			then
				return 1
			fi
		fi

		if not check_ctlr_for_volumes $2 volumes
		then
			ewritemsg -M vxvmshm:1238 \
"This operation could render the following volumes inaccessible or
  reduce their redundancy:"
			print_line $volumes
			ewritemsg -M vxvmshm:1176 \
"Make sure that the objects on these disks are moved before proceeding
  with this operation."
			voladm_yorn -M vxvmshm:115 "Continue operation?" y
			if [ $? -ne 0 ]
			then
				return 1
			fi
		fi

		cntrl=$2;ewritemsg -M vxvmshm:1306 \
"All paths to the following enclosures through controller $cntrl will be hidden
  from VxVM as a result of this operation :"

		print_line $enclrlist

		voladm_yorn -M vxvmshm:115 "Continue operation?" y

		if [ $? -ne 0 ]
		then
			return 1
		fi
		vxdmpadm -f disable ctlr=$2 2>/dev/null
		if [ $? -ne 0 ]
		then
			ewritemsg -M vxvmshm:1235 \
"This operation cannot be completed as it will render the rootdisk
  inaccessible."
			echo
			voladm_continue
			return 1
		fi
		vxdmpadm exclude vxvm ctlr=$2:$3 2>/dev/null
		touch $excltmpfile1
		cntrl=$2;ewritemsg -M vxvmshm:1323 \
"The controller $cntrl will be disabled. The entries for paths on controller $cntrl
  will still be visible through VxVM utilities in a disabled state till a
  reboot. After a reboot these entries will not be seen."
		echo
		voladm_continue -n
	else
		ctlrpaths=`vxdmpadm getsubpaths ctlr=$2 2>/dev/null | tail +3 | awk '{ print $1; }'`
		if [ -z "$ctlrpaths" ]
		then
			cntrl=$2; ewritemsg -M vxvmshm:1314 "Could not get paths under $cntrl."
			voladm_continue -n
			return 1
		fi

		allpaths=
		for p in $ctlrpaths
		do
			path_disk=`vxdmpadm getdmpnode nodename=$p 2>/dev/null | tail +3 | awk '{ print $1; }'`
			disk_paths=`vxdmpadm getsubpaths dmpnodename=$path_disk 2>/dev/null | tail +3 | awk '{ print $1; }'`
			allpaths="$allpaths $disk_paths"
		done

		ewritemsg -M vxvmshm:1129 \
"All disks on the following enclosures will be excluded from DMP ( ie
  claimed in the OTHER_DISKS category and hence not multipathed by vxdmp) as a
  result of this operation :"

		print_line $enclrlist

		voladm_yorn -M vxvmshm:115 "Continue operation?" y

		if [ $? -ne 0 ]
		then
			return 1
		fi

		if not get_volumes_on_ctlr $2 volumes
		then
			ewritemsg -M vxvmshm:1237 \
"This operation could render the following volumes inaccesible or reduce
  their redundancy:"
			print_line $volumes
			ewritemsg -M vxvmshm:1177 \
"Make sure that the objects on these disks are moved before proceeding
  with this operation.

  You can use the \"Remove a disk for replacement\" option of vxdiskadm
  to remove the affected disks. These could be replaced with the new
  entries in the OTHER_DISKS after this operation is completed.

  If you do not want to move the objects on these disks, then you could
  choose to make this exclusion take effect only on the next reboot."

			voladm_yorn -M vxvmshm:1155 \
"Do you want this exlcusion to take effect only after reboot ?" y

			if [ $? -ne 0 ]
			then
				voladm_yorn -M vxvmshm:1146 \
"Are you sure you have moved all objects from the affected disks ?" y
				if [ $? -ne 0 ]
				then
					return 1
				else
					touch $excltmpfile1
					after_reboot=no
				fi
			else
				touch $excltmpfile2
				after_reboot=yes
			fi
		fi

		set -- $allpaths
		count=0
		while [ $# -gt 0 ]
		do
			savebuf="$@"
			pathname=`basename $1`
			set -- `ls -l $DISK_RAWPATH/$pathname`
			shift 2
			fullpathname=$9
			fullpathname=`expr $fullpathname : '../../devices\([^:]*\)'`
			if [ "$after_reboot" = "no" ]
			then
				vxdmpadm -f disable path=$pathname 2>/dev/null
				if [ $? != 0 ]
				then
					export pathname; ewritemsg -M vxvmshm:0 \
"Attempt to disable path $pathname failed."
					echo
					voladm_continue
					set -- $savebuf
					shift 1
					continue
				fi
			fi

			vxdmpadm exclude vxdmp \
				path=$pathname:$fullpathname 2>/dev/null
			count=1

			set -- $savebuf
			shift 1
		done

		[ $count -eq 0 ] && quit 1

		if [ "$after_reboot" = "no" ]
		then
			touch $excltmpfile1
			export input_ctlr; ewritemsg -M vxvmshm:1213 \
"The disks connected through controller $input_ctlr will appear in the
  OTHER_DISKS category. However, the existing paths will be visible through
  VxVM utilities in a disabled state till a reboot. After reboot, these
  entries will not be seen."
			echo
			voladm_continue -n
		fi
	fi

	return 0
}

exclude_ctlr()
{
	case $1 in
		VXVM)	exclude=vxvm
			heading=VxVM;;
		DMP)	exclude=vxdmp
			heading=DMP;;
	esac

	while true
	do
		export heading; voladm_begin_screen -M vxvmshm:1169 \
"Exclude controllers from $heading"

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1247 \
"Use this operation to exclude all paths through a controller from VxVM.  

  This operation can be reversed using the vxdiskadm command."
		else
			ewritemsg -M vxvmshm:1246 \
"Use this operation to exclude all disks on a controller from being multipathed
  by vxdmp.

  As a result of this operation, all disks having a path through the specified
  controller will be claimed in the OTHER_DISKS category and hence, not
  multipathed by vxdmp. This operation can be reversed using the vxdiskadm
  command."
		fi

		ewritemsg -M vxvmshm:1263 \
  "You can specify a controller name at the prompt. A controller name is of
  the form c#, example c3, c11 etc. Enter 'all' to exclude all paths on all
  the controllers on the host. To see the list of controllers on the system,
  type 'list'."

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter a controller name" vxvmshm:1287`	
		read_input "$prompt [<ctlr-name>,all,list,list-exclude,q,?]"
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $# -gt 1 ]
		then
			ewritemsg -M vxvmshm:1196 "Specify a single controller."
			voladm_continue -n
			continue
		fi

		if [ $1 = "l" -o $1 = "list" ]
		then
			ctlrlist=`vxdmpadm listctlr all | tail +3 | awk '{ print $1; }' | grep -v mc`
			if [ -z "$ctlrlist" ]
			then
				ewritemsg -M vxvmshm:1181 \
"No controllers were found !!"
				voladm_continue -n
				return
			fi
			ewritemsg -M vxvmshm:1214 \
"The following controllers were found on the system :"
			print_line $ctlrlist
			voladm_continue -n
			continue
		fi

		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ $1 = "all" ]
		then
			exclude_all $exclude
			quit
		fi

		ctlr_len=`strlen $input`
		match_len=`expr $input : 'c[0-9][0-9]*'`
		if not [ "$ctlr_len" -eq "$match_len" ]
		then
			ewritemsg -M vxvmshm:1224 \
"The input is not in proper format."
			echo;echo
			voladm_continue
			continue
		fi

		ctlrinfo=`vxdmpadm listctlr ctlr=$input 2>/dev/null`
		if [ $? -ne 0 ]
		then
			export input; ewritemsg -M vxvmshm:1123 \
"$input is not a valid controller."
			echo;echo
			voladm_continue
			continue
		fi

		lctlr=$input
		pctlr=`vxdmpadm getctlr all | tail +3 | grep "^$input" | awk '{ print $2; }'`
		do_exclude_ctlr $exclude $lctlr $pctlr

		voladm_yorn -M vxvmshm:1159 \
"Do you wish to exclude more controllers ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

exclude_path()
{
	case $1 in
		VXVM)	exclude=vxvm
			heading=VxVM;;
		DMP)	exclude=vxdmp
			heading=DMP;;
	esac

	while true
	do
		after_reboot=no
		export heading; voladm_begin_screen -M vxvmshm:1170 "Exclude paths from $heading"

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1250 \
"Use this operation to exclude one or more paths from VxVM.  

  As a result of this operation, the specified paths will be excluded from
  the view of VxVM. This operation can be reversed using the vxdiskadm
  command."
		else
			ewritemsg -M vxvmshm:1249 \
"Use this operation to exclude one or more disks from vxdmp.  

  As a result of this operation, the disks corresponding to the specified paths
  will not be multipathed by vxdmp. This operation can be reversed using the
  vxdiskadm command."
		fi

		ewritemsg -M vxvmshm:1266 \
"You can specify a pathname or a pattern at the prompt.  Here are
  some path selection examples:

  all:		all paths
  c4t2:		all paths on controller 4, target 2
  c3t4d2:	a single path
  list:		list all paths on the system"

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter a pathname or pattern :" vxvmshm:1288`
		read_input "$prompt [<pattern>,all,list,list-exclude,q,?]" 
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $# -gt 1 ]
		then
			ewritemsg -M vxvmshm:1197 "Specify a single path/pattern."
			voladm_continue -n
			continue
		fi

		if [ $1 = "list" -o $1 = "l" ]
		then
			pathlist=`listpaths`
			devicelist=`slice_to_device $pathlist`
			print_line $devicelist
			voladm_continue
			continue
		fi

		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ $1 = "all" ]
		then
			exclude_all $exclude
			continue
		fi

		if not match_path $1
		then
			ewritemsg -M vxvmshm:1225 \
"The input is not in valid format."
			echo;echo
			voladm_continue
			continue
		fi

		excludepaths=`listpaths | grep $input 2>/dev/null`

		if [ -z "$excludepaths" ]
		then
			ewritemsg -M vxvmshm:1184 \
"No valid paths were found matching the input pattern."
			echo;echo
			voladm_continue
			continue
		fi

		excludepaths=`ls $DISK_RAWPATH/$input* 2>/dev/null | grep "s2$"`
		if [ $heading = DMP ]
		then
			vxdmpadm checkexclude vxvm all 2>/dev/null
			if [ $? -eq 3 ]
			then
				ewritemsg -M vxvmshm:1126 \
"All disks are currently excluded from VxVM. Include all disks in VxVM to
  proceed with the operation."
				voladm_continue -n
				quit
			fi
		fi

		check_exclude_all $exclude

		if [ $heading = DMP ]
		then
			allpaths=
			for p in $excludepaths
			do
				tmpp=`basename $p`
				dmpnode=`vxdmpadm getdmpnode nodename=$tmpp 2>/dev/null | tail +3 | awk '{ print $1; }'`
				tmppaths=`vxdmpadm getsubpaths dmpnodename=$dmpnode 2>/dev/null | tail +3 | awk '{ print $1; }'`
				set -- $tmppaths
				while [ $# -gt 0 ]
				do
					present=`echo $allpaths | grep $1`
					if [ -z "$present" ]
					then
						allpaths="$allpaths $1"	
					fi
					shift 1
				done
			done
			excludepaths=$allpaths
		fi

		if [ -z "$excludepaths" ]
		then
			ewritemsg -M vxvmshm:1151 \
"Could not get paths to the specified disk"
			voladm_continue -n
			quit 1
		fi

		set -- $excludepaths
		tmpp=`basename $1`

		# Note that the major,minor pair is dummy here
		vxdmpadm checkexclude vxvm path=$tmpp:0,0 2>/dev/null
		ret=$?
		if [ $exclude = vxvm ]
		then
			if [ $ret -eq 2 ]
			then
				ewritemsg -M vxvmshm:1209 \
"The controller through which the specfied path(s) are connected has already
  been excluded from VxVM."
				voladm_continue -n
				quit
			fi
		elif [ $exclude = vxdmp ]
		then
			if [ $ret -eq 2 ]
			then
				ewritemsg -M vxvmshm:1211 \
"The controller through which the specfied path(s) are connected is currently
  excluded from VxVM. Include this controller in VxVM to proceed with the
  operation."
				voladm_continue -n
				quit
			fi
			vxdmpadm checkexclude vxdmp path=$tmpp:0,0 2>/dev/null
			ret=$?
			if [ $ret -eq 2 ]
			then
				ewritemsg -M vxvmshm:1210 \
"The controller through which the specfied path(s) are connected has already
  been excluded from multipathing by vxdmp."
				voladm_continue -n
				quit
			fi
		fi

		set -- $excludepaths
		excludepaths=
		while [ $# -gt 0 ]
		do
			tmpp=`basename $1`
			if [ $exclude = vxdmp ]
			then
				vxdmpadm checkexclude vxvm path=$tmpp:0,0 2>/dev/null
				if [ $? -eq 0 ]
				then
					pathsnotinvxvm="$pathsnotinvxvm $tmpp"
					shift 1
					continue
				fi
			fi
			vxdmpadm checkexclude $exclude path=$tmpp:0,0 2>/dev/null	
			if [ $? -eq 0 ]
			then
				pathsexcluded="$pathsexcluded $tmpp"
			else
				excludepaths="$excludepaths $tmpp"
			fi
			shift 1
		done

		if [ $exclude = vxdmp -a ! -z "$pathsnotinvxvm" ]
		then
			devsnotinvxvm=`slice_to_device $pathsnotinvxvm`
			ewritemsg -M vxvmshm:1216 \
"The following paths are currently excluded from VxVM. In order to exclude them
  from multipathing by vxdmp, first include them in VxVM."
			print_line $devsnotinvxvm
			voladm_continue -n
			[ -z "$pathsexcluded" -a -z "$excludepaths" ] && quit
		fi

		if [ ! -z "$pathsexcluded" ]
		then
			devs_excluded=`slice_to_device $pathsexcluded`
			export heading; ewritemsg -M vxvmshm:1217 \
"The following paths have already been excluded from $heading:"
			print_line $devs_excluded
			voladm_continue -n
			[ -z "$excludepaths" ] && quit
		fi

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1221 \
"The following paths will be excluded from VxVM as a result of this operation:"
		else
			ewritemsg -M vxvmshm:1218 \
"The following paths will appear in the OTHER_DISKS category as a result of
  this operation:"
		fi
		excludedevs=`slice_to_device $excludepaths`
		print_line $excludedevs

		voladm_yorn -M vxvmshm:115 "Continue operation?" y
		if [ $? -ne 0 ]
		then
			quit 0
		fi

		if [ $heading = DMP ]
		then
			vol_list=
			volumes_present=false
			for p in $excludepaths
			do
				pathname=`basename $p`
				if not check_dmpnode_for_volumes $pathname\
								volumes
				then
					volumes_present=true
					for v in $volumes
					do
						echo "$vol_list" | grep $v
						if [ $? -ne 0 ]
						then
							vol_list="$vol_list $v"
						fi
					done
				fi
			done

			if [ "$volumes_present" = "true" ]
			then
				ewritemsg -M vxvmshm:1237 \
"This operation could render the following volumes inaccesible or reduce
  their redundancy:"
				print_line $volumes
				ewritemsg -M vxvmshm:1175 \
"Make sure that the objects on these disks are moved before proceeding with
  this operation.

  You can use the \"Remove a disk for replacement\" option of vxdiskadm to
  remove the affected disks. These could be replaced with the new entries
  in the OTHER_DISKS after this operation is completed.

  If you do not want to move the objects on these disks, then you could
  choose to make this exclusion take effect only on the next reboot."
			
				voladm_yorn -M vxvmshm:1155 \
"Do you want this exlcusion to take effect only after reboot ?" y

				if [ $? -ne 0 ]
				then
					voladm_yorn -M vxvmshm:1146 \
"Are you sure you have moved all objects from the affected disks ?" y
					if [ $? -ne 0 ]
					then
						return 1
					else
						touch $excltmpfile1
						after_reboot=no
					fi
				else
					touch $excltmpfile2
					after_reboot=yes
				fi
			fi
		fi

		set -- $excludepaths
		tmpdevlist=
		while [ $# -gt 0 ]
		do
			savebuf=$@
			pathname=`basename $1`

			if [ $heading = VxVM ]
			then
				if not check_path_for_disk $pathname disk
				then
					disk_dev=`slice_to_device $disk`
					ewritemsg -M vxvmshm:1234 \
"This is the last path through which follwing disk is visible:"
					print_line $disk_dev
					voladm_yorn -M vxvmshm:115 "Continue operation?" y
					if [ $? -ne 0 ]
					then
						return 1
					fi
				fi

				if not check_path_for_volumes $pathname volumes
				then
					ewritemsg -M vxvmshm:1237 \
"This operation could render the following volumes inaccesible or reduce
  their redundancy:"
					print_line $volumes
					ewritemsg -M vxvmshm:1178 \
"Make sure that the objects on this disk are moved before proceeding with
  this operation."
					voladm_yorn -M vxvmshm:115 "Continue operation?" y
					if [ $? -ne 0 ]
					then
						return 1
					fi
				fi
				touch $excltmpfile1
				after_reboot=no
			fi

			rm -f $tmpfile1
			set -- $savebuf
			tmpdevlist="$tmpdevlist $pathname"
			shift 1
		done

		set -- $excludepaths
		tmpdevlist=
		while [ $# -gt 0 ]
		do
			savebuf=$@
			pathname=`basename $1`

			set -- `ls -l $DISK_RAWPATH/$pathname`
			shift 2
			fullpathname=$9
			fullpathname=`expr $fullpathname : '../../devices\([^:]*\)'`
			if [ "$after_reboot" = "no" ]
			then
				vxdmpadm -f disable path=$pathname 2>/dev/null

				if [ $? != 0 ]
				then
					export pathname; ewritemsg -M vxvmshm:0 \
"Attempt to disable path $pathname failed."
					echo
					voladm_continue
					set -- $savebuf
					shift 1
					continue
				fi
			fi

			vxdmpadm exclude $exclude path=$pathname:$fullpathname 2>/dev/null
			set -- $savebuf
			tmpdevlist="$tmpdevlist $pathname"
			shift 1
		done

		[ -z "$tmpdevlist" ] && quit

		if [ $exclude = vxvm ]

		then
			ewritemsg -M vxvmshm:1220 \
"The following paths will be disabled. However, these paths will still be
  visible to VxVM utilities in a disabled state till a reboot. After reboot,
  these entries will not be seen."
			echo
			voladm_continue
		else
			if [ "$after_reboot" = "no" ]
			then
				touch $excltmpfile1
				ewritemsg -M vxvmshm:1219 \
"The following paths will appear in the OTHER_DISKS category. However, the
  existing paths will be visible to VxVM utilities in a disabled state till
  a reboot. After reboot, these entries will not be seen."
				echo
				print_line $tmpdevlist
				voladm_continue
			fi
		fi

		voladm_yorn -M vxvmshm:1160 "Do you wish to exclude more paths ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

exclude_vidpid()
{
	case $1 in
		VXVM)	exclude=vxvm
			heading=VxVM;;
		DMP)	exclude=vxdmp
			heading=DMP;;
	esac

	while true
	do
		export heading; voladm_begin_screen -M vxvmshm:1167 "Exclude VID:PID from $heading"

		if [ $heading = VxVM ]
		then
			ewritemsg -M vxvmshm:1248 \
"Use this operation to exclude disks returning a specified VendorID:ProductID
  combination from VxVM.

  As a result of this operation, all disks that return VendorID:ProductID
  matching the specified combination will be excluded from the view of VxVM.
  This operation can be reversed using the vxdiskadm command."
		else
			ewritemsg -M vxvmshm:1257 \
"Use this operation to prevent vxdmp from multipathing disks returning a
  specified VendorID:ProductID combination.

  As a result of this operation, all disks that return VendorID:ProductID
  matching the specified combination will be claimed in the OTHER_DISKS
  category (ie, they will not be multipathed by vxdmp). This operation can be
  reversed using the vxdiskadm command."
		fi

			export MAX_VENDORID MAX_PRODUCTID; ewritemsg -M vxvmshm:1262 \
"You can specify a VendorID:ProductID combination at the prompt. The
  specification can be as follows :
 
 	VID:PID		where VID stands for Vendor  ID
			      PID stands for Product ID
			      (The command vxdmpinq in /etc/vx/diag.d can be
			       used to obtain the Vendor ID and Product ID)

	Both VID and PID can have an optional '*' (asterisk) following them.
	If a '*' follows VID, it will result in the exclusion of all disks
	returning Vendor ID starting with the specified VID. The same is
	true for Product ID as well. Both VID and PID should be non NULL.
	The maximum allowed lengths for Vendor ID and Product ID are
	$MAX_VENDORID and $MAX_PRODUCTID characters respectively.

	Some examples of VID:PID specification are:

	all		- Exclude all disks
	aaa:123 	- Exclude all disks having VID 'aaa' and PID '123'
	aaa*:123 	- Exclude all disks having VID starting with 'aaa' 
			  and PID '123'
	aaa:123* 	- Exclude all disks having VID 'aaa' and PID starting
			  with '123'
	aaa:*		- Exclude all disks having VID 'aaa' and any PID"

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter a VID:PID combination:" vxvmshm:1286`
		read_input "$prompt [<pattern>,all,list-exclude,q,?]" 
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $# -gt 1 ]
		then
			ewritemsg -M vxvmshm:1195 \
"Specify a single VID:PID combination."
			voladm_continue -n
			continue
		fi

		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ $1 = "all" ]
		then
			exclude_all $exclude
			continue
		fi

		match_vidpid $1 || {
			ewritemsg -M vxvmshm:1224 \
"The input is not in proper format."
			echo;echo
			voladm_continue
			continue
		}

		vxdmpadm checkexclude $exclude product=$1 2>/dev/null
		if [ $? -eq 2 ]
		then
			ewritemsg -M vxvmshm:1165 \
"Either VID or PID exceeds the maximum allowed length. Please ensure that they
  don't exceed the specified maximum allowed lengths."
			voladm_continue -n
			continue
		fi

		if [ $exclude = vxdmp ]
		then
			vxdmpadm checkexclude vxvm product=$1 2>/dev/null
			ret=$?
			if [ $ret -eq 0 ]
			then
				combstr=$1; ewritemsg -M vxvmshm:1318 \
"The VID:PID combination $combstr is currently excluded from VxVM. Include this in
  VxVM to proceed with the operation."
				voladm_continue -n
				quit
			elif [ $ret -eq 3 ]
			then
				ewritemsg -M vxvmshm:1126 \
"All disks are currently excluded from VxVM. Include all disks in VxVM to
  proceed with the operation."
				voladm_continue -n
				quit
			fi
		fi

		check_exclude_all $exclude
		vxdmpadm checkexclude $exclude product=$1 2>/dev/null
		if [ $? -eq 0 ]
		then
			combstr=$1 export combstr; ewritemsg -M vxvmshm:1322 \
"The VendorID:ProductID combination $combstr has already been
  excluded from $heading."
			voladm_continue -n
			quit
		fi

		if [ $heading = VxVM ]
		then
			check_rootdisk_vidpid $1
			if [ $? -eq 0 ]
			then
				combstr=$1 export combstr; ewritemsg -M vxvmshm:1326 \
"$combstr matches the VID:PID combination of the rootdisk. Since the
  rootdisk cannot be suppressed from VxVM, this operation cannot be
  performed. Please use the exclude options through controller/path to
  exclude the devices."
				echo
				voladm_continue
				continue
			fi

			combstr=$1 export combstr; ewritemsg -M vxvmshm:1302 \
"All disks returning VID/PID matching the combination $combstr will be
  excluded from VxVM as a result of this operation."
		else
			combstr=$1 export combstr; ewritemsg -M vxvmshm:1301 \
"All disks returning VID/PID matching the combination $combstr will be
  claimed in the OTHER_DISKS category and hence not multipathed by vxdmp
  as a result of this operation."
		fi

		voladm_yorn -M vxvmshm:115 "Continue operation?" y
		if [ $? -ne 0 ]
		then
			quit 0
		fi
		
		vxdmpadm exclude $exclude product=$1 2>/dev/null

		touch $excltmpfile2
		reboot_message
		voladm_yorn -M vxvmshm:1158 \
"Do you wish to exclude more Vendor ID:Product ID combinations?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

make_pathgroup()
{
	while true
	do
		voladm_begin_screen -M vxvmshm:1168 \
"Exclude all but one paths to a disk"

		ewritemsg -M vxvmshm:1245 \
"Use this operation to exclude all but one paths to a disk. In case of disks
  which are not multipathed by vxdmp, VxVM will see each path as a disk. In
  such cases, creating a pathgroup of all paths to the disk will ensure that
  only one of the paths from the group is made visible to VxVM. The pathgroup
  can be removed using the vxdiskadm command.

  Example: If c1t30d0 and c2t30d0 are paths to the same disk and both are seen
  by VxVM as separate disks, c1t30d0 and c2t30d0 can be put in a pathgroup so
  that only one of these paths is visible to VxVM.

  The pathgroup can be specified as a list of blank separated paths,
  for example, c1t30d0 c2t30d0."

		# Make sure prompt is displayed on the next line.
		prompt=`egettxt "Enter pathgroup:" vxvmshm:1291`
		read_input "$prompt [<pattern>,list,list-exclude,q,?]" 
		if [ -z "$input" ]
		then
			continue
		fi

		set -- $input
		if [ $1 = "list-exclude" ]
		then
			vxdmpadm listexclude | voladm_display
			echo;echo
			voladm_continue
			continue
		fi

		if [ $1 = "list" -o $1 = "l" ]
		then
			pathlist=`listpaths`
			devicelist=`slice_to_device $pathlist`
			print_line $devicelist
			voladm_continue
			continue
		fi

		if [ $# -le 1 ]
		then
			ewritemsg -M vxvmshm:1179 \
"Need more than one path for a pathgroup."
			voladm_continue -n
			continue
		fi

		check_pathgroup $input || {
			ewritemsg -M vxvmshm:1173 \
"Input should be all paths (c#t#d#)."
			echo;echo
			voladm_continue
			continue
		}

		set -- $input
		input_len=`strlen $1`
		match_len=`expr $1 : 'c[0-9][0-9]*t[0-9][0-9]*d[0-9][0-9]*'`
		if [ "$input_len" -eq "$match_len" ]
		then
			pathlist=
			while [ $# -gt 0 ]
			do
				path="$1""s2"
				if [ ! -h $DISK_RAWPATH/$path ]
				then
					export path; ewritemsg -M vxvmshm:1230 \
"The path $path is not a valid path."
					echo
					voladm_continue
					continue 2
				fi
				category=`vxdmpadm getdmpnode nodename=$path 2>/dev/null | tail +3 | awk '{ print $3; }'`
				if [ "$category" != OTHER ]
				then
					pathstr=$1; ewritemsg -M vxvmshm:1324 \
"The path $pathstr doesn't appear in the OTHER_DISKS category. A pathgroup can
  consist only of paths that appear in the OTHER_DISKS category."
					echo
					voladm_continue
					continue 2
				fi
				pathlist="$pathlist $path"
				shift 1
			done

			ewritemsg -M vxvmshm:1185 \
"Only one of the following paths will be visible to VxVM."
			print_line $input
			voladm_yorn -M vxvmshm:115 "Continue operation?" y
			if [ $? -ne 0 ]
			then
				quit 0
			fi
			vxdmpadm mkgroup $pathlist 2>/dev/null
			touch $excltmpfile1
			reboot_message
		else
			set -- $input
			paths=`vxdmpadm getsubpaths ctlr=$1 | tail +3 | awk '{ print $1; }'`
			if [ -z "$paths" ]
			then
				pathstr=$1; ewritemsg -M vxvmshm:1325 \
"There are no paths under controller $pathstr."
				echo
				voladm_continue
				continue
			fi

			valid=0
			for path in $paths
			do
				pathlist=
				dmpnode=`vxdmpadm getdmpnode nodename=$path | tail +3 | awk '{ print $1; }'`
				for ctlr in $input
				do
					altpath=`vxdmpadm getsubpaths dmpnodename=$dmpnode | tail +3 | grep $ctlr | awk '{ print $1; }'`
					if [ ! -z "$altpath" ]
					then
						pathlist="$pathlist $altpath"
					fi
				done
				set -- $pathlist
				if [ $# -le 1 ]
				then
					export path; ewritemsg -M vxvmshm:1147 \
"Cannot create pathgroup for $path because there is only one path to \
  the disk."
					echo
					voladm_continue
				else
					vxdmpadm mkgroup $pathlist 2>/dev/null
					valid=1
				fi
			done
			if [ $valid -eq 1 ]
			then
				touch $excltmpfile2
				reboot_message
			fi
		fi

		voladm_yorn -M vxvmshm:1157 \
"Do you wish to create more pathgroups ?" n
		if [ $? -eq 0 ]
		then
			continue
		else
			quit
		fi
	done
}

set_OS_variables

voladm_menu_push $1-$2

case $1 in
	PATH)
		exclude_path $2;;
	CTLR)	
		exclude_ctlr $2;;
	VIDPID)
		exclude_vidpid $2;;
	PATHGROUP)
		make_pathgroup $2;;
esac

quit 0
