#!/bin/sh

# Script to configure the IDP
# This script MUST be customized before executing
# This script is executed on the system to be used as IDP
# It requires these files:
# idpmetadata.xml
# subOrgRequests.xml

####################**IMPORTANT**#####################
# All these values must be specified before running the script
# Edit these values and then run the script
######################################################
ORG_DN="dc=sun,dc=com"
IDP_HOST_DOMAIN="hostB.sun.com"
IDP_PORT="58080"
SP_HOST_DOMAIN="hostA.sun.com"
SP_PORT="58080"
PROTOCOL="http"
PASSWORD="11111111"         #amAdmin password
AMLDAPUSER_PWD="22222222"    #amldapuser password
IDSAME_BASEDIR="/opt"
IS_DEPLOY_DESCRIPTOR="amserver"
COOKIE_DOMAIN=".sun.com"

######################################################
# These values may be edited, if required.
######################################################
ADMIN_DN="uid=amAdmin,ou=People,$ORG_DN"
COOKIE_NAME="sunDirectoryPro"

######################################################
# Command definitions
######################################################
AMADMIN=$IDSAME_BASEDIR/SUNWam/bin/amadmin
RM="/usr/bin/rm -f"
GREP=/usr/bin/grep
SED=/usr/bin/sed
CP=/usr/bin/cp
CAT=/usr/bin/cat

######################################################
# Create sub organizations and users under suborgs
######################################################
create_sub_orgs() {
echo "Creating sub orgs www.idp1.com and www.idp2.com..."

FILE="/tmp/subOrgRequests.xml"
$SED -e "s/\$ORG_DN/$ORG_DN/g" \
     -e "s/\$PROTOCOL/$PROTOCOL/g" \
     -e "s/\$IS_DEPLOY_DESCRIPTOR/$IS_DEPLOY_DESCRIPTOR/g" \
     -e "s/\$IDP_PORT/$IDP_PORT/g" \
     -e "s/\$AMLDAPUSER_PWD/$AMLDAPUSER_PWD/g" \
     subOrgRequests.xml > $FILE

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" --data $FILE
$RM $FILE
}

######################################################
# Load IDP metadata
######################################################
load_idp_metadata() {
echo "Loading metadata..."

FILE="/tmp/idpmetadata.xml"
$SED -e "s/\$ORG_DN/$ORG_DN/g" \
     -e "s/\$PROTOCOL/$PROTOCOL/g" \
     -e "s/\$SP_HOST_DOMAIN/$SP_HOST_DOMAIN/g" \
     -e "s/\$SP_PORT/$SP_PORT/g" \
     -e "s/\$IS_DEPLOY_DESCRIPTOR/$IS_DEPLOY_DESCRIPTOR/g" \
     -e "s/\$IDP_HOST_DOMAIN/$IDP_HOST_DOMAIN/g" \
     -e "s/\$IDP_PORT/$IDP_PORT/g" \
     -e "s/\$COOKIE_DOMAIN/$COOKIE_DOMAIN/g" \
     idpmetadata.xml > $FILE

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" --data $FILE
$RM $FILE
}

######################################################
# Change the cookie name and add fqdn mapping to AMConfig.properties
######################################################
change_cookie_name() {
FILE="/etc/opt/SUNWam/config/AMConfig.properties"

if [ -f "${FILE}.original" ]; then
  echo "Cookie name and fqdn mapping not set. Please set it manually."
  return
else
 $CP $FILE ${FILE}.original
fi

#change the cookie name only if idp and sp domains are same
IDP_DOMAIN=`echo $IDP_HOST_DOMAIN | cut -f2- -d.`
SP_DOMAIN=`echo $SP_HOST_DOMAIN | cut -f2- -d.`

if [ $IDP_DOMAIN = "$SP_DOMAIN" ]; then
C_NAME=`$GREP "^com.iplanet.am.cookie.name=" $FILE | $SED -e "s/com.iplanet.am.cookie.name=//"`
if [ "$C_NAME" = "iPlanetDirectoryPro" ]; then
 echo "Changing com.iplanet.am.cookie.name from iPlanetDirectoryPro to sunDirectoryPro..."
 $SED -e "s/iPlanetDirectoryPro/$COOKIE_NAME/" ${FILE}.original > $FILE
fi

fi

EXISTS=`$GREP 'com.sun.identity.server.fqdnMap\[www.idp1.com\]' $FILE`
if [ -n "$EXISTS" ]; then
  echo "fqdn mapping already exists..."
else
  echo "Adding fqdn mapping..."
  $CP $FILE $FILE-tmp
  $SED -e "/#com.sun.identity.server.fqdnMap\[<invalid-name>\]=<valid-name>/ {
a\\
com.sun.identity.server.fqdnMap\[www.idp2.com\]=www.idp2.com
}" $FILE-tmp > $FILE
  $CP $FILE $FILE-tmp
  $SED -e "/#com.sun.identity.server.fqdnMap\[<invalid-name>\]=<valid-name>/ {
a\\
com.sun.identity.server.fqdnMap\[www.idp1.com\]=www.idp1.com
}" $FILE-tmp > $FILE
  $RM $FILE-tmp
fi

}

######################################################
#  Main
######################################################
create_sub_orgs
load_idp_metadata
change_cookie_name      #change cookie name and fqdn mapping
