#!/bin/sh

# Script to configure the IDP
# This script MUST be customized before executing
# This script is executed on the system to be used as IDP
# It requires idpmetadata.xml file.

####################**IMPORTANT**#####################
# All these values must be specified before running the script
# Edit these values and then run the script
######################################################
ORG_DN="dc=sun,dc=com"
IDP_HOST_DOMAIN="hostB.sun.com"
IDP_PORT="58080"
SP_HOST_DOMAIN="hostA.sun.com"
SP_PORT="58080"
PROTOCOL="http"
PASSWORD="11111111"    #amAdmin password
IDSAME_BASEDIR="/opt"
IS_DEPLOY_DESCRIPTOR="amserver"
COOKIE_DOMAIN=".sun.com"

######################################################
# These values may be edited, if required.
######################################################
ADMIN_DN="uid=amAdmin,ou=People,$ORG_DN"
COOKIE_NAME="sunDirectoryPro"

######################################################
# Command definitions
######################################################
AMADMIN=$IDSAME_BASEDIR/SUNWam/bin/amadmin
RM="/usr/bin/rm -f"
GREP=/usr/bin/grep
SED=/usr/bin/sed
CP=/usr/bin/cp
CAT=/usr/bin/cat

######################################################
# Load IDP metadata
######################################################
load_idp_metadata() {
echo "Loading metadata..."

FILE="/tmp/idpmetadata.xml"
$SED -e "s/\$ORG_DN/$ORG_DN/g" \
     -e "s/\$PROTOCOL/$PROTOCOL/g" \
     -e "s/\$SP_HOST_DOMAIN/$SP_HOST_DOMAIN/g" \
     -e "s/\$SP_PORT/$SP_PORT/g" \
     -e "s/\$IS_DEPLOY_DESCRIPTOR/$IS_DEPLOY_DESCRIPTOR/g" \
     -e "s/\$IDP_HOST_DOMAIN/$IDP_HOST_DOMAIN/g" \
     -e "s/\$IDP_PORT/$IDP_PORT/g" \
     -e "s/\$COOKIE_DOMAIN/$COOKIE_DOMAIN/g" \
     idpmetadata.xml > $FILE

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" --data $FILE
$RM $FILE
}

######################################################
# Change the cookie name
######################################################
change_cookie_name() {
#change the cookie name only if idp and sp domains are same

IDP_DOMAIN=`echo $IDP_HOST_DOMAIN | cut -f2- -d.`
SP_DOMAIN=`echo $SP_HOST_DOMAIN | cut -f2- -d.`

FILE="/etc/opt/SUNWam/config/AMConfig.properties"

if [ $IDP_DOMAIN = "$SP_DOMAIN" ]; then
C_NAME=`$GREP "^com.iplanet.am.cookie.name=" $FILE | $SED -e "s/com.iplanet.am.cookie.name=//"`
if [ "$C_NAME" = "iPlanetDirectoryPro" ]; then
 echo "Changing com.iplanet.am.cookie.name from iPlanetDirectoryPro to sunDirectoryPro..."
 $CP $FILE ${FILE}.original
 $SED -e "s/iPlanetDirectoryPro/$COOKIE_NAME/" ${FILE}.original > $FILE
fi

fi
}

######################################################
# Create a Identity server user "user1" on IDP hostB
######################################################
create_idp_user() {
echo "Creating user=user1 with password=user1..."

FILE="/tmp/request.xml"
$CAT > $FILE << EOF 
<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE Requests
    PUBLIC "-//iPlanet//Sun ONE Identity Server 6.0 Admin CLI DTD//EN"
    "file:$IDSAME_BASEDIR/SUNWam/dtd/amAdmin.dtd">

<Requests>    
    <PeopleContainerRequests DN="ou=People,$ORG_DN">
      <CreateUser createDN="user1">
        <AttributeValuePair>
          <Attribute name="userpassword"/>
          <Value>user1</Value>
        </AttributeValuePair>
        <AttributeValuePair>
          <Attribute name="sn"/>
          <Value>user1</Value>
        </AttributeValuePair>
        <AttributeValuePair>
          <Attribute name="cn"/>
          <Value>user1</Value>
        </AttributeValuePair>
      </CreateUser>
    </PeopleContainerRequests>
</Requests>
EOF

$AMADMIN --runasdn $ADMIN_DN --password "$PASSWORD" --data $FILE
$RM $FILE
}


######################################################
#  Main
######################################################
load_idp_metadata
change_cookie_name
create_idp_user
