/*
 * Please read the License Agreement and other supplemental license terms, if 
 * any, accompanying this software package before using any of the software 
 * provided.  If you do not agree to the terms of the License Agreement or any 
 * other supplemental terms, please promptly destroy or return the software to 
 * Sun Microsystems, Inc. 
 * 
 * "CONFIDENTIAL AND PROPRIETARY" Copyright  2003 Sun Microsystems, Inc. 
 * All rights reserved. 
 */ 
 
package com.sun.portal.providers.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Cookie;
import java.util.Hashtable;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Enumeration;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;

public class LoginProvider extends ProfileProviderAdapter {
    public StringBuffer getContent(HttpServletRequest request,
				   HttpServletResponse response) 
				  throws ProviderException 
    {

        if(getProviderContext().isDebugMessageEnabled()) {
	    getProviderContext().debugMessage("LoginProvider.getContent()");
	}

	StringBuffer content = new StringBuffer();
	Hashtable tagTable = new Hashtable();

        String fontFace = "";
        URL loginHelpUrl = null;         
	fontFace = getStringProperty("fontFace1","sans-serif");
	tagTable.put("fontFace1", fontFace);
        loginHelpUrl = getHelp(request, "loginHelpUrl");

        // are persistent cookies enabled? 
	// note: if the property returns true, it
	// must also be the case the the authentication
	// service is set to accept persistent cookies
	
	StringBuffer persistent = new StringBuffer();
	boolean pc = getBooleanProperty("persistentCookie");

        if (pc) {
	    if(getProviderContext().isDebugMessageEnabled()) { 
	         getProviderContext().debugMessage("LoginProvider.getContent(): enabling persistent cookie");
	    }
	    persistent = getTemplate("persistentCookie.template",tagTable);
        } else
            persistent.append("");
	    
	tagTable.put("persistentCookie", persistent.toString());
	if (loginHelpUrl != null) {
	  tagTable.put("loginHelpUrl", loginHelpUrl.toString());
	}
        
        StringBuffer libertyLogin = new StringBuffer();
        boolean federationEnabled = false;
		try {
			if (getProviderContext().getProviderVersion(getName()) >= 2) {
         		federationEnabled = getBooleanProperty("federationEnabled");
			}
		} catch (ProviderContextException pce) {
			if (getProviderContext().isDebugWarningEnabled()) {
				getProviderContext().debugWarning("LoginProvider.getContent():Exception getting login provider version", pce);
			}
			throw new ProviderException("LoginProvider.getContent():Exception getting login provider version", pce);
		}

        if (federationEnabled) {
            String preLoginURL = getStringProperty("preLoginURL", "/portal/dt");
            tagTable.put("preLoginURL", preLoginURL);

            if(getProviderContext().isDebugMessageEnabled()) { 
                 getProviderContext().debugMessage("LoginProvider.getContent(): enabling liberty login");
            }
            libertyLogin = getTemplate("libertyLogin.template", tagTable);
        } else {
            libertyLogin.append("");
        }
        
        tagTable.put("libertyLogin", libertyLogin.toString());

        //get the login url from provider context
        String loginUrl = getProviderContext().getLoginURL();
        tagTable.put("loginURL", loginUrl);
        tagTable.put("channelName", getName());
        content = getTemplate("display.template", tagTable);
        return content;
        
    }

    /**
     * isPresentable() returns true if the template for the front page
     * of the provider exists and returns false if it doesn't exist
     */
    public boolean isPresentable(HttpServletRequest request) {
        boolean isPresentable = false;
        ProviderContext pc = getProviderContext();
        try {
	    if ((getTemplatePath("display.template") != null)) {
              isPresentable = true;
            }
        }
        catch (Exception pe) {
            if (getProviderContext().isDebugMessageEnabled()) {
                getProviderContext().debugMessage("LoginProvider.isPresentable(): Unable to get display.template", pe);
            }
        }
        return isPresentable;
    }

}
