#!/bin/sh
#
# create Grid Engine 5.3 settings.[c]sh file
#
# (c) 2002 Sun Microsystems, Inc. Use is subject to license terms.  
#
# $1 = base directory  where settings.[c]sh is created

PATH=/bin:/usr/bin

ErrUsage()
{
   echo
   echo "usage: `basename $0` outdir"
   echo "       \$SGE_ROOT must be set"
   echo "       \$SGE_CELL and \$COMMD_PORT must be set if used in your environment"
   exit 1
}


if [ $# != 1 ]; then
   ErrUsage
fi

if [ "$SGE_ROOT" = "" ]; then
   ErrUsage
fi

SP_CSH=$1/settings.csh
SP_SH=$1/settings.sh

echo "setenv SGE_ROOT $SGE_ROOT"                         >  $SP_CSH
echo ""                                                  >> $SP_CSH
echo "set ARCH = \`\$SGE_ROOT/util/arch\`"               >> $SP_CSH
echo "set DEFAULTMANPATH = \`\$SGE_ROOT/util/arch -m\`"  >> $SP_CSH
echo "set MANTYPE = \`\$SGE_ROOT/util/arch -mt\`"        >> $SP_CSH
echo ""                                                  >> $SP_CSH

if [ "$SGE_CELL" != "" -a "$SGE_CELL" != "default" ]; then
   echo "setenv SGE_CELL $SGE_CELL"                      >> $SP_CSH
else
   echo "unsetenv SGE_CELL"                              >> $SP_CSH
fi

if [ "$COMMD_PORT" != "" ]; then
   echo "setenv COMMD_PORT $COMMD_PORT"                  >> $SP_CSH
else
   echo "unsetenv COMMD_PORT"                            >> $SP_CSH
fi

echo ""                                                          >> $SP_CSH
echo 'if ( $?MANPATH == 1 ) then'                                >> $SP_CSH
echo "   setenv MANPATH \$SGE_ROOT/"'${MANTYPE}':'$MANPATH'      >> $SP_CSH
echo "else"                                                      >> $SP_CSH
echo "   setenv MANPATH \$SGE_ROOT/"'${MANTYPE}:$DEFAULTMANPATH' >> $SP_CSH
echo "endif"                                                     >> $SP_CSH
echo ""                                                          >> $SP_CSH
echo "set path = ( \$SGE_ROOT/bin/"'$ARCH $path )'               >> $SP_CSH
echo "set shlib_path_name = \`\$SGE_ROOT/util/arch -lib\`"       >> $SP_CSH

echo "if ( \`eval echo '\$?'\$shlib_path_name\` ) then"          >> $SP_CSH
echo "   set old_value = \`eval echo '\$'\$shlib_path_name\`"    >> $SP_CSH
echo "   setenv \$shlib_path_name \"\$SGE_ROOT/lib/\$ARCH\":\"\$old_value\""   >> $SP_CSH
echo "else"                                                      >> $SP_CSH
echo "   setenv \$shlib_path_name \$SGE_ROOT/lib/\$ARCH"         >> $SP_CSH
echo "endif"                                                     >> $SP_CSH
echo "unset ARCH DEFAULTMANPATH MANTYPE shlib_path_name"         >> $SP_CSH


echo "SGE_ROOT=$SGE_ROOT; export SGE_ROOT"                        > $SP_SH
echo ""                                                          >> $SP_SH
echo "ARCH=\`\$SGE_ROOT/util/arch\`"                             >> $SP_SH
echo "DEFAULTMANPATH=\`\$SGE_ROOT/util/arch -m\`"                >> $SP_SH
echo "MANTYPE=\`\$SGE_ROOT/util/arch -mt\`"                      >> $SP_SH
echo ""                                                          >> $SP_SH

if [ "$SGE_CELL" != "" -a "$SGE_CELL" != "default" ]; then
   echo "SGE_CELL=$SGE_CELL; export SGE_CELL"                    >> $SP_SH
else
   echo "unset SGE_CELL"                                         >> $SP_SH
fi

if [ "$COMMD_PORT" != "" ]; then
   echo "COMMD_PORT=$COMMD_PORT; export COMMD_PORT"              >> $SP_SH
else
   echo "unset COMMD_PORT"                                       >> $SP_SH              
fi

echo ""                                                          >> $SP_SH
echo "if [ \"\$MANPATH\" = \"\" ]; then"                         >> $SP_SH
echo "   MANPATH=\$DEFAULTMANPATH"                               >> $SP_SH
echo "fi"                                                        >> $SP_SH
echo "MANPATH=\$SGE_ROOT/\$MANTYPE:\$MANPATH; export MANPATH"    >> $SP_SH
echo ""                                                          >> $SP_SH
echo "PATH=\$SGE_ROOT/bin/\$ARCH:\$PATH; export PATH"            >> $SP_SH
echo "shlib_path_name=\`\$SGE_ROOT/util/arch -lib\`"             >> $SP_SH
echo "old_value=\`eval echo '\$'\$shlib_path_name\`"             >> $SP_SH
echo "if [ x\$old_value = "x" ]; then"                           >> $SP_SH
echo "   eval \$shlib_path_name=\$SGE_ROOT/lib/\$ARCH"           >> $SP_SH
echo "else"                                                      >> $SP_SH
echo "   eval \$shlib_path_name=\$SGE_ROOT/lib/\$ARCH:\$old_value" >> $SP_SH
echo "fi"                                                        >> $SP_SH
echo "export \$shlib_path_name"                                  >> $SP_SH
echo "unset ARCH DEFAULTMANPATH MANTYPE shlib_path_name"         >> $SP_SH
