#pragma ident "@(#)meshify.h	1.2 98/08/25 SMI"

/*
 * meshify.h
 *
 *	@(#)meshify.h 1.8 96/11/04 
 *
 *      Author: Mike M. Chow 
 *
 *      This module contains generalized triangle mesh headers.
 * 
 */

#ifndef _modelviewer_meshify
#define _modelviewer_meshify

typedef struct MeshInfo MeshInfo;
typedef struct GTMesh   GTMesh;
typedef struct HeaderInfo HeaderInfo;
typedef struct VertHeader VertHeader;

struct VertHeader {
  int mbref;                    /* Mesh Buffer Reference index (-1 is NULL) */
  int mbp;                      /* Mesh Buffer Push bit */
  int repl;                     /* Mesh Buffer Replacement code (0-2) */
};

struct HeaderInfo {
  VertHeader *header;           /* Array of vertex headers */
  HeaderInfo  *next;            /* Linked list node to next vert header */
};


/* General Triangle Mesh (GTMesh)
 * 
 * This structure consists of a list of general triangle strip vertices (indices 
 * only) each having a header information (gtmesh->headers) that have mesh buffer
 * references or push bits. 
 * 
 * A gtmesh is essentially a stream of vertices:
 * 
 * v0 h0 v1 h1 v2 h2 ...
 * 
 * where each header has the mesh buffer information.
 */

struct GTMesh {
  TriStrips *triStrips;         /* A list of general triangle strips. */
  HeaderInfo *headers;          /* A list of vertex headers corresponding to 
				   each triangle strip index. */
  struct timeval timeStamp;     /* General purpose time stamp. */
  Vertex *varray;               /* Pointer to vertex array for this mesh. */
  int     posQuant;             /* How much to quantize position. */
  int     normalQuant;          /* Normal quantization */
  int     colorQuant;           /* Color quantization */
  GTMesh *next;                 /* Next mesh */
};
  
struct MeshInfo {
  GTMesh *gtmeshes;             /* A list of meshes. */
  int     meshCnt;              /* Total number of meshes. */
  struct timeval timeStamp;     /* Generic time stamp. */
};

/* Mesh Info Routines */
MeshInfo *meshInfoCreate();
void meshInfoDestroy(MeshInfo *);
void meshInfoAddMesh(MeshInfo *mi, GTMesh *mesh);

/* General Triangle Mesh Routines */
GTMesh *gtmeshCreate();

HeaderInfo *headerInfoCreate();
void headerInfoDestroy(HeaderInfo *);
void headerInfosAdd(HeaderInfo **node, HeaderInfo *item);

/* Mesh Buffer Routines */
int meshBufferInit();
int mbpush(int value);
int mbref(int backIndex);
int mbufferLookup(int value);
void meshBufferPrint(Vertex *varray);

#endif
