#pragma ident "@(#)cgpdecompress.h 1.1 97/04/07 SMI"

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */

/*
 * used to hold 3 most recent vertices - needed when trimesh flips
 *  from strip to star - four floats max for r,g,b,a
 */

typedef struct {
        float val[4]; 
} fArray;


/*
 *  Geometery Decompression Huffman table element format.
 */
typedef struct  gc_table_e {
    int tag_length;
    int data_length;
    int right_shift;
    int abs_rel;
} gc_table_e;


/*
 *  The Mesh Buffer element format.
 */
typedef struct  gc_mesh_buffer_e {
    short x, y, z;
    short octant, sextant, u, v;
    short r, g, b, a;
} gc_mesh_buffer_e;

/*
 *  Geometery Compression op-codes.
 */
#define GC_VERTEX       0x40
#define GC_SET_NORM     0x80
#define GC_SET_COLOR    0xC0
#define GC_MESH_B_R     0x20
#define GC_SET_STATE    0x18
#define GC_SET_TABLE    0x10
#define GC_PASS_THROUGH 0x08
#define GC_EOS          0x00
#define GC_V_NO_OP      0x01

/* Sepcial normal tags */
#define GC_SPECIAL_NORM_X_AXIS          0x30000
#define GC_SPECIAL_NORM_Y_AXIS          0x34000
#define GC_SPECIAL_NORM_Z_AXIS          0x38000
#define GC_SPECIAL_NORMAL_MID_OCT       0x31000
#define GC_SPECIAL_NORMAL_CIR_XY        0x30800
#define GC_SPECIAL_NORMAL_CIR_YZ        0x34800
#define GC_SPECIAL_NORMAL_CIR_XZ        0x38800

/* vertex replacemnet policy */
#define RESTART_CW      0x0
#define RESTART_CCW     0x1
#define REPLACE_MIDDLE  0x2
#define REPLACE_OLDEST  0x3

/* meshState values - needed to know when colors/normals come from */
/* meshBuffer or that they have already been set via SetColor Set Normal */
#define USE_MESH_NORMAL 0x1
#define USE_MESH_COLOR  0x2

/* primitive class - a compressed geometry buffer may be made up of only a */
/*  single class                                                           */
#define PRIMCLASS_POINT 0x1
#define PRIMCLASS_LINE  0x2
#define PRIMCLASS_FILL  0x4

/* used to increment decompression buffer */
/*  CurBuffPos always points to the next  */
/*  free position.                        */
#define CGP_INC_DECOMP_BUFF_POS                                   \
        CurBuffPos++;                                             \
        if (CurBuffPos == BuffSize)                               \
        {                                                         \
            BuffSize += CGP_DECOMP_BUFF_SIZE;                     \
            Buff =                                                \
                realloc(Buff, sizeof(CGuint) * BuffSize);         \
        }

/* initial size of decompressed geometry buffer */
#define CGP_DECOMP_BUFF_SIZE 2000
