#pragma ident "@(#)cgp.h	1.15 98/09/28 SMI"
#ifndef _ogl_cgph_
#define _ogl_cgph_

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */


/******************************************************************************
 *
 * cgp.h
 *
 * This header file contains all the type definitions and function declarations
 * needed to use the geometry compression utility library.  It should be
 * included in any application that will be using any of the compression
 * utilities.
 *
 *****************************************************************************/

/* type definitions           */
typedef unsigned int CGenum;
typedef unsigned char CGboolean;
typedef unsigned int CGbitfield;
typedef signed char CGbyte;
typedef short CGshort;
typedef int CGint;
typedef int CGsizei;
typedef unsigned char CGubyte;
typedef unsigned short CGushort;
typedef unsigned int CGuint;
typedef unsigned long long CGulongint;
typedef float CGfloat;
typedef float CGclampf;
typedef double CGdouble;
typedef double CGclampd;
typedef void CGvoid;

/* used to reposition compressed geometry back to original location */
typedef struct {
	float scale;
	float xo, yo, zo; /* Offsets in x, y, and z */
} CGviewport;

/* holds stats of compressed buffer */
typedef struct {
    CGint	numPrims;
    CGint	numVtx;
    CGint	vtxSize;
} CGstats;

/* ErrorCode values                            */
#define CG_NO_ERROR			0
#define CG_DATA_INCONSISTENT		0x01
#define CG_INVALID_ENUM			0x02
#define CG_INVALID_OPERATION		0x04
#define CG_OUT_OF_MEMORY		0x08

/* valid values for cgBegin mode               */
#define CG_POINTS			0
#define CG_LINES			1
#define CG_LINE_LOOP			2
#define CG_LINE_STRIP			3
#define CG_TRIANGLES			4
#define CG_TRIANGLE_STRIP		5
#define CG_TRIANGLE_FAN			6
#define CG_QUADS			7
#define CG_QUAD_STRIP			8
#define CG_POLYGON			9

/* valid values for cgFrontFace                */
#define CG_CW				0x01
#define CG_CCW				0x02

/* values for quantization enforcement to allow decreasing the quant levels */
#define CG_QUANTIZE_STRICT		1   /* must always compress to */
                                            /*  specified quantization levels */
#define CG_QUANTIZE_LOOSE		2   /* can relax quantization levels */
                                            /*  when precision loss would be */
                                            /*  high                         */

/* data type values used by the decompression routine */
#define CG_CMD_LINE_STRIP		1
#define CG_CMD_POINTS			2
#define CG_CMD_SET_COLOR3		3
#define CG_CMD_SET_COLOR4		4
#define CG_CMD_SET_FRONTFACE		5
#define CG_CMD_SET_NORMAL		6
#define CG_CMD_TRIANGLE_FAN		7
#define CG_CMD_TRIANGLE_STRIP		8

/*******************
 * External function definitions
 *
 */

extern void cgBegin(CGenum);
extern void cgBeginCompressedGeometryStream (CGint geomQuant,
					     CGint normalQuant,
					     CGint colorQuant,
					     CGenum quantEnforcement);
extern void cgColor3b (CGbyte red, CGbyte green, CGbyte blue);
extern void cgColor3bv (const CGbyte *v);
extern void cgColor3d (CGdouble red, CGdouble green, CGdouble blue);
extern void cgColor3dv (const CGdouble *v);
extern void cgColor3f (CGfloat red, CGfloat green, CGfloat blue);
extern void cgColor3fv (const CGfloat *v);
extern void cgColor3i (CGint red, CGint green, CGint blue);
extern void cgColor3iv (const CGint *v);
extern void cgColor3s (CGshort red, CGshort green, CGshort blue);
extern void cgColor3sv (const CGshort *v);
extern void cgColor3ub (CGubyte red, CGubyte green, CGubyte blue);
extern void cgColor3ubv (const CGubyte *v);
extern void cgColor3ui (CGuint red, CGuint green, CGuint blue);
extern void cgColor3uiv (const CGuint *v);
extern void cgColor3us (CGushort red, CGushort green, CGushort blue);
extern void cgColor3usv (const CGushort *v);
extern void cgColor4b (CGbyte red, CGbyte green, CGbyte blue, CGbyte alpha);
extern void cgColor4bv (const CGbyte *v);
extern void cgColor4d (CGdouble red, CGdouble green, CGdouble blue, CGdouble alpha);
extern void cgColor4dv (const CGdouble *v);
extern void cgColor4f (CGfloat red, CGfloat green, CGfloat blue, CGfloat alpha);
extern void cgColor4fv (const CGfloat *v);
extern void cgColor4i (CGint red, CGint green, CGint blue, CGint alpha);
extern void cgColor4iv (const CGint *v);
extern void cgColor4s (CGshort red, CGshort green, CGshort blue, CGshort alpha);
extern void cgColor4sv (const CGshort *v);
extern void cgColor4ub (CGubyte red, CGubyte green, CGubyte blue, CGubyte alpha);
extern void cgColor4ubv (const CGubyte *v);
extern void cgColor4ui (CGuint red, CGuint green, CGuint blue, CGuint alpha);
extern void cgColor4uiv (const CGuint *v);
extern void cgColor4us (CGushort red, CGushort green, CGushort blue, CGushort alpha);
extern void cgColor4usv (const CGushort *v);
extern void cgDecompressGeometryStream(CGubyte *cgBuff, CGuint **uData, CGuint *size);
extern void cgEnd (void);
extern void cgEndCompressedGeometryStream(CGubyte **data, CGint *size, CGviewport *viewport);
extern void cgGeomFrontFace (CGenum);
extern CGenum cgGetError (void);
extern void cgNormal3b (CGbyte nx, CGbyte ny, CGbyte nz);
extern void cgNormal3bv (const CGbyte *v);
extern void cgNormal3d (CGdouble nx, CGdouble ny, CGdouble nz);
extern void cgNormal3dv (const CGdouble *v);
extern void cgNormal3f (CGfloat nx, CGfloat ny, CGfloat nz);
extern void cgNormal3fv (const CGfloat *v);
extern void cgNormal3i (CGint nx, CGint ny, CGint nz);
extern void cgNormal3iv (const CGint *v);
extern void cgNormal3s (CGshort nx, CGshort ny, CGshort nz);
extern void cgNormal3sv (const CGshort *v);
extern void cgVertex3d (CGdouble x, CGdouble y, CGdouble z);
extern void cgVertex3dv (const CGdouble *v);
extern void cgVertex3f (CGfloat x, CGfloat y, CGfloat z);
extern void cgVertex3fv (const CGfloat *v);
extern void cgVertex3i (CGint x, CGint y, CGint z);
extern void cgVertex3iv (const CGint *v);
extern void cgVertex3s (CGshort x, CGshort y, CGshort z);
extern void cgVertex3sv (const CGshort *v);
extern void cgAbortGeometryStream() ;
extern void cgpUtilRenderApiBuff() ;


void cgMBPush();
void cgMBRef(int n);
void cgCurPtSetHeader(int mask);
void cgCurPtSetQuant(int geomQuant, int normQuant, int colorQuant);
void cgCurPtSetMBRef(int ref);
void cgCurPtSetFakeQuant(float x, float y, float z);
void prims2Compress(CGubyte **data, CGint *size,
		    CGviewport *viewport);
void cgResetPrims();
void cgPutEndStream();
void cgPutBeginStream();

void cgUtilPrimStats(CGint *numPrims, CGint *numVtx, CGint *vtxSize);

#endif
