/*
 * 
 * Copyright 30 Mar 1995 Sun Microsystems, Inc. All Rights Reserved
 * 
 * 
 * Author:  S. McKinty
 * Date:	 20th September 1994
 * 
 * Modified
 * 
*/
#ifndef LINKHEADER
#define LINKHEADER

#define WAN_DEV   1
#define LAN_DEV   2
#define WAN_LOOP  3

#define L_TYPE	  	4
#define L_LINES 	5
#define L_DEVICE	6
#define L_NAME		7
#define L_MRU		8
#define L_WANMOD	9

#define BOARDCONF	"/boardconf"
#define XINFO	   "/x_info"
#define TORXINFO	"/torx_info"

/* limit of 5 physical devices per MLP link */
#define MAX_SLP		5

/* NP CTE fix, bug #4237175, esc #520465, JK, 19 May 1999 */
/* value associated to the field panel_item of the first item of a dev_type struct
 * for first initialization.
 */
/* NPCTE fix for bug #4237175, SD, 16 Sep 99 */
/* initialize the unsigned field of this structure 
   with 0, and not with -2 */
#define DEV_TYPE_TBI	-2
#define DEV_TYPE_DETECT "notinit",\
			"notinit",\
			"notinit",\
			(uint8)0,\
			(uint8)0,\
			(uint8)0,\
			(char)0,\
			(void *)DEV_TYPE_TBI,\
			(long)DEV_TYPE_TBI
/* end NPCTE fix for bug #4237175, SD, 16 Sep 99 */

/* NP CTE fix, bug #4237175, esc #520465, JK, 19 May 1999 */
struct dev_type {
	char	devname[8];	/* e.g. HSI, MCP, ZS etc */
	char	driver[20];	/* e.g. /dev/hih, /dev/zsh, etc */
	char	modname[16];	/* e.g. wanmod */
	uint8	lines;		/* number of lines per board */
	uint8	board_type;	/* WAN_DEV, LAN_DEV, or WAN_LOOP */
	uint8	boards;		/* quantity of such boards */
	char	id;		/* A, B, C etc. (as in wansA, ethrB etc.) */
	void	*panel_item;	/* used to construct KernelDevices screen */
	long	mru;		/* maximum received (and transmit) unit for that board (in bytes) */
	};
 
struct type_struct {
	char    *string;
	uint8   value;
	};

/*
 * This contains pointers to other structures. 'free'ing
 * it is not simply a matter of calling free() with the address of
 * such a structure.
 *
 * For MLP we make the prefix. board and lines items arrays, so that there is
 * one for each possible SLP. The dtype item has been removed since it
 * is no longer used.
*/

/* flags value: link is circuit-switched */
#define	LINK_SWITCHED	0x01

struct link_item {
	uint8		 prefix[MAX_SLP];	/* entry number in linktype array */
	uint8		 line[MAX_SLP];		/* line number on board */
	uint8		 board[MAX_SLP];	/* physical board number */
	uint8		 mlp_priority[MAX_SLP];	/* num. outstanding frames */
	uint		 flags;			/* special features */
	uint8		 net_type;		/* LAN, W80, W84 W88 (see xnetdb.h) */
#ifdef __cplusplus
	uint8		 link_class;		/* as defined in snet/ll_proto.h */
#else
	uint8		 class;			/* as defined in snet/ll_proto.h */
#endif
	uint8		 address[18];		/* DTE or MAC address */
	uint8		 num_devs;		/* number of valid device entries */
	uint8		 mlp;			/* 1=MLP, 0=simple LAPB */
	uint8		 max_lan_conns;		/* number of preallocated LLC2 streams */
	struct subnetent link;		/* defined in xnetdb.h */
	struct pvcitem	 *pvcptr;	/* ptr to list of non-standard PVCs */
	};

struct pvcitem {
	struct pvcitem  *next;
	struct pvcitem  *prev;
	struct pvcconff pvc;
	};

/*
 * MLP item. This is used as the data item in the config file, and
 * holds MLP info + a pointer to a LAPB structure and a WAN structure
 * for each of the SLPs.
*/

struct MLP_item {
        struct mlp_tnioc        tunedata;
	struct LAPB_config_data	*lapbdata[MAX_SLP];
	struct WAN_config_data	*wandata[MAX_SLP];
	};


/*
 * The public interface
*/
void set_link_error_function(int (*)(char *));
void free_link_item(struct link_item *);

/*
 * Used in the Interface ('links') screen. Must be in same order
 * as the setting item. Its mildly inefficient to have it here since
 * each file which #includes this one will get its own copy, but in the
 * long run that is very little penalty, and is easily outweighed by
 * the advantages of having a single point of update for it, so there
 * is no possibility of it having different contents in different programs.
*/
static const struct type_struct link_nettype[] = {
{"WAN88",  W88},
{"WAN84",  W84},
{"WAN80",  W80},
{"LAN",    LAN},
{"MLP1",   MLP1},
{"MLP2",   MLP2},
{"MLP3",   MLP3},
{"MLP4",   MLP4},
{"MLP5",   MLP5},
{"?",      ANY}		 /* must have final 0 */
};
#endif

